#define ULTIMA_CASILLA 22
#define PAUSA_SEGUNDO 16384
#define MAX_GOTAS 10
#define MAX_PIEDRAS 4
#define MAX_DESAFIOS 9 
//1-Camino Oculto, 2-Repetir Patrón, 3-Superviviencia, 4-Parar Tiempo, 5-Parar Sprite, 6-Suma colores, 7-Lluvia ácida, 8-Tiro al Arco, 9-Salto Lanzas
#define PLAYERS 3
#define TOTAL_TURNOS 32
#define ADDR_VARIABLES 0xA700 //Hasta 400 (0x0190) *Cambiar esto implica cambiar los loader.bas pues guardan idioma y dispositivo de carga en direcciones absolutas
#define ADDR_TEXTOS 0xA890 
#define TOTAL_TEXTOS 1024  //0x0400 
#define ADDR_GRAFICOS 0xAC90 
#define TOTAL_GRAFICOS 4320 //0x10E0
#define ADDR_MUSICA 0xBD70 
#define TOTAL_MUSICA 416

#define PLIEGUE 0
#define DESPLIEGUE 1
#define LIMITE_SUPERIOR_CAMINO 0
#define LIMITE_INFERIOR_CAMINO 4
#define DIVISOR_DESAFIOS 4


/*
FirmW_Hex| Hardware  | Hard+Command | Colour Name    |  R%   G%   B% Colour
---------------------------------------------------------------------------
    00   | 20 (0x14) |  0x54        | Black          |   0    0    0
    01   |  4 (0x04) |  0x44 (0x50) | Blue           |   0    0   50
    02   | 21 (0x15) |  0x55        | Bright Blue    |   0    0  100
    03   | 28 (0x1C) |  0x5C        | Red            |  50    0    0
    04   | 24 (0x18) |  0x58        | Magenta        |  50    0   50
    05   | 29 (0x1D) |  0x5D        | Mauve          |  50    0  100
    06   | 12 (0x0C) |  0x4C        | Bright Red     | 100    0    0
    07   |  5 (0x05) |  0x45 (0x48) | Purple         | 100    0   50
    08   | 13 (0x0D) |  0x4D        | Bright Magenta | 100    0  100
    09   | 22 (0x16) |  0x56        | Green          |   0   50    0
    0A   |  6 (0x06) |  0x46        | Cyan           |   0   50   50
    0B   | 23 (0x17) |  0x57        | Sky Blue       |   0   50  100
    0C   | 30 (0x1E) |  0x5E        | Yellow         |  50   50    0
    0D   |  0 (0x00) |  0x40 (0x41) | White          |  50   50   50
    0E   | 31 (0x1F) |  0x5F        | Pastel Blue    |  50   50  100
    0F   | 14 (0x0E) |  0x4E        | Orange         | 100   50    0
    10   |  7 (0x07) |  0x47        | Pink           | 100   50   50
    11   | 15 (0x0F) |  0x4F        | Pastel Magenta | 100   50  100
    12   | 18 (0x12) |  0x52        | Bright Green   |   0  100    0
    13   |  2 (0x02) |  0x42 (0x51) | Sea Green      |   0  100   50
    14   | 19 (0x13) |  0x53        | Bright Cyan    |   0  100  100
    15   | 26 (0x1A) |  0x5A        | Lime           |  50  100    0
    16   | 25 (0x19) |  0x59        | Pastel Green   |  50  100   50
    17   | 27 (0x1B) |  0x5B        | Pastel Cyan    |  50  100  100
    18   | 10 (0x0A) |  0x4A        | Bright Yellow  | 100  100    0
    19   |  3 (0x03) |  0x43 (0x49) | Pastel Yellow  | 100  100   50
    1A   | 11 (0x0B) |  0x4B        | Bright White   | 100  100  100
    */
extern const u8 paletaM2[2];
extern const u8 paletaM1[4];
extern const u8 paletaM0[16];
extern const u8 paleta_khytya[16];
extern const u8 paleta_vendha[16];
extern const u8 paleta_hyrca[16];
extern const u8 pos_x[3][23];
extern const u8 pos_y[3][23];
extern const u8 txtAMC[80];
extern u8 tabla_desafios[MAX_DESAFIOS];


void playFX (u8 instrumento, u8 nota);

typedef struct {
    u8 id; //identificador 0, 1 ó 2
	u8 com; //0:Humano; 1: Computadora; 2:No juega
	u8 mundo; //0:Hyrca; 1:Kythya; 2: Vendha
	u8 casilla; //Casilla del mundo donde se encuentra
	u8 mision1; // Misión que debe hacerse
	u8 mision2; // Misión que debe hacerse
	u8 oraculo_visitado; 
    u8 intentos; //Intentos de viaje/desafío fallados. A los 2 fallos seguidos, éxito automático para el siguiente
    u8 mundo_destino; //Guarda a qué mundo quiere viajar si es COM
    u8 *sprite; //puntero a frame1 
} TJugador;

typedef struct {
	u8 pos_x;
	u8 pos_y;
	u8 pos_x_ant;
	u8 tipo; //0:nada; 1:piedra; 2:Enemigo
    u8 pintar;
} TPiedra;

void intHandler();
void setInterruptAtVSYNCStart(void *intHdl);

/* MISIONES
0x1 K1 gigante polifemo - lanza de luz
0x2 K2 traspasar del tempo de las mil puertas - llave maestra
0x3 V1 derrotar al gran dinosaurio - hacha de hierro
0x4 V2 conquistar la ciudad de plata - espejo mágico
0x5 H1 sobrevivir a las montañas del alud - amuleto de la suerte
0x6 H2 destruir el palacio de cristal - martillo destructor
*/

//////////////////// VARIABLES //////////////////////////////////
__at(ADDR_VARIABLES+2) u8 relojArena[114];
__at(ADDR_VARIABLES+116) TPiedra piedras[MAX_PIEDRAS]; //posición x de las piedras
__at(ADDR_VARIABLES+136) u8 armas_casilla[6]; // valor 0 = arma no se usa o ya recogida
__at(ADDR_VARIABLES+142) u8 armas_mundo[6]; // valor 3 = arma usada, misión completada
__at(ADDR_VARIABLES+148) u8 contador_musica;
__at(ADDR_VARIABLES+149) u8 musica;
__at(ADDR_VARIABLES+150) u8 game_over; //Byte con información del juego: 
__at(ADDR_VARIABLES+151) u8 num_turno;
__at(ADDR_VARIABLES+152) u8 vidas;
__at(ADDR_VARIABLES+153) u8 splitScreen;
__at(ADDR_VARIABLES+154) u8 modo_dificil;
__at(ADDR_VARIABLES+155) u8 armas_activas[6]; // valor 0: misión de arma todavía no activa
__at(ADDR_VARIABLES+161) u8 buffer_fondo[20]; // guarda fondo antes de dibujar ficha del jugador para restablecer
__at(ADDR_VARIABLES+181) u8 cuadrilla[13][5]; //cuadrilla para desafíos (para tiles de 5B + 20 px)
__at(ADDR_VARIABLES+246) TJugador players[3];
__at(ADDR_VARIABLES+279) u8 musica_sonando;
__at(ADDR_VARIABLES+280) u8 musica_off;
__at(ADDR_VARIABLES+281) u8 depurar;
__at(ADDR_VARIABLES+282) u8 relojArenaDesafio[114];
__at(ADDR_VARIABLES+396) u8 indice_desafios;