//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of CPCtelera: An Amstrad CPC Game Engine
//  Copyright (C) 2015 ronaldo / Fremos / Cheesetea / ByteRealms (@FranGallegoBR)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

#include <cpctelera.h>
#include "main.h"
#include "funciones.h"
#include "intro.h"
#include "juego.h"
#include "consola.h"
#include "fonts2B.h"
#include "textos.h"
//Músicas
#include "musica/m_intro.h"
#include "musica/m_khytya.h"
#include "musica/m_vendha.h"
#include "musica/m_hyrca.h"
#include "musica/m_oraculo.h"


const u8 paletaM2[2] = {0x54, 0x4B};
const u8 paletaM1[4] = {0x54, 0x43, 0x4C, 0x4B};
const u8 paletaM0[16] = { 0x54, 0x57, 0x5c, 0x4c, 0x55, 0x40, 0x53, 0x4D, 0x4E, 0x5E, 0x5F, 0x47, 0x52, 0x56, 0x4A, 0x4B  };
const u8 paleta_khytya[16] = {0x54, 0x57, 0x5c, 0x4c, 0x56, 0x5e, 0x40, 0x4e, 0x52, 0x42, 0x5a, 0x59, 0x5b, 0x4a, 0x43, 0x4b};
const u8 paleta_vendha[16] = {0x54, 0x57, 0x5c, 0x4c, 0x45, 0x47, 0x5e, 0x40, 0x5f, 0x4e, 0x4f, 0x5a, 0x5b, 0x4a, 0x43, 0x4b};
const u8 paleta_hyrca[16]  = {0x54, 0x57, 0x5c, 0x4c, 0x45, 0x56, 0x5e, 0x55, 0x40, 0x4e, 0x47, 0x4f, 0x5a, 0x5b, 0x4a, 0x4b};

const u8 pos_x[3][23] = { //Khytya (0), Vendha (1), Hyrca (2)
{11,15,18,23,27,29,33,39,58,62,67,71,68,59,55,49,45,41,38,26,25,28,33},
{ 8,13,19,24,30,32,32,36,57,62,68,73,72,61,57,51,46,42,38,27,29,34,40},
{11,15,20,23,27,30,34,35,55,60,67,70,75,64,58,54,49,45,40,22,23,26,30}}; //posición en pantalla para los 3 mundos, eje x
const u8 pos_y[3][23] = { 
{125,114,108,110,122,135,150,154,155,141,137,122,105,67,64,54,56,65,78,70,53,31,21},
{138,117,111,114,115,141,162,168,165,174,178,153,129,40,31,33,43,55,66,49,31,28,21},
{131,123,127,141,159,166,148,133,156,173,175,150,119,41,43,54,58,57,62,54,33,21, 8}}; //posición en pantalla para los 3 mundos, eje y
//FXs
__at (0x0040) const unsigned char m_sfx[205] = { //Instrumentos para Fxs
 0x41, 0x54, 0x31, 0x30, 0x01, 0x40, 0x42, 0x0f, 0x02, 0xff, 0xab, 0x00, 0x56, 0x00, 0x5f, 0x00,
 0x78, 0x00, 0xa0, 0x00, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x58, 0x00, 0x01,
 0x00, 0x3c, 0x38, 0x74, 0x0c, 0x74, 0x18, 0x70, 0x0c, 0x6c, 0x18, 0x28, 0x24, 0x20, 0x1c, 0x18,
 0x14, 0x10, 0x0c, 0x08, 0x04, 0x0d, 0x58, 0x00, 0x01, 0x00, 0x7e, 0x21, 0x0c, 0x78, 0x18, 0x76,
 0x21, 0x10, 0x70, 0x1c, 0x7a, 0x21, 0x13, 0x7c, 0x1f, 0x25, 0x28, 0xf4, 0x3c, 0x25, 0x28, 0xf4,
 0x3c, 0x25, 0x28, 0xf4, 0x3c, 0x25, 0x28, 0xe8, 0x3c, 0x25, 0x28, 0xe8, 0x3c, 0x0d, 0x58, 0x00,
 0x01, 0x00, 0x3e, 0x21, 0x7c, 0x0d, 0x7e, 0x21, 0x02, 0x7c, 0x0e, 0x7c, 0x03, 0x7c, 0x0f, 0x0d,
 0x58, 0x00, 0x01, 0x00, 0x3c, 0xbc, 0xff, 0xff, 0x3c, 0xb8, 0x01, 0x00, 0x38, 0xb8, 0xff, 0xff,
 0x34, 0xb4, 0x01, 0x00, 0x30, 0xb0, 0xff, 0xff, 0x2c, 0xac, 0x01, 0x00, 0x28, 0xa8, 0xff, 0xff,
 0x24, 0xa4, 0x01, 0x00, 0x20, 0xa0, 0xff, 0xff, 0x1c, 0x9c, 0x01, 0x00, 0x18, 0x98, 0xff, 0xff,
 0x14, 0x94, 0x01, 0x00, 0x10, 0x90, 0xff, 0xff, 0x0c, 0x8c, 0x01, 0x00, 0x08, 0x88, 0xff, 0xff,
 0x04, 0x84, 0x01, 0x00, 0x0d, 0x58, 0x00, 0x40, 0x00, 0x00, 0x00, 0x07, 0x01, 0x00, 0x08, 0x01,
 0x08, 0x01, 0x08, 0x01, 0x01, 0xfd, 0x00, 0x00, 0x42, 0x80, 0x00, 0x00, 0x00};
//Justo antes del firmware (que empieza en #A6FC) espacio para variables que rellenará el cargador BASIC 
__at (0xA6FA) u8 idioma; // valor 0=Inglés; 1= Español
__at (0xA6FB) u8 cinta; // valor 0= cargado de disco; 1 = cargado de cinta
//Entre la última música y antes del código
__at (0x0479) const u8 fichero_datos[9] = {'D','A','T','A','1','.','B','I','N'}; //Fichero con datos extra (Gráficos, texto)
__at (ADDR_MUSICA) u8 m_theme[TOTAL_MUSICA];

const u8 txtAMC[80] = { 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0x00, 0xFF, 0xAA, 
    0xAA, 0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 
    0x28, 0x00, 0x3C, 0x00, 0x28, 0x28, 0x28, 0x28, 0x3C, 0x00, 
    0x28, 0x28, 0x3C, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 
    0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 
    0xFF, 0xAA, 0xAA, 0xAA, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}; //"Gronf Gronf", guiño a AMC por su 30º aniversario

const unsigned char G_flag_1[15] = { 
    0x55, 0x10, 0x98, 
    0xFF, 0x55, 0xDD, 
    0x55, 0x44, 0xCC, 
    0x55, 0x55, 0xDD, 
    0x55, 0x10, 0x98};


const unsigned char G_flag_2[15] = { 
    0xFF, 0x44, 0xCC, 
    0x55, 0x15, 0x3F, 
    0xFF, 0x15, 0x3F, 
    0xAA, 0x15, 0x3F, 
    0xFF, 0x44, 0xCC};

u8 tabla_desafios[MAX_DESAFIOS];

void jukebox(){
    u8 *p;

    p = (u8*) m_sfx; //Apunto a la melodía de fx que es vacía para cuando quiero reproducir sólo FX como en desafío de repetir patrón
    if (!musica_off){ //Si el jugador no ha desactivado la música ...
        if (musica == 1)
            p = (u8*) m_intro;
        if (musica == 2)
            p = (u8*) m_khytya;
        if (musica == 3)
            p = (u8*) m_vendha;
        if (musica == 4)
            p = (u8*) m_hyrca;
        if (musica == 5)
            p = (u8*) m_oraculo;
        if (musica == 6)
            p = (u8*) m_theme;
    } 
    
    cpct_akp_musicInit(p);
}

void playFX (u8 instrumento, u8 nota) {
// SFXPlay admite notas de 0 a 143, es decir 144 notas. Siendo 12 notas por octava, daría para 12 octavas
// Sin embargo, Arkos sólo muestra octavas de 0 a A
// Para obtener una nota hay que calcular
// ((octava * 12) + nota (teniendo en cuenta semitonos)) - 1. Por ejemplo E2 => (2 * 12) + 5 - 1

//    1: Recoger Objeto           Short Cool Instruments E2
//    2: Completar misión         Targhan - Dead On Time - Sound Effects CAPSUMAJ  E4
//    3: vida perdida             Targhan - Dead On Time - Sound Effects COUNTDOWN E4
//    4: Botón Rojo               FenyxKell - KellyOn NORMAL  G4
//    5: Botón Verde              FenyxKell - KellyOn NORMAL  C5
//    6: Botón Amarillo           FenyxKell - KellyOn NORMAL  C4
//    7: Botón Azul               FenyxKell - KellyOn NORMAL  A4    
    cpct_akp_SFXInit (m_sfx);
    
    cpct_akp_SFXPlay (instrumento, 15, nota, 0, 0, AY_CHANNEL_B);
    //cpct_akp_SFXStop (AY_CHANNEL_B);
}


void intHandler(){
	//Las interrupciones saltan 300 por segundo (Hz), como la música está diseñada en 50Hz
	//debe llamarse a musciPlay cada 6 veces que llegue la interrupción
	if (!musica)
		cpct_akp_stop();

    if (musica != musica_sonando){
        jukebox();
    }

	if (!(contador_musica % 6) && musica){
		cpct_akp_musicPlay();
	} 

	if (!contador_musica && splitScreen) {
		cpct_waitVSYNC(); //Sincronizar a inicio de ciclo para que los cortes de modos del menú sean constantes. Semilla es 0 cuando está en menú
		contador_musica = 5;
	}
	contador_musica--;
    musica_sonando = musica;
}

void setInterruptAtVSYNCStart(void *intHdl){
	//Asegurarnos que cambiamos la gestión de interrupciones es al terminar VSync
	//pues el primero puede saltar si estamos a mitad de VSync. Por eso se pasan 2 interrupciones más
	//y entra en espera. Ahora es seguro que saltará de la espera al llegar el CRTC al VSync
	cpct_waitVSYNC();
	__asm
        ei
		halt
        ei
		halt
	__endasm;
	cpct_waitVSYNC();//Nos aseguramos que CRTC estaba a mitad de pantalla
	cpct_setInterruptHandler(intHdl);
}

//Loader basado en
//http://cpctech.cpc-live.com/source/loader.html (original de Kevin Thacker)
//http://www.cpcmania.com/Docs/Programming/Ficheros.htm (adaptado para C)

void setupDOS() {
// Procedimiento que hay que llamar nada más ejecutar el main para inicializar el uso de disco para el loader	
__asm
    pop hl ;;Guardar la dirección de retorno
    ld (_stack+1), hl
    ;;------------------------------------------------------------------------
    ;; guardar la disquetera que se está usando (se perderá esta información con las llamadas al firmware)
    ld hl,(#0xbe7d)
    ld a,(hl)                  
    ld (_drive+1),a

    ;;------------------------------------------------------------------------
    ld c,#0xff          	  ;; desactivar temporalmente las roms
    ld hl, #_start222         ;; execution address for program
    call #0xbd16  ;;mc_start_program    ;; start it

_start222:: nop
    call #0xbccb  ;;kl_rom_walk     ;; activar  roms 

    ;;------------------------------------------------------------------------
    ;; Restaurar la unidad de disquete
_drive: ld a, #0x00
    ld hl,(#0xbe7d)
    ld (hl),a     
_stack: ld hl, #0x0000
    push hl ;;Restablecer la dirección de retorno

  __endasm;
}

void cargarDatos(char longNombre, char *nombreFichero, char *direccionCarga) {
    //Para que no salte warning 85 por no usar los parámetros. Luego no se genera código 
    longNombre;
    nombreFichero;
    direccionCarga;
    
 __asm
 	POP IY	;; Guardar la dirección de Retorno para restaurarla después
    ld a,#01
    call #0xbc6b ;; cas_noisy off  Para que no muestre el mensaje y pausa "press play then any key"


 	;; Para usar el load del firmware es necesario establecer estos 3 parámetros en los siguientes registros
 	;; B = longitud del nombre de ficher (incluido . y extensión; máximo=11)
 	;; HL = dirección donde está la cadena de texto con el nombre de Fichero
 	;; HL = dirección donde cargar los datos


 	;; Ésto lo hago así porque sólo tengo que recuperar 1 byte, no 2. Y no hay POP para 1 byte. 
 	;; Por eso luego hay que pasar el valor de C a B y cambiar el puntero de SP
    POP BC
    LD B,C
    DEC SP
    POP HL

    ;; DE = dirección para buffer de lectura de 2k (no se usa en disco)
    ld de, #0xE000

    ;; Llamada al firmware para abrir fichero
    call #0xbc77 ;;cas_in_open

    ;; Leer el fichero a la dirección indicada en HL
    POP HL
    call #0xbc83 ;;cas_in_direct

    ;; Llamada al firmware para cerrar fichero
    call #0xbc7a ;;cas_in_close

    ;; Restaurar la dirección de retorno (IY no se resetea con las llamadas a firmware de disco ni de cinta)
    PUSH IY

  __endasm;
}

void main(void) {
    u16 firmware;

    firmware = cpct_disableFirmware();
    borrarPantalla();
    //cpct_setBorder(HW_BLACK);
    //idioma = 2;  //Lo inicializa el cargador BASIC
    cpct_setVideoMode(0);
    cpct_setPalette(paletaM0,16);
    cpct_drawSprite (G_flag_1, cpctm_screenPtr(CPCT_VMEM_START,37,92), 3, 5);
    cpct_drawSprite (G_flag_2, cpctm_screenPtr(CPCT_VMEM_START,37,103), 3, 5);

    idioma = 0;
    /*do
        cpct_scanKeyboard_f();
    while (!cpct_isAnyKeyPressed()) ;//Cualquier tecla menos el 2 será para elegir versión inglesa. Esto es para poder jugar completamente desde joystick sin necesidad de teclado
    */

    pausaTeclado();
    if (cpct_isKeyPressed(Key_2))
        idioma=1;
    
    cpct_reenableFirmware (firmware);

	if (!cinta) //Si se ha cargado de disco hay que inicializar el AMSDOS/PARADOS
        setupDOS();

    if (idioma)
        *(u8*)&fichero_datos[4] = '2'; //cargar data2.bin si se seleccionó castellano

    //borrarPantalla();  

    //Llamo a una función propia en vez de cpct_setDrawCharM1(3, 1); porque sólo voy a escribir una vez y 
    //no necesito cambiar los colores. Así uso 13 Bytes en vez de 84 Bytes de la función cpctelera
    initDrawChar(); 
    cpct_drawStringM1("LOADING EXTRA BYTES, PLEASE WAIT ....", (char *) 0xC000/*0xC0A2*/);
    //Si los cargo directamente en B000 falla por estar aún activo el firmware, por eso los cargo en la memoria de vídeo
    //y luego los paso a la dirección definitiva, tras desactivar el firmware
    cargarDatos(9,(u8 *) &fichero_datos[0],(char *) 0xC000);
    cpct_disableFirmware(); //Ya están cargados los datos temporalmente en la memoria de vídeo, ya no necesito firmware y lo desactivo para liberar #A6FC-...
    cpct_memcpy ((void*) ADDR_TEXTOS, (void *) 0xC000 , TOTAL_TEXTOS + TOTAL_GRAFICOS + TOTAL_MUSICA); 
    
	//Las variables globales (no constantes) no pueden ser inicializadas directamente en su declaración con el compilador de cpctelera SDCC
    musica = 0;
    musica_off = 0;
    players[0].com = 0;
    players[1].com = 1;
    players[2].com = 1;
    
    //depurar = 0;
    //cpct_setBorder(HW_BLACK); 
    setInterruptAtVSYNCStart(intHandler);

    borrarPantalla();
    cpct_setVideoMode(0);
    cpct_setPalette(paletaM0,16); 
    
    //txtMusicaOff();
    //Pongo directamente el código de la función para ahorrar bytes de la llamada
    f_teletipo = 1;
    f_c = cpctm_screenPtr(CPCT_VMEM_START, 0,100);
    myDrawString(txtMusica);
    f_teletipo = 0; //No va a haber teletipo salvo raras ocasiones donde se pondrá a 1 y se volverá a poner a 0 al final (oráculo,)
    pausa();
    
  	while (1) { 	
	  	//cpct_waitVSYNC();
	  	splitScreen = 1;
	  	menu();
        borrarPantalla();
	  	splitScreen = 0;
	  	setInterruptAtVSYNCStart(intHandler); //Volver a Interrupción normal (sin múltiple modo de vídeo, sólo música)
	  	juego();
		}
}