#include <cpctelera.h>
#include "debug.h"
#include "main.h"
#include "funciones.h"
#include "graficos.h"
#include "consola.h"

// Declaro las variables externas así para ir más rápido
extern const unsigned char G_Tiempo_8[57];
extern const unsigned char G_Tiempo_2[57];
extern unsigned char *f_c; 
extern void myDrawString (unsigned char* f_l);
extern __at(ADDR_TEXTOS+130) unsigned char txtMision1_1[11];

u8* reloj;

u8 cruzar_casilla (u8 objetivo, u8 casilla_pre, u8 casilla_post, u8 movimiento) {
	//movimiento: 0=avanzar; 1=retroceder
	if  ((objetivo >= casilla_pre && objetivo <= casilla_post && !movimiento)
	 || ((objetivo <= casilla_pre && objetivo >= casilla_post && movimiento))) 
		return 1;
	else
		return 0;
}

i8 distancia (TJugador *jugador, u8 mundo, u8 casilla) {
	if (jugador->mundo != mundo) 
		return (ULTIMA_CASILLA - jugador->casilla) + (ULTIMA_CASILLA - casilla); 
	else
		return (casilla - jugador->casilla);
}

u8 IA (TJugador *jugador) {
	u8 decision;
	i8 dist_temp, dist;
	u8 i,mision,mundo_destino;

	decision = 0; //Por defecto avanzar, 

	if (/*jugador->com &&*/ jugador->oraculo_visitado) { //Si no ha visitado oráculo, avanzará por ser el valor por defecto
		//Buscar arma u objetivo más cercano
		dist = 100;

		for (i = 0; i < 2; i++) {
			mision = jugador->mision1;
			if (i)
				mision = jugador->mision2;

			if (!armas_casilla[mision] && armas_mundo[mision] < 3) {//arma ya recogida y misión no completada
				// La primera misión está siempre entre casilla 12 y 13. La segunda,  entre casilla 18 y 19
				dist_temp = distancia (jugador,mision/2,12 + ((mision % 2)*6));  
				mundo_destino = mision/2;
				}
			else { 
				dist_temp = distancia (jugador,armas_mundo[mision],armas_casilla[mision]);
				mundo_destino = armas_mundo[mision];
				}

			if (abs(dist_temp)<abs(dist)) {
				dist = dist_temp;
				decision = dist < 0 ? 1 : 0; 
				jugador->mundo_destino = mundo_destino;
				// Avanzar (0) o Retroceder (1), según el arma esté en una casilla superior o inferior
				// En caso de estar en la casilla (dist = 0), se pone avanzar porque el objetivo en las localizaciones de las misiones
				// es la casilla anterior, es decir, que avanzando 1 pasaría por la localización
			}
		}				
	}

	return decision;
}

u8 prepararDesafio(TJugador *jugador, u8 tipo){ //tipo 0:final; 1: viaje; 2: resto
	u8 exito, seleccion;
	u8 i,j,k, temp;

	exito = 0;
	vidas = 3;

	//Si ha completado ambas misiones => DESAFIO FINAL	
	if (armas_mundo[jugador->mision1] == 3 && armas_mundo[jugador->mision2] == 3){
		if (jugador->com || desafioFinal(jugador))  {
			exito = 1;
			game_over = jugador->id + 1;
		}
	}
	else {
		if (tipo == 1) {
			exito = 1; //marcar éxito si eligió quedarse; ordenador siempre viaja a la primera
		 	if (!(jugador->com) && jugador->mundo_destino != jugador->mundo) { //usuario quiere viajar entre mundos
				exito = jugarViaje(jugador);
			}
		  	if (exito)
		  		jugador->mundo = jugador->mundo_destino;  

		} 
		if (tipo == 2) { //Procedimientos comunes a desafío
			if (jugador->intentos > 1) { //Dar automáticamente el desafío como completado tras fallar 2 veces 
				exito = 2; //es una marca de control para que no se vuelva a pintar el tablero, pues no es necesario volver a pintar el tablero
			} else {
				(jugador->intentos)++;
				if (jugador->com)  {
					// % de éxito: 75% 
					exito = cpct_rand() % 4;
					if (!exito) //Si COM "falla" en el desafío suena como a vida perdida para indicar que no va a tirar dado
						playFX (3, 52);
					else
						exito = 2; //No se puede dejar éxito == 1 porque se reserva para indicar que hay que redibujar tablero, que no es el caso
				} else {
					if (indice_desafios == MAX_DESAFIOS) {
						// Inicializar tabla de desafíos y "barajar"
						for (i = 0; i < MAX_DESAFIOS; i++) {
							tabla_desafios[i]=i;
						}
						for (i = 0; i < 20; i++){ //cambiar 20 veces de manera aleatoria el orden de los desafíos
							j = cpct_rand() % (MAX_DESAFIOS);
							k = cpct_rand() % (MAX_DESAFIOS);
							temp = tabla_desafios [j];
							tabla_desafios[j] = tabla_desafios[k];
							tabla_desafios[k] = temp;
						}
						indice_desafios = 0;
					}
					//desafio = cpct_rand() % MAX_DESAFIOS;
					seleccion = tabla_desafios[indice_desafios];
					indice_desafios++;
					//if (depurar) // Depurar Desafío en concreto (pulsando d en Menú Inicial)
					//	seleccion = depurar - 1;
					//seleccion = 7; 
					exito = desafio(jugador,seleccion);
				}
			}
		}
	}

	if (exito) {
		jugador->intentos = 0; //Reseteamos el contador
	}
	
	return exito;
}

void turno (TJugador *jugador) {
	u8 fila, dado, i,j,k,l;
	u8 casilla_ant;
	u8 salir, noPierdeTurno, exito;
	u8 *grafico_dado, *temp;

	noPierdeTurno = 1;

	cpct_scanKeyboard_f();
	if (cpct_isKeyPressed (Key_Esc)){
		num_turno = 1; //Para mostrar Game Over por Time out (Se restará 1 al finalizar el turno y quedará = 0)
		game_over = 1;
	}
	/*if (cpct_isKeyPressed (Key_M)){
		musica_off = ~musica_off;
		musica = ~musica;
		pausaTecladoLibre();
	}*/

	

//Cambiar Reloj de Arena
	if (!(num_turno % (TOTAL_TURNOS/8)))
		actualizaRelojArena(num_turno / (TOTAL_TURNOS/8));

	//Dibujar situación actual del jugador
	pintarTablero(jugador);	
	//pausa(); 

	//Cambio de mundo (no se repintará después la posición)
	if (jugador->casilla == ULTIMA_CASILLA) {
		fila = jugador->mundo;
		if (!(jugador->com)) {
			salir = 0;
			marcoCenefa(0, 100, 20, 6);
			txtMenuViaje(jugador);
			pausaTecladoLibre();

			while (!salir){
				txtSelecMenu(fila, 3, 20, 140);
				
				if (pressedDown())
					fila++;

				if (pressedUp())
					fila--;

				if (pressedFire()) //si lo pongo en la condición del while como en otros, no funciona ¿¿??
					salir = 1;
				
				//controlar overflow de fila
				if (fila == 255)
					fila++;

				if (fila == PLAYERS)
					fila--;
			}
			jugador->mundo_destino = fila;
		}
		noPierdeTurno = prepararDesafio(jugador,1);//Si ha fallado en viaje, perderá turno

		if (noPierdeTurno) { //Si falla viaje no hace falta volver a pintar el tablero, cambia turno
			pintarTablero(jugador);
		}
	}

	if (noPierdeTurno) {
		exito = prepararDesafio(jugador,2);
	  	if (exito)
	  		cpct_setBorder(HW_GREEN);
	  	else
	  		cpct_setBorder(HW_RED);

		if (exito && !game_over) { 

		  	if (exito == 1) //Se ha borrado el tablero y es necesario volverlo a pintar
		  		pintarTablero(jugador);

			casilla_ant = jugador->casilla;

		//TIRAR DADO	
			fila = 0; 
			do {
				dado = cpct_rand() % 6;
				for (i = 0; i < 64; i++) {//Bucle para que la animación del dado cambiando no sea muy rápida
					grafico_dado =  G_dado_1 + (dado * 56);
					cpct_drawSprite (grafico_dado,cpctm_screenPtr(CPCT_VMEM_START,8,24),4,14);
				}

				fila++;
			} while (fila < 32);
			
			for (i = 1; i < 4; i++) {
				cutreZoomModo0 (grafico_dado, 8,24, 4, 14, i);
				pausa();
			}
			cpct_drawSolidBox (cpctm_screenPtr(CPCT_VMEM_START,2,3),cpct_px2byteM0 (0, 0),16,56); //Borrado hasta factor x4
			txtMenuJuego(jugador);
			dado += 1;
			
		// Menú para avanzar o retroceder
			txtMenuDado(jugador,casilla_ant,dado);
			fila = IA(jugador);
			txtSelecMenu(fila, 2, 0, 18); //Para mostrar opción elegida por COM

			if (!(jugador->com))  {			
				while (!pressedFire()){
					cpct_scanKeyboard_f();
					if ((pressedDown() && !fila) || (pressedUp() && fila)) {
						if (pressedDown())
							fila++;
						else
							fila--;
						
						txtSelecMenu(fila, 2, 0, 18);
					}
				}
			}

			if (!fila) { //avanzar
				jugador->casilla = casilla_ant + dado;
				if (casilla_ant + dado > ULTIMA_CASILLA) 
					jugador->casilla = ULTIMA_CASILLA;
				
					
				if (!(jugador->oraculo_visitado) && jugador->casilla > 7)  //No soprepasar si no se había visitado oráculo
					jugador->casilla = 8;
			} else { //retroceder
				jugador->casilla = casilla_ant - dado;
				if (dado > casilla_ant)
					jugador->casilla = 0;
			}

		//Pintar movimiento de ficha de jugador
			i = casilla_ant;
			while (i != jugador->casilla) {
				j=i;
				if (fila)
					i--;
				else
					i++;

				pintarJugadorTablero(jugador,j,i);
				pausa();
			}

		//Recoger Objetos y completar mision
			if (jugador->oraculo_visitado) { //Ha visitado ya el oráculo
				for (i = 0; i < 2; i++) {
					j = jugador->mision1;
					l = 0;
					if (i) {
						l = 24; //offset para pintado de arma
						j = jugador->mision2;
					}

					//Miramos Completar Misión primero para que no se hagan las 2 cosas a la vez en la misma tirada
					//Para completar misión tenemos que tener el arma en la tirada anterior
					if (!armas_casilla[j] && armas_mundo[j] < 3 && jugador->mundo == j/2  
						&& 	cruzar_casilla (12 + ((j % 2)*6), casilla_ant, jugador->casilla - (1 - fila), fila)) {
						//Si estamos avanzando, no vale con llegar a la casilla de la localización, pues hay que atravesarla.
						//Por eso resto una casilla si estoy avanzando (fila = 0). Si estoy retrocediendo, no lo varío (fila = 1)
						armas_mundo [j] = 3;
						//Cambiar Mision a COMPLETADA
						modificarMision (jugador,i,j, 1);
						playFX (2,52);
						bordeMulticolor();
					}

							// Recoger Objetos
					if (armas_casilla[j] && jugador->mundo == armas_mundo[j]  
		              	&&   cruzar_casilla (armas_casilla[j], casilla_ant, jugador->casilla, fila)) {
		            	//marcar objeto recogido para que se muestre en menú y no más en tablero (si no ha sido recogido ya)
		            	armas_casilla [j] = 0;
		            	playFX (1,28);
		            	bordeMulticolor();

		            	// Mostrar arma recogida parpadeando en el menú
		            	for (k = 0; k < 10; k++) {
		              		if (k % 2) {
		                		f_c = cpct_mygetScreenPtr(0, 58 + l);
		                		temp = (u8*) &txtMision1_1[0] + (jugador->id*40) + 11 + (i*20);
		                		myDrawString(temp);
		                		temp = (u8*) G_Llave + (32 * j);
		                		cpct_drawSpriteMasked (temp, cpct_mygetScreenPtr(18,58 + l), 2, 8);
		              		}
		              		else
		                		cpct_drawSolidBox (cpct_mygetScreenPtr(0,58 + l),cpct_px2byteM0 (0, 0),20,8); 

				            pausa();
		        	    }

		          	}
				}
			}

		//visita al oráculo por primera vez
			if (!(jugador->oraculo_visitado) && jugador->casilla > 7) { 
				oraculo(jugador);
			}

			//Refrescar por si ha habido cambio (objetos, oráculo, misiones)
			txtMenuJuego(jugador);

			if (armas_mundo[jugador->mision1] == 3 && armas_mundo[jugador->mision2] == 3){
				prepararDesafio(jugador, 0); //Llamar a desafío final por si ha completado las 2 misiones en este turno
			}
		}
	}

//FIN TURNO
	for (i = 0; i < 6; i++) 
		pausa();
}

void juego() {
	u8 misiones[2 * PLAYERS],temp,i,j,k;

	//Resetear valores al iniciar nueva partida;
	for (i=0; i < PLAYERS; i++) {
		players[i].id = i;
		players[i].mundo = i;
		players[i].sprite = G_Player1_f1 + (i* 224);
		players[i].casilla = 0;
		players[i].intentos = 0;
		players[i].oraculo_visitado = 0;
	}
	num_turno = TOTAL_TURNOS;
	modo_dificil = 0;
	indice_desafios = MAX_DESAFIOS;
	game_over = 0;

	//players[0].casilla = ULTIMA_CASILLA; //Debug para probar viaje
	inicializaMenuMision();

//MEZCLA ALEATORIA (ARMAS y MISIONES)
	//Inicialmente 2 armas en cada mundo
	for (i = 0; i < 6; i++) {
		armas_mundo[i] = i/2;
	}
	//Casillas para armas, elegir al azar, excepto: 
	//0 (se reserva para marcar arma que no se usará), 
	//ni 8 (casilla a la salida de Oráculo; no quedaría bien coger un arma al salir del oráculo), 
	//ni 22 por si viene de otro mundo (misma razón que 8)
	for (i = 0; i < 6; i++) {
		do { 
			armas_casilla[i] = 1 + (cpct_rand() % (ULTIMA_CASILLA - 1));

			//comprobar que no se haya seleccionado una casilla ya ocupada
			for (j = 0; j < i; j++) {
				if (armas_casilla[i] == armas_casilla[j]){
					armas_casilla[i] = 8;
				}
			}
		} while (armas_casilla[i] == 8);
		armas_activas[i] = 0;
	}
	
	//Las misiones se asignan aleatoriamente al principio por simplicidad. También se sitúan los objetos
	for (i = 0; i < 2 * PLAYERS; i++) {
		misiones[i] = i;
	}
	
	for (i = 0; i < 10; i++){ //cambiar 10 veces de manera aleatoria el orden de misiones
		j = cpct_rand() % (2 * PLAYERS);
		k = cpct_rand() % (2 * PLAYERS);
		temp = misiones [j];
		misiones[j] = misiones[k];
		misiones[k] = temp;
	}

	for (i=0; i< PLAYERS; i++) {
		players[i].mision1 = misiones[2*i];
		players[i].mision2 = misiones[(2*i)+1];
		//Desactivar las armas que no se usarán (jugadores desactivados)
		if (players[i].com == 2) {
			armas_casilla[players[i].mision1] = 0;
			armas_casilla[players[i].mision2] = 0;
		}
	}

	for (i=0; i<10; i++){ //cambiar 10 veces de manera aleatoria la posición inicial de las armas
		j = cpct_rand() % 6;
		k = cpct_rand() % 6;
		if (armas_casilla[j] && armas_casilla[k]){
			temp = armas_mundo [j];
			armas_mundo[j] = armas_mundo[k];
			armas_mundo[k] = temp;

			temp = armas_casilla [j];
			armas_casilla[j] = armas_casilla[k];
			armas_casilla[k] = temp;
		}
	}

	//jugarViaje(&players[0]);

	while (!game_over) { //Mientras no se marque GAME OVER ...
		for (i = 0; i < PLAYERS ; i++) {
		 	if (!game_over && players[i].com != 2){
		 		cpct_setBorder(HW_BLACK);
		 		efecto_pliegue(PLIEGUE);
		 		borrarPantalla();
		 		//cpct_setPalette(paletaM0,16);
		 		cpct_setPalette((u8*) &paleta_khytya[0] + (16*i),16);
		 		marcoCenefa(0, 4, 20, 12);
		 		txtTurno(i);
		 		efecto_pliegue(DESPLIEGUE);
		 		pausa();
				turno(&players[i]);
		 	}
		}

		num_turno--;
		if (num_turno < TOTAL_TURNOS/2)
			modo_dificil = 1;

		if (!num_turno) // GAME OVER por TIME OUT
			game_over = 255;
	}

	//Mostrar GAME OVER
	marcoCenefa(0, 100, 20, 6);
	if (!num_turno) { 
		GameOverTimeOut();
		for (i=8; i; i--) {
			if (i == 8) {
				for (j=0; j<114; j++) {
					relojArenaDesafio[j] = G_RelojArenaOriginal[j];
				}
			} else {
				reloj = (u8*) G_Tiempo_2 + (57*(7-i));
				for (j=0; j<57; j++) {
					relojArenaDesafio[(2*j)+1] = reloj[j];
				}
			}

			//Pintar reloj
			cpct_drawSpriteMasked (relojArenaDesafio, cpctm_screenPtr(CPCT_VMEM_START,0,144), 3, 19); 
			cpct_drawSpriteMasked (relojArenaDesafio, cpctm_screenPtr(CPCT_VMEM_START,77,144), 3, 19); 
			pausa();
		} 
				
	}
	else {
		final(&players[game_over-1]);
	}
	pausaTeclado();
}
