#include <cpctelera.h>
#include "main.h"
#include "funciones.h"
#include "debug.h"
#include "consola.h"
#include "graficos.h"
#include "graficos_2.h"
#include "fonts2B.h"
#include "tableros/khytya.h"
#include "tableros/vendha.h"
#include "tableros/hyrca.h"

/*i8 const tablaDesfase[MAX_PIEDRAS][4] = {
	{ 0,0,0,0},
	{-1,0,1,2},
	{-2,0,2,4},
	{-3,0,3,6},
};*/

i8 const tablaSalto[28] = {-3,0,-3,0,-4,0,-4,0,-3,0,-2,0,-2,0,-1,0,
							1,0,2,0,2,2,3,0,4,4,4,0};

void pintarFondo(u8 color){
	u8 i;

	for (i = 0; i < 2; i++)
		cpct_drawSolidBox (cpct_mygetScreenPtr( (40*i),0),cpct_px2byteM0 (color, color),40,152); 
}

void vidaPerdida(){
	vidas--;
	playFX (3, 52);
	pausa();
}

void pausaTecladoLibre(){
	while (cpct_isAnyKeyPressed_f ()) { //Asegurarnos que se ha dejado de pulsar la tecla anterior 
   		cpct_scanKeyboard_f();
   	}
}

u8 tecladoPulsado(){
	cpct_scanKeyboard_f();
   	return  cpct_isAnyKeyPressed_f();
   }

void pausaTeclado(){
	pausaTecladoLibre();
	while (!tecladoPulsado())
			;
}

void pausa () {
	u16 i;

	for (i = 0; i < PAUSA_SEGUNDO; i++)
			;
}

void efecto_pliegue(u8 modo) {
  u8 i,j;

  i = 200;
  if (modo)
    i = 1;
  
  do {
    cpct_setCRTCReg (1, i/5);   //Cambiar nº columnas por pantalla (1-40)
    cpct_setCRTCReg (6, i/8);   //Cambiar nº de filas por pantallas (1-25)

    for (j = 0; j < 255; j++)
      ;

    if (modo) {
      i++;
    } else {
      i--; 
    }
  } while (i > 0 && i <= 200);
}

void bordeMulticolor(){
	u8 i;

	for (i = 0; i < 255; i ++) {
		cpct_setBorder( cpct_getHWColour(cpct_rand()%27));
	}
	cpct_setBorder(HW_BLACK);
}

u8 maximo (u8 punto1, u8 punto2) {
  return (punto1 > punto2 ? punto1 : punto2);
}

u8 minimo (u8 punto1, u8 punto2) {
	return (punto1 < punto2 ? punto1 : punto2);
}

u8 abs (i8 valor){
	return (valor > 0 ? valor : -valor);
}

u8 pressedUp() {
	return (cpct_isKeyPressed(Key_Q) || cpct_isKeyPressed(Key_CursorUp) || cpct_isKeyPressed(Joy0_Up));
}

u8 pressedDown() {
	return (cpct_isKeyPressed(Key_A) || cpct_isKeyPressed(Key_CursorDown) || cpct_isKeyPressed(Joy0_Down));
}

u8 pressedLeft() {
	return (cpct_isKeyPressed(Key_O) || cpct_isKeyPressed(Key_CursorLeft) || cpct_isKeyPressed(Joy0_Left));
}

u8 pressedRight() {
	return (cpct_isKeyPressed(Key_P) || cpct_isKeyPressed(Key_CursorRight) || cpct_isKeyPressed(Joy0_Right));
}

u8 pressedFire() {
	return (cpct_isKeyPressed(Key_Space) || cpct_isKeyPressed(Key_Return) || cpct_isKeyPressed(Key_Enter) || cpct_isKeyPressed(Joy0_Fire1));
}

void pintarJugadorTablero(TJugador *jugador, u8 anterior, u8 casilla){
	i8 offset;
	u8 *sprite, offset_a;
	//u8 x,y,x0,y0,offset_buffer;

	//offset: Jugador1 se sitúa un byte a la izquierda, Jugador2 en la casilla y Jugador3 uno a la derecha, por si coinciden en la misma casilla
	offset = jugador->id - 1;
	offset_a = 0;
	//offset_buffer = 0;
	if (jugador->id == 1) {
		offset_a = 40;
		//offset_buffer = 20;
	}
	if (jugador->id == 2) {
		offset_a = 80;
		//offset_buffer = 40;
	}

	sprite = (u8*) &G_Ficha1[0] + offset_a;
	//offset_buffer = 20 * jugador->id;

	//offset_buffer = 0;

	if (anterior != casilla) //Restablecer fondo guardado previamente (La primera vez que se pinta el tablero no, pues el buffer tiene datos de otro jugador/tablero/posición)
		cpct_drawSprite (buffer_fondo, cpct_mygetScreenPtr(pos_x[jugador->mundo][anterior] + offset,pos_y[jugador->mundo][anterior]), 2, 10);

	cpct_getScreenToSprite (cpct_mygetScreenPtr(pos_x[jugador->mundo][casilla] + offset,pos_y[jugador->mundo][casilla]), buffer_fondo, 2, 10);

	cpct_drawSpriteMasked (sprite, cpct_mygetScreenPtr(pos_x[jugador->mundo][casilla] + offset,pos_y[jugador->mundo][casilla]), 2, 10);
}

void pintarTablero(TJugador *jugador){
	u8 i,j;
	u8 *temp;
	u8 mundo;
	TJugador *player;

	mundo = jugador->mundo;
	musica = 2 + mundo;
	
	//Tablero
	temp = (u8 *) vendha_end;
	//cpct_setPalette(paleta_vendha,16);
	if (!mundo) {
		temp = (u8 *) khytya_end;
		//cpct_setPalette(paleta_khytya,16);
	}
	else if (mundo == 2) {
		temp = (u8 *) hyrca_end;
		//cpct_setPalette(paleta_hyrca,16);
	}

	cpct_setPalette((u8*) &paleta_khytya[0] + (16*mundo),16);
	cpct_zx7b_decrunch_s((void *) 0xFFFF,(void *) temp);

	//Armas
	for (i = 0; i < 6; i++) {
		if (armas_casilla[i] && armas_mundo[i] == mundo && armas_activas[i]){
			temp = (u8*) &G_Llave[0] + (32 * i);
			cpct_drawSpriteMasked (temp, cpct_mygetScreenPtr(pos_x[mundo][armas_casilla[i]],pos_y[mundo][armas_casilla[i]]), 2, 8);	
		}
	}


	//Pintar Jugadores en ese tablero
	//El jugador actual debe ser el último en pintar para que al restaurar el fondo pinte lo que había antes de él
	//(Por si en esa casilla hay otros jugadores)
	j = jugador->id;
	i = j; 
	do {
		i++;
	
		if (i == PLAYERS)
			i = 0;

		player = (TJugador*) &players[i]; //Puntero a cada uno de los 3 jugadores
		if (player->com != 2 && player->mundo == mundo) //Pintar ficha sólo si está jugando
			pintarJugadorTablero(player, player->casilla, player->casilla);

	} while (i != j);

	//Reloj de Arena
	cpct_drawSpriteMasked (relojArena, cpctm_screenPtr(CPCT_VMEM_START,76,180), 3, 19);

	txtMenuJuego(jugador);
}

void pintarPersonajeAnimado (void* sprite, void* memVideo, u8 frame) {
	if (frame)
		cpct_drawSpriteMasked ((u8*)sprite+84, memVideo, 3, 14);
	else
		cpct_drawSpriteMasked (sprite, memVideo, 3, 14);
}

void marcoCenefa(u8 x, u8 y, u8 ancho, u8 alto) { //ancho y alto del tile (4B * 16px)
	u8 i,j, alto_total,a,b;

	alto_total = alto * 16;

	if (ancho > 10) {
		cpct_drawSolidBox (cpct_mygetScreenPtr(x   ,y),0, 40            , alto_total);
		cpct_drawSolidBox (cpct_mygetScreenPtr(x+40,y),0, 4 * (ancho-10), alto_total);
	} else {
		cpct_drawSolidBox (cpct_mygetScreenPtr(x,y),0, ancho * 4, alto_total);
	}

	a = x;
	for (i = 0; i < ancho; i++){
		b = y;
		for (j = 0; j < alto; j++){
			if (j == 0 || j == (alto - 1) || i == 0 || i == (ancho - 1))
				cpct_drawSprite (G_TileMenu, cpct_mygetScreenPtr(a, b), 4, 16); 
			b = b + 16;
		}
		a = a + 4;
	}
}

void actualizaRelojArena(u8 paso) {
	u8 i, *reloj;

	if (paso == 8) {
		for (i=0; i<114; i++) {
			relojArena[i] = G_RelojArenaOriginal[i];
		}
	} else {
		reloj = (u8*) G_Tiempo_2 + (57*(7-paso));

		for (i=0; i<57; i++) {
			relojArena[(2*i)+1] = reloj[i];
		}
	} 
	
}

void pintarEstrellas() {
	u8 i;

	for (i = 0; i < 20; i++){
		cpct_drawSprite (G_Estrella, cpct_mygetScreenPtr(cpct_rand()%80,cpct_rand()%60), 1, 1 + cpct_rand()%2);
	}

}


void pintarMar(u8 estrellas){
	u8 i;

	//Cielo
	for (i = 0; i < 2; i++)
		cpct_drawSolidBox (cpct_mygetScreenPtr((40*i),0),cpct_px2byteM0 (6, 6),40,65); //6 es azul cielo de la paleta paletaM0

	//Agua
	for (i = 0; i < 2; i++)
		cpct_drawSolidBox (cpct_mygetScreenPtr((40*i),65),cpct_px2byteM0 (10, 10),40,92);//1 es azul oscuro de la paleta paletaM0

	if (estrellas)
		pintarEstrellas();
}

void pintarMarcador(TJugador *jugador, u8 max_lifes){
	u8 i, *sprite;

	marcoCenefa(0,152,20,3);
	marcadorJugador(jugador);
	for (i = 0; i < max_lifes; i++) {
		sprite = (u8*) G_Calavera;
		if (i < vidas)
			sprite = (u8*) G_Corazon;
		
		cpct_drawSprite (sprite, cpct_mygetScreenPtr( 36 + (i*4),170), 4, 14) ;
	}

}


u8 jugarViaje(TJugador *jugador) {
	u8 pos_Balsa, pos_Balsa_ant;
	u8 *sprite_s, *sprite_p, *sprite_b;
	u8 i, j;
	u8 paso, oleadas, altura_sol, x_pajaros;
	u8 tecla_libre;
	u8 tipo,pos_x,pintar;
	u8 piedra_emerge;
	u8 color_cielo;
	u8 color_mar;
	u8 haySol, hayPajaros;


	haySol = cpct_rand() %2;
	// Para que siempre haya al menos uno de los dos
	if (!haySol)
		hayPajaros = 1;
	else
		hayPajaros = cpct_rand() %2;

	pos_Balsa = 70;
	pos_Balsa_ant = 0;
	oleadas = 17;
	altura_sol = 1;
	x_pajaros = 1;
	tecla_libre = 1;
	color_cielo = cpct_px2byteM0 (6, 6);
	color_mar = cpct_px2byteM0 (10, 10);

	musica = 6;
	cpct_setPalette(paletaM0,16);
	pintarMar(0);
	pintarMarcador(jugador,3);

	sprite_p = jugador->sprite; //Coger frame2 del jugador

	piedra_emerge = 56;

	while (vidas && oleadas) {
		paso = 77;
		//inicializar piedras
		for (i = 0; i < MAX_PIEDRAS; i++) {
			piedras[i].pos_x = /*piedras[i].pos_x_ant =*/ 77;
			piedras[i].pos_y = 70 + (20 * i);

			piedras[i].tipo = 2; //Piedra oculta
			if (cpct_rand() % 3 ) //66% de piedra normal
				piedras[i].tipo = 1;
			}

		//Poner 1 o 2 huecos de manera aleatoria
		piedras[cpct_rand() % MAX_PIEDRAS].tipo = 0;
		piedras[cpct_rand() % MAX_PIEDRAS].tipo = 0;

		if (haySol && oleadas == 8) { //oscurecer (cambiar color de mar y cielo)
			*(u8*)&paletaM0[6] = 0x55;
			*(u8*)&paletaM0[10] = 0x44;
			cpct_setPalette(paletaM0,16);
			pintarMar(!hayPajaros);
		}

		//Borrar piedras en margen izquierdo de oleada anterior
		cpct_drawSolidBox (cpct_mygetScreenPtr(0,65), color_mar,5,87); 				
		do {

			paso--;
////////////////////OPERACIONES///////////////////////
			for (i = 0; i < MAX_PIEDRAS; i++) {
				piedras[i].pos_x_ant = piedras[i].pos_x;
				//aplicar desfase según x e y si no va aquedar en negativo
				j = (((paso/20) - 1) * i); //La tabla de desfase se puede resumir en una función para ahorrar código. La tabla está comentada arriba

				piedras[i].pos_x = paso + j;
				if (paso < -j )
					piedras[i].pos_x = 0;

				//decidir si se va a pintar o no esta piedra para aligerar ciclos en la fase de pintado
				piedras[i].pintar = 0;
				tipo = piedras[i].tipo;
				pos_x = piedras[i].pos_x;
				if (tipo && pos_x < 77) {//Se pinta sólo si x=76, por ser sprite de 4px (Puede tener valor mayor a 76 por desfase)
					if (tipo == 1 || pos_x < 30)
						piedras[i].pintar = 1;
					if (tipo == 2 && pos_x < piedra_emerge && pos_x > 40)
						piedras[i].pintar = 13;
					if (tipo == 2 && pos_x < 41 && pos_x > 30)
						piedras[i].pintar = 9;
				}
			}

			//Colisión
			for (i = 0; i < MAX_PIEDRAS; i++) {
				if (piedras[i].tipo 
					&& piedras[i].pos_x < 26 && piedras[i].pos_x > 6 
					&& piedras[i].pos_y == pos_Balsa) {
				
					vidaPerdida();
					paso = 0;
					pintarMar(haySol && !hayPajaros && oleadas < 9);
					pintarMarcador(jugador,3);
				}
			}

			if (!(paso % 35)) 
				altura_sol++;
			
			if (!(paso % 25)) 
				x_pajaros++;

			sprite_s = (u8*) &G_Sol_f1[0];
			sprite_b = (u8*) &G_Pajaro_f1[0];
			if ((paso/10) %2) {
				sprite_s += 60;
				sprite_b += 24;
			}

//////////////////////TECLADO///////////////////////
			cpct_scanKeyboard_f();
			pos_Balsa_ant = 0; //Para borrar sólo si se ha movido
			if (tecla_libre && pressedUp() && pos_Balsa > 70) {
				tecla_libre = 0;
				pos_Balsa_ant = pos_Balsa;
				pos_Balsa -= 20;
			}
			if (tecla_libre &&  pressedDown() && pos_Balsa < 130) {
				tecla_libre = 0;
				pos_Balsa_ant = pos_Balsa;
				pos_Balsa += 20;
			} 

			if (!pressedDown() && !pressedUp())
				tecla_libre = 1;
			
//////////////////////VSYNC////////////////////////
//No da tiempo a pintarlo todo mientras el CRTC está "fuera de pantalla", por lo que tengo que mover borrados y pintados 
//fuera de lo lógico para evitar el flickering o al menos reducirlo al mínimo
//			
//Llegados a este punto el CRTC está normalmente en la parte inferior (casi a la altura del marcador), 
//por lo que puedo actualizar la parte superior (pájaros y sol) y borrar la balsa
//Espero al VSYNC y como el CRTC empezará por arriba es el momento de pintar las piedras y la balsa pues se pintan a mitad de pantalla

			//cpct_setBorder(HW_RED);
			//Pájaros
			if (hayPajaros) {
				cpct_drawSolidBox (cpct_mygetScreenPtr( x_pajaros-1,10),color_cielo,3,8); 
				cpct_drawSprite (sprite_b, cpct_mygetScreenPtr(x_pajaros,10), 3, 8) ;
			}
			
			//Sol
			if (haySol) {
				cpct_drawSolidBox (cpct_mygetScreenPtr( 14 + altura_sol,altura_sol - 1),color_cielo,5,12); 
				cpct_drawSprite (sprite_s, cpct_mygetScreenPtr(15 + altura_sol,altura_sol), 5, 12) ;
			}
			if (pos_Balsa_ant)
				cpct_drawSolidBox (cpct_mygetScreenPtr( 10,pos_Balsa_ant-5),color_mar,16,21);  //Borrar también lo que sobresale del jugador

			
			//cpct_setBorder(HW_BLUE);
			//Borrar Piedras
			if (paso) { //Si ha muerto o acabado oleada, no hace falta borrar
				for (i = 0; i < MAX_PIEDRAS; i++) {
					pintar = piedras[i].pintar;
					if (pintar) {
						cpct_drawSolidBox (cpct_mygetScreenPtr(piedras[i].pos_x_ant,piedras[i].pos_y), color_mar,5,16); 				
					}
				}	
			}

 			//cpct_setBorder(HW_WHITE);
			cpct_waitVSYNC();
			
			

/////////////////////BORRAR y PINTAR/////////////////////
			//cpct_setBorder(HW_GREEN);
			//Pintar Piedras
			if (paso) { //Si ha muerto o acabado oleada no hace falta pintar piedra pues habría que borrar posteriormente
				for (i = 0; i < MAX_PIEDRAS; i++) {
					pintar = piedras[i].pintar;
					if (pintar) {
						//cpct_drawSolidBox (cpct_mygetScreenPtr(piedras[i].pos_x_ant,piedras[i].pos_y), color_mar,4,16);
						pintar--;
						cpct_drawSprite (G_Piedra, cpct_mygetScreenPtr(piedras[i].pos_x,piedras[i].pos_y + pintar), 4, 16 - pintar);
					} else {
						cpct_drawSolidBox (cpct_mygetScreenPtr(0,49), color_cielo,4,16); //Para que el proceso de pintado sea mas o menos constante
					}
				}	
			}
			//cpct_setBorder(HW_YELLOW);
			//Balsa			
			cpct_drawSprite (G_Balsa, cpct_mygetScreenPtr(10,pos_Balsa), 16, 16) ;
			
			//Jugador
			pintarPersonajeAnimado  (sprite_p, cpct_mygetScreenPtr(16,pos_Balsa-5),1);
			
			cpct_setBorder(HW_BLACK);
		} while (paso);
		oleadas--;
	}
	//Restablecer paleta por si se cambió
	*(u8*)&paletaM0[6] = 0x53;
	*(u8*)&paletaM0[10] = 0x5F;

	//Devolver éxito o no
	if (vidas) {
		return 1;
	}
	else {
		return 0;
	}
}

u8 desafioFinal(TJugador *jugador) {
	u8 i,x,movido,girado, cobra_activa;
	u8 *sprite, *sprite_Cobra;
	u16 tiempo;

	if (jugador->com) //Ordenador siempre lo consigue a la primera
		return 1;

	cpct_setPalette(paletaM0,16);
	musica = 5;
	x = 1; //Para que se pueda girar desde posición inicial
	movido = 0; 
	girado = 0;
	tiempo = 600; //75 pasos * 8 ciclos
	cobra_activa = 0;
	initTime(7,5);

	//cpct_setPalette(paletaM0,16);
	pintarFondo(4);
	pintarEstrellas();
	pintarMarcador(jugador,3);
	while (vidas && x < 73 && tiempo) {
		//Guardar posición
		i = x;

		//Activar cobra
		if (!cobra_activa && (cpct_rand() % 2))
			cobra_activa = 1;

		//Leer teclado
		cpct_scanKeyboard_f();
		if (pressedLeft() && x) {
			x--;
			girado = 1;
		}
		if (pressedRight()) {
			x++;
			girado = 0;
		}
		pausaTecladoLibre();

		if (x != i) { //personaje se movió, cambiar frame y Borrar personaje
			movido = ~movido;
			cpct_drawSolidBox (cpct_mygetScreenPtr(i,138),cpct_px2byteM0 (4, 4),3,14);
		}

		if (cobra_activa)
			cobra_activa++;

		sprite = jugador->sprite;
		sprite_Cobra = (u8*) &G_Cobra_A[0];
		if (movido) 
			sprite += 84; //Frame2
		if (girado)
		 	sprite = jugador->sprite + 168; //Frame3

		if (cobra_activa > 118) 
			sprite_Cobra = (u8*) &G_Cobra_C[0];

		if (cobra_activa > 130) {
			sprite_Cobra = (u8*) &G_Cobra_B[0];
			if (!girado) { //volver al principio si no está girado para evitar la mirada.
				vidaPerdida();
				cobra_activa = 0;
				x=1;
				pintarFondo(4);
				pintarEstrellas();
				pintarMarcador(jugador,3);
			}
		}
		if (cobra_activa > 180) {
			cobra_activa = 0;
		}

		//Restar contador de tiempo
		if (!(tiempo % 8)) {
			txtPintarTime();
			decTime();
		}
		tiempo--;

		cpct_waitVSYNC();
		cpct_drawSprite (sprite_Cobra, cpctm_screenPtr(CPCT_VMEM_START,75,122), 5, 30);
		cpct_drawSpriteMasked (sprite, cpct_mygetScreenPtr(x,138),  3 - girado, 14); //El sprite girado ocupa 2Bytes (4pixels)
	}

	//Devolver éxito o no
	if (tiempo && vidas) 
		return 1;
	else 
		return 0;
}

void pintarBaldosa(u8 x, u8 y) {
	u8 *sprite;

	sprite = (u8*) G_Suelo_vacio;
	if (cuadrilla[x][y] == 1) 
		sprite = (u8*) G_Suelo_lleno;
	if (cuadrilla[x][y] == 2) 
		sprite = (u8*) G_Suelo_salida;

	cpct_drawSprite (sprite, cpct_mygetScreenPtr(7+(5*x),25+(20*y)), 5, 20);
}

void pintarCamino() {
	u8 i,j;

	for (i = 0; i < 13; i++)
		for (j = LIMITE_SUPERIOR_CAMINO; j <= LIMITE_INFERIOR_CAMINO; j++) 
			pintarBaldosa(i, j);

	j = 8;
	if (modo_dificil)
		j = 4;

	for (i = 0; i < j; i++)
		pausa();
}

void pintarBoton(u8 color, u8 borrado, TJugador *jugador, u8 sonido) {
	u8 x,y, *sprite;

	//Azul Derecha (color == 3)
	x = 46;
	y = 68;
	sprite = (u8*) &G_Boton_Azul[0];

	if (color == 0) { //Rojo Arriba
		x = 38;
		y = 40;
		sprite = (u8*) &G_Boton_Rojo[0];
	}
	if (color == 1) { //Verde Abajo
		x = 38;
		y = 96;
		sprite = (u8*) &G_Boton_Verde[0];
	}
	if (color == 2) { //Amarillo Izquierda
		x = 31;
		//y = 68;  //ya está inicializado a ese valor
		sprite = (u8*) &G_Boton_Amarillo[0];
	}

	if (borrado) //borrar todo el área
		cpct_drawSolidBox (cpctm_screenPtr(CPCT_VMEM_START,  31, 40), 0, 19, 72); 

	cpct_waitVSYNC();
	//Pintar Botón
	cpct_drawSprite (sprite, cpct_mygetScreenPtr(x,y), 4, 16);

	if (sonido)
		playFX (4,48 + (color * 4));

	//Pintar jugador, si procede
	if (jugador) {
		sprite = jugador->sprite + 168; //Frame3
		cpct_drawSpriteMasked (sprite, cpctm_screenPtr(CPCT_VMEM_START,39,68),  2, 14);
	} else { //Si estamos reproduciendo el patrón, ponemos pausa según modo dificultad
		for (x = 0; x < (2 - modo_dificil); x++)
			pausa();
	}
}

void reproducirPatron() {
	u8 i;

	borrarPantalla();
	marcoCenefa(0,8,20,9);

	i = 6;
	do {
		i--;
		pintarBoton(cuadrilla[i][0],1, (TJugador *) 0x0000, 1); //No mostrar sprite del jugador
	} while (i);
}

u8 desafio(TJugador *jugador, u8 desafio) {
	u8 i,j,k,ok,pos_original;
	u8 color_negro;

	u8 patrones;
	u8 anterior, actual;
	u8 nota_actual,boton_pulsado;

	u8 x,y,x_ant,y_ant, *sprite;
	//u8 a,b,c,d; //límites del área de juego 
	u8 calaveras[2][6];
	u8 movido;
	u16 tiempo;
	u8 max_x0,min_x1,max_y0,min_y1;

	u8 objetivo;
	u8 *reloj, paso;

	u8 flecha1_x,flecha1_y,flecha1_cooldown;
	u8 flecha2_x,flecha2_y,flecha2_cooldown;

	color_negro = cpct_px2byteM0 (0, 0);
	musica = 6;
	sprite = jugador->sprite;
	borrarPantalla();
	cpct_setPalette(paletaM0,16);

	if (desafio == 4 || desafio ==7)
		vidas = 1;

////////////// CAMINO OCULTO //////////////////
	if (desafio == 0) {
		//Inicializar camino y aprovechar para meter algunas baldosas aleatorias
		for (i = 0; i < 13; i ++)
			for (j = 0; j < 5; j ++) {  //Cuadrilla de 13 columnas * 5 filas
				if (cpct_rand()%8)
					cuadrilla[i][j] = 0;
				else
					cuadrilla[i][j] = 1;
			}

		y = 2 + cpct_rand() % 3; //salida siempre en una de las 3 filas centrales para que el camino generado sea de dificultad similar siempre
		x = 12; 
		cuadrilla[x][y] = 2;
		
		//x llevará la columna; y, la fila
		while (x) {
			ok = 0;
			do {
				k = cpct_rand() % 3; //0=arriba; 1=izquierda; 2=abajo

				if (k == 0 && y > LIMITE_SUPERIOR_CAMINO) {
					y--;
					ok = 1;
				}
				if (k == 1) {
					x--;
					ok = 1;
				}
				if (k == 2 && y < LIMITE_INFERIOR_CAMINO) {
					y++;
					ok = 1;
				}
			} while (!ok);
			if (cuadrilla[x][y] != 2) //no sobreescribir la salida
				cuadrilla[x][y] = 1;
		}

		pintarFondo(2);
		pintarCamino();

		//Borrar Camino
		min_y1 = 25;
		max_y0 = 100;
		
		cpct_drawSolidBox (cpctm_screenPtr(CPCT_VMEM_START, 7,25),color_negro, 40 ,100); 
		cpct_drawSolidBox (cpctm_screenPtr(CPCT_VMEM_START,47,25),color_negro, 25 ,100);
		
		k = 0; //marca éxito
		ok = 0; //controlar qué frame del jugador pintar
		pos_original = y; //Guardar posición original de y para restablecer al morir
		pintarMarcador(jugador,3);
		while (vidas) {
			//Guardar posición
			i = x;
			j = y;

			//Leer teclado
			cpct_scanKeyboard_f();
			if (pressedUp() && y > LIMITE_SUPERIOR_CAMINO)
				y--;
			if (pressedDown() && y < LIMITE_INFERIOR_CAMINO)
				y++;
			if (pressedLeft() && x)
				x--;
			if (pressedRight() && x < 12)
				x++;
			
			pausaTecladoLibre();

			if (x != i || y != j) //personaje se movió, cambiar frame
				ok = ~ok;
			
			cpct_waitVSYNC();
			pintarBaldosa(i, j); //Pintar Baldosa de posición anterior para borrar personaje
			pintarBaldosa(x, y); //Pintar Baldosa de posición actual
			pintarPersonajeAnimado (sprite, cpct_mygetScreenPtr(8+(5*x),28+(20*y)),ok);

			if (!cuadrilla[x][y]) {
				pintarBaldosa(x,y); 
				vidaPerdida();
				x=0;
				y=pos_original;
				pintarMarcador(jugador,3); //Pintar las nuevas vidas
			}

			if (cuadrilla[x][y] == 2) { //Pintar la salida
				//pintarCamino(8);
				return 1; //marcar éxito
			}

		}
		pintarCamino();
	}
////////////// REPETIR PATRON //////////////////
	if (desafio == 1) {
		borrarPantalla();
		//Parar música para que se oigan bien los FX (botón)
		musica = 255; 
		cpct_akp_stop();
		//Inicializar patron (6 notas)
		anterior = 255;
		for (j = 0; j < 6; j++) {
			do {
				actual = cpct_rand() % 4; //Coger uno de los 4 botones al azar
			} while (actual == anterior);
			cuadrilla[j][0] = actual;
			anterior = actual;
		}
				
		patrones = 1; 
		while (vidas && patrones) {
			nota_actual = 5; //longitud del patrón - 1

			reproducirPatron();
			pintarMarcador(jugador,3);
			//Pantalla inicial (4 botones + jugador)
			for (j=0; j<4; j++)
				pintarBoton(j,0,jugador, 0);

			while (j) { //Repetir patrón (j viene ya con un valor > 0)
				boton_pulsado=4; //botón pulsado 0:arriba; 1:abajo; 2:izquierda; 3:derecha; 4:otro (sin acción)
				cpct_scanKeyboard_f();
				if (pressedUp())
					boton_pulsado=0;
				else if (pressedDown())
					boton_pulsado=1;
				else if (pressedLeft())
					boton_pulsado=2;
				else if (pressedRight())
					boton_pulsado=3;

				if (boton_pulsado < 4) {
					pintarBoton(boton_pulsado,1, jugador, 1);
					if (boton_pulsado == cuadrilla[nota_actual][0]) {
						if (nota_actual) //completado patron, cambiar
							nota_actual--;
						else{
							patrones--;						
							j = 0;
						}
					}
					else {
						vidaPerdida();
						j = 0; //Salir de bucle para repetir patrón
					}
					pausaTecladoLibre();
				}

			}
		}

		//musica = 1; ***
		if (vidas)  
			return 1;
	}	

/////////////// SUPERVIVENCIA //////////////////
	if (desafio == 2) {
	
		tiempo = 1;
		//pintarFondo(5);
		for (i=0;i<8;i++)
			for (j=0;j<16;j++) {
				cpct_drawSprite (G_Tile2, cpct_mygetScreenPtr((5*j),(20*i)), 5, 20);
			}

		while (vidas) {
			//Pintar área de juego
			cpct_drawSolidBox (cpctm_screenPtr(CPCT_VMEM_START, 20,20),color_negro, 40 , 110);
			pintarMarcador(jugador,3);
			tiempo = 480; //60 pasos * 8 ciclos
			initTime(6,0);

			//Posición Inicial jugador
			x = 40;
			y = 75;
			movido = 0;
			//Posición inicial calaveras
			calaveras[0][0] = 22;
			calaveras[0][1] = 32;
			calaveras[1][0] = 51;
			calaveras[1][1] = 100;
			for (i=0;i<2;i++){
				calaveras[i][4] = 2 * (cpct_rand()%2);
				calaveras[i][5] = 2 * (cpct_rand()%2);
			}

			while (tiempo) {
	//OPERACIONES		
				x_ant = x;
				y_ant = y;
				for (i=0;i<2;i++){
					calaveras[i][2] = calaveras[i][0];
					calaveras[i][3] = calaveras[i][1];
				}

	//TECLADO
				cpct_scanKeyboard_f();
				if (pressedLeft() && x > 20)
					x--;
				if (pressedRight() && x < 57)
					x++;
				if (pressedUp() && y > 21) 
					y -=2;	//Incrementar 2 pasos en vez de 1 para que se mueva más rápido	
				if (pressedDown() && y < 115)
					y +=2;
				
				if ((x!=x_ant) || (y!=y_ant) != 0)
					movido = ~movido;

				//Mover calaveras
				if (tiempo < 440) { //Pausa de cortesía al principio
					for (i = 0; i < 2; i++){
						if (i || tiempo%2 || modo_dificil){
							calaveras[i][1] = calaveras[i][1] + calaveras[i][5] - 1;
							calaveras[i][0] = calaveras[i][0] + calaveras[i][4] - 1;
						}
							//Revisar si hemos llegado a topes para cambiar dirección
							if (calaveras[i][0] == 20) 
								calaveras[i][4] = 2; //desplazar a +x
							if (calaveras[i][0] == 56) 
								calaveras[i][4] = 0; //desplazar a -x
							if (calaveras[i][1] == 20) 
								calaveras[i][5] = 2; //desplazar a +y
							if (calaveras[i][1] == 116) 
								calaveras[i][5] = 0; //desplazar a -y
					}
				}

	///VSYNC
				cpct_waitVSYNC();					
				
	//BORRAR
				cpct_drawSolidBox (cpct_mygetScreenPtr(x_ant,y_ant),0,3,14);
				for (i=0;i<2;i++){
					cpct_drawSolidBox (cpct_mygetScreenPtr(calaveras[i][2],calaveras[i][3]),0,4,14);
				}
	//PINTAR

				cpct_drawSprite (G_Calavera, cpct_mygetScreenPtr(calaveras[0][0],calaveras[0][1]),4,14); 
				cpct_drawSprite (G_Calavera, cpct_mygetScreenPtr(calaveras[1][0],calaveras[1][1]),4,14); 
				pintarPersonajeAnimado(sprite, cpct_mygetScreenPtr(x,y),movido);

				//Restar contador de tiempo
				if (!(tiempo % 8)) {
					txtPintarTime();
					decTime();
				}

				tiempo--;
				if (tiempo) {
					//¿Colisión?
					for (i = 0; i < 2; i++){
						max_x0 = maximo (x, calaveras[i][0]);
						min_x1 = minimo (x + 3,calaveras[i][0] + 4);
						max_y0 = maximo (y, calaveras[i][1]);
						min_y1 = minimo (y + 14,  calaveras[i][1] + 14);
						if (max_x0 < min_x1 && max_y0 < min_y1) {
							//hay recuadro de intersección, colisión en este caso (no se mirará al pixel)
							vidaPerdida();
							cpct_drawSolidBox (cpctm_screenPtr(CPCT_VMEM_START, 20,20),color_negro, 40 , 110);

							j = 116;
							do {
								cpct_drawSprite (txtAMC, cpct_mygetScreenPtr(29,j), 10, 8);
								cpct_drawSprite (txtAMC, cpct_mygetScreenPtr(41,j), 10, 8);

								for (k = 0; k < 25 ; k++)
									cpct_waitVSYNC();

								cpct_drawSolidBox (cpct_mygetScreenPtr(29,j),color_negro, 22 , 8);
								j = j - 8;
							} while (j > 19);
							
							tiempo = 0;
							break; //Salir del bucle. Si no puede haber colisión con la otra calavera y quitar otra 2 vidas a la vez
						}
					}
				} 
				else //llegamos a tiempo 0 (éxito)
					return 1;
			}
		}

	}

////////////// PARAR TIEMPO //////////////////
	if (desafio == 3) {
	
		paso = 8;
		//divisor = 4; // pasa a constante

		while (vidas) {
			pintarFondo(13);
			for (i = 0; i < 2; i++)
				cpct_drawSolidBox (cpct_mygetScreenPtr((40*i),0),cpct_px2byteM0 (6, 6),40,90);

			pintarMarcador(jugador,3);

			objetivo = 1 + cpct_rand() % 20; //objetivo no puede ser 0
			tiempo = 40 * DIVISOR_DESAFIOS;
			initTime(4,0);
			if (modo_dificil) {
				tiempo = 30 * DIVISOR_DESAFIOS;
				initTime(3,0);
			}

			txtStopTime(objetivo);
			pintarPersonajeAnimado (sprite,cpctm_screenPtr(CPCT_VMEM_START,26,80),0 );						

			while (tiempo) {
				txtPintarTime();
				
				if (tecladoPulsado()) {
					if ((tiempo / DIVISOR_DESAFIOS) == objetivo)
						return 1;
					else {
						tiempo = 1;
					}
				}	
				
				if (!(tiempo % DIVISOR_DESAFIOS)) {
					decTime();

					if (paso == 8) {
						for (i=0; i<114; i++) {
							relojArenaDesafio[i] = G_RelojArenaOriginal[i];
						}
					} else {
						reloj = (u8*) G_Tiempo_2 + (57*(7-paso));

						for (i=0; i<57; i++) {
							relojArenaDesafio[(2*i)+1] = reloj[i];
						}
					} 

					//Pintar reloj
					cpct_drawSpriteMasked (relojArenaDesafio, cpctm_screenPtr(CPCT_VMEM_START,16,71), 3, 19); 

					paso--;

					if (!paso)
						paso = 8;
				}

				--tiempo;
			}
			vidaPerdida();
		}
	}
////////////// PAREDON //////////////////
	if (desafio == 4) {
		//desafío de suerte
		cpct_drawSolidBox (cpctm_screenPtr(CPCT_VMEM_START,0,0),cpct_px2byteM0 (5, 5),16,152);
		
		pintarMarcador(jugador,1);
		while (vidas) {
			i = cpct_rand()%3;
			j = i + 1;
			if (j > (PLAYERS-1))
				j = j - PLAYERS;

			k = i + 2;
			if (k > (PLAYERS-1))
				k = k - PLAYERS;

			
			cpct_waitVSYNC();
			cpct_drawSolidBox (cpctm_screenPtr(CPCT_VMEM_START,17,49),color_negro,8,55);

			sprite = (u8*) &G_Player1_f1[0] + (j * 224);
			pintarPersonajeAnimado (sprite, cpctm_screenPtr(CPCT_VMEM_START,17,49),0);
			sprite = (u8*) &G_Player1_f1[0] + (i * 224);
			pintarPersonajeAnimado (sprite, cpctm_screenPtr(CPCT_VMEM_START,17,69),0);
			sprite = (u8*) &G_Player1_f1[0] + (k * 224);
			pintarPersonajeAnimado (sprite, cpctm_screenPtr(CPCT_VMEM_START,17,89),0);

			cpct_drawSprite (G_Flecha_I, cpctm_screenPtr(CPCT_VMEM_START,75,52), 5, 5); 
			cpct_drawSprite (G_Flecha_I, cpctm_screenPtr(CPCT_VMEM_START,75,92), 5, 5); 

			cpct_scanKeyboard_f();
			if (cpct_isAnyKeyPressed_f() ) {
				for (j = 75; j > 20; j--) {
					cpct_drawSprite (G_Flecha_I, cpct_mygetScreenPtr(j,52), 5, 5); 
					cpct_drawSprite (G_Flecha_I, cpct_mygetScreenPtr(j,92), 5, 5); 
					for (k = 0; k < 255; k++)
						;
				}
				pausa();

				cpct_drawSprite (G_Calavera, cpctm_screenPtr(CPCT_VMEM_START,17,50), 4, 14) ; 
				cpct_drawSprite (G_Calavera, cpctm_screenPtr(CPCT_VMEM_START,17,90), 4, 14) ; 

				if (i != jugador->id) {
					vidaPerdida();
					pintarMarcador(jugador,1);
				}

				for (j = 0; j < 4; j++)
					pausa();

				if (i == jugador->id)
					return 1;
			}
		}
	}
////////////// SUMA COLORES //////////////////
	if (desafio == 5) {
		while (vidas) {
			borrarPantalla();
			objetivo = 0;
			pintarMarcador(jugador,3);
			//Dar valores aleatorios a los botones y calcular valor a conseguir. También pintar valor de cada botón
			for (i = 0; i < 4; i++){
				cuadrilla[0][i] = 2 + (2 * i) + (cpct_rand() % 2);  //Asociar color a número
				cuadrilla[1][i] = 1 + (cpct_rand() % 2); 
				cuadrilla[2][i] = 2;					 // Inicializar el nº de veces que podrá usarlo jugador
				objetivo += (cuadrilla[0][i] * cuadrilla[1][i]);
				cpct_drawSprite ((u8*)&G_Boton_Rojo[0] + (64*i), cpct_mygetScreenPtr(0,i*20), 4, 16);
				cpct_drawSprite ((u8*)&G_S0 + (16*cuadrilla[0][i]), cpct_mygetScreenPtr(5,i*20), 2,8);
			}
			//Pintar objetivo
			cpct_drawSprite ((u8*)&G_S0 + (16*(objetivo/10)), cpctm_screenPtr(CPCT_VMEM_START,40,0), 2,8);
			cpct_drawSprite ((u8*)&G_S0 + (16*(objetivo%10)), cpctm_screenPtr(CPCT_VMEM_START,42,0), 2,8);
			cpct_drawSprite ((u8*)&G_exc[0], cpctm_screenPtr(CPCT_VMEM_START,44,0), 2,8);
			

			//Inicializar tiempo
			//divisor = 4;
			tiempo = 99 * DIVISOR_DESAFIOS;  //99 pasos * 4 ciclos en modo fácil
			initTime(9,9);
			if (modo_dificil) {
				tiempo = 70 * DIVISOR_DESAFIOS;  //70 pasos * 4 ciclos en modo fácil
				initTime(7,0);
			}

			actual = 0; //Suma del jugador
			j=0; //Bloque seleccionado
			y=0; //Altura de bloques resultado
			//bloques a usar
			for (i = 0; i < 4; i++) 
				for (k = 0; k < 2; k++) 
					cpct_drawSprite ((u8*)&G_Boton_Rojo[0] + (64*i), cpct_mygetScreenPtr(44 + (k*5),20 + (i*20)), 4, 16);
				
			while (tiempo) {
				txtPintarTime();
				
				anterior = j;
				//teclado
				cpct_scanKeyboard_f();
				if (pressedUp() && j)  
					j--;
				if (pressedDown() && j < 3)
					j++;
				if (pressedFire() && cuadrilla[2][j]) {
					//pintar columna resultado
					cpct_drawSprite ((u8*)&G_Boton_Rojo[0] + (64*j), cpct_mygetScreenPtr(76,y), 4, 16);
					y +=18;
					//actualizar valor actual
					actual += cuadrilla[0][j];
					cuadrilla[2][j]--;
					cpct_drawSolidBox (cpct_mygetScreenPtr(44 + (cuadrilla[2][j]*5),20 + (j*20)),0,4,16);
				}
				pausaTecladoLibre();
				//borrar
				cpct_drawSolidBox (cpct_mygetScreenPtr(40,20 + (anterior*20)),0,3,14);
				cpct_waitVSYNC();
				pintarPersonajeAnimado(sprite,cpct_mygetScreenPtr(40,20 + (j*20)),1);
				if (objetivo == actual)
					return 1;

				if (y == 144) //Se han usado todos los bloques, matar vida para no tener que esperar contador a 0
					tiempo = 1;

				if (!(tiempo % DIVISOR_DESAFIOS)) {
					decTime();
				}
				--tiempo;
			}
			vidaPerdida();
		} 
	}
////////////// LLUVIA ÁCIDA //////////////////
	if (desafio == 6) {	
		//tiempo = 1;
		for (i=0;i<8;i++)
			for (j=0;j<16;j++) {
				if (j < 5 || j > 11)
				cpct_drawSprite (G_Suelo_lleno, cpct_mygetScreenPtr((5*j),(20*i)), 5, 20);
			}

		
		while (vidas) {
			//Inicializar gotas
			for (i = 0; i < MAX_GOTAS; i++) {
				cuadrilla[i][0] = 20 + (i * (40/MAX_GOTAS)); // X de la gota
				cuadrilla[i][1] = 0;			 			// Y de la gota (Y == 0 NO está activa)
				cuadrilla[i][2] = cpct_rand() % 40; 		// "Cooldown" de la gota (periodo inactivo)
			}

			//Pintar área de juego
			cpct_drawSolidBox (cpctm_screenPtr(CPCT_VMEM_START, 20,0),color_negro, 40 , 152);
			pintarMarcador(jugador,3);
			tiempo = 480; //70 pasos * 8 ciclos
			initTime(6,0);
			if (modo_dificil) {
				tiempo = 792; //99 pasos * 8 ciclos
				initTime(9,9);
			}

			//Posición Inicial jugador
			x = 40;
			y = 138;
			movido = 0;

			while (tiempo) {
	//OPERACIONES		
				x_ant = x;
				y_ant = y;

				for (i = 0; i < MAX_GOTAS; i++) {
					if (cuadrilla[i][1]) { //Gota Activa
						cuadrilla[i][1] += 2;	
					} else { // Esperar Cooldown
						if (cuadrilla[i][2] == 0) { 
							cuadrilla[i][1] = 1;
						}
					}
					
					cuadrilla[i][2]--; //Reducir Cooldown

					if (cuadrilla[i][1] > 138) {
						cuadrilla[i][1] = 0;
						cuadrilla[i][2] = cpct_rand() % 20;
						cpct_drawSolidBox (cpct_mygetScreenPtr(cuadrilla[i][0],138),0,3,13);
					}
				}

	//TECLADO
				cpct_scanKeyboard_f();
				if (pressedLeft() && x > 20)
					x--;
				if (pressedRight() && x < 57)
					x++;
				
				if ((x!=x_ant) != 0)
					movido = ~movido;

	///VSYNC
				cpct_waitVSYNC();					
				
	//BORRAR
				cpct_drawSolidBox (cpct_mygetScreenPtr(x_ant,y_ant),0,3,14);
				
	//PINTAR
				for (i = 0; i < MAX_GOTAS; i++) {
					if (cuadrilla[i][1])
						cpct_drawSprite (G_Gota, cpct_mygetScreenPtr(cuadrilla[i][0],cuadrilla[i][1]), 3,13);
				}
				pintarPersonajeAnimado(sprite, cpct_mygetScreenPtr(x,y),movido);

				//Restar contador de tiempo
				if (!(tiempo % 8)) {
					txtPintarTime();
					decTime();
				}

				tiempo--;
				if (tiempo) {
					//¿Colisión?
					for (i = 0; i < MAX_GOTAS; i++) {
						if (cuadrilla[i][1] < (138 - 13) || abs (cuadrilla[i][0] - x) > 2)
							;
						else { 
							vidaPerdida();
							tiempo = 0;
							break; //Salir del bucle. Si no puede haber colisión con la otra calavera y quitar otra 2 vidas a la vez
						}
					}
				} 
				else //llegamos a tiempo 0 (éxito)
					return 1;
			}
		}		
	}
////////////// TIRO AL ARCO //////////////////
	if (desafio == 7) {	
		actual = 28 + cpct_rand() % 10; //Posición del jugador aleatoria [28,37]
		patrones = 1;
		x = actual + 5; // X de la Flecha
		y = 0;  // Y de la Flecha (Y == 0 inactiva)
		i = 0;  // Y de la calavera
		j = cpct_rand() % 50;  // cooldown de la calavera	
		k = 0; // Dirección de la calavera. 0 = arriba a abajo; 1 = abajo a arriba
		pintarMarcador(jugador,1);


		cpct_drawSolidBox (cpctm_screenPtr(CPCT_VMEM_START,0,85),cpct_px2byteM0 (2, 5),40,10); //tierra
		cpct_drawSolidBox (cpctm_screenPtr(CPCT_VMEM_START,0,95),cpct_px2byteM0 (8, 8),40,57); //hierba

		while (patrones && vidas) {
		//OPERACIONES	
			if (i == 0) {
				cpct_drawSolidBox (cpctm_screenPtr(CPCT_VMEM_START,76,1),0,4,14); //Pintar en i anterior
			}
			if (i == (151 - 14) ) {
				cpct_drawSolidBox (cpct_mygetScreenPtr(76,i),0,4,14); //No es necesesario en i anterior porque la primera fila del sprite calavera es negro
				i = 0;  
			}

			j--;

			if (!j) {  //Aparición de la calavera
				k = cpct_rand() % 2; 
				if (k)
					i = (151 - 14) - (15 * modo_dificil);
				else
					i = 1 + (15 * modo_dificil);
			}

			if (i) //Calavera activa
				if (k) //Está subiendo
					i--;
				else //Está bajando
					i++;

			if (y) {
				x++;

				//¿colisión?
				if (x > 71 && i > 60 && i < 77 ) {
					playFX (2,52);
					bordeMulticolor();
					patrones--;
				}

				if (x == 75) { //Llegó al final de pantalla
					vidaPerdida();
					pintarMarcador(jugador,1);
				}
			}

		//TECLADO
			cpct_scanKeyboard_f();
			if (pressedFire() && !y){
				y = 73;
			}

		///VSYNC
			cpct_waitVSYNC();					
			
		//BORRAR Y PINTAR
			//Flecha
			if (y) {
				//Se autoborra por tener marco negro donde dejaría estela
				cpct_drawSprite (G_Flecha_D, cpct_mygetScreenPtr(x,73), 5,5);
			}

			//Calavera
			if (i) {
				cpct_drawSolidBox (cpct_mygetScreenPtr(76,i-1+(2*k)),0,4,14);
				cpct_drawSprite (G_Calavera, cpct_mygetScreenPtr(76,i), 4,14);
			}
			//Jugador
			cpct_drawSolidBox (cpctm_screenPtr(CPCT_VMEM_START,actual,69),0,3,16);
			pintarPersonajeAnimado (sprite,cpct_mygetScreenPtr(actual,69),y);

		}
		if (vidas)
			return 1;
	}
////////////// SALTO LANZAS //////////////////
	if (desafio == 8) {	

		while (vidas) {
			pintarFondo(0);
			for (i=0;i<5;i++)
				for (j=0;j<(7-i);j++) {
					cpct_drawSprite (G_Suelo_lleno, cpct_mygetScreenPtr((5*j),(20*i)), 5, 20);
					cpct_drawSprite (G_Suelo_lleno, cpct_mygetScreenPtr(45+(5*i)+(5*j),(20*i)), 5, 20);
				}

			//Inicializar 
			flecha1_x = flecha2_x = 0;
			flecha1_y = flecha2_y = 0;			 			// Y de la flecha (Y == 0 NO está activa)
			flecha1_cooldown = cpct_rand() % 50; 		// "Cooldown" de la flecha (periodo inactivo)
			flecha2_cooldown = cpct_rand() % 50; 		// "Cooldown" de la flecha (periodo inactivo)

			j = 0; //salto
			
			pintarMarcador(jugador,3);
			tiempo = 480; //60 pasos * 8 ciclos
			initTime(6,0);
			if (modo_dificil) {
				tiempo = 792; //99 pasos * 8 ciclos
				initTime(9,9);
			}

			//Posición Inicial jugador
			x = 40;
			y = 138;
			movido = 0;

			while (tiempo) {
	//OPERACIONES		
				x_ant = x;
				y_ant = y;

				//Avanzar flecha
				if (flecha1_y) { 
					flecha1_x++;
				}
				
				if (flecha2_y) { //Avanzar flecha
					flecha2_x--;
				}

				//Flecha llegó al final
				if (flecha1_x == 75 && flecha1_y) { 
					cpct_drawSolidBox (cpct_mygetScreenPtr(flecha1_x,flecha1_y),0,5,5);
					flecha1_y = 0;
					flecha1_cooldown = cpct_rand() % 50;
				}

				if (flecha2_x == 0 && flecha2_y) {
					cpct_drawSolidBox (cpct_mygetScreenPtr(flecha2_x,flecha2_y),0,5,5);
					flecha2_y = 0;
					flecha2_cooldown = cpct_rand() % 50;
				}
				 
				//Terminó cooldown, disparar flecha
				flecha1_cooldown--;
				flecha2_cooldown--;

				if (!flecha1_cooldown && !flecha1_y) {
					flecha1_x = 0;
					flecha1_y = 147 - cpct_rand() % 28;
				}

				if (!flecha2_cooldown && !flecha2_y) {
					flecha2_x = 75;
					flecha2_y = 147 - cpct_rand() % 28;
				}
					
	//TECLADO
				cpct_scanKeyboard_f();
				//No dejo que se pueda acercar el personaje a los márgenes porque ahí la flecha desaparece, sería una zona casi segura
				if (pressedLeft() && x > 1)
					x--;
				if (pressedRight() && x < 76)
					x++;
				if ((pressedUp() || pressedFire()) && !j)
					j = 1;
				
				if (j) { 
					y = y + tablaSalto[j-1];
					if (j == 28) //fin de salto
						j = 0;
					else
						j++;
				}

				if ((x!=x_ant) != 0)
					movido = ~movido;

	///VSYNC
				cpct_waitVSYNC();					
				
	//BORRAR PERSONAJE
				cpct_drawSolidBox (cpct_mygetScreenPtr(x_ant,y_ant),0,3,14);
				
	//PINTAR
				//Flecha
				if (flecha1_y) {
					//Se autoborra por tener marco negro donde dejaría estela
					cpct_drawSprite (G_Flecha_D, cpct_mygetScreenPtr(flecha1_x,flecha1_y), 5,5);
				}
				if (flecha2_y) {
					//Se autoborra por tener marco negro donde dejaría estela
					cpct_drawSprite (G_Flecha_I, cpct_mygetScreenPtr(flecha2_x,flecha2_y), 5,5);
				}
				

				pintarPersonajeAnimado(sprite, cpct_mygetScreenPtr(x,y),movido);

				//Restar contador de tiempo
				if (!(tiempo % 8)) {
					txtPintarTime();
					decTime();
				}

				tiempo--;
				if (tiempo) {
					//¿Colisión?
					ok = 0;
					if (flecha1_y) {
						max_x0 = maximo (x, flecha1_x + 1);
						min_x1 = minimo (x + 3,flecha1_x + 5);
						max_y0 = maximo (y, flecha1_y);
						min_y1 = minimo (y + 14,  flecha1_y + 5);
						if (max_x0 < min_x1 && max_y0 < min_y1) {
							ok = 1;
						}
					}
					if (flecha2_y) {
						max_x0 = maximo (x, flecha2_x);
						min_x1 = minimo (x + 3,flecha2_x + 4);
						max_y0 = maximo (y, flecha2_y);
						min_y1 = minimo (y + 14,  flecha2_y + 5);
						if (max_x0 < min_x1 && max_y0 < min_y1) {
							ok = 1;
						}
					}
					if (ok) { // Hubo colisión
						vidaPerdida();
						tiempo = 0;
						break;
					}
				} 
				else //llegamos a tiempo 0 (éxito)
					return 1;
			}
		}		
	}
	////////////// FIN DESAFIOS //////////////////

	return 0; //Si llegamos aquí es porque no se completó el desafío
}

void final(TJugador *jugador){
	u8 i, *sprite;

	if (!(jugador->com)) {
		//cpct_setPalette(paletaM0,16); //Por si está en paleta Tablero
		musica = 5;
		pintarEstrellas();
		pintarFondo(4);
		for (i = 0; i < 2; i++)
			cpct_drawSolidBox (cpct_mygetScreenPtr( (40*i),90),cpct_px2byteM0 (5, 5),40,62); 

		vidas = 1;
		pintarMarcador(jugador,1);
		//Cobra modo 0
		cpct_drawSprite (G_Cobra_C, cpctm_screenPtr(CPCT_VMEM_START,37,60), 5, 30);

		//Animación
		sprite = jugador->sprite;
		for (i = 1; i < 35; i++) {
			cpct_waitVSYNC();
			cpct_drawSolidBox (cpct_mygetScreenPtr(i-1,76),cpct_px2byteM0 (4, 4),3,14);
			pintarPersonajeAnimado(sprite, cpct_mygetScreenPtr(i,76), i%2);
			pausa();
		}
		
		//Texto (40 caracteres por fila)
		txtFinal();
		pausa();
		vidas = 0;
		pintarMarcador(jugador,1);

		//Resplandor
		for (i = 0; i < 16; i++) {
			pintarFondo(0);
			pintarFondo(15);
		}

		//Cambio a Modo 1
		borrarPantalla();
		cpct_setVideoMode(1);
		cpct_setPalette(paletaM1,4);
		cpct_drawSprite (G_Cobra,cpctm_screenPtr(CPCT_VMEM_START, 37,60), 5, 30); // Figura Cobra en Modo 1
		pausa();
		//cambiar PaletaM1 a la del jugador "ganador"
		*(u8*)&paletaM1[1]=0x47;
		*(u8*)&paletaM1[2]=0x5C;
		if (jugador->id == 1) {
			*(u8*)&paletaM1[1]=0x43;
			*(u8*)&paletaM1[2]=0x40;
		}
		if (jugador->id == 2) {
			*(u8*)&paletaM1[1]=0x4B;
			*(u8*)&paletaM1[2]=0x55;
		}

		cpct_setPalette(paletaM1,4);
		
		
	} else {
		GameOverPlayer();
	}
}


void cutreZoomModo0 (void* sprite, u8 x, u8 y, u8 width, u8 height, u8 factor) {
// Tomando como base el sprite "*sprite" situado en x,y con dimensiones width,height,
// hace un escalado por el número indicado por factor tiendo como referencia el centro de la figura original
// Es decir para ver la misma figura con distintos factores de escalado, no se modifica x e y. Ya lo calcula la función
// NO SE HACEN COMPROBACIONES si se pintará fuera de pantalla
// No es ótpima, no es rápida, ¡PERO FUNCIONA!
	u8 xc,yc,x0,y0;
	u8 i,j,k,l,*ptr, pasos;
	u8 color1, color2, pixelFinal;
	

	// Calcular centro
	xc = x + (width/2);
	yc = y + (height/2);

	// Calcular x e y
	x0 = xc - ((width/2) * factor);
	y0 = yc - ((height/2) * factor);

	ptr = sprite;
	pasos = 0;

	//Recorreré cada pixel ancho por alto del sprite escalado e iré cogiendo el pixel del original
	for (i = 0; i < height; i++){
		for (j = 0; j < width; j++){
			for (k = 0; k < factor; k++){
				//obtenemos los valores codificados de los 2 colores del byte
				//Un byte contiene 2 pixeles, o sea dos colores que se codifican de la siguiente manera
				//Byte 94 correspondería a los colores 1 y 6 (en ese orden)
				//0x94 = 0b 1001 0100 
				//Si tomamos el orden como b0,b1,...b7 del byte. 
				//El primer color sale de coger los bits de los lugares 6,2,4,0 = 0001 => Color 1 de la paleta
				//El segundo color sale de coger los bits de los lugares 7,3,5,1 = 0110 => Color 6 de la paleta
				color1 = *ptr;
				color1 = color1 & 0b10101010;
				color2 = *ptr;
				color2 = color2 & 0b01010101;

				//Si el factor es par, la primera mitad será del color1; la segunda de color2
				//Para codificar un color consigo mismo, depende de si es el color1 o es el color2 hay que hacer un OR consigo mismo
				// desplazando a la derecha o la izquierda respectivamente.

				if (k < (factor/2)) { 
					pixelFinal = color1 | (color1 >> 1);
				} else if ((factor % 2) == 0 || (k > (factor/2))){
					pixelFinal = color2 | (color2 << 1);
				} else { //El centro de los factores impares es una mezcla de ambos colores
					pixelFinal = color1 | color2;
				}
				// *((u8*) 0xFFFF) = shift;				

				for (l=0;l<factor;l++) {
					//Pintar en Memoria de Vídeo el Byte Resultante
					*(cpct_mygetScreenPtr (x0+(j*factor)+k,y0+(i*factor)+l)) = pixelFinal;
				}
				//Cada X pasos avanzamos el puntero del sprite )donde X es el factor de escalado)
				pasos++;
				if (pasos % factor == 0)
					ptr++;
			}
		}
	}	
}