﻿#include "fonts2B.h"
#include "debug.h"
#include <cpctelera.h>

unsigned char f_teletipo = 1;
unsigned char *f_c; //Puntero de memoria de vídeo donde pintar carácter con myDrawChar

void myDrawString (unsigned char* f_l) { //fastcall optimiza cuando sólo hay un parámetro. No usa pila(push/pop), sólo registro HL
	
	//Función propia para dibujar mis caracteres (sprites) para optimizar pues siempre tienen el mismo tamaño y 
	//la dirección de vídeo a pintar está en una variable global
	unsigned char i,j;
	unsigned char eol; //Marca de fin de texto
	eol = 0;
	for (i=0; i<MAX_CHARS_PER_LINE; i++){
		if (eol) { //Si ya hemos llegado al final del texto, sólo hay que aumentar la posición del puntero (2 posiciones por ser modo 0)
			*f_c++;
			*f_c++;
		}
		else {
			for (j=0; j<16;j++){			
	 //Si hemos llegado a carácter fin de línea dejamos de escribir en memoria de vídeo y sólo hacemos los cálculos para ir actualizando el puntero
				*f_c = *( &G_S0[0] + (u16) (16*f_l[i]) + j);  //Teniendo como base el primer sprite le sumamos el desplazamiento indicado (multiplicado por su tamaño, que es 16) y ya cogemos la fila en cuestión: 1 byte
				
				if (!(j%2))
					f_c++; //Al ser cada caracter de 2 Bytes, sólo aumentar una posición el puntero de vídeo, no pasar aún de línea
				else {
					f_c += 0x07FF; //Saltar de línea
				
					if (!((int) f_c & 0x3800)) //Detectar si la dirección resultante lleva a final de línea de 8 bits => cambiar de banco de vídeo
						f_c += 0xC050;

					cpct_scanKeyboard_f();
				   	if ( cpct_isAnyKeyPressed_f ())
						f_teletipo = 0;
				}
			}
			f_c -= 0x04E; //Volver al banco anterior - 0x50 e ir a la siguiente casilla + 0x02 (tamaño caracter)
			if (f_l[i+1] == 0xFF) //Fin de línea
					eol = 1;
			else {
				if (f_teletipo)
					for (int i = 0; i < 5000; ++i) //Bucle espera para simular teletipo
						;
				}
			}
	}
}

const unsigned char G_S0[16] = { 
	0x00, 0x00, 
	0x55, 0x00, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0x55, 0x00, 
	0x00, 0x00};


const unsigned char G_S1[16] = { 
	0x00, 0x00, 
	0x55, 0x00, 
	0xFF, 0x00, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x55, 0x00, 
	0xFF, 0xAA, 
	0x00, 0x00};


const unsigned char G_S2[16] = { 
	0x00, 0x00, 
	0xFF, 0x00, 
	0x00, 0xAA, 
	0x00, 0xAA, 
	0x55, 0x00, 
	0xAA, 0x00, 
	0xFF, 0xAA, 
	0x00, 0x00};


const unsigned char G_S3[16] = { 
	0x00, 0x00, 
	0xFF, 0x00, 
	0x00, 0xAA, 
	0x00, 0xAA, 
	0xFF, 0xAA, 
	0x00, 0xAA, 
	0xFF, 0x00, 
	0x00, 0x00};


const unsigned char G_S4[16] = { 
	0x00, 0x00, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0xFF, 0xAA, 
	0x00, 0xAA, 
	0x00, 0xAA, 
	0x00, 0x00};


const unsigned char G_S5[16] = { 
	0x00, 0x00, 
	0xFF, 0xAA, 
	0xAA, 0x00, 
	0xAA, 0x00, 
	0xFF, 0xAA, 
	0x00, 0xAA, 
	0xFF, 0x00, 
	0x00, 0x00};


const unsigned char G_S6[16] = { 
	0x00, 0x00, 
	0x55, 0xAA, 
	0xAA, 0x00, 
	0xAA, 0x00, 
	0xFF, 0x00, 
	0xAA, 0xAA, 
	0x55, 0x00, 
	0x00, 0x00};


const unsigned char G_S7[16] = { 
	0x00, 0x00, 
	0xFF, 0xAA, 
	0x00, 0xAA, 
	0x00, 0xAA, 
	0x00, 0xAA, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x00, 0x00};


const unsigned char G_S8[16] = { 
	0x00, 0x00, 
	0x55, 0x00, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0x55, 0x00, 
	0xAA, 0xAA, 
	0x55, 0x00, 
	0x00, 0x00};


const unsigned char G_S9[16] = { 
	0x00, 0x00, 
	0x55, 0x00, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0x55, 0xAA, 
	0x00, 0xAA, 
	0xFF, 0x00, 
	0x00, 0x00};


const unsigned char G_a[16] = { 
	0x00, 0x00, 
	0x55, 0x00, 
	0x00, 0xAA, 
	0x55, 0xAA, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0x55, 0x00, 
	0x00, 0x00};


const unsigned char G_b[16] = { 
	0xAA, 0x00, 
	0xAA, 0x00, 
	0xAA, 0x00, 
	0xFF, 0x00, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0xFF, 0x00, 
	0x00, 0x00};


const unsigned char G_c[16] = { 
	0x00, 0x00, 
	0x55, 0xAA, 
	0xAA, 0x00, 
	0xAA, 0x00, 
	0xAA, 0x00, 
	0xAA, 0x00, 
	0x55, 0xAA, 
	0x00, 0x00};


const unsigned char G_d[16] = { 
	0x00, 0xAA, 
	0x00, 0xAA, 
	0x00, 0xAA, 
	0x55, 0xAA, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0x55, 0xAA, 
	0x00, 0x00};


const unsigned char G_e[16] = { 
	0x00, 0x00, 
	0x55, 0x00, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0xFF, 0xAA, 
	0xAA, 0x00, 
	0x55, 0xAA, 
	0x00, 0x00};


const unsigned char G_f[16] = { 
	0x55, 0xAA, 
	0xAA, 0x00, 
	0xAA, 0x00, 
	0xFF, 0x00, 
	0xAA, 0x00, 
	0xAA, 0x00, 
	0xAA, 0x00, 
	0x00, 0x00};


const unsigned char G_g[16] = { 
	0x00, 0x00, 
	0x55, 0x00, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0x55, 0xAA, 
	0x00, 0xAA, 
	0xAA, 0xAA, 
	0x55, 0x00};


const unsigned char G_h[16] = { 
	0xAA, 0x00, 
	0xAA, 0x00, 
	0xAA, 0x00, 
	0xFF, 0x00, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0x00, 0x00};


const unsigned char G_i[16] = { 
	0x00, 0x00, 
	0x55, 0x00, 
	0x00, 0x00, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x00, 0x00};


const unsigned char G_j[16] = { 
	0x00, 0xAA, 
	0x00, 0x00, 
	0x00, 0xAA, 
	0x00, 0xAA, 
	0x00, 0xAA, 
	0x00, 0xAA, 
	0x00, 0xAA, 
	0x55, 0x00};


const unsigned char G_k[16] = { 
	0xAA, 0x00, 
	0xAA, 0x00, 
	0xAA, 0xAA, 
	0xFF, 0x00, 
	0xFF, 0x00, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0x00, 0x00};


const unsigned char G_l[16] = { 
	0x55, 0x00, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x00, 0xAA, 
	0x00, 0x00};


const unsigned char G_m[16] = { 
	0x00, 0x00, 
	0x00, 0x00, 
	0x00, 0x00, 
	0xFF, 0xAA, 
	0xFF, 0xFF, 
	0xAA, 0xFF, 
	0xAA, 0x55, 
	0x00, 0x00};

const unsigned char G_n[16] = { 
	0x00, 0x00, 
	0x00, 0x00, 
	0x00, 0x00, 
	0xFF, 0x00, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0x00, 0x00};


const unsigned char G_o[16] = { 
	0x00, 0x00, 
	0x00, 0x00, 
	0x55, 0x00, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0x55, 0x00, 
	0x00, 0x00};


const unsigned char G_p[16] = { 
	0x00, 0x00, 
	0x55, 0x00, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0xFF, 0x00, 
	0xAA, 0x00, 
	0xAA, 0x00, 
	0xAA, 0x00};


const unsigned char G_q[16] = { 
	0x00, 0x00, 
	0x55, 0xAA, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0x55, 0xAA, 
	0x00, 0xAA, 
	0x00, 0xAA, 
	0x00, 0xAA};


const unsigned char G_r[16] = { 
	0x00, 0x00, 
	0x00, 0x00, 
	0x55, 0xAA, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x00, 0x00};


const unsigned char G_s[16] = { 
	0x00, 0x00, 
	0x55, 0xAA, 
	0xAA, 0x00, 
	0xAA, 0x00, 
	0x55, 0x00, 
	0x00, 0xAA, 
	0xFF, 0x00, 
	0x00, 0x00};


const unsigned char G_t[16] = { 
	0x55, 0x00, 
	0x55, 0x00, 
	0xFF, 0xAA, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x00, 0xAA, 
	0x00, 0x00};


const unsigned char G_u[16] = { 
	0x00, 0x00, 
	0x00, 0x00, 
	0x00, 0x00, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0x55, 0xAA, 
	0x00, 0x00};


const unsigned char G_v[16] = { 
	0x00, 0x00, 
	0x00, 0x00, 
	0x00, 0x00, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0x55, 0x00, 
	0x00, 0x00};


const unsigned char G_w[16] = { 
	0x00, 0x00, 
	0x00, 0x00, 
	0x00, 0x00, 
	0xAA, 0x55, 
	0xFF, 0x55, 
	0xFF, 0xFF, 
	0x55, 0xFF, 
	0x00, 0x00};


const unsigned char G_x[16] = { 
	0x00, 0x00, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0x55, 0x00, 
	0x55, 0x00, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0x00, 0x00};


const unsigned char G_y[16] = { 
	0x00, 0x00, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0x55, 0xAA, 
	0x00, 0xAA, 
	0xAA, 0xAA, 
	0x55, 0x00};


const unsigned char G_z[16] = { 
	0x00, 0x00, 
	0xFF, 0xAA, 
	0x00, 0xAA, 
	0x55, 0x00, 
	0x55, 0x00, 
	0xAA, 0x00, 
	0xFF, 0xAA, 
	0x00, 0x00};


const unsigned char G_ny[16] = { 
	0x00, 0x00, 
	0xFF, 0xAA, 
	0x00, 0x00, 
	0xFF, 0x00, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0x00, 0x00};


const unsigned char G_at[16] = { 
	0x00, 0x55, 
	0x55, 0x00, 
	0x00, 0xAA, 
	0x55, 0xAA, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0x55, 0x00, 
	0x00, 0x00};


const unsigned char G_et[16] = { 
	0x00, 0x55, 
	0x55, 0x00, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0xFF, 0xAA, 
	0xAA, 0x00, 
	0x55, 0xAA, 
	0x00, 0x00};


const unsigned char G_it[16] = { 
	0x00, 0xAA, 
	0x55, 0x00, 
	0x00, 0x00, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x00, 0x00};


const unsigned char G_ot[16] = { 
	0x00, 0x55, 
	0x00, 0x00, 
	0x55, 0x00, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0x55, 0x00, 
	0x00, 0x00};


const unsigned char G_ut[16] = { 
	0x00, 0x55, 
	0x00, 0x00, 
	0x00, 0x00, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0x55, 0xAA, 
	0x00, 0x00};


const unsigned char G_pt[16] = { 
	0x00, 0x00, 
	0x00, 0x00, 
	0x00, 0x00, 
	0x00, 0x00, 
	0x00, 0x00, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x00, 0x00};


const unsigned char G_cm[16] = { 
	0x00, 0x00, 
	0x00, 0x00, 
	0x00, 0x00, 
	0x00, 0x00, 
	0x00, 0x00, 
	0x55, 0x00, 
	0xAA, 0x00, 
	0x00, 0x00};


const unsigned char G_str[16] = { 
	0x00, 0x00, 
	0x00, 0x00, 
	0xAA, 0x00, 
	0xFF, 0x00, 
	0xFF, 0xAA, 
	0xFF, 0x00, 
	0xAA, 0x00, 
	0x00, 0x00};


const unsigned char G_bl[16] = { 
	0x00, 0x00, 
	0x00, 0x00, 
	0x00, 0x00, 
	0x00, 0x00, 
	0x00, 0x00, 
	0x00, 0x00, 
	0x00, 0x00, 
	0x00, 0x00};


const unsigned char G_piz[16] = { 
	0x00, 0x00, 
	0x00, 0xAA, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x00, 0xAA, 
	0x00, 0x00};


const unsigned char G_pdr[16] = { 
	0x00, 0x00, 
	0x55, 0x00, 
	0x00, 0xAA, 
	0x00, 0xAA, 
	0x00, 0xAA, 
	0x00, 0xAA, 
	0x55, 0x00, 
	0x00, 0x00};

const unsigned char G_man[16] = { 
	0x00, 0x00, 
	0x55, 0x00, 
	0x0C, 0x08, 
	0x04, 0x00, 
	0x04, 0x00, 
	0x08, 0x08, 
	0x08, 0x08, 
	0x00, 0x00};


/*const unsigned char G_ful[16] = { 
	0x00, 0x00, 
	0xFF, 0xFF, 
	0xFF, 0xFF, 
	0xFF, 0xFF, 
	0xFF, 0xFF, 
	0xFF, 0xFF, 
	0xFF, 0xFF, 
	0xFF, 0xFF};*/

/*const unsigned char G_amc_n[16] = { 
	0x00, 0x00, 
	0xFF, 0x00, 
	0xAA, 0xAA, 
	0x28, 0x28, 
	0x28, 0x28, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0x00, 0x00};*/


const unsigned char G_ap[16] = { 
	0x00, 0x00, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x00, 0x00, 
	0x00, 0x00, 
	0x00, 0x00, 
	0x00, 0x00, 
	0x00, 0x00};


const unsigned char G_exc[16] = { 
	0x55, 0x00, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x55, 0x00, 
	0x00, 0x00, 
	0x55, 0x00, 
	0x00, 0x00};


/*const unsigned char G_amc_f[16] = { 
	0x00, 0x00, 
	0xFF, 0xAA, 
	0xAA, 0x00, 
	0x3C, 0x00, 
	0x28, 0x00, 
	0xAA, 0x00, 
	0xAA, 0x00, 
	0x00, 0x00};*/


const unsigned char G_man2[16] = { 
	0x00, 0x00, 
	0x55, 0x00, 
	0x3F, 0x2A, 
	0x15, 0x00, 
	0x15, 0x00, 
	0x2A, 0x2A, 
	0x2A, 0x2A, 
	0x00, 0x00};


const unsigned char G_com[16] = { 
	0x00, 0x00, 
	0x0C, 0x08, 
	0x08, 0x08, 
	0x0C, 0x08, 
	0x00, 0x00, 
	0x0C, 0x08, 
	0x0C, 0x08, 
	0x00, 0x00};


const unsigned char G_com2[16] = { 
	0x00, 0x00, 
	0x3F, 0x2A, 
	0x2A, 0x2A, 
	0x3F, 0x2A, 
	0x00, 0x00, 
	0x3F, 0x2A, 
	0x3F, 0x2A, 
	0x00, 0x00};


const unsigned char G_man3[16] = { 
	0x00, 0x00, 
	0x55, 0x00, 
	0xC0, 0x80, 
	0x40, 0x00, 
	0x40, 0x00, 
	0x80, 0x80, 
	0x80, 0x80, 
	0x00, 0x00};


const unsigned char G_com3[16] = { 
	0x00, 0x00, 
	0xC0, 0x80, 
	0x80, 0x80, 
	0xC0, 0x80, 
	0x00, 0x00, 
	0xC0, 0x80, 
	0xC0, 0x80, 
	0x00, 0x00};

const unsigned char G_amp[16] = { 
	0x55, 0x00, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0x55, 0xFF, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0x55, 0x55, 
	0x00, 0x00};	

/*const unsigned char G_amc_g[16] = { 
	0x00, 0x00, 
	0xFF, 0xAA, 
	0xAA, 0x00, 
	0x28, 0x00, 
	0x28, 0x28, 
	0xAA, 0xAA, 
	0xFF, 0xAA, 
	0x00, 0x00};


const unsigned char G_amc_r[16] = { 
	0x00, 0x00, 
	0xFF, 0xAA, 
	0xAA, 0xAA, 
	0x3C, 0x00, 
	0x28, 0x28, 
	0xAA, 0xAA, 
	0xAA, 0xAA, 
	0x00, 0x00};
	

const unsigned char G_amc_o[16] = { 
	0x00, 0x00, 
	0xFF, 0xAA, 
	0xAA, 0xAA, 
	0x28, 0x28, 
	0x28, 0x28, 
	0xAA, 0xAA, 
	0xFF, 0xAA, 
	0x00, 0x00};*/

			
const unsigned char G_eol[1] = { 
	0xFF};	