#include <cpctelera.h>
#include "fonts2B.h"
#include "main.h"
#include "textos.h"
#include "funciones.h"
#include "graficos.h"
#include "debug.h"

void txtSelecMenu(u8 fila, u8 total, u8 pos_x, u8 pos_y) {
	u8 i;
	const u8 *digito;

	pausaTecladoLibre();
	//Cursor de selección
	for (i=0; i < total; i++){
		if (i == fila)
			digito = G_str; // Cursor
		else		
			digito = G_bl; // Espacio

		cpct_drawSprite (digito, cpct_mygetScreenPtr(pos_x, pos_y + (8*i)), 2, 8);
	}
	cpct_scanKeyboard_f();
}

/*void txtMusicaOff(){
	f_teletipo = 1;
	f_c = cpctm_screenPtr(CPCT_VMEM_START, 0,100);
	myDrawString(txtMusica);
	f_teletipo = 0; //No va a haber teletipo salvo raras ocasiones donde se pondrá a 1 y se volverá a poner a 0 al final (oráculo,)
}*/

void txtMenuInicio(){
	//Jugador 1
	*(u8*)&txtIntro1[8] = 48;
	if (players[0].com) //player1 nunca se puede deshabilitar para asegurarnos un jugador mínimo
		*(u8*)&txtIntro1[8] = 52;

	//Jugador 2
	*(u8*)&txtIntro2[8] = 51;
	if (players[1].com == 1)
		*(u8*)&txtIntro2[8] = 53;
	if (players[1].com == 2)
		*(u8*)&txtIntro2[8] = 33;

	//Jugador 3
	*(u8*)&txtIntro3[8] = 54;
	if (players[2].com == 1)
		*(u8*)&txtIntro3[8] = 55;
	if (players[2].com == 2)
		*(u8*)&txtIntro3[8] = 33;

	//dificultad
	//*if (modo_dificil){
	//	*(u8*)&txtIntro4[6] = 17;
	//	*(u8*)&txtIntro4[7] = 10;
	//	*(u8*)&txtIntro4[8] = 27;
	//	*(u8*)&txtIntro4[9] = 13;
	//} else{
	//	*(u8*)&txtIntro4[6] = 14;
	//	*(u8*)&txtIntro4[7] = 10;
	//	*(u8*)&txtIntro4[8] = 28;
	//	*(u8*)&txtIntro4[9] = 34;
	//}

	f_c = cpctm_screenPtr (CPCT_VMEM_START, 27,140);
	myDrawString(txtIntro1); //Player1
	myDrawString(txtIntro2); //Player2
	myDrawString(txtIntro3); //Player3
	//myDrawString(txtIntro4); //Level
	myDrawString(txtIntro5); //Start
	//myDrawString(txtIntro6);	//Practica

	f_c = cpctm_screenPtr(CPCT_VMEM_START, 0, 192);	
	myDrawString(txtIntro7);
}

void txtMenuJuego(TJugador *jugador){
	u8 *temp,i;

	i = jugador->id;

	temp = (u8*) &txtIntro1[0] + (i*10);

	f_c = cpctm_screenPtr(CPCT_VMEM_START, 0,2);
	myDrawString(temp);
	f_c = cpctm_screenPtr(CPCT_VMEM_START, 0, 50);
	temp = (u8*) &txtMision1_1[0] + (i*40);
	myDrawString(temp);
	myDrawString(temp+11);
	f_c = cpctm_screenPtr(CPCT_VMEM_START, 0, 74);
	myDrawString(temp+20);
	myDrawString(temp+31);
	
	//Armas que ya estén recogidas
	if (!armas_casilla[jugador->mision1]) {
		temp = (u8*) G_Llave + (32 * (jugador->mision1));
		cpct_drawSpriteMasked (temp, cpctm_screenPtr(CPCT_VMEM_START,18,58), 2, 8);
	}

	if (!armas_casilla[jugador->mision2]) {
		temp = (u8*) G_Llave + (32 * (jugador->mision2));
		cpct_drawSpriteMasked (temp, cpctm_screenPtr(CPCT_VMEM_START,18,82), 2, 8);
	}

}


/*void txtMenuPractica(){
	f_c = cpctm_screenPtr(CPCT_VMEM_START, 22,140);
	myDrawString(txtTraining1);
	myDrawString(txtTraining2);
	}*/


void txtMenuViaje(TJugador *jugador){
	u8 *temp;
	u8 i,j;

	j=140;
	for (i = 0; i < PLAYERS; i++) {
		f_c = cpct_mygetScreenPtr(22, j);
		temp = (u8*) &txtViaje4[0];
		if (jugador->mundo != i) {
			temp = (u8*) txtViaje1 + (15 * i);
		}
		myDrawString(&temp[0]);
		j = j + 8;
	}
}


void txtMenuDado(TJugador *jugador, u8 casilla, u8 dado){
	u8 casilla1, casilla2;

	casilla1 = casilla + dado;
	if (casilla1 > ULTIMA_CASILLA)
		casilla1 = ULTIMA_CASILLA;
	
	if (casilla1 > 8 && !jugador->oraculo_visitado)
		casilla1 = 8;

	if (casilla < dado)
		casilla2 = 0;
	else
		casilla2 = casilla - dado;

	//Hay que incrementar ambos pues internamente la casilla empieza desde 0, pero en tablero desde 1
	casilla1++;
	casilla2++;
	
	f_c = cpctm_screenPtr(CPCT_VMEM_START, 2,18);
	*(u8*)&txtMenuDado1[6] = 45;
	if (casilla1 > 9)
		*(u8*)&txtMenuDado1[6] = casilla1 / 10;
			
	*(u8*)&txtMenuDado1[7] = casilla1 % 10;


	*(u8*)&txtMenuDado2[6] = 45;
	if (casilla2 > 9)
		*(u8*)&txtMenuDado2[6] = casilla2 / 10;

	*(u8*)&txtMenuDado2[7] = casilla2 % 10;

	myDrawString(txtMenuDado1);
	myDrawString(txtMenuDado2);
}

void txtFinal(){
	f_teletipo = 1;
	f_c = cpctm_screenPtr(CPCT_VMEM_START, 0,110);
	myDrawString(txtFinal1);
	myDrawString(txtFinal2);
	myDrawString(txtFinal3);
	f_teletipo = 0;
}

void txtFinalEasy(){
	f_teletipo = 1;
	f_c = cpctm_screenPtr(CPCT_VMEM_START, 0,110);
	myDrawString(txtFinal4);
	f_teletipo = 0;
}

void txtStopTime(u8 objetivo) {
	*(u8*)&txtStopTime1[13] = objetivo/10;
	*(u8*)&txtStopTime1[14] = objetivo%10;

	f_c = cpctm_screenPtr(CPCT_VMEM_START, 33,82);
	myDrawString(txtStopTime1);
}

void initTime(u8 decenas, u8 unidades) {
	*(u8*)&txtTime[5] =	decenas;
	*(u8*)&txtTime[6] =	unidades;
}

void txtPintarTime() {
	f_c = cpctm_screenPtr(CPCT_VMEM_START, 60,168);
	myDrawString(txtTime);
}

void decTime() {
	if (txtTime[6]) //restar unidades
		txtTime[6]--;
	else if (txtTime[5]) { //restar decenas
		txtTime[5]--;
		txtTime[6]=9;
	}
}

void txtTurno(u8 id){
	
	f_c = cpctm_screenPtr(CPCT_VMEM_START, 31,96);
	myDrawString(&txtIntro1[0] + (id * 10));
}

void inicializaMenuMision() {
	u8 i,j,*temp;

	temp = (u8*) &txtMision1_1[0];

	//Inicializar las dos misiones de cada jugador a "go to oracle"
	for (i=0; i<20; i++) {
		for (j=0;j<2*PLAYERS;j++) {
			*(temp + (20*j)) = txtMision[i];	
		}
		temp ++;
	}
}

void modificarMision (TJugador *jugador, u8 ranura, u8 mision, u8 modificacion) {
	// modificacion: 0=asignar misión; 1=completar misión
	u8 despl_mision, limite;
	u8 *texto;
	u8 i;
	u8 *p;

	despl_mision = 0;
	if (ranura % 2)
		despl_mision = 11 + 9;
	
		
	i = jugador->id;

	texto = (u8*) &txtMisionKhytya1[0] + (mision * 18);
	p = (u8*) &txtMision1_1[0];
	limite = 18;
	if (modificacion) {
		//Para completar misión, sólo modifico la segunda línea
		texto = (u8*) &txtMisionCompletada[0];
		p = (u8*) &txtMision1_2[0];
		limite = 8;
	} 

	p += ((2*i)*(11 + 9)) + despl_mision;

	for (i=0; i<limite; i++){
		*p = *texto;
		p++;
		texto++;
		if (i == 9)
			p++; //Saltar el fin de línea
	}

}

void oraculo (TJugador *jugador) {
	u8 *temp;
	
	musica = 5;
	marcoCenefa(0, 100, 20, 6);
	f_teletipo = 1;

	//mostrar texto de oráculo
	f_c = cpctm_screenPtr(CPCT_VMEM_START, 8,116);
	myDrawString(txtOraculoSup);
	f_c = cpctm_screenPtr(CPCT_VMEM_START, 8,124);
	temp = (u8*) txtOraculoK_11 + (32 * (jugador->mision1));
	myDrawString(&temp[0]);
	f_c = cpctm_screenPtr(CPCT_VMEM_START, 8,132);
	myDrawString(txtOraculoInf);
	temp = (u8*) txtOraculoK_12 + (19 * (jugador->mision1));
	f_c = cpctm_screenPtr(CPCT_VMEM_START, 27,132);
	myDrawString(&temp[0]);
	temp = (u8*) G_Llave + (32 * (jugador->mision1));
	cpct_drawSpriteMasked (temp, cpctm_screenPtr(CPCT_VMEM_START,5,124), 2, 8);
	modificarMision (jugador,0,jugador->mision1,0);

	f_c = cpctm_screenPtr(CPCT_VMEM_START, 8,156);
	myDrawString(txtOraculoSup);
	f_c = cpctm_screenPtr(CPCT_VMEM_START, 8,164);
	temp = (u8*) txtOraculoK_11 + (32 * (jugador->mision2));
	myDrawString(&temp[0]);
	f_c = cpctm_screenPtr(CPCT_VMEM_START, 8,172);
	myDrawString(txtOraculoInf);
	temp = (u8*) txtOraculoK_12 + (19 * (jugador->mision2));
	f_c = cpctm_screenPtr(CPCT_VMEM_START,27,172);
	myDrawString(&temp[0]);
	temp = (u8*) G_Llave + (32 * (jugador->mision2));
	cpct_drawSpriteMasked (temp, cpctm_screenPtr(CPCT_VMEM_START,5,164), 2, 8);
	modificarMision (jugador,1,jugador->mision2,0);
	

	//marcar como oráculo ya visitado
	jugador->oraculo_visitado = 1;
	armas_activas[jugador->mision1] = 1;
	armas_activas[jugador->mision2] = 1;
	f_teletipo = 0;
	}

void GameOverTimeOut() {
	f_c = cpctm_screenPtr(CPCT_VMEM_START, 32,150);
	myDrawString(txtTimeOut);
}

void GameOverPlayer() {
	f_c = cpctm_screenPtr(CPCT_VMEM_START, 25,140);
	myDrawString(txtFelicitaciones);
	f_c = cpctm_screenPtr(CPCT_VMEM_START, 31,150);
	myDrawString(&txtIntro1[0] + ((game_over-1) * 10));
}

void marcadorJugador(TJugador *jugador){
	f_c = cpctm_screenPtr(CPCT_VMEM_START, 6,172);
	myDrawString(&txtIntro1[0] + ((jugador->id) * 10));
}

/*void txtVersionShow(){
	f_c = cpctm_screenPtr(CPCT_VMEM_START, 72,192);
	myDrawString(txtVersion);
}*/