# Variables del nombre del proyecto y para llamar a iDSK y 2CDT
PROYECTO=cobra
IDSK=../cpctelera/tools/iDSK-0.13/bin/iDSK.exe
CPC2CDT=../cpctelera/tools/cpc2cdt/bin/cpc2cdt
# Muestro fecha del sistema para que luego se pueda calcular lo que ha tardado en generarse todo
clear
date
echo ; echo ; echo 
# Limpio lo creado anteriormente para hacer un build completo, para evitar problemas si sólo se modifican .h que estén incluidos en otros ficheros 
make cleanall 
make all 
# Borro estos ficheros que no necesito porque hacen que el proyecto no quede actualizado tras el build.sh y lo necesito para crear el apk
rm ./src/tableros/*.h.s
#
# CREACIÓN DEL DISCO
#
# cpctelera generará ${PROYECTO}.bin pero lo quiero renombrar a data0.bin para que sólo quede loader.bas en el disco y así sea más evidente 
# qué archivo hay que lanzar. Para ello extraigo ${PROYECTO}.bin del disco creado y lo borro, lo renombro.
# También incluyo el loader.bas directamente como fichero ASCII para que sea más cómodo realizar cualquier modificación en el BASIC 
# (Previamente hay que pasarle el unix2dos)
# Existe un bug (o un fallo por mi parte) que hace que con la creación automática del disco queda ${PROYECTO}.bin al hacer un CAT aunque 
# luego no se pueda cargar. Por lo que creo el disco manualmente
$IDSK ${PROYECTO}.dsk -g ${PROYECTO}.bin
#$IDSK ${PROYECTO}.dsk -r ${PROYECTO}.bin
mv ${PROYECTO}.bin data0.bin
rm ${PROYECTO}.dsk
$IDSK ${PROYECTO}.dsk -n
unix2dos ./doc/disc.bas
$IDSK ${PROYECTO}.dsk -i ./doc/disc.bas -t 0
$IDSK ${PROYECTO}.dsk -i ./dsk/splash.bin
$IDSK ${PROYECTO}.dsk -i data0.bin
$IDSK ${PROYECTO}.dsk -i ./dsk/data1.bin
$IDSK ${PROYECTO}.dsk -i ./dsk/data2.bin
$IDSK ${PROYECTO}.dsk -i ./dsk/screen0.bin
$IDSK ${PROYECTO}.dsk -i ./dsk/screen1.bin
$IDSK ${PROYECTO}.dsk -i ./dsk/screen2.bin
#
# CREACIÓN DEL CASSETTE
#
# Lo vuelvo a crear desde 0, no me vale el creado con cpctelera, pues los archivos deben ir en un orden en concreto:
# 1. Fichero de carga en BASIC (tras pasarle el unix2dos) a partir de un fichero de texto para editar fácilmente
# 2. Pantalla de carga, escojo screen2.bin
# 3. El binario con el código y datos principales, es necesario indicarle dirección de la memoria donde tiene que cargarlo y luego
# la dirección de ejecución. Para esto último miro donde se ha generado la función main() en el fichero .map
# 4. Añadir los dos ficheros externos data1.bin y data2.bin
rm $PROYECTO.cdt
unix2dos ./doc/cdt.bas
$CPC2CDT -t -b 2000 -m cpctxt -r ${PROYECTO} ./doc/cdt.bas ${PROYECTO}.cdt
#$CPC2CDT -t -b 2000 -m cpc  -r splash.bin  ./dsk/splash.bin ${PROYECTO}.cdt 
$CPC2CDT -t -b 2000 -m cpc  -r screen2.bin ./dsk/screen2.bin ${PROYECTO}.cdt
DIR_MAIN=`grep _main ./obj/${PROYECTO}.map  | cut -c 10-13`
DIR_MAIN=0x$DIR_MAIN
$CPC2CDT -t -b 2000 -m cpc -r data0.bin  -l 0x0040 -x $DIR_MAIN ./obj/${PROYECTO}.bin ${PROYECTO}.cdt 
$CPC2CDT -t -b 2000 -m cpc  -r data1.bin ./dsk/data1.bin ${PROYECTO}.cdt 
$CPC2CDT -t -b 2000 -m cpc  -r data2.bin ./dsk/data2.bin ${PROYECTO}.cdt 
# Borrar ficheros que se han extraído, ya no son necesarios
rm data0.bin
# Fecha para saber cuando terminó
date
echo ; echo ; echo 
# Ejecutar el disco final (WinApe no puede ejecutar directamente una cinta por línea de comando)
cpct_winape ${PROYECTO}.dsk