;; 	  Th Spirit of Halloween. An Amstrad CPC 464 game.
;;    Copyright (C) 2018 Lab16Devs
;;
;;    This program is free software: you can redistribute it and/or modify
;;    it under the terms of the GNU General Public License as published by
;;    the Free Software Foundation, either version 3 of the License, or
;;    (at your option) any later version.
;;
;;    This program is distributed in the hope that it will be useful,
;;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;    GNU General Public License for more details.
;;
;;    You should have received a copy of the GNU General Public License
;;    along with this program.  If not, see <https://www.gnu.org/licenses/>.

.include "main.h.s"

DefineDrawableEntity lives,     #0x05, #0xBB, #0x02, #0x08, #0xF0
DefineDrawableEntity candy,     #0x38, #0xBB, #0x04, #0x08, #0xF0
DefineDrawableEntity highscore_d, #0x2B, #0xBB, #0x04, #0x08, #0xF0

lives_initial_position:
	.db #0x05 			;; X
candy_digit_initial_position:
	.db #0x38 			;; X
hs_initial_position:
	.db #0x2B 			;; X

clear_UI:
	ld hl, #ren_clear_sprite_ui
	call update_lives
	ret

draw_UI:
	ld hl, #ren_draw_sprite_ui
	call update_lives

	call update_candy
	call draw_highscore
	ret

draw_highscore:
	ld ix, #highscore_d 		;; Cargo los datos de la vida

	ld a, (#highscore)
	ld h, #0
	ld l, a
	ld e, #10
	call div_16_8

	push af
	
	ld a, h
	call getCharNum
	call ren_draw_sprite_ui

	ld a, de_a_x(ix)
	add #-5
	ld de_a_x(ix), a

	pop af

	ld h, #0
	ld l, a
	ld e, #10
	call div_16_8

	push af

	ld a, h
	call getCharNum
	call ren_draw_sprite_ui

	ld a, de_a_x(ix)
	add #-5
	ld de_a_x(ix), a

	pop af

	call getCharNum
	call ren_draw_sprite_ui

	ld a, de_a_x(ix)
	add #-5
	ld de_a_x(ix), a

	ld hl, #_numbers_array_10
	call ren_draw_sprite_ui

	ld a, (hs_initial_position)
	ld de_a_x(ix), a
	ret

update_candy:
	ld ix, #candy 		;; Cargo los datos de la vida
	ld hl, #_candy_array
	call ren_draw_sprite_ui

	ld a, de_a_x(ix)
	add #5
	ld de_a_x(ix), a

	ld hl, #_numbers_array_10
	call ren_draw_sprite_ui

	ld a, de_a_x(ix)
	add #5
	ld de_a_x(ix), a

	ld h, #0
	ld a, (#sweets_left)
	ld l, a
	ld e, #10
	call div_16_8

	push hl

	call getCharNum
	call ren_draw_sprite_ui

	ld a, de_a_x(ix)
	add #5
	ld de_a_x(ix), a

	pop hl
	ld a, h
	call getCharNum
	call ren_draw_sprite_ui

	ld a, (candy_digit_initial_position)
	ld de_a_x(ix), a

	ret

getCharNum:
	ld hl, #_numbers_array_00

	loop_getNum:
		cp #0
		ret z
		ld bc, #32
		add hl, bc
		dec a
		jp loop_getNum

	ret


update_lives:
	ld ix, #hero_data 	;; Cargo los datos del jugador
	ld a, e_lives(ix) 	;; Cargo la cantidad de vidas en A
	cp #0
	jr z, fin_pintar 	;; Si no tengo vidas no las pinto
	ld (draw_or_clear_0), hl       ;;
	ld (draw_or_clear_1), hl       ;;
	pintar_vida:
		push af 			;; Guardo el contador de vidas actuales

		ld ix, #lives 		;; Cargo los datos de la vida
		ld hl, #_lives_array_0
		draw_or_clear_0 = . + 1
		call ren_draw_sprite_ui

		pop af
		dec a
		cp #0
		jp z, fin_pintar
		push af

		ld a, de_a_x(ix)
		add de_a_w(ix)
		ld de_a_x(ix), a

		ld hl, #_lives_array_1
		draw_or_clear_1 = . + 1
		call ren_draw_sprite_ui

		ld a, de_a_x(ix)
		add #3
		ld de_a_x(ix), a

		pop af 				;; Recupero mis datos de contador
		dec a 				;; Reduzco en uno mi contador
		cp #0  				;;
		jr nz, pintar_vida 	;; Si aun me quedan vidas por pintar repito el bucle

	fin_pintar:
		ld a, (lives_initial_position)
		ld de_a_x(ix), a
		ret

; Integer divides HL by E
; Result in A, remainder in H
; Clobbers F, B, L
div_16_8:
    ld b, #8
	loop_d_16_8_0:  
		adc hl,hl
		ld a,h
		jr c, loop_d_16_8_1
		cp e
		jr c, loop_d_16_8_2
	loop_d_16_8_1:  
		sub e
		ld h,a
		or a
	loop_d_16_8_2: 
		djnz loop_d_16_8_0
		ld a,l
		rla
		cpl

	ret