;;    Th Spirit of Halloween. An Amstrad CPC 464 game.
;;    Copyright (C) 2018 Lab16Devs
;;
;;    This program is free software: you can redistribute it and/or modify
;;    it under the terms of the GNU General Public License as published by
;;    the Free Software Foundation, either version 3 of the License, or
;;    (at your option) any later version.
;;
;;    This program is distributed in the hope that it will be useful,
;;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;    GNU General Public License for more details.
;;
;;    You should have received a copy of the GNU General Public License
;;    along with this program.  If not, see <https://www.gnu.org/licenses/>.

;; RENDER
.include "main.h.s"

map_to_load: .dw _game_map_3

createMaskedTable:
  .area _g_masktable_ (ABS)
  .org 0x0100
  _g_masktable::
    .db 0xFF, 0xAA, 0x55, 0x00, 0xAA, 0xAA, 0x00, 0x00
    .db 0x55, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0xAA, 0xAA, 0x00, 0x00, 0xAA, 0xAA, 0x00, 0x00
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0x55, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0x55, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0xAA, 0xAA, 0x00, 0x00, 0xAA, 0xAA, 0x00, 0x00
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0xAA, 0xAA, 0x00, 0x00, 0xAA, 0xAA, 0x00, 0x00
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0x55, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0x55, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0x55, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0x55, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  .area _CSEG (REL, CON)
  ret

front_buffer: .db 0xC0
back_buffer: .db 0x80
animation_change: .db 0x03  ;;Time between animation rendering for sprites
pinkbones_pointer: .dw #_pinkbones_array_0

sprite_size_16: .db 0x00    ;;Tamaño sprite, 0 -> 16x16 | 1 -> 8x8

ren_change_to_new_buffer:
    call cpct_waitVSYNC_asm
    call ren_switch_buffers
    
    ret

;; Dibujar una entidad
;; 
ren_draw_entity:
    ld a, (back_buffer)    ;; Cargamos el origen del backbuffer
    ld d, a                ;; Pasamos el origen a D
    ld e, #0               ;; Ponemos el final de la direccion de memoria a 0
    ld c, de_x(ix)         ;; C = Entity Y
    ld b, de_y(ix)         ;; B = Entity X
    call cpct_getScreenPtr_asm
    ex de, hl

    ld a, (#sprite_size_16)
    set 0, a                    ;;Asumimos sprite de 8x8
    ld (#sprite_size_16), a

    ld b, a

    ld a, e_type(ix)
    cp #4                        ;;Goblin
    jp z, enemies    

    ld c, a                      ;;Guardar a
    ld a, b
    res 0, a                     ;;Es un sprite de 16x16
    ld (#sprite_size_16), a

    ld a, c

    cp #3
    jp z, bullets     ;;go to draw the bullets
    cp #2
    jp z, enemies    ;;go to draw the enemies

    ret

    enemies:
        ld a, e_last_s(ix)
        ld b, e_sprite_h(ix)
        ld c, e_sprite_l(ix)

        cp #-1              
        jp z, left_side     ;;Entity looks to the left
        cp #1               
        jp z, right_side    ;;Entity looks to the right

        ;;for both sides, we check if we have to draw one of the https://www.youtube.com/watch?v=EpVnuD6qnHwtwo animations
        ;;this works with a counter from 3 to 0, 0 being a change of frame and
        ;;then it gets reset back to its original value

        right_side:
            ld a, e_animation(ix)
            push ix
            cp #0
            jp z, right_second

            ;;Load in BC the value of FRAME0
            ld b, e_sprite_h(ix)
            ld c, e_sprite_l(ix)
            jp continue

            right_second:

                ;;Add to the pointer in IX the value of the frame we want to animate
                .dw 0x60DD  ;;ld ixh, b
                .dw 0x69DD  ;;ld ixl, c
                ld a, (#sprite_size_16)
                bit 0, a
                jp z, sum_128

                ld bc, #32                  ;;Es un sprite de 8x8
                jr sum_1

                sum_128:                    ;;Es un sprite de 16x16
                    ld bc, #128

                sum_1:
                add ix, bc
                .dw 0x44DD  ;;b = ixh   ;;Load in BC the value of FRAME1
                .dw 0x4DDD  ;;c = ixl

                jp continue

        left_side:
            ld a, e_animation(ix)
            push ix
            cp #0
            jp z, left_second

            ;;Add to the pointer in IX the value of the frame we want to animate
            .dw 0x60DD  ;;ld ixh, b
            .dw 0x69DD  ;;ld ixl, c
            ld a, (#sprite_size_16)
            bit 0, a
            jp z, sum_256

            ld bc, #64
            jr sum_2

            sum_256:
                ld bc, #256

            sum_2:
            add ix, bc
            .dw 0x44DD  ;;b = ixh   ;;Load in BC the value of FRAME2
            .dw 0x4DDD  ;;c = ixl

            jp continue

            left_second:
                
                ;;Add to the pointer in IX the value of the frame FRAME3
                .dw 0x60DD  ;;ld ixh, b
                .dw 0x69DD  ;;ld ixl, c
                ld a, (#sprite_size_16)
                bit 0, a
                jp z, sum_384

                ld bc, #96
                jr sum_3

                sum_384:
                    ld bc, #384

                sum_3:
                add ix, bc
                .dw 0x44DD  ;;b = ixh   ;;Load in BC the value of the frame to animate
                .dw 0x4DDD  ;;c = ixl

                jp continue

    bullets:
        ld b, e_sprite_h(ix)
        ld c, e_sprite_l(ix)
        push ix

    continue:
        pop ix
        ld h, de_w(ix)
        ld l, de_h(ix)
        push ix
        ld a, h
        .dw 0x6FDD   ;;ld ixl, width
        ld a, l
        .dw 0x67DD   ;;ld ixh, height
        ld hl, #_g_masktable
        call cpct_drawSpriteMaskedAlignedTable_asm

        pop ix

        ret

ren_draw_hero:
    ld a, (back_buffer)    ;; Cargamos el origen del backbuffer
    ld d, a                ;; Pasamos el origen a D
    ld e, #0               ;; Ponemos el final de la direccion de memoria a 0
    ld c, de_x(ix)         ;; C = Entity Y
    ld b, de_y(ix)         ;; B = Entity X
    call cpct_getScreenPtr_asm
    ex de, hl

    ;;see if player is jumping and draw jump sprite, else draw normal
    ld a, (#hero_state)
    bit 1, a
    jp nz, check_idle
    ld a, e_last_s(ix)

    cp #-1              
    jp z, left_jump
    
    ld bc, #_jack_array_6
    jp continue_p

    check_idle:
       ld a, (#hero_state)
       bit 6, a 
       jp z, choose_sprite

       ld a, e_last_s(ix)
       cp #-1              
       jp z, left_side_idle     ;;Entity looks to the left
       
       ld bc, #_jack_array_0
       jp continue_p

       left_side_idle:
        ld bc, #_jack_array_1
        jp continue_p

    left_jump:
        ld bc, #_jack_array_7
        jp continue_p

    choose_sprite:
        ld a, e_last_s(ix)

        cp #-1              
        jp z, left_side_p     ;;Entity looks to the left
        cp #1               
        jp z, right_side_p    ;;Entity looks to the right

        ;;for both sides, we check if we have to draw one of the https://www.youtube.com/watch?v=EpVnuD6qnHwtwo animations
        ;;this works with a counter from 3 to 0, 0 being a change of frame and
        ;;then it gets reset back to its original value

        right_side_p:
            ld a, e_animation(ix)
            cp #0
            jp z, right_second_p

            ld bc, #_jack_array_2
            jp continue_p

            right_second_p:
                ld bc, #_jack_array_3
                jp continue_p

        left_side_p:
            ld a, e_animation(ix)
            cp #0
            jp z, left_second_p

            ld bc, #_jack_array_4
            jp continue_p

            left_second_p:
                ld bc, #_jack_array_5

    continue_p:
        ld h, de_w(ix)
        ld l, de_h(ix)
        push ix
        ld a, h
        .dw 0x6FDD   ;;ld ixl, width
        ld a, l
        .dw 0x67DD   ;;ld ixh, height
        ld hl, #_g_masktable
        call cpct_drawSpriteMaskedAlignedTable_asm

        pop ix

        ret

ren_draw_map:
    ld hl, #_tiles_tileset
    call cpct_etm_setTileset2x4_asm

    ld hl, (#map_to_load)
    push hl
    ld a, (back_buffer)
    ld d, a
    ld e, #0x00
    push de
    ld bc, #0000
    ld de, #0x3228
    ld a, #40

    call cpct_etm_drawTileBox2x4_asm
    ret

;; BC = HL / E

division:
    ld a, e
    or a
    ret z
    ld bc, #-1
    ld d, #0

div:
    sbc hl, de
    inc bc
    jr nc, div

    ret

;; IX -> Entidad a borrar
ren_clear_entity:
    ld hl, (#map_to_load)    ;; Cargo el mapa
    push hl                 ;; Lo guardo para la funcion 2x4
    ld a, (back_buffer)     ;; Cargo el backbuffer
    ld d, a
    ld e, #0
    push de                 ;; Lo guardo para la funcion 2x4

    ld a, de_x(ix)          ;;
    ld h, #0                ;;
    ld l, a                 ;; Calculo la posicion relativa de la entidad 
    ld e, #2                ;; en tiles para X
    call division           ;;

    push bc                 ;; Lo guardo para usarlo mas tarde

    ld a, de_y(ix)          ;;
    ld h, #0                ;;
    ld l, a                 ;; Mismo calculo de posicion pero para Y
    ld e, #4                ;;
    call division           ;; 

    ld b, c                 ;; Pongo C en B

    pop hl                  ;; Recupero la posicion de X

    ld c, l                 ;; Pongo L en C

    ld a, b                 ;;
    dec a
    ld b, a                 ;;

    ld a, c
    dec a
    dec a
    ld c, a

    ld e, #7
    ld d, #6
    ld a, #40

    call cpct_etm_drawTileBox2x4_asm

    ret

ren_clear_entity_front:
    ld hl, (#map_to_load)    ;; Cargo el mapa
    push hl                 ;; Lo guardo para la funcion 2x4
    ld a, (front_buffer)     ;; Cargo el backbuffer
    ld d, a
    ld e, #0
    push de                 ;; Lo guardo para la funcion 2x4

    ld a, de_x(ix)          ;;
    ld h, #0                ;;
    ld l, a                 ;; Calculo la posicion relativa de la entidad 
    ld e, #2                ;; en tiles para X
    call division           ;;

    push bc                 ;; Lo guardo para usarlo mas tarde

    ld a, de_y(ix)          ;;
    ld h, #0                ;;
    ld l, a                 ;; Mismo calculo de posicion pero para Y
    ld e, #4                ;;
    call division           ;; 

    ld b, c                 ;; Pongo C en B

    pop hl                  ;; Recupero la posicion de X

    ld c, l                 ;; Pongo L en C

    ld a, b                 ;;
    dec a
    ld b, a                 ;;

    ld a, c
    dec a
    dec a
    ld c, a

    ld e, #7
    ld d, #6
    ld a, #40

    call cpct_etm_drawTileBox2x4_asm

    ret

ren_clear_entity_front_iy:
    ld hl, (#map_to_load)    ;; Cargo el mapa
    push hl                 ;; Lo guardo para la funcion 2x4
    ld a, (front_buffer)     ;; Cargo el backbuffer
    ld d, a
    ld e, #0
    push de                 ;; Lo guardo para la funcion 2x4

    ld a, de_x(iy)          ;;
    ld h, #0                ;;
    ld l, a                 ;; Calculo la posicion relativa de la entidad 
    ld e, #2                ;; en tiles para X
    call division           ;;

    push bc                 ;; Lo guardo para usarlo mas tarde

    ld a, de_y(iy)          ;;
    ld h, #0                ;;
    ld l, a                 ;; Mismo calculo de posicion pero para Y
    ld e, #4                ;;
    call division           ;; 

    ld b, c                 ;; Pongo C en B

    pop hl                  ;; Recupero la posicion de X

    ld c, l                 ;; Pongo L en C

    ld a, b                 ;;
    dec a
    ld b, a                 ;;

    ld a, c
    dec a
    dec a
    ld c, a

    ld e, #7
    ld d, #6
    ld a, #40

    call cpct_etm_drawTileBox2x4_asm

    ret

;; Limpiar el backbuffer
;; Registros destruidos: AF, HL, DE, BC 
ren_clear_back_buffer:
    ld a, (back_buffer)         ;; Cargamos el origen del backbuffer
    ld h, a                     ;; Pasamos el origen a H
    ld de, #0                   ;; Ponemos a 0 el registro con el que vamos a setear la memoria
    ld l, e                     ;; Colocamos a 0 el final del origen del backbuffer
    ld bc, #0x4000              ;; Tamanyo de memoria que vamos a sobreescribir
    call cpct_memset_f64_asm

    ret
;; Registros destruidos: A, B, F, BC, HL
ren_switch_buffers:
    ld a, (back_buffer)     ;;
    ld b, a                 ;;
    ld a, (front_buffer)    ;; Se intercambia front_buffer con
    ld (back_buffer), a     ;; back_buffer
    ld a, b                 ;;
    ld (front_buffer), a    ;;

    srl b                   ;; Movemos dos bits a la derecha dado que la siguiente 
    srl b                   ;; funcion necesita solo los bits significativos
    ld l, b                 ;;
    call cpct_setVideoMemoryPage_asm
    ret

ren_draw_sprite_ui:
    push hl
    ld a, (back_buffer)     ;; Cargo el backbuffer
    ld d, a
    ld e, #0
    ld c, de_a_x(ix)         ;; C = Entity X
    ld b, de_a_y(ix)         ;; B = Entity Y
    call cpct_getScreenPtr_asm

    ex de, hl
    pop hl
    ld b, de_a_h(ix)
    ld c, de_a_w(ix)

    call cpct_drawSprite_asm
    ret

ren_clear_sprite_ui:
    ld hl, (#map_to_load)   ;; Cargo el mapa
    push hl                 ;; Lo guardo para la funcion 2x4
    ld a, (back_buffer)     ;; Cargo el backbuffer
    ld d, a
    ld e, #0
    push de                 ;; Lo guardo para la funcion 2x4

    ld a, de_a_x(ix)          ;;
    ld h, #0                ;;
    ld l, a                 ;; Calculo la posicion relativa de la entidad 
    ld e, #2                ;; en tiles para X
    call division           ;;

    push bc                 ;; Lo guardo para usarlo mas tarde

    ld a, de_a_y(ix)          ;;
    ld h, #0                ;;
    ld l, a                 ;; Mismo calculo de posicion pero para Y
    ld e, #4                ;;
    call division           ;; 

    ld b, c                 ;; Pongo C en B

    pop hl                  ;; Recupero la posicion de X

    ld c, l                 ;; Pongo L en C

    ld a, b                 ;;
    dec a
    ld b, a                 ;;

    ld a, c
    dec a
    dec a
    ld c, a

    ld e, #7
    ld d, #6
    ld a, #40

    call cpct_etm_drawTileBox2x4_asm

    ret