;; 	  Th Spirit of Halloween. An Amstrad CPC 464 game.
;;    Copyright (C) 2018 Lab16Devs
;;
;;    This program is free software: you can redistribute it and/or modify
;;    it under the terms of the GNU General Public License as published by
;;    the Free Software Foundation, either version 3 of the License, or
;;    (at your option) any later version.
;;
;;    This program is distributed in the hope that it will be useful,
;;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;    GNU General Public License for more details.
;;
;;    You should have received a copy of the GNU General Public License
;;    along with this program.  If not, see <https://www.gnu.org/licenses/>.

.include "main.h.s"

show_infinite_level: .db 0x03

menu_main:
	ld hl, #_a_m_pal
	ld de, #16
	call cpct_setPalette_asm 

	ld c, #0
	call cpct_setVideoMode_asm

	ld hl, #_title_1_array
	ld de, #0xC000
	ld c, #40
	ld b, #48
	call cpct_drawSprite_asm

	ld hl, #_title_2_array
	ld de, #0xC028
	ld c, #40
	ld b, #48
	call cpct_drawSprite_asm

	before_loop_main:
		call clear_all_screen
		call draw_moon_and_jack
		call draw_menu_options

	loop_menu:
		call  cpct_scanKeyboard_asm

		;;if Key_A then start the game
		ld    hl, #Key_A
		call  cpct_isKeyPressed_asm
		jp    nz, start_game

		;;if Key_S then go to controls
		ld    hl, #Key_S
		call  cpct_isKeyPressed_asm
		jp    nz, before_loop_controls

		;;if Key_D then go to credits
		ld    hl, #Key_D
		call  cpct_isKeyPressed_asm
		jp    nz, before_loop_credits_1

		;;if Key_X then go to credits
		ld a, (#show_infinite_level)
		cp #1
		jp nz, dont_admit_infinite_level

		ld    hl, #Key_X
		call  cpct_isKeyPressed_asm
		jp    nz, start_game_endless

		dont_admit_infinite_level:

		call cpct_waitVSYNC_asm
		call cpct_waitVSYNC_asm
		call cpct_waitVSYNC_asm
		call cpct_akp_musicPlay_asm

	jp loop_menu

	before_loop_controls:
		call clear_all_screen
		call draw_moon_and_jack
		call draw_controls_options

	loop_controls:
		call cpct_waitVSYNC_asm
		call cpct_waitVSYNC_asm
		call cpct_waitVSYNC_asm
		call cpct_akp_musicPlay_asm

		call  cpct_scanKeyboard_asm

		;;if Key_B then go back to main menu
		ld    hl, #Key_B
		call  cpct_isKeyPressed_asm
		jp    nz, before_loop_main

	jp loop_controls

	before_loop_credits_1:
		call clear_all_screen
		call draw_made_by

	loop_credits_1:
		call cpct_waitVSYNC_asm
		call cpct_waitVSYNC_asm
		call cpct_waitVSYNC_asm
		call cpct_akp_musicPlay_asm

		call  cpct_scanKeyboard_asm

		;;if Key_B then go back to main menu
		ld    hl, #Key_B
		call  cpct_isKeyPressed_asm
		jp    nz, before_loop_main

		;;if Key_B then go to next credits screen
		ld    hl, #Key_N
		call  cpct_isKeyPressed_asm
		jp    nz, before_loop_credits_2

	jp loop_credits_1

	before_loop_credits_2:
		call clear_all_screen
		call draw_starring

	loop_credits_2:
		call cpct_waitVSYNC_asm
		call cpct_waitVSYNC_asm
		call cpct_waitVSYNC_asm
		call cpct_akp_musicPlay_asm

		call  cpct_scanKeyboard_asm

		;;if Key_B then go back to main menu
		ld    hl, #Key_B
		call  cpct_isKeyPressed_asm
		jp    nz, before_loop_main

	jp loop_credits_2

	start_game:
		ld hl, #_jack_pal
		ld de, #16
		call cpct_setPalette_asm 
		call cpct_akp_stop_asm

		call full_reset

		jp end

	start_game_endless:
		ld hl, #_a_m_pal
		ld de, #16
		call cpct_setPalette_asm 
		call cpct_akp_stop_asm
		
		call load_lvl_endless_from_menu
		ld a, #10
		ld (#current_lvl_ld), a

		call map_draw
		call ren_change_to_new_buffer
		call map_draw
		sub a
	end:
	
	ret

clear_all_screen:

	ld de, #0xF416
	ld a, #0
	ld c, #29
	ld b, #80
	call cpct_drawSolidBox_asm

	ld de, #0xF4B6
	ld a, #0
	ld c, #49
	ld b, #40
	call cpct_drawSolidBox_asm

	ld de, #0xF736
	ld a, #0
	ld c, #25
	ld b, #15
	call cpct_drawSolidBox_asm

	ld de, #0xC304
	ld a, #0
	ld c, #50
	ld b, #90
	call cpct_drawSolidBox_asm

	ld de, #0xE753
	ld a, #0
	ld c, #44
	ld b, #12
	call cpct_drawSolidBox_asm

	ld de, #0xC287
	ld a, #0
	ld c, #50
	ld b, #90
	call cpct_drawSolidBox_asm

	ld de, #0xF252
	ld a, #0
	ld c, #50
	ld b, #90
	call cpct_drawSolidBox_asm

	ld de, #0xF65D
	ld a, #0
	ld c, #60
	ld b, #20
	call cpct_drawSolidBox_asm

	

	ret

draw_moon_and_jack:

	ld hl, #_luna_menu_array
	ld de, #0xC304
	ld c, #25
	ld b, #29
	call cpct_drawSprite_asm

	ld hl, #_jack_menu_array
	ld de, #0xC445
	ld c, #27
	ld b, #40
	call cpct_drawSprite_asm

	ret

draw_moon_and_jack_pause:
	ld hl, #_luna_menu_array
	ld de, #0xC1C4
	ld c, #25
	ld b, #29
	call cpct_drawSprite_asm

	ld hl, #_jack_menu_array
	ld de, #0xC305
	ld c, #27
	ld b, #40
	call cpct_drawSprite_asm

	ret

draw_moon:
	ld hl, #_luna_menu_array
	ld de, #0xC124
	ld c, #25
	ld b, #29
	call cpct_drawSprite_asm

	ret

draw_back:

	;; B : BACK

	ld hl, #_a_m_array_01
	ld de, #0xF736
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_ddot_array
	ld de, #0xF73A
	ld c, #2
	ld b, #7
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_01
	ld de, #0xF73D
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_00
	ld de, #0xF741
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_02
	ld de, #0xF745
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_10
	ld de, #0xF749
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ret

draw_starring:

	;; STARRING:

	ld hl, #_n_z_array_05
	ld de, #0xC295
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_06
	ld de, #0xC299
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_00
	ld de, #0xC29D
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_04
	ld de, #0xC2A1
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_04
	ld de, #0xC2A5
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_08
	ld de, #0xC2A9
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00
	ld de, #0xC2AD
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_06
	ld de, #0xC2B1
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_ddot_array
	ld de, #0xC2B5
	ld c, #2
	ld b, #7
	call cpct_drawSprite_asm

	;; JACK

	ld hl, #_a_m_array_09
	ld de, #0xC358
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_00
	ld de, #0xC35C
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_02
	ld de, #0xC360
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_10
	ld de, #0xC364
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_jack_credits_array
	ld de, #0xE318
	ld c, #8
	ld b, #24
	call cpct_drawSprite_asm

	;; PINKBONES

	ld hl, #_n_z_array_02
	ld de, #0xF434
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_08
	ld de, #0xF438
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00
	ld de, #0xF43C
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_10
	ld de, #0xF440
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_01
	ld de, #0xF444
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_01
	ld de, #0xF448
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00
	ld de, #0xF44C
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04
	ld de, #0xF450
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_05
	ld de, #0xF454
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_pinkbones_credits_array
	ld de, #0xC458
	ld c, #8
	ld b, #23
	call cpct_drawSprite_asm

	;; SPOOK

	ld hl, #_n_z_array_05
	ld de, #0xE584
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_02
	ld de, #0xE588
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_01
	ld de, #0xE58C
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_01
	ld de, #0xE590
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_10
	ld de, #0xE594
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_spook_credits_array
	ld de, #0xF548
	ld c, #8
	ld b, #24
	call cpct_drawSprite_asm

	;; THE GOBLINS

	ld hl, #_n_z_array_06
	ld de, #0xD6AD
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_07
	ld de, #0xD6B1
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04
	ld de, #0xD6B5
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_06
	ld de, #0xD6BB
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_01
	ld de, #0xD6BF
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_01
	ld de, #0xD6C3
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_11
	ld de, #0xD6C7
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_08
	ld de, #0xD6CB
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00
	ld de, #0xD6CF
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_05
	ld de, #0xD6D3
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_goblins_credits_array
	ld de, #0xF688
	ld c, #8
	ld b, #17
	call cpct_drawSprite_asm

	call draw_back

	ret

draw_made_by:

	;; MADE

	ld hl, #_a_m_array_12
	ld de, #0xC287
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_00
	ld de, #0xC28B
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_03
	ld de, #0xC28F
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04
	ld de, #0xC293
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	;; BY

	ld hl, #_a_m_array_01
	ld de, #0xC299
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_11
	ld de, #0xC29D
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	;; @LAB16DEVS:

	ld hl, #_at_array
	ld de, #0xF252
	ld c, #6
	ld b, #11
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_11
	ld de, #0xC2A8
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_00
	ld de, #0xC2AC
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_01
	ld de, #0xC2B0
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_one_six_array_0
	ld de, #0xC2B4
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_one_six_array_1
	ld de, #0xC2B8
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_03
	ld de, #0xC2BC
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04
	ld de, #0xC2C0
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_08
	ld de, #0xC2C4
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_05
	ld de, #0xC2C8
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_ddot_array
	ld de, #0xC2CC
	ld c, #2
	ld b, #7
	call cpct_drawSprite_asm

	;; ALVARO B.

	ld hl, #_a_m_array_00
	ld de, #0xC3CF
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_11
	ld de, #0xC3D3
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_08
	ld de, #0xC3D7
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_00
	ld de, #0xC3DB
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_04
	ld de, #0xC3DF
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_01
	ld de, #0xC3E3
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_01
	ld de, #0xC3E9
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_dot_array
	ld de, #0xF3ED
	ld c, #2
	ld b, #4
	call cpct_drawSprite_asm

	;; TUDOR M.

	ld hl, #_n_z_array_06
	ld de, #0xC46F
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_07
	ld de, #0xC473
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_03
	ld de, #0xC477
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_01
	ld de, #0xC47B
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_04
	ld de, #0xC47F
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_12
	ld de, #0xC485
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_dot_array
	ld de, #0xF489
	ld c, #2
	ld b, #4
	call cpct_drawSprite_asm

	;; SEBASTIAN M.

	ld hl, #_n_z_array_05
	ld de, #0xC50F
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04
	ld de, #0xC513
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_01
	ld de, #0xC517
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_00
	ld de, #0xC51B
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_05
	ld de, #0xC51F
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_06
	ld de, #0xC523
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_08
	ld de, #0xC527
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_00
	ld de, #0xC52B
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00
	ld de, #0xC52F
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_12
	ld de, #0xC535
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_dot_array
	ld de, #0xF539
	ld c, #2
	ld b, #4
	call cpct_drawSprite_asm

	call draw_back

	;; N : NEXT

	ld hl, #_n_z_array_00
	ld de, #0xF765
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_ddot_array
	ld de, #0xF769
	ld c, #2
	ld b, #7
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00
	ld de, #0xF76D
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04
	ld de, #0xF771
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_10
	ld de, #0xF775
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_06
	ld de, #0xF779
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ret

draw_controls_options:

	;; A : LEFT

	ld hl, #_a_m_array_00
	ld de, #0xF416
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_ddot_array
	ld de, #0xF41A
	ld c, #2
	ld b, #7
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_11
	ld de, #0xF41D
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04
	ld de, #0xF421
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_05
	ld de, #0xF425
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_06
	ld de, #0xF429
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	;; D : RIGHT

	ld hl, #_a_m_array_03
	ld de, #0xD4B6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_ddot_array
	ld de, #0xD4BA
	ld c, #2
	ld b, #7
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_04
	ld de, #0xD4BD
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_08
	ld de, #0xD4C1
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_06
	ld de, #0xD4C5
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_07
	ld de, #0xD4C9
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_06
	ld de, #0xD4CD
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	;; O : JUMP

	ld hl, #_n_z_array_01
	ld de, #0xF506
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_ddot_array
	ld de, #0xF50A
	ld c, #2
	ld b, #7
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_09
	ld de, #0xF50D
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_07
	ld de, #0xF511
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_12
	ld de, #0xF515
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_02
	ld de, #0xF519
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	;; P : SHOOT

	ld hl, #_n_z_array_02
	ld de, #0xD5A6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_ddot_array
	ld de, #0xD5AA
	ld c, #2
	ld b, #7
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_05
	ld de, #0xD5AD
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_07
	ld de, #0xD5B1
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_01
	ld de, #0xD5B5
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_01
	ld de, #0xD5B9
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_06
	ld de, #0xD5BD
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	;; ESC : PAUSE

	ld hl, #_a_m_array_04
	ld de, #0xF5F6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_05
	ld de, #0xF5FA
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_02
	ld de, #0xF5FE
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_ddot_array
	ld de, #0xF602
	ld c, #2
	ld b, #7
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_02
	ld de, #0xF605
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_00
	ld de, #0xF609
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_07
	ld de, #0xF60D
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_05
	ld de, #0xF611
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04
	ld de, #0xF615
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	call draw_back

	ret

draw_menu_options:
	;; A . PLAY

	ld hl, #_a_m_array_00
	ld de, #0xF416
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_dot_array
	ld de, #0xD46A
	ld c, #2
	ld b, #4
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_02
	ld de, #0xF41D
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_11
	ld de, #0xF421
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_00
	ld de, #0xF425
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_11
	ld de, #0xF429
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	;; S . CONTROLS

	ld hl, #_n_z_array_05
	ld de, #0xD4B6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_dot_array
	ld de, #0xF4BA
	ld c, #2
	ld b, #4
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_02
	ld de, #0xD4BD
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_01
	ld de, #0xD4C1
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00
	ld de, #0xD4C5
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_06
	ld de, #0xD4C9
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_04
	ld de, #0xD4CD
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_01
	ld de, #0xD4D1
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_11
	ld de, #0xD4D5
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_05
	ld de, #0xD4D9
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	;; D . CREDITS

	ld hl, #_a_m_array_03
	ld de, #0xF506
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_dot_array
	ld de, #0xD55A
	ld c, #2
	ld b, #4
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_02
	ld de, #0xF50D
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_04
	ld de, #0xF511
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04
	ld de, #0xF515
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_03
	ld de, #0xF519
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_08
	ld de, #0xF51D
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_06
	ld de, #0xF521
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_05
	ld de, #0xF525
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	;; X . INFINITE

	ld a, (#show_infinite_level)
	cp #1
	jp nz, dont_show_infinite_level

	ld hl, #_n_z_array_10
	ld de, #0xF5A6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_dot_array
	ld de, #0xD5FA
	ld c, #2
	ld b, #4
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_08
	ld de, #0xF5AD
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00
	ld de, #0xF5B1
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_05
	ld de, #0xF5B5
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_08
	ld de, #0xF5B9
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00
	ld de, #0xF5BD
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_08
	ld de, #0xF5C1
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_06
	ld de, #0xF5C5
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04
	ld de, #0xF5C9
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	dont_show_infinite_level:

	;; @LAB16DEVS

	ld hl, #_at_array
	ld de, #0xE753
	ld c, #6
	ld b, #11
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_11
	ld de, #0xF759
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_00
	ld de, #0xF75D
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_01
	ld de, #0xF761
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_one_six_array_0
	ld de, #0xF765
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_one_six_array_1
	ld de, #0xF769
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_03
	ld de, #0xF76D
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04
	ld de, #0xF771
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_08
	ld de, #0xF775
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_05
	ld de, #0xF779
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ret

draw_pause_options:
	call draw_moon_and_jack_pause
	;; PAUSE

	ld hl, #_n_z_array_02			;;P
	ld de, #0xF376
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_00			;;A
	ld de, #0xF37A
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_07			;;U
	ld de, #0xF37E
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_05			;;S
	ld de, #0xF382
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04			;;E
	ld de, #0xF386
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	;; ENTER . CONTINUE

	ld hl, #_a_m_array_04			;;E
	ld de, #0xD5A6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00			;;N
	ld de, #0xD5AA
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_06			;;T
	ld de, #0xD5AE
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04			;;E
	ld de, #0xD5B2
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_04			;;R
	ld de, #0xD5B6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_dot_array
	ld de, #0xF5BA
	ld c, #2
	ld b, #4
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_02			;;C
	ld de, #0xD5BE
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_01			;;O
	ld de, #0xD5C2
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00			;;N
	ld de, #0xD5C6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_06			;;T
	ld de, #0xD5CA
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_08			;;I
	ld de, #0xD5CE
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00			;;N
	ld de, #0xD5D2
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_07			;;U
	ld de, #0xD5D6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04			;;E
	ld de, #0xD5DA
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	;; Q . QUIT

	ld hl, #_n_z_array_03
	ld de, #0xF606
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_dot_array
	ld de, #0xD65A
	ld c, #2
	ld b, #4
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_03
	ld de, #0xF60E
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_07
	ld de, #0xF612
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_08
	ld de, #0xF616
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_06
	ld de, #0xF61A
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ret

draw_game_over:
	ld hl, #_a_m_array_06			;;G
	ld de, #0xF376
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_00			;;A
	ld de, #0xF37A
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_12			;;M
	ld de, #0xF37E
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04			;;E
	ld de, #0xF382
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_01			;;O
	ld de, #0xF38A
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_08			;;V
	ld de, #0xF38E
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04			;;E
	ld de, #0xF392
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_04			;;R
	ld de, #0xF396
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	;; ENTER . CONTINUE

	ld hl, #_a_m_array_04			;;E
	ld de, #0xD5A6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00			;;N
	ld de, #0xD5AA
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_06			;;T
	ld de, #0xD5AE
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04			;;E
	ld de, #0xD5B2
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_04			;;R
	ld de, #0xD5B6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_dot_array
	ld de, #0xF5BA
	ld c, #2
	ld b, #4
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_02			;;C
	ld de, #0xD5BE
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_01			;;O
	ld de, #0xD5C2
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00			;;N
	ld de, #0xD5C6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_06			;;T
	ld de, #0xD5CA
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_08			;;I
	ld de, #0xD5CE
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00			;;N
	ld de, #0xD5D2
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_07			;;U
	ld de, #0xD5D6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04			;;E
	ld de, #0xD5DA
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ret

draw_next_lvl:
	call draw_moon
	ld hl, #_n_z_array_00			;;N
	ld de, #0xF376
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04			;;E
	ld de, #0xF37A
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_10			;;X
	ld de, #0xF37E
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_06			;;T
	ld de, #0xF382
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_11			;;L
	ld de, #0xF38A
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04			;;E
	ld de, #0xF38E
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_08			;;V
	ld de, #0xF392
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04			;;E
	ld de, #0xF396
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_11			;;L
	ld de, #0xF39A
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	;; ENTER . CONTINUE

	ld hl, #_a_m_array_04			;;E
	ld de, #0xD5A6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00			;;N
	ld de, #0xD5AA
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_06			;;T
	ld de, #0xD5AE
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04			;;E
	ld de, #0xD5B2
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_04			;;R
	ld de, #0xD5B6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_dot_array
	ld de, #0xF5BA
	ld c, #2
	ld b, #4
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_02			;;C
	ld de, #0xD5BE
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_01			;;O
	ld de, #0xD5C2
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00			;;N
	ld de, #0xD5C6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_06			;;T
	ld de, #0xD5CA
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_08			;;I
	ld de, #0xD5CE
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00			;;N
	ld de, #0xD5D2
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_07			;;U
	ld de, #0xD5D6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04			;;E
	ld de, #0xD5DA
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ret

draw_next_lvl_e:
	ld hl, #_a_m_array_02			;;C
	ld de, #0xC056
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_01			;;O
	ld de, #0xC05A
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00			;;N
	ld de, #0xC05E
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_06			;;G
	ld de, #0xC062
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_04			;;R
	ld de, #0xC066
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_00			;;A
	ld de, #0xC06A
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_06			;;T
	ld de, #0xC06E
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_07			;;U
	ld de, #0xC072
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_11			;;L
	ld de, #0xC076
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_00			;;A
	ld de, #0xC07A
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_06			;;T
	ld de, #0xC07E
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_08			;;I
	ld de, #0xC082
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_01			;;O
	ld de, #0xC086
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00			;;N
	ld de, #0xC08A
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_05			;;S
	ld de, #0xC08E
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	;; ENTER . CONTINUE

	ld hl, #_a_m_array_04			;;E
	ld de, #0xD5A6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00			;;N
	ld de, #0xD5AA
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_06			;;T
	ld de, #0xD5AE
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04			;;E
	ld de, #0xD5B2
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_04			;;R
	ld de, #0xD5B6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_dot_array
	ld de, #0xF5BA
	ld c, #2
	ld b, #4
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_02			;;C
	ld de, #0xD5BE
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_01			;;O
	ld de, #0xD5C2
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00			;;N
	ld de, #0xD5C6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_06			;;T
	ld de, #0xD5CA
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_08			;;I
	ld de, #0xD5CE
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00			;;N
	ld de, #0xD5D2
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_07			;;U
	ld de, #0xD5D6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04			;;E
	ld de, #0xD5DA
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	;;ENDLESS MODE

	ld hl, #_a_m_array_04			;;E
	ld de, #0xF376
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00			;;N
	ld de, #0xF37A
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_03			;;D
	ld de, #0xF37E
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_11			;;L
	ld de, #0xF382
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04			;;E
	ld de, #0xF386
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_05			;;S
	ld de, #0xF38A
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_05			;;S
	ld de, #0xF38E
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_12			;;M
	ld de, #0xF396
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_01			;;O
	ld de, #0xF39A
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_03			;;D
	ld de, #0xF39E
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04			;;E
	ld de, #0xF3A2
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	;; ENTER . CONTINUE

	ld hl, #_a_m_array_04			;;E
	ld de, #0xD5A6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00			;;N
	ld de, #0xD5AA
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_06			;;T
	ld de, #0xD5AE
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04			;;E
	ld de, #0xD5B2
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_04			;;R
	ld de, #0xD5B6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_dot_array
	ld de, #0xF5BA
	ld c, #2
	ld b, #4
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_02			;;C
	ld de, #0xD5BE
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_01			;;O
	ld de, #0xD5C2
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00			;;N
	ld de, #0xD5C6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_06			;;T
	ld de, #0xD5CA
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_08			;;I
	ld de, #0xD5CE
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_00			;;N
	ld de, #0xD5D2
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_07			;;U
	ld de, #0xD5D6
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_04			;;E
	ld de, #0xD5DA
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	;; Q . QUIT

	ld hl, #_n_z_array_03
	ld de, #0xF606
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_dot_array
	ld de, #0xD65A
	ld c, #2
	ld b, #4
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_03
	ld de, #0xF60E
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_07
	ld de, #0xF612
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_a_m_array_08
	ld de, #0xF616
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ld hl, #_n_z_array_06
	ld de, #0xF61A
	ld c, #4
	ld b, #8
	call cpct_drawSprite_asm

	ret