;;    Th Spirit of Halloween. An Amstrad CPC 464 game.
;;    Copyright (C) 2018 Lab16Devs
;;
;;    This program is free software: you can redistribute it and/or modify
;;    it under the terms of the GNU General Public License as published by
;;    the Free Software Foundation, either version 3 of the License, or
;;    (at your option) any later version.
;;
;;    This program is distributed in the hope that it will be useful,
;;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;    GNU General Public License for more details.
;;
;;    You should have received a copy of the GNU General Public License
;;    along with this program.  If not, see <https://www.gnu.org/licenses/>.

;###########################################################################
;#### FICHERO: main.s
;###########################################################################
 
;; Include all CPCtelera constant definitions, macros and variables
.include "main.h.s"
 
;;
;; Start of _DATA area
;;  SDCC requires at least _DATA and _CODE areas to be declared, but you may use
;;  any one of them for any purpose. Usually, compiler puts _DATA area contents
;;  right after _CODE area contents.
;;
.area _DATA
.area _CODE

.macro setBorder _color
  ld hl, #0x'_color'10
  call cpct_setPALColour_asm
.endm

map_draw:
  call ren_draw_map

  ret

cpct_mxor32_seed:      .dw #0x1A7B, #0x59F2
;;
;; MAIN function. This is the entry point of the application.
;;    _main:: global symbol is required for correctly compiling and linking
;;
_main::
  ld sp, #0x8000
  
  ;; Disable firmware to prevent it from interfering with string drawing
  call cpct_disableFirmware_asm

  ld hl, #_dot_pal_aux
	ld de, #16
	call cpct_setPalette_asm 

  ;setBorder 0

  ld de, #_game_song_array
  call cpct_akp_musicInit_asm

  call ren_clear_back_buffer
  call ren_change_to_new_buffer
  call ren_clear_back_buffer
  call ren_change_to_new_buffer

  call menu_main
 
  ld    c, #0
  call cpct_setVideoMode_asm
 
  ld hl, #_tiles_tileset
  call cpct_etm_setTileset2x4_asm

  call map_draw
  call ren_change_to_new_buffer
  call map_draw

loop:

;PRUEBAS
  call  cpct_scanKeyboard_asm
  ld    hl, #Key_Esc
  call  cpct_isKeyPressed_asm
  jr    z, continue_game
  call cpct_akp_stop_asm

  call ren_clear_back_buffer
  call ren_change_to_new_buffer
  call ren_clear_back_buffer
  ld a, (#back_buffer)
  cp #0xC0
  jp z, switch
  jp do_pause

  switch:
    call ren_change_to_new_buffer

  do_pause:
    ld a, (#hero_state)
    set 3, a              ;; Pausa
    ld (#hero_state), a

  continue_game:

  ld a, (#hero_state)
  bit 3, a              ;;Estoy en pausa?
  jp nz, paused

  ld a, (#hero_state)
  bit 7, a              ;;Game over?
  jp nz, end_game_m

  ld a, (#restart)
  cp #1
  jp z, endless

  ld a, (#change_lvl)
  cp #1
  jp z, changing_lvl_m

  call cpct_akp_musicPlay_asm
  halt
  call cpct_akp_musicPlay_asm
  halt
  call cpct_akp_musicPlay_asm
  halt
  call cpct_akp_musicPlay_asm

  ld ix, #hero_data
  call ent_clear

  call clear_enemies
  call clear_bullets

  call clear_UI

  ld ix, #hero_data
  call ent_update
  call hero_draw

  ;;call draw_UI
  call spawn_enemies
  call update_enemies
  call update_bullets
 
  call draw_UI

  call ren_change_to_new_buffer
  
  jp loop
  
  endless:
    call prep_game_over
    ld a, #0
    ld (#restart), a

    call load_lvl_endless

    jp loop

  changing_lvl_m:
    call cpct_akp_stop_asm  
    jp    loop

  end_game_m:
    call cpct_akp_stop_asm  
    ld a, (#game_over_d)
    cp #0
    call z, prep_game_over
    ld a, #1
    ld (#game_over_d), a

    call end_game
    jp    loop

  paused:
    call cpct_akp_stop_asm
    call paused_state   

  ;; Loop forever
  jp    loop