;;    Th Spirit of Halloween. An Amstrad CPC 464 game.
;;    Copyright (C) 2018 Lab16Devs
;;
;;    This program is free software: you can redistribute it and/or modify
;;    it under the terms of the GNU General Public License as published by
;;    the Free Software Foundation, either version 3 of the License, or
;;    (at your option) any later version.
;;
;;    This program is distributed in the hope that it will be useful,
;;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;    GNU General Public License for more details.
;;
;;    You should have received a copy of the GNU General Public License
;;    along with this program.  If not, see <https://www.gnu.org/licenses/>.

.include "main.h.s"

current_lvl_ld: .db 0x00 ;;Carga el siguiente nivel
restart: .db 0x00

full_reset:
    call cpct_akp_stop_asm  
    call reset_game 

    ld hl, #hero_data_ini
    ld de, #hero_data
    call ent_copy

    ld a, #0x00
    ld (#highscore), a
    ld (#loops_highscore), a
    ld (#current_lvl_ld), a

    ld hl, #_game_map_3
    ld (#map_to_load), hl

    ld a, #k_enemies_lvl_0
    ld (#k_enemies_to_spawn), a

    ld a, #K_cadence
    ld (time_cadence), a                ;;Reiniciamos el contador de cadencia

    ret

reset_game:
    call cpct_akp_stop_asm 
    ld ix, #hero_data
    call ent_clear_reset

    ld hl, #hero_data_ini
    ld de, #hero_data
    ld bc, #9 ;; Carga el tamaño de la entidad
    ldir                  ;; Copia desde la primera posicion en HL a la de DE

    call clear_enemies_reset
    call clear_bullets_reset

    ld a, #0x00
    ld (#hero_state), a                 ;;Reiniciamos los estados del jugador
    ld (#m_num_enemies), a              ;;Reiniciamos el contador de enemigos
    ld (#m_num_enemies_spawned), a      ;;Reiniciamos el contador de enemigos spawneados
    ld (#m_num_bullets), a              ;;Reiniciamos el contador de enemigos spawneados
    ld (#m_num_enemies), a              ;;Reiniciamos el contador de enemigos
    ld (#game_over_d), a
    ld (#invert_side), a

    ld hl, #enemies_vector              ;;Colocamos el puntero al siguiente enemigo al principio
    ld (m_next_enemy), hl

    ld a, #sweets_lvl_0
    ld (sweets_left), a                 ;;Reiniciamos el contador de caramelos

    ld hl, #enemies_lvl_0
    ld (m_next_enemy_to_spawn), hl

    ld a, #time_spawn_lvl_0
    ld (time_remaining_for_spawn), a    ;;Reiniciamos el contador de caramelos

    ld hl, #enemies_vector              ;;Colocamos el puntero al siguiente enemigo al principio
    ld (m_next_enemy), hl

    ld hl, #bullet_vector   
    ld (m_next_bullet), hl

    ld a, #k_max_time
    ld (time_jump), a                   ;;Reiniciamos el contador de salto

    ld a, #k_inmunity_time
    ld (inmunity_time), a               ;;Reiniciamos el contador de inmunidad

    ret

up_lives:
    ld ix, #hero_data
    ld a, e_lives(ix)
    cp #6
    ret z

    ld a, (#hero_state)
    bit 5, a              ;;Infinito
    jp z, up_1_live

    ld a, #6
    ld e_lives(ix), a

    ret

    up_1_live:
        ld a, e_lives(ix)
        add #1
        ld e_lives(ix), a

    ret

ini_lvl_1:
    call up_lives

    ld a, #sweets_lvl_1
    ld (sweets_left), a                 ;;Reiniciamos el contador de caramelos

    ld hl, #enemies_lvl_1
    ld (m_next_enemy_to_spawn), hl

    ld a, #time_spawn_lvl_1
    ld (time_remaining_for_spawn), a    ;;Reiniciamos el contador de caramelos

    ld a, #k_enemies_lvl_1
    ld (#k_enemies_to_spawn), a

    ld hl, #_game_map_1
    ld (#map_to_load), hl

    call change_lvl_f

    ret

ini_lvl_2:
    call up_lives

    ld a, #sweets_lvl_2
    ld (sweets_left), a                 ;;Reiniciamos el contador de caramelos

    ld hl, #enemies_lvl_2
    ld (m_next_enemy_to_spawn), hl

    ld a, #time_spawn_lvl_2
    ld (time_remaining_for_spawn), a    ;;Reiniciamos el contador de caramelos

    ld hl, #_game_map_1
    ld (#map_to_load), hl

    ld a, #k_enemies_lvl_2
    ld (#k_enemies_to_spawn), a

    call change_lvl_f

    ret

ini_lvl_3:
    call up_lives

    ld a, #sweets_lvl_3
    ld (sweets_left), a                 ;;Reiniciamos el contador de caramelos

    ld hl, #enemies_lvl_3
    ld (m_next_enemy_to_spawn), hl

    ld a, #time_spawn_lvl_3
    ld (time_remaining_for_spawn), a    ;;Reiniciamos el contador de caramelos

    ld hl, #_game_map_1
    ld (#map_to_load), hl

    ld a, #k_enemies_lvl_3
    ld (#k_enemies_to_spawn), a

    call change_lvl_f

    ret

ini_lvl_4:
    call up_lives

    ld a, #sweets_lvl_4
    ld (sweets_left), a                 ;;Reiniciamos el contador de caramelos

    ld hl, #enemies_lvl_4
    ld (m_next_enemy_to_spawn), hl

    ld a, #time_spawn_lvl_4
    ld (time_remaining_for_spawn), a    ;;Reiniciamos el contador de caramelos

    ld hl, #_game_map_1
    ld (#map_to_load), hl

    ld a, #k_enemies_lvl_4
    ld (#k_enemies_to_spawn), a

    call change_lvl_f

    ret

ini_lvl_5:
    call up_lives

    ld a, #sweets_lvl_5
    ld (sweets_left), a                 ;;Reiniciamos el contador de caramelos

    ld hl, #enemies_lvl_5
    ld (m_next_enemy_to_spawn), hl

    ld a, #time_spawn_lvl_5
    ld (time_remaining_for_spawn), a    ;;Reiniciamos el contador de caramelos

    ld hl, #_game_map_1
    ld (#map_to_load), hl

    ld a, #k_enemies_lvl_5
    ld (#k_enemies_to_spawn), a

    call change_lvl_f

    ret

ini_lvl_6:
    call up_lives

    ld a, #sweets_lvl_6
    ld (sweets_left), a                 ;;Reiniciamos el contador de caramelos

    ld hl, #enemies_lvl_6
    ld (m_next_enemy_to_spawn), hl

    ld a, #time_spawn_lvl_6
    ld (time_remaining_for_spawn), a    ;;Reiniciamos el contador de caramelos

    ld hl, #_game_map_2
    ld (#map_to_load), hl

    ld a, #k_enemies_lvl_6
    ld (#k_enemies_to_spawn), a

    call change_lvl_f

    ret

ini_lvl_7:
    call up_lives

    ld a, #sweets_lvl_7
    ld (sweets_left), a                 ;;Reiniciamos el contador de caramelos

    ld hl, #enemies_lvl_7
    ld (m_next_enemy_to_spawn), hl

    ld a, #time_spawn_lvl_7
    ld (time_remaining_for_spawn), a    ;;Reiniciamos el contador de caramelos

    ld hl, #_game_map_2
    ld (#map_to_load), hl

    ld a, #k_enemies_lvl_7
    ld (#k_enemies_to_spawn), a

    call change_lvl_f

    ret

ini_lvl_8:
    call up_lives

    ld a, #sweets_lvl_8
    ld (sweets_left), a                 ;;Reiniciamos el contador de caramelos

    ld hl, #enemies_lvl_8
    ld (m_next_enemy_to_spawn), hl

    ld a, #time_spawn_lvl_8
    ld (time_remaining_for_spawn), a    ;;Reiniciamos el contador de caramelos

    ld hl, #_game_map_2
    ld (#map_to_load), hl

    ld a, #k_enemies_lvl_8
    ld (#k_enemies_to_spawn), a

    call change_lvl_f

    ret

ini_lvl_9:
    call up_lives

    ld a, #sweets_lvl_9
    ld (sweets_left), a                 ;;Reiniciamos el contador de caramelos

    ld hl, #enemies_lvl_9
    ld (m_next_enemy_to_spawn), hl

    ld a, #time_spawn_lvl_9
    ld (time_remaining_for_spawn), a    ;;Reiniciamos el contador de caramelos

    ld hl, #_game_map_2
    ld (#map_to_load), hl

    ld a, #k_enemies_lvl_9
    ld (#k_enemies_to_spawn), a

    call change_lvl_f

    ret

ini_lvl_10:
    call up_lives

    ld a, #sweets_lvl_10
    ld (sweets_left), a                 ;;Reiniciamos el contador de caramelos

    ld hl, #enemies_lvl_10
    ld (m_next_enemy_to_spawn), hl

    ld a, #time_spawn_lvl_10
    ld (time_remaining_for_spawn), a    ;;Reiniciamos el contador de caramelos

    ld hl, #_game_map_2
    ld (#map_to_load), hl

    ld a, #k_enemies_lvl_10
    ld (#k_enemies_to_spawn), a

    call change_lvl_f

    ret

ini_lvl_endless:
    ld a, (#hero_state)
    set 5, a              ;;Infinito
    ld (#hero_state), a

    ld a, #1
    ld (#restart), a

    ld a, #1
    ld (#show_infinite_level), a

    ret

load_lvl_endless:
    call up_lives

    ld a, #sweets_lvl_endless
    ld (sweets_left), a                 ;;Reiniciamos el contador de caramelos

    ld a, (#hero_state)                 ;;Activamos endless mode
    set 5, a
    ld (#hero_state), a

    ld a, #1
    ld (#show_infinite_level), a

    call change_lvl_endless

    ret

load_lvl_endless_from_menu:
    ld a, #0
    ld (#restart), a

    call full_reset
    
    ld a, (#hero_state)
    set 5, a              ;;Infinito
    ld (#hero_state), a

    ld hl, #_game_map_2
    ld (#map_to_load), hl

    ld a, #1
    ld (#show_infinite_level), a

    ld a, #sweets_lvl_endless
    ld (sweets_left), a                 ;;Reiniciamos el contador de caramelos

    ld a, #1
    ld (#show_infinite_level), a

    ret

change_lvl_endless:
    ld hl, #_a_m_pal    
	ld de, #16
	call cpct_setPalette_asm 

    ld a, #1
    ld (#show_infinite_level), a

    loop_change_e:
        call draw_next_lvl_e

        call  cpct_scanKeyboard_asm
        ld    hl, #Key_Return
        call  cpct_isKeyPressed_asm
        jp nz, quit_change

        ld    hl, #Key_Q
        call  cpct_isKeyPressed_asm
        jp z, loop_change_e

    call menu_main
    ret z
    call full_reset

    quit_change:
        call map_draw
        call ren_change_to_new_buffer
        call map_draw

        ld a, #0
        ld (#change_lvl), a

    ret

change_lvl_f:
    ld hl, #_a_m_pal    
	ld de, #16
	call cpct_setPalette_asm 

    call prep_game_over

    loop_change:
        call draw_next_lvl

        call  cpct_scanKeyboard_asm
        ld    hl, #Key_Return
        call  cpct_isKeyPressed_asm
        jp z, loop_change

    ld hl, #_jack_pal    
    ld de, #16
    call cpct_setPalette_asm

    call map_draw
    call ren_change_to_new_buffer
    call map_draw

    ld a, #0
    ld (#change_lvl), a
        
    ret

next_lvl:
    call reset_game
    ld a, (#current_lvl_ld)
    push af
    cp #0
    call z, ini_lvl_1
    cp #1
    call z, ini_lvl_2
    cp #2
    call z, ini_lvl_3
    cp #3
    call z, ini_lvl_4
    cp #4
    call z, ini_lvl_5
    cp #5
    call z, ini_lvl_6
    cp #6
    call z, ini_lvl_7
    cp #7
    call z, ini_lvl_8
    cp #8
    call z, ini_lvl_9
    cp #9
    call z, ini_lvl_10
    cp #10
    call z, ini_lvl_endless

    pop af
    inc a
    ld (#current_lvl_ld), a
    
    ret

update_sweets_state:
    ld a, (#sweets_left)
    dec a
    cp #0
    jp z, end_game_s
    ld (#sweets_left), a

    ld a, (#highscore)
    cp #5
    call m, to_0_hs
    ret m
    cp #0xFF
    ret z
    add #-5
    ld (#highscore), a

    ret

    end_game_s:
        ld a, (#hero_state)
        set 7, a              ;; Poner game over
        ld (#hero_state), a

    ret

to_0_hs:
    ld a, #0
    ld (#highscore), a
    ret

prep_game_over:
    call ren_clear_back_buffer
    call ren_change_to_new_buffer
    call ren_clear_back_buffer

    ld a, (#back_buffer)
    cp #0xC0
    ret nz
        
    call ren_change_to_new_buffer

    ret

end_game:
        ld hl, #_a_m_pal    
        ld de, #16
        call cpct_setPalette_asm 

        call draw_game_over

        call  cpct_scanKeyboard_asm
        ld    hl, #Key_Return
        call  cpct_isKeyPressed_asm
        ret z

        call menu_main
        call full_reset

        ld hl, #_jack_pal    
        ld de, #16
        call cpct_setPalette_asm

        call map_draw
        call ren_change_to_new_buffer
        call map_draw

        ld a, (#hero_state)
        res 7, a              ;; Quitar game over
        ld (#hero_state), a

    ret


update_hero_state:
    ld a, (#hero_state)
    bit 2, a
    ret nz

    set 2, a
    ld (#hero_state), a

    ld a, e_lives(iy)
    dec a
    ld e_lives(iy), a
    cp #0
    jp z, end_game_lives  

    ld a, (#highscore)
    cp #2
    call m, to_0_hs
    ret
    cp #0xFF
    ret z
    add #-2
    ld (#highscore), a   

    ret

    end_game_lives:
        ld a, (#hero_state)
        set 7, a              ;; Poner game over
        ld (#hero_state), a

    ret

paused_state:
    call cpct_akp_stop_asm
    ld hl, #_a_m_pal    
	ld de, #16
	call cpct_setPalette_asm 

    call draw_pause_options

    call  cpct_scanKeyboard_asm
    ld    hl, #Key_Return
    call  cpct_isKeyPressed_asm
    jp nz, quit_pause

    ld    hl, #Key_Q
    call  cpct_isKeyPressed_asm
    ret z

    call prep_game_over

    call menu_main
    jp z, quit_pause
    call full_reset

    quit_pause:
        ld a, (#hero_state)
        bit 5, a              ;;Me dibujo en esta
        jp nz, draw_map_not_p

        ld hl, #_jack_pal    
        ld de, #16
        call cpct_setPalette_asm
        draw_map_not_p:
            call map_draw
            call ren_change_to_new_buffer
            call map_draw

            ld a, (#hero_state)
            res 3, a              ;; Quitar pausa
            ld (#hero_state), a

    ret