;;    Th Spirit of Halloween. An Amstrad CPC 464 game.
;;    Copyright (C) 2018 Lab16Devs
;;
;;    This program is free software: you can redistribute it and/or modify
;;    it under the terms of the GNU General Public License as published by
;;    the Free Software Foundation, either version 3 of the License, or
;;    (at your option) any later version.
;;
;;    This program is distributed in the hope that it will be useful,
;;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;    GNU General Public License for more details.
;;
;;    You should have received a copy of the GNU General Public License
;;    along with this program.  If not, see <https://www.gnu.org/licenses/>.

;###########################################################################
;#### FICHERO: entity.s
;###########################################################################
.include "main.h.s"

k_max_time = 12     ;;Tiempo maximo de salto
time_jump: .db 0x0C ;;Tiempo de salto

k_inmunity_time = 16     ;;Tiempo maximo de invulnerabilidad
inmunity_time: .db 0x10  ;;Tiempo de invulnerabilidad

K_cadence = 6          ;;Tiempo maximo de cadencia
time_cadence: .db 0x00 ;;Tiempo de cadencia

game_over_d: .db 0x00  ;;Primera iteracion en game over
change_lvl: .db 0x00 ;;Cambiando de nivel

;;.macro DefineEntity _name, _x, _y, _vx, _vy, _w, _h, _col, _upd, _last_side, _lives, _sprite, _animation, _type
DefineEntity hero_data, 0x24, 0x90, 0x00, 0x00, 0x08, 0x10, 0x0F, ent_moveKeyboard, 0x01, 0x06, _jack_array_2, 0x03, 0x01
DefineEntity hero_data_ini, 0x24, 0x90, 0x00, 0x00, 0x08, 0x10, 0x0F, ent_moveKeyboard, 0x01, 0x06, _jack_array_2, 0x03, 0x01
hero_state: .db 0x00    ;;  00000000  ;; Bit 7 -> End Game | Bit 6 -> Idle | Bit 5 -> Endless mode | Bit 4 -> Dibujado anterior | 
                                      ;; Bit 3 -> Pausa | Bit 2 -> Invulnerable | Bit 1 -> ¿Estoy en el suelo? | Bit 0 -> ¿Estoy saltando?
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; DIBUJAR UNA ENTIDAD
;; REGISTROS DESTRUIDOS: AF, BC, DE, HL
;; ENTRADA: IX -> Puntero a entidad
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ent_draw:
  call ren_draw_entity
  ret
 
hero_draw:
  ld a, (#hero_state)
  bit 2, a              ;;Estoy inmune?
  jp z, not_inmune

  ld a, (#hero_state)
  bit 4, a
  jp z, not_inmune      ;;No se ha dibujado en la anterior, dibujar ahora

  res 4, a              ;;Me dibujo en la siguiente
  ld (#hero_state), a

  ret

  not_inmune:
    ld a, (#hero_state)
    set 4, a              ;;Me dibujo en esta
    ld (#hero_state), a

    call ren_draw_hero

  ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ACTUALIZAR UNA ENTIDAD
;; REGISTROS DESTRUIDOS:
;; ENTRADA: IX -> Puntero a entidad
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ent_update:
  ld     h, e_up_h(ix)
  ld     l, e_up_l(ix)
  jp    (hl)

ent_clear:
  call ren_clear_entity
  ret

ent_clear_reset:
  call ren_clear_entity
  call ren_clear_entity_front
  ret
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; MOVER UNA ENTIDAD CON TECLADO
;; REGISTROS DESTRUIDOS: HL, A
;; ENTRADA: IX -> Puntero a entidad
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ent_moveKeyboard:
  call  cpct_scanKeyboard_asm

    ld    hl, #Key_A
    call  cpct_isKeyPressed_asm
    jr    z, a_no_pulsada
    ld e_vx(ix), #-1

  a_no_pulsada:
    ld    hl, #Key_D
    call  cpct_isKeyPressed_asm
    jr    z, d_no_pulsada
    ld e_vx(ix), #1

  d_no_pulsada:
    ld a, (#hero_state)
    bit 0, a             ;;Si estamos saltando no comprobamos la tecla
    jp nz, continue

    ld a, (#hero_state)
    bit 1, a             ;;Si no estamos en el suelo no se puede volver a saltar
    jp z, o_no_pulsada

    check_o:
      ld hl, #Key_O
      call cpct_isKeyPressed_asm
      jr z, o_no_pulsada

      ld a, (#hero_state)
      set 0, a              ;; Estamos saltando
      res 1, a              ;; No estamos en el suelo
      ld (#hero_state), a
      
    continue:
      ld a, (#time_jump)
      cp #0           ;;El tiempo de salto se ha acabado
      jp z, set_salto
      dec a
      ld (#time_jump), a

      ld e_vy(ix), #-4
      jr no_caer

      set_salto:      ;;Establecemos el estado de salto a 0 y restauramos el contador de salto
        ld a, (#hero_state)            
        res 0, a         
        ld (#hero_state), a

        ld a, #k_max_time
        ld (#time_jump), a

  o_no_pulsada:
    ld e_vy(ix), #4
    ld a, (#hero_state)
    res 1, a                ;; No estoy en el suelo
    ld (#hero_state), a

  no_caer:
    call  ent_move
    
  x_no_pulsada:
    ld a, (#time_cadence)
    cp #0                       ;;El tiempo de inmunidad se ha acabado
    jp z, enable_shooting
    dec a
    ld (#time_cadence), a

    jp p_no_pulsada

    enable_shooting:
      ld hl, #Key_P
      call cpct_isKeyPressed_asm
      jr z, p_no_pulsada

      ld a, #K_cadence
      ld (#time_cadence), a       ;;Reiniciamos cadencia

      ld a, (m_num_bullets)
      cp #k_max_num_bullets       ;;Comprobamos si ya existe el maximo numero de balas
      jr z, p_no_pulsada
      call bullet_new
      ex de, hl
      call bullet_initialize

  p_no_pulsada:
    ld e_vx(ix), #0
    ld e_vy(ix), #0

    call update_inmunity_state

  ret
 
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; MOVER UNA ENTIDAD
;; REGISTROS DESTRUIDOS:
;; ENTRADA: IX -> Puntero a entidad
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ent_move:
  call update_last_side
  call update_animation 
  
  ld    a, de_x(ix)
  ld    b, a
  add   e_vx(ix)
  ld    de_x(ix), a
  ld    e_bb_x(ix), a
  
  call check_walls_collide        ;; Compruebo si toco paredes
  jr nz, fix_move_x
  call check_platforms_collide    ;; Compruebo si toco plataformas
  jr nz, fix_move_x

  jr y

  fix_move_x:                     ;; No me muevo
    ld de_x(ix), b
    ld e_bb_x(ix), b

  y:
    ld    a, de_y(ix)
    ld    b, a
    add   e_vy(ix)
    ld    de_y(ix), a
    ld    e_bb_y(ix), a

    call check_limits_collide     ;; Compruebo si toco limites
    jr nz, fix_move_y
    call check_platforms_collide
    jr nz, fix_move_y

    ret

    fix_move_y:
      ld a, (#hero_state)
      set 1, a                ;; Estoy en el suelo
      ld (#hero_state), a
      ld de_y(ix), b 
      ld e_bb_y(ix), b   
 
ret

update_animation:
  ld a, e_type(ix)
  cp #1
  jp nz, update_anim

  ld a, e_vx(ix)
  cp #0
  jp nz, update_anim

  ld a, (#hero_state)
  set 6, a
  ld (#hero_state), a

  ret
  update_anim:
    ld a, e_type(ix)
    cp #1
    jp nz, not_hero

    ld a, (#hero_state)
    res 6, a
    ld (#hero_state), a

    not_hero:
      ld a, e_animation(ix)
      cp #0
      jp z, is_zero
      dec a
      jp end

      is_zero:
        ld a, #3

      end:
        ld e_animation(ix), a
    
  ret

update_last_side:
  ld    a, e_vx(ix)
  cp #0
  ret z
  ld    e_last_s(ix), a ;;Si existe velocidad en x guardar su estado
  ret

update_inmunity_state:
  ld a, e_lives(ix)
  cp #0
  jp nz, check_inmunity

  check_inmunity:
    ld a, (#hero_state)
    bit 2, a
    ret z

    ld a, (#inmunity_time)
    cp #0                       ;;El tiempo de inmunidad se ha acabado
    jp z, reset_inmunity
    dec a
    ld (#inmunity_time), a

    ret

    reset_inmunity:
      ld a, (#hero_state)
      res 2, a                  ;;Ya no soy inmune
      ld (#hero_state), a
      ld a, #k_inmunity_time
      ld (#inmunity_time), a

    ret

ent_copy:
  ld bc, #k_entity_size ;; Carga el tamaño de la entidad
  ldir                  ;; Copia desde la primera posicion en HL a la de DE

  ret