;;    Th Spirit of Halloween. An Amstrad CPC 464 game.
;;    Copyright (C) 2018 Lab16Devs
;;
;;    This program is free software: you can redistribute it and/or modify
;;    it under the terms of the GNU General Public License as published by
;;    the Free Software Foundation, either version 3 of the License, or
;;    (at your option) any later version.
;;
;;    This program is distributed in the hope that it will be useful,
;;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;    GNU General Public License for more details.
;;
;;    You should have received a copy of the GNU General Public License
;;    along with this program.  If not, see <https://www.gnu.org/licenses/>.

;###########################################################################
;#### FICHERO: entity.h.s
;###########################################################################
k_entity_size = 19
k_vx_pos_from_end = 10

;;_animation is a counter for sprite frame switching
;;_type is to differentiate the 3 main entities (3=bullet, 2=enemy, 1=player)

.macro DefineEntity _name, _x, _y, _vx, _vy, _w, _h, _col, _upd, _last_side, _lives, _sprite, _animation, _type
_name:
   DefineBoundingBox _name'_bb, _x, _y, _w, _h
   DefineDrawableEntity _name'_dr, _x, _y, _w, _h, _col
    .db   _vx, _vy    ;; VX, VY
    .dw   _upd        ;; Puntero a su funcion de movimiento
    .db   _last_side, _lives
    .dw   _sprite
    .db   _animation, _type
.endm

.macro DefineEntityDefault _name, _suf
   DefineEntity _name'_suf, 0xAA, 0, 0, 0, 0, 0, 0, 0xFFFF, 0x01, 0x01, 0xFFFF, 0x03, 0x02
.endm

.macro DefineNEntities _name, _n
  _c = 0
  .rept _n
     DefineEntityDefault _name, \_c
     _c = _c + 1
  .endm
.endm


drawable_entity_size = 5
boundingbox_size = 4
end_drawable_entity = (boundingbox_size + drawable_entity_size)
e_bb_x = 0
e_bb_y = 1
e_bb_w = 2
e_bb_h = 3
e_vx = 0 + end_drawable_entity
e_vy = 1 + end_drawable_entity
e_up_l = 2 + end_drawable_entity
e_up_h = 3 + end_drawable_entity
e_last_s = 4 + end_drawable_entity
e_lives = 5 + end_drawable_entity
e_sprite_l = 6 + end_drawable_entity
e_sprite_h = 7 + end_drawable_entity
e_animation = 8 + end_drawable_entity
e_type = 9 + end_drawable_entity
 
 ;;
 ;;	GLOBALES
 ;;
.globl ent_draw
.globl ent_clear
.globl ent_clear_reset
.globl hero_draw
.globl ent_update
.globl ent_copy
.globl ent_move
.globl update_last_side
.globl update_animation
 
.globl hero_data
.globl hero_data_ini
.globl hero_state

.globl k_max_time
.globl time_jump
.globl k_inmunity_time
.globl inmunity_time
.globl K_cadence
.globl time_cadence
.globl game_over_d
.globl change_lvl
