;;    Th Spirit of Halloween. An Amstrad CPC 464 game.
;;    Copyright (C) 2018 Lab16Devs
;;
;;    This program is free software: you can redistribute it and/or modify
;;    it under the terms of the GNU General Public License as published by
;;    the Free Software Foundation, either version 3 of the License, or
;;    (at your option) any later version.
;;
;;    This program is distributed in the hope that it will be useful,
;;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;    GNU General Public License for more details.
;;
;;    You should have received a copy of the GNU General Public License
;;    along with this program.  If not, see <https://www.gnu.org/licenses/>.

;###########################################################################
;#### FICHERO: enemies.s
;###########################################################################
.include "main.h.s"

k_enemies_to_spawn: .db 0x06
k_enemies_lvl_0 = 6
k_enemies_lvl_1 = 16
k_enemies_lvl_2 = 6
k_enemies_lvl_3 = 8
k_enemies_lvl_4 = 15
k_enemies_lvl_5 = 22
k_enemies_lvl_6 = 28
k_enemies_lvl_7 = 30
k_enemies_lvl_8 = 30
k_enemies_lvl_9 = 20
k_enemies_lvl_10 = 35
time_spawn_lvl_0 = 20
time_spawn_lvl_1 = 20
time_spawn_lvl_2 = 20
time_spawn_lvl_3 = 20
time_spawn_lvl_4 = 20
time_spawn_lvl_5 = 20
time_spawn_lvl_6 = 20
time_spawn_lvl_7 = 15
time_spawn_lvl_8 = 10
time_spawn_lvl_9 = 10
time_spawn_lvl_10 = 10
time_remaining_for_spawn: .db 0x14

;;Vector de enemigos para spawnear (01 -> Pinkbones | 02 -> Spook | 04 -> Goblin | 08 -> Chicago)
enemies_lvl_0: .db 0x04, 0x04, 0x04, 0x04, 0x04, 0x02
enemies_lvl_1: .db 0x04, 0x04, 0x04, 0x02, 0x04, 0x02, 0x04, 0x02, 0x04, 0x02, 0x04, 0x02, 0x04, 0x02, 0x04, 0x02
enemies_lvl_2: .db 0x01, 0x01, 0x04, 0x04, 0x01, 0x01
enemies_lvl_3: .db 0x08, 0x04, 0x08, 0x04, 0x08, 0x02, 0x08, 0x04
enemies_lvl_4: .db 0x01, 0x04, 0x01, 0x04, 0x01, 0x04, 0x01, 0x04, 0x01, 0x01, 0x04, 0x04, 0x01, 0x04, 0x01
enemies_lvl_5: .db 0x04, 0x01, 0x04, 0x01, 0x08, 0x04, 0x01, 0x04, 0x01, 0x04, 0x08, 0x01, 0x04, 0x04, 0x01, 0x04, 0x08, 0x02, 0x04, 0x02, 0x01, 0x04
enemies_lvl_6: .db 0x04, 0x04, 0x08, 0x04, 0x04, 0x04, 0x02, 0x08, 0x02, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x04, 0x04, 0x04, 0x01, 0x01, 0x08
enemies_lvl_7: .db 0x04, 0x04, 0x04, 0x04, 0x01, 0x04, 0x04, 0x01, 0x04, 0x04, 0x04, 0x01, 0x01, 0x04, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x04, 0x01, 0x04, 0x04, 0x04, 0x04, 0x04, 0x01, 0x04, 0x04
enemies_lvl_8: .db 0x02, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x02, 0x02, 0x04, 0x04, 0x04, 0x04, 0x04, 0x02, 0x02, 0x04, 0x04, 0x04, 0x04, 0x02, 0x04, 0x04, 0x04, 0x02, 0x04, 0x04, 0x02, 0x02, 0x02
enemies_lvl_9: .db 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x01, 0x02, 0x02, 0x01, 0x01, 0x02, 0x01, 0x02, 0x04, 0x04, 0x02, 0x04, 0x02, 0x04
enemies_lvl_10: .db 0x02, 0x02, 0x04, 0x04, 0x01, 0x08, 0x02, 0x08, 0x02, 0x04, 0x04, 0x01, 0x04, 0x04, 0x01, 0x04, 0x01, 0x04, 0x04, 0x04, 0x01, 0x04, 0x08, 0x01, 0x08, 0x02, 0x04, 0x01, 0x02, 0x01, 0x01, 0x04, 0x01, 0x04, 0x04

m_num_enemies_spawned:
  .db 00    ;;Numero de entidades generadas
m_next_enemy_to_spawn:
  .dw enemies_lvl_0

k_max_num_enemies = 5  ;;Cantidad maxima de entidades

sweets_lvl_0 = 8
sweets_lvl_1 = 8
sweets_lvl_2 = 8
sweets_lvl_3 = 6
sweets_lvl_4 = 6
sweets_lvl_5 = 6
sweets_lvl_6 = 5
sweets_lvl_7 = 4
sweets_lvl_8 = 3
sweets_lvl_9 = 3
sweets_lvl_10 = 4
sweets_lvl_endless = 3
sweets_left: .db 0x05 ;;Caramelos restantes

highscore: .db 0x00 ;;Puntuacion
loops_highscore: .db 0x00 ;;Vueltas a la puntuacion
next_spook: .db 0x00 ;;Inicializacion especial
invert_side: .db 0x00

enemies_vector:
DefineNEntities enemies_vector, k_max_num_enemies
;;DefineEntity _name,     _x,    _y,   _vx, _vy,  _w,    _h, _col, _upd, _last_side, _lives, _sprite, _animation, _type
DefineEntity basic_enemy, 0x10, 0x08, 0x00, 0x04, 0x08, 0x10, 0x01, enemy_move_basic, 0x01, 0x02, _pinkbones_array_0, 0x03, 0x02
DefineEntity spook_enemy, 0x10, 0x08, 0x00, 0x04, 0x08, 0x10, 0x00, spook_move, 0x01, 0x01, _spook_array_0, 0x03, 0x02
DefineEntity goblin_enemy, 0x10, 0x08, 0x00, 0x04, 0x04, 0x08, 0xFF, enemy_move_goblin, 0x01, 0x01, _goblin_array_0, 0x03, 0x04
DefineEntity chicago_enemy, 0x10, 0x08, 0x00, 0x04, 0x08, 0x10, 0xFF, enemy_move_basic, 0x01, 0x01, _chicago_array_0, 0x03, 0x02

DefineBoundingBox sweets_floor_0_map_1,  0x22, 0xA7, 0x0C, 0x08
DefineBoundingBox sweets_floor_0_map_2,  0x08, 0xA7, 0x0C, 0x08
DefineBoundingBox sweets_floor_1_map_2,  0x38, 0xA7, 0x14, 0x08

m_num_enemies:
  .db 00    ;;Numero de entidades generadas
m_next_enemy:
  .dw enemies_vector

spawn_enemies:
  ld a, (#hero_state)
  bit 5, a              ;;Modo infinito
  jp nz, endless

  ld a, (#m_num_enemies_spawned)
  ld c, a
  ld a, (#k_enemies_to_spawn)
  ld b, a
  ld a, c
  cp b
  jp nz, endless
  call z, check_if_lvl_cleared

  ret

  endless:
    ld a, (#time_remaining_for_spawn)
    cp #0                       ;;El tiempo de spawn se ha acabado
    jp z, spawn_enemy
    dec a
    ld (#time_remaining_for_spawn), a

  ret

  spawn_enemy:
    call spawn_new_enemy

  ret

check_if_lvl_cleared:
  ld a, (#m_num_enemies)
  cp #0
  call z, next_lvl
  ret

spawn_new_enemy:
  ld a, (m_num_enemies)
  cp #k_max_num_enemies
  ret z

  call enemy_new
  ex de, hl

  ld a, (#hero_state)
  bit 5, a                                  ;;Modo infinito
  jp nz, endless_type_spawn

  call select_enemy_type_vector
  jp initialize_and_spawn

  endless_type_spawn:
    push de
    call select_enemy_type_random
    pop de

  initialize_and_spawn:
    call enemy_initialize

    ld a, #time_spawn_lvl_0
    ld (#time_remaining_for_spawn), a       ;;Reiniciar el contador

  ret

select_enemy_type_random:
  call cpct_getRandom_mxor_u8_asm     ;; Registro L -> Numero aleatorio
  ld a, l
  cp #0x7F
  jp m, basic_initialize_r
  cp #0xC0
  jp m, spook_initialize_r
  cp #0xFF
  jp m, goblin_initialize_r

  basic_initialize_r:
    ld hl, #basic_enemy
    ret

  spook_initialize_r:
    ld hl, #spook_enemy
    ret

  goblin_initialize_r:
    ld hl, #goblin_enemy

  ret

select_enemy_type_vector:
  call spawn_new
  ld a, (hl)
  bit 0, a
  jp nz, basic_initialize
  bit 1, a
  jp nz, spook_initialize
  bit 2, a
  jp nz, goblin_initialize
  bit 3, a
  jp nz, chicago_initialize

  basic_initialize:
    ld hl, #basic_enemy
    ret

  spook_initialize:
    ld a, #1
    ld (#next_spook), a
    ld hl, #spook_enemy
    ret

  goblin_initialize:
    ld hl, #goblin_enemy
    ret

  chicago_initialize:
    ld hl, #chicago_enemy
    ret

  ret

;; REGISTRA UNA ENTIDAD
;; DESTRUYE: AF, HL, BC
spawn_new:
  ld a, (#m_num_enemies_spawned)
  inc a
  ld (#m_num_enemies_spawned), a

  ld hl, (#m_next_enemy_to_spawn)
  inc hl
  ld (#m_next_enemy_to_spawn), hl
  dec hl

  ret

;; REGISTRA UNA ENTIDAD
;; DESTRUYE: AF, HL, BC
enemy_new:
  ld a, (m_num_enemies)
  inc a
  ld (m_num_enemies), a

  ld hl, (m_next_enemy)
  ld bc, #k_entity_size
  add hl, bc
  ld (m_next_enemy), hl
  or a  ;;DEJA ACARREO EN 0
  sbc hl, bc  ;; RESTA CON ACARREO

  ret

;; COPIA UNA ENTIDAD
enemy_initialize:
  ld bc, #k_entity_size ;; Carga el tamaño de la entidad
  ldir                  ;; Copia desde la primera posicion en HL a la de DE

  ld h, d       
  ld l, e
  ld bc, #-k_entity_size
  add hl, bc

  ld a, (#next_spook)
  cp #1
  jp z, ini_in_map2

  ld a, (#current_lvl_ld)
  cp #1
  jp m, ini_map3
  cp #6
  jp m, ini_map1

  ini_in_map2:
    call initialize_rand_enemy_map_2

  ld a, #0
  ld (#next_spook), a

  ret

  ini_map3:
    call initialize_rand_enemy_map_3
  ret

  ini_map1:
    call initialize_rand_enemy_map_1

  ret

initialize_rand_enemy_map_2:
  ld a, (#invert_side)
  cp #0
  jp nz, choose_side_or_vel

  push hl
  call cpct_getRandom_mxor_u8_asm     ;; Registro L -> Numero alearorio
  ld a, l
  cp #80
  jp m, ini_to_left

  jp ini_to_right

  choose_side_or_vel:
    push hl
    ld a, (#invert_side)
    cp #1
    jp z, ini_to_left

  ini_to_right:
    pop hl
    ld (hl), #0x10        ;; Posicion X BB

    ld bc, #4
    add hl, bc

    ld (hl), #0x10        ;; Posicion X

    ld bc, #5
    add hl, bc

    ld (hl), #1           ;; Velocidad X

    ld a, #1
    ld (#invert_side), a
    ret
  
  ini_to_left:
    pop hl

    ld (hl), #0x40        ;; Posicion X BB

    ld bc, #4
    add hl, bc

    ld (hl), #0x40        ;; Posicion X

    ld bc, #5
    add hl, bc
       
    ld (hl), #-1          ;; Velocidad X

    ld a, #2
    ld (#invert_side), a

  ret

initialize_rand_enemy_map_3:
  ld (hl), #0x10        ;; Posicion X BB

  ld bc, #4
  add hl, bc

  ld (hl), #0x10        ;; Posicion X

  ld bc, #5
  add hl, bc

  ld (hl), #1           ;; Velocidad X
  ret

initialize_rand_enemy_map_1:
  ld (hl), #0x24        ;; Posicion X BB

  ld bc, #4
  add hl, bc

  ld (hl), #0x24        ;; Posicion X

  ld a, (#invert_side)
  cp #0
  jp nz, choose_side_or_vel_1

  push hl
  call cpct_getRandom_mxor_u8_asm     ;; Registro L -> Numero alearorio
  ld a, l
  cp #80
  jp m, ini_to_left_1

  jp ini_to_right_1

  choose_side_or_vel_1:
    push hl
    ld a, (#invert_side)
    cp #1
    jp z, ini_to_left_1

  ini_to_right_1:
    pop hl
    ld bc, #5
    add hl, bc

    ld (hl), #1           ;; Velocidad X

    ld a, #1
    ld (#invert_side), a
    ret
  
  ini_to_left_1:
    pop hl

    ld bc, #5
    add hl, bc
       
    ld (hl), #-1          ;; Velocidad X

    ld a, #2
    ld (#invert_side), a

  ret

;; ELIMINA UNA ENTIDAD DEL VECTOR
;; PARAMETROS: DE -> DIRECCIÓN A ENTIDAD A ELIMINAR
;; REGISTROS DESTRUIDOS: A, HL, IX, BC
enemy_delete:
  ld a, (m_num_enemies)       ;;RECOJO EL NUMERO ACTUAL DE ENTIDADES
  cp #0
  jr z, nada_a_borrar
  dec a
  ld hl, #enemies_vector

  buscar_ultimo:
    ld bc, #k_entity_size   ;; CARGO EL TAMANYO DE UNA ENTIDAD
    add hl, bc              ;; PASO A LA SIGUIENTE ENTIDAD
    dec a                   ;; REDUZCO MI ITERADOR
    jr nz, buscar_ultimo

    call ent_copy                 ;; SOBREESCRIBO EL ELEMENTO A BORRAR CON LA ULTIMA ENTIDAD

    ld a, (m_num_enemies)       ;;
    dec a                   ;;
    ld (m_num_enemies), a       ;; REDUZCO EN UNO EL NUMERO DE ENTIDADES

    ld hl, (m_next_enemy)  ;; CARGO LA SIGUIENTE ENTIDAD
    ld bc, #k_entity_size   ;; CARGO EL TAMANYO DE UNA ENTIDAD
    sbc hl, bc              ;; SE REDUCE EN NUEVE LA DIRECCION EN HL
    ld (m_next_enemy), hl  ;; ...PARA CALCULAR EL NUEVO NEXT_ENTITY

    nada_a_borrar:
      ret


update_enemies:
  ld hl, #ent_update
  call ent_do_this_for_all

  ld hl, #ent_draw
  call ent_do_this_for_all

  ret

clear_enemies:
  ld hl, #ent_clear
  call ent_do_this_for_all

  ret

clear_enemies_reset:
  ld hl, #ent_clear_reset
  call ent_do_this_for_all

  ret

;; Realiza la funcion global en todas las entidades
;; HL -> direccion a ejecutar
;; REGISTROS DESTRUIDOS: TODOS
ent_do_this_for_all:
  ld  a, (m_num_enemies)    ;; Cargamos en A el numero de entidades
  cp #0
  jr z, no_hay_entidades
  ld ix, #enemies_vector ;; Cargamos el puntero que apunta al vector de entidades
  ld (metodo), hl       ;;
  bucle:
    push af               ;; Guardamos el valor de A
    metodo = . + 1        ;; Calculamos el valor de la dirección de memoria de mi posicion+1
    call ent_draw         ;; Metodo dummy
    pop af                ;; Recuperamos A
    ld bc, #k_entity_size ;; Cargamos el tamanyo de la entidad
    add ix, bc            ;; Avanzamos el iterador a la siguiente entidad

    dec a                 ;; Reducimos A
    jr nz, bucle          ;; Si no se ha ejecutado el metodo en todas las entidades continuamos

    no_hay_entidades:
       ret

enemy_move_basic:
  ld a, de_col(ix)
  bit 0, a
  jp z, dont_move

  call check_walls_collide
  call nz, switch_direction
  call enemy_move

  res 0, a
  ld de_col(ix), a
  ret

  dont_move:
    set 0, a
    ld de_col(ix), a
    
  ret

enemy_move_goblin:
  call check_walls_collide
  call nz, switch_direction
  call enemy_move
  ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; MOVER UN ENEMIGO CON LOGICA BASICA
;; MUEVE DE IZQUIERDA A DERECHA UN ENEMIGO
;; REGISTROS DESTRUIDOS: AF, FLAGS
;; ENTRADA: IX -> Puntero a entidad
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
enemy_move:
  call update_last_side
  call update_animation

  ld    a, de_x(ix)
  add   e_vx(ix)
  ld    de_x(ix), a
  ld    e_bb_x(ix), a

  y_e:
    ld    a, de_y(ix)
    ld b,a
    add   e_vy(ix)
    ld    de_y(ix), a
    ld    e_bb_y(ix), a

    call check_limits_collide    ;; Compruebo si toco limites
    jr nz, fix_move_y_e
    call check_platforms_collide
    jr nz, fix_move_y_e

    jp check_col_with_entity_and_sweets

    fix_move_y_e:
      ld de_y(ix), b 
      ld e_bb_y(ix), b 

    check_col_with_entity_and_sweets:
      call check_col_entity
      call check_sweets

    ret

check_col_entity:
  ld iy, #hero_data

  call detect_collision
  ret z

  call update_hero_state

  ret

switch_direction:           ;;Invertimos la direccion
  ld a, e_vx(ix)
  cp #1
  jp z, turn_left

  ld e_vx(ix), #1
  ld    a, de_x(ix)
  ret

  turn_left:
    ld e_vx(ix), #-1
    ld    a, de_x(ix)

  ret

spook_move:
  call update_animation
  call update_last_side
  ld iy, #hero_data

  call check_y_pos_hero
  jp z, spook_x
  add   de_y(ix)
  ld    de_y(ix), a
  ld    e_bb_y(ix), a

  ret

  spook_x:
    call check_x_pos_hero
    ld a, de_x(ix)
    add   e_vx(ix)
    ld    de_x(ix), a
    ld    e_bb_x(ix), a

  call check_col_entity
  ret z

  call ren_clear_entity_front
  call ren_clear_entity

  push ix
  pop de

  call enemy_delete

  ld bc, #-k_entity_size          ;;Dejar IX en esta posicion para el bucle
  add ix, bc

  ret

check_x_pos_hero:
  ld a, de_x(iy)
  ld c, de_x(ix)
  sub c
  ret z
  jp m, go_left

  ld e_vx(ix), #2
  ret

  go_left:
    ld e_vx(ix), #-2

  ret

check_y_pos_hero:
  ld a, de_col(ix)
  cp #1
  jp z, skip_start_check

  ld a, de_y(ix)
  cp #0x19
  jp m, go_down_always

  ld de_col(ix), #1

  skip_start_check:
  ld a, de_y(ix)
  ld c, de_y(iy)
  sub c
  ld b, a
  ret z
  jp m, go_down

  ld a, b
  cp #4
  jp m, adjust_y_slow_minus

  normal_y_m:
    or a
    ld a, #-4
    ret

  adjust_y_slow_minus:
    cp #-4
    jp m, normal_y_m
    sub a
    ret
  ret

  go_down_always:
    ld a, de_y(ix)
    ld c, de_y(iy)
    sub c
    cp #0
    ret z
    or a
    ld a, #4
    ret

  go_down:
    ld a, b
    cp #-4
    jp m, adjust_y_slow_sum

    normal_y_s:
      or a
      ld a, #4
      ret

    adjust_y_slow_sum:
      cp #4
      jp m, normal_y_s
      sub a
    ret
    
  ret

check_sweets:
  ld a, (#current_lvl_ld)
  cp #1
  jp m, check_map_0_sweets
  cp #6
  jp m, check_map_1_sweets

  jp check_map_2_sweets

  check_map_0_sweets:
    ld iy, #sweets_floor_1_map_2
    call detect_collision
    jp nz, col_with_sweets
    ret

  check_map_2_sweets:
    ld iy, #sweets_floor_0_map_2
    call detect_collision
    jp nz, col_with_sweets
    ld iy, #sweets_floor_1_map_2
    call detect_collision
    jp nz, col_with_sweets

  ret

  check_map_1_sweets:
    ld iy, #sweets_floor_0_map_1
    call detect_collision
    jp nz, col_with_sweets

  ret

  col_with_sweets:
    call ren_clear_entity_front
    call ren_clear_entity

    push ix
    pop de

    call enemy_delete

    ld bc, #-k_entity_size        ;;Dejar IX en esta posicion para el bucle
    add ix, bc

    call update_sweets_state

    sub a

    ret