;;    Th Spirit of Halloween. An Amstrad CPC 464 game.
;;    Copyright (C) 2018 Lab16Devs
;;
;;    This program is free software: you can redistribute it and/or modify
;;    it under the terms of the GNU General Public License as published by
;;    the Free Software Foundation, either version 3 of the License, or
;;    (at your option) any later version.
;;
;;    This program is distributed in the hope that it will be useful,
;;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;    GNU General Public License for more details.
;;
;;    You should have received a copy of the GNU General Public License
;;    along with this program.  If not, see <https://www.gnu.org/licenses/>.

.include "main.h.s"

;;--------------------------------------------------
;;  Comprueba la colision entre dos objetos
;;  IN:     HL -> Entidad 1, DE -> Entidad 2
;;  OUT:    Z flag no activado si hay colision
;;  UNSAFE: HL, DE, AF, BC, FLAGS
;;--------------------------------------------------
detect_collision:
  call check_pos_collision_X_W_X_IX    ;; ((DE.x + DE.w) - HL.x) - 1         ;; El -1 es para forzar el menor o igual a menor
  jp m, no_collision

  call check_pos_collision_X_W_X_IY    ;; ((HL.x + HL.w) - DE.x) - 1
  jp m, no_collision

  call check_pos_collision_Y_H_Y_IX    ;; ((DE.y + DE.h) - HL.y) - 1
  jp m, no_collision
  
  call check_pos_collision_Y_H_Y_IY    ;; ((HL.y + HL.h) - DE.y) - 1
  jp m, no_collision

  add #1

  ret

  no_collision:
    sub a

  ret 

;; Comprueba si se solapan las entidades en uno de los ejes
check_pos_collision_X_W_X_IX:
  ld a, e_bb_x(ix)
  ld c, e_bb_w(ix)
  add c
  sub e_bb_x(iy)
  dec a

  ret

  ;; Comprueba si se solapan las entidades en uno de los ejes
check_pos_collision_X_W_X_IY:
  ld a, e_bb_x(iy)
  ld c, e_bb_w(iy)
  add c
  sub e_bb_x(ix)
  dec a

  ret

  ;; Comprueba si se solapan las entidades en uno de los ejes
check_pos_collision_Y_H_Y_IX:
  ld a, e_bb_y(ix)
  ld c, e_bb_h(ix)
  add c
  sub e_bb_y(iy)
  dec a

  ret

  ;; Comprueba si se solapan las entidades en uno de los ejes
check_pos_collision_Y_H_Y_IY:
  ld a, e_bb_y(iy)
  ld c, e_bb_h(iy)
  add c
  sub e_bb_y(ix)
  dec a

  ret

  ret

;;--------------------------------------------------
;;  Comprueba la colision con las paredes
;;  OUT:    Z flag no activado si hay colision
;;  UNSAFE: HL, DE, AF, BC, FLAGS
;;--------------------------------------------------
check_walls_collide:
  ld iy, #wall_left_lower
  call detect_collision
  jr nz, collide_walls
  ld iy, #wall_right_lower
  call detect_collision
  jr nz, collide_walls
  ld iy, #wall_left_upper
  call detect_collision
  jr nz, collide_walls
  ld iy, #wall_right_upper
  call detect_collision
  jr nz, collide_walls

  ld a, (#current_lvl_ld)
  cp #6
  jp m, map_1_col_wall

  ld iy, #central_wall
  call detect_collision
  jr nz, collide_walls

  map_1_col_wall:
    sub a

    ret

    collide_walls:
      add #1
      ret

;;--------------------------------------------------
;;  Comprueba la colision con las plataformas
;;  OUT:    Z flag no activado si hay colision
;;  UNSAFE: HL, DE, AF, BC, FLAGS
;;--------------------------------------------------
check_platforms_collide:
  ld a, (#current_lvl_ld)
  cp #1
  jp m, map_3_walls

  ld iy, #floor_med_up
  call detect_collision
  jr nz, collide_platforms
  ld iy, #floor_med_down
  call detect_collision
  jr nz, collide_platforms
  ld iy, #floor_lower_left
  call detect_collision
  jr nz, collide_platforms
  ld iy, #floor_lower_right
  call detect_collision
  jr nz, collide_platforms
  ld iy, #floor_upper_left
  call detect_collision
  jr nz, collide_platforms
  ld iy, #floor_upper_right
  call detect_collision
  jr nz, collide_platforms

  sub a
  ret

  map_3_walls:
    ld iy, #floor_0_m_3
    call detect_collision
    jr nz, collide_platforms
    ld iy, #floor_1_m_3
    call detect_collision
    jr nz, collide_platforms
    ld iy, #floor_2_m_3
    call detect_collision
    jr nz, collide_platforms
    ld iy, #floor_3_m_3
    call detect_collision
    jr nz, collide_platforms

  sub a

  ret

  collide_platforms:
    add #1
    ret

;;--------------------------------------------------
;;  Comprueba la colision con el suelo y el techo
;;  OUT:    Z flag no activado si hay colision
;;  UNSAFE: HL, DE, AF, BC, FLAGS
;;--------------------------------------------------
check_limits_collide:
  ld iy, #ground
  call detect_collision
  jr nz, collide_limits
  ld iy, #roof
  call detect_collision
  jr nz, collide_limits
  ld iy, #end_floor_1_map_2
  call detect_collision
  jr nz, collide_limits
  ld iy, #end_floor_0_map_2
  call detect_collision
  jr nz, collide_limits
  ld iy, #roof_spawn_l
  call detect_collision
  jr nz, collide_limits
  ld iy, #roof_spawn_r
  call detect_collision
  jr nz, collide_limits
  
  sub a

  ret

  collide_limits:
    add #1
  ret