;;    Th Spirit of Halloween. An Amstrad CPC 464 game.
;;    Copyright (C) 2018 Lab16Devs
;;
;;    This program is free software: you can redistribute it and/or modify
;;    it under the terms of the GNU General Public License as published by
;;    the Free Software Foundation, either version 3 of the License, or
;;    (at your option) any later version.
;;
;;    This program is distributed in the hope that it will be useful,
;;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;    GNU General Public License for more details.
;;
;;    You should have received a copy of the GNU General Public License
;;    along with this program.  If not, see <https://www.gnu.org/licenses/>.
;###########################################################################
;#### FICHERO: bullets.s
;###########################################################################
.include "main.h.s"

k_max_num_bullets = 5  ;;Cantidad maxima de entidades

bullet_vector:
DefineNEntities bullet_vector, k_max_num_bullets
;;DefineEntity _name,       _x,   _y,   _vx,  _vy,   _w,   _h,  _col,       _upd, _last_side,_lives, _sprite,   _animation,_type
DefineEntity bullet_data_r, 0x20, 0x20, 0x03, 0x00, 0x04, 0x08, 0xFF, ent_move_bullet, 0xAA, 0xAA, _bullet_array_0, 0x03, 0x03    ;;Bala direccion derecha
DefineEntity bullet_data_l, 0x20, 0x20, 0xFD, 0x00, 0x04, 0x08, 0xFF, ent_move_bullet, 0xAA, 0xAA, _bullet_array_1, 0x03, 0x03    ;;Bala direccion izquierda

m_num_bullets:
  .db 00    ;;Numero de entidades generadas
m_next_bullet:
  .dw bullet_vector
 
;; REGISTRA UNA BALA
;; DESTRUYE: AF, HL, BC
bullet_new:
  ld a, (m_num_bullets)
  inc a
  ld (m_num_bullets), a

  ld hl, (m_next_bullet)
  ld bc, #k_entity_size
  add hl, bc
  ld (m_next_bullet), hl
  or a  ;;DEJA ACARREO EN 0
  sbc hl, bc  ;; RESTA CON ACARREO

  ret

;; COPIA UNA BALA
bullet_initialize:
  ld a, e_last_s(ix)    ;;Si no nos movemos comprobamos la ultima direccion de movimiento
  cp #0
  jp m, s_left_m

  ld hl, #bullet_data_r   ;;Compiamos la bala hacia la derecha
  jp copy

  s_left_m:
    ld hl, #bullet_data_l   ;;Compiamos la bala hacia la izquierda

  copy:
    ld bc, #k_entity_size ;; Carga el tamaño de la entidad
    ldir                  ;; Copia desde la primera posicion en HL a la de DE

    ld h, d       
    ld l, e
    ld bc, #-(k_entity_size-boundingbox_size)
    add hl, bc            ;;Despues del ldir el puntero apunta a hl+k_entity_size
                          ;;volvemos a colocarlo al inicio de los datos de la bala
    ld a, de_x(ix)        ;;Copiamos la x y la y de la entidad que genera la bala
    ld (hl), a
    inc hl
    ld a, de_y(ix)
    add #2                ;;Para que la bala no se genere en el primer pixel de alto
    ld (hl), a

    ret

;; ELIMINA UNA ENTIDAD DEL VECTOR
;; PARAMETROS: DE -> DIRECCIÓN A ENTIDAD A ELIMINAR
;; REGISTROS DESTRUIDOS: A, HL, IX
bullet_delete:
  ld a, (m_num_bullets)       ;;RECOJO EL NUMERO ACTUAL DE ENTIDADES
  cp #0
  jr z, nada_a_borrar_b
  dec a
  ld hl, #bullet_vector

  buscar_ultima_bala:
    ld bc, #k_entity_size   ;; CARGO EL TAMANYO DE UNA ENTIDAD
    add hl, bc              ;; PASO A LA SIGUIENTE ENTIDAD
    dec a                   ;; REDUZCO MI ITERADOR
    jr nz, buscar_ultima_bala

    call ent_copy                 ;; SOBREESCRIBO EL ELEMENTO A BORRAR CON LA ULTIMA ENTIDAD

    ld a, (m_num_bullets)       ;;
    dec a                   ;;
    ld (m_num_bullets), a       ;; REDUZCO EN UNO EL NUMERO DE ENTIDADES

    ld hl, (m_next_bullet)  ;; CARGO LA SIGUIENTE ENTIDAD
    ld bc, #k_entity_size   ;; CARGO EL TAMANYO DE UNA ENTIDAD
    sbc hl, bc              ;; SE REDUCE EN NUEVE LA DIRECCION EN HL
    ld (m_next_bullet), hl  ;; ...PARA CALCULAR EL NUEVO NEXT_ENTITY

  nada_a_borrar_b:
    ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; MOVER UNA BALA
;; REGISTROS DESTRUIDOS: IX, HL, DE
;; ENTRADA: IX -> Puntero a entidad
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ent_move_bullet:
  ld    a, de_x(ix)
  add   e_vx(ix)
  ld    de_x(ix), a
  ld    e_bb_x(ix), a

  ld    a, de_y(ix)
  add   e_vy(ix)
  ld    de_y(ix), a
  ld    e_bb_y(ix), a
  call check_walls_collide        ;; Compruebo si toco paredes
  jr nz, delete_bullet_limit
  call check_platforms_collide    ;; Compruebo si toco plataformas
  ret z

  delete_bullet_limit:
    
    push ix

    call ren_clear_entity_front

    pop de
    
    call bullet_delete

  ret


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ACTUALIZA LAS BALAS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
update_bullets:
  ld hl, #ent_update
  call ent_do_this_for_all_bullets

  ld hl, #check_colision_to_all_enemies
  call ent_do_this_for_all_bullets

  ld hl, #ent_draw
  call ent_do_this_for_all_bullets

  ret

clear_bullets:
  ld hl, #ent_clear
  call ent_do_this_for_all_bullets

  ret

clear_bullets_reset:
  ld hl, #ent_clear_reset
  call ent_do_this_for_all_bullets

  ret

;; Realiza la funcion global en todas las entidades
;; HL -> direccion a ejecutar
;; REGISTROS DESTRUIDOS: TODOS
ent_do_this_for_all_bullets:
  ld  a, (m_num_bullets)    ;; Cargamos en A el numero de entidades
  cp #0
  jr z, no_hay_balas
  ld ix, #bullet_vector ;; Cargamos el puntero que apunta al vector de entidades
  ld (metodo_b), hl       ;;
  bucle_b:
    push af               ;; Guardamos el valor de A
    metodo_b = . + 1        ;; Calculamos el valor de la dirección de memoria de mi posicion+1
    call ent_draw         ;; Metodo dummy
    pop af                ;; Recuperamos A
    ld bc, #k_entity_size ;; Cargamos el tamanyo de la entidad
    add ix, bc            ;; Avanzamos el iterador a la siguiente entidad

    dec a                 ;; Reducimos A
    jr nz, bucle_b          ;; Si no se ha ejecutado el metodo en todas las entidades continuamos
  no_hay_balas:
    ret

;; Comprueba si la bala ha impactado contra algun enemigo
;; IX -> Bala
;; REGISTROS DESTRUIDOS: TODOS
check_colision_to_all_enemies:
  ld  a, (m_num_enemies)    ;; Cargamos en A el numero de entidades
  cp #0
  jr z, no_hay_enemigos
  ld iy, #enemies_vector ;; Cargamos el puntero que apunta al vector de entidades

  bucle_e:
    push af               ;; Guardamos el valor de A
    call detect_collision
    jp z, enemy_not_hit_or_dead

    call ren_clear_entity_front
    call ren_clear_entity

    push ix
    pop de
    
    call bullet_delete

    ld a, e_lives(iy)
    dec a
    ld e_lives(iy), a
    cp #0
    jp nz, enemy_not_hit_or_dead

    ld a, (#highscore)
    cp #0xFF
    jp z, up_loop
    add #1
    ld (#highscore), a
    
    jp cont_delete

    up_loop:
      ld a, (#loops_highscore)
      add #1
      ld (#loops_highscore), a
      ld a, #0
      ld (#highscore), a

    cont_delete:
      push ix
      push iy
      pop ix

      call ren_clear_entity_front
      call ren_clear_entity

      push iy
      pop de

      call enemy_delete

      pop ix

      pop af

      ret

      enemy_not_hit_or_dead:
        pop af                ;; Recuperamos A
        ld bc, #k_entity_size ;; Cargamos el tamanyo de la entidad
        add iy, bc            ;; Avanzamos el iterador a la siguiente entidad

        dec a                 ;; Reducimos A
        jr nz, bucle_e          ;; Si no se ha ejecutado el metodo en todas las entidades continuamos

  no_hay_enemigos:
    ret