##-----------------------------LICENSE NOTICE------------------------------------
##  This file is part of CPCtelera: An Amstrad CPC Game Engine 
##  Copyright (C) 2018 ronaldo / Fremos / Cheesetea / ByteRealms (@FranGallegoBR)
##
##  This program is free software: you can redistribute it and/or modify
##  it under the terms of the GNU Lesser General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU Lesser General Public License for more details.
##
##  You should have received a copy of the GNU Lesser General Public License
##  along with this program.  If not, see <http://www.gnu.org/licenses/>.
##------------------------------------------------------------------------------
############################################################################
##                        CPCTELERA ENGINE                                ##
##                 Automatic image conversion file                        ##
##------------------------------------------------------------------------##
## This file is intended for users to automate image conversion from JPG, ##
## PNG, GIF, etc. into C-arrays.                                          ##
############################################################################

##
## NEW MACROS
##

## 16 colours palette
#PALETTE=0 1 2 3 6 9 11 12 13 15 16 18 20 24 25 26

## Default values
#$(eval $(call IMG2SP, SET_MODE        , 0                  ))  { 0, 1, 2 }
#$(eval $(call IMG2SP, SET_MASK        , none               ))  { interlaced, none }
#$(eval $(call IMG2SP, SET_FOLDER      , src/               ))
#$(eval $(call IMG2SP, SET_EXTRAPAR    ,                    ))
#$(eval $(call IMG2SP, SET_IMG_FORMAT  , sprites            ))	{ sprites, zgtiles, screen }
#$(eval $(call IMG2SP, SET_OUTPUT      , c                  ))  { bin, c }
#$(eval $(call IMG2SP, SET_PALETTE_FW  , $(PALETTE)         ))
#$(eval $(call IMG2SP, CONVERT_PALETTE , $(PALETTE), g_palette ))
#$(eval $(call IMG2SP, CONVERT         , img.png , w, h, array, palette, tileset))


#PALETTE=13 0 1 2 3 4 8 10 11 12 15 17 18 20 23 26
PALETTE=13 0 1 2 3 4 6 8 9 10 11 15 17 24 25 26
$(eval $(call IMG2SP, SET_FOLDER, src/sprites))
$(eval $(call IMG2SP, SET_PALETTE_FW, $(PALETTE)))
$(eval $(call IMG2SP, CONVERT, assets/pinkbones.png, 16, 16, pinkbones_array, pinkbones_pal))
$(eval $(call IMG2SP, CONVERT, assets/spook.png, 16, 16, spook_array, spook_pal))
$(eval $(call IMG2SP, CONVERT, assets/jack.png, 16, 16, jack_array, jack_pal))
$(eval $(call IMG2SP, CONVERT, assets/goblin.png, 8, 8, goblin_array, goblin_pal))
$(eval $(call IMG2SP, CONVERT, assets/bullet.png, 8, 8, bullet_array, bullet_pal))
$(eval $(call IMG2SP, CONVERT, assets/lives.png, 4, 8, lives_array, lives_pal))
$(eval $(call IMG2SP, CONVERT, assets/candy.png, 8, 8, candy_array, candy_pal))
$(eval $(call IMG2SP, CONVERT, assets/0-9X.png, 8, 8, numbers_array, numbers_pal))
$(eval $(call IMG2SP, CONVERT, assets/final_tiles.png, 4, 4, tiles, tiles_pal, tiles_tileset))
$(eval $(call IMG2SP, CONVERT, assets/chicago_sprite.png, 16, 16, chicago_array, chicago_pal))

PALETTE1=1 0 3 4 6 8 9 10 11 13 15 16 17 24 25 26
$(eval $(call IMG2SP, SET_FOLDER, src/sprites/menu))
$(eval $(call IMG2SP, SET_PALETTE_FW, $(PALETTE1)))
$(eval $(call IMG2SP, CONVERT, assets/menu/jack_w54_h40.png, 54, 40, jack_menu_array, jack_menu_pal))
$(eval $(call IMG2SP, CONVERT, assets/menu/luna_w50_h29.png, 50, 29, luna_menu_array, luna_menu_pal))
$(eval $(call IMG2SP, CONVERT, assets/menu/title_w80_h48.png, 80, 48, title_1_array, title_1_pal))
$(eval $(call IMG2SP, CONVERT, assets/menu/title1_w80_h48.png, 80, 48, title_2_array, title_2_pal))
$(eval $(call IMG2SP, CONVERT, assets/menu/at_w12_h11.png, 12, 11, at_array, at_pal))
$(eval $(call IMG2SP, CONVERT, assets/menu/A_M-sprites8x8.png, 8, 8, a_m_array, a_m_pal))
$(eval $(call IMG2SP, CONVERT, assets/menu/N-Z-sprites8x8.png, 8, 8, n_z_array, n_z_pal))
$(eval $(call IMG2SP, CONVERT, assets/menu/dot.png, 4, 4, dot_array, dot_pal))
$(eval $(call IMG2SP, CONVERT, assets/menu/ddot.png, 4, 7, ddot_array, ddot_pal))
$(eval $(call IMG2SP, CONVERT, assets/menu/16.png, 8, 8, one_six_array, one_six_pal))
$(eval $(call IMG2SP, CONVERT, assets/menu/jack_w16_h24.png, 16, 24, jack_credits_array, jack_credits_pal))
$(eval $(call IMG2SP, CONVERT, assets/menu/pinkbones_w16_h23.png, 16, 23, pinkbones_credits_array, pinkbones_credits_pal))
$(eval $(call IMG2SP, CONVERT, assets/menu/spook_w16_h24.png, 16, 24, spook_credits_array, spook_credits_pal))
$(eval $(call IMG2SP, CONVERT, assets/menu/goblins_w16_h17.png, 16, 17, goblins_credits_array, goblins_credits_pal))

PALETTE2=0 13 1 2 3 4 6 8 9 10 11 15 17 24 25 26
$(eval $(call IMG2SP, SET_PALETTE_FW, $(PALETTE2)))
$(eval $(call IMG2SP, CONVERT, assets/menu/dot_aux.png, 4, 4, dot_aux, dot_pal_aux))

##
## OLD MACROS (For compatibility)
##

## Example firmware palette definition as variable in cpct_img2tileset format

# PALETTE={0 1 3 4 7 9 10 12 13 16 19 20 21 24 25 26}

## AUTOMATED IMAGE CONVERSION EXAMPLE (Uncomment EVAL line to use)
##
##    This example would convert img/example.png into src/example.{c|h} files.
##    A C-array called pre_example[24*12*2] would be generated with the definition
##    of the image example.png in mode 0 screen pixel format, with interlaced mask.
##    The palette used for conversion is given through the PALETTE variable and
##    a pre_palette[16] array will be generated with the 16 palette colours as 
##	  hardware colour values.

#$(eval $(call IMG2SPRITES,img/example.png,0,pre,24,12,$(PALETTE),mask,src/,hwpalette))



############################################################################
##              DETAILED INSTRUCTIONS AND PARAMETERS                      ##
##------------------------------------------------------------------------##
##                                                                        ##
## Macro used for conversion is IMG2SPRITES, which has up to 9 parameters:##
##  (1): Image file to be converted into C sprite (PNG, JPG, GIF, etc)    ##
##  (2): Graphics mode (0,1,2) for the generated C sprite                 ##
##  (3): Prefix to add to all C-identifiers generated                     ##
##  (4): Width in pixels of each sprite/tile/etc that will be generated   ##
##  (5): Height in pixels of each sprite/tile/etc that will be generated  ##
##  (6): Firmware palette used to convert the image file into C values    ##
##  (7): (mask / tileset / zgtiles)                                       ##
##     - "mask":    generate interlaced mask for all sprites converted    ##
##     - "tileset": generate a tileset array with pointers to all sprites ##
##     - "zgtiles": generate tiles/sprites in Zig-Zag pixel order and     ##
##                  Gray Code row order                                   ##
##  (8): Output subfolder for generated .C/.H files (in project folder)   ##
##  (9): (hwpalette)                                                      ##
##     - "hwpalette": output palette array with hardware colour values    ##
## (10): Aditional options (you can use this to pass aditional modifiers  ##
##       to cpct_img2tileset)                                             ##
##                                                                        ##
## Macro is used in this way (one line for each image to be converted):   ##
##  $(eval $(call IMG2SPRITES,(1),(2),(3),(4),(5),(6),(7),(8),(9), (10))) ##
##                                                                        ##
## Important:                                                             ##
##  * Do NOT separate macro parameters with spaces, blanks or other chars.##
##    ANY character you put into a macro parameter will be passed to the  ##
##    macro. Therefore ...,src/sprites,... will represent "src/sprites"   ##
##    folder, whereas ...,  src/sprites,... means "  src/sprites" folder. ##
##                                                                        ##
##  * You can omit parameters but leaving them empty. Therefore, if you   ##
##  wanted to specify an output folder but do not want your sprites to    ##
##  have mask and/or tileset, you may omit parameter (7) leaving it empty ##
##     $(eval $(call IMG2SPRITES,imgs/1.png,0,g,4,8,$(PAL),,src/))        ##
############################################################################
