;;-----------------------------LICENSE NOTICE------------------------------------
;;  This file is part of Nightmare Fortress: An Amstrad CPC Game 
;;  Copyright (C) 2017 Natalia Bernal Pérez / Álvaro Esteve Bernabeu / Plácido Antonio López Ávila
;;
;;  Nightmare Fortress is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU Lesser General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  Nightmare Fortress is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU Lesser General Public License for more details.
;;
;;  You should have received a copy of the GNU Lesser General Public License
;;  along with Nightmare Fortress.  If not, see <http://www.gnu.org/licenses/>.
;;-------------------------------------------------------------------------------

.area _DATA
.area _CODE


;;-----------------------------------------------------------------------
;;PRIVATE DATA 
;;-----------------------------------------------------------------------
.include "cpctelera.h.s"
.include "utils.h.s"
.include "macros.h.s"
.include "gameController.h.s"
.include "sprites/sprites.h.s"
.include "levels/tilemaps.h.s"
.include "tilesets/tilesets.h.s"
.include "actors/object.h.s"
.include "actors/enemy.h.s"
.include "actors/character.h.s"
.include "stage.h.s"
.include "dobleBuffer.h.s"
.include "interface.h.s"
.globl isr_void
.globl _g_song_boss
.globl _g_song_game
.globl _g_song_game2
.globl isr
.globl isr50
	
.macro newObject x, y, w, h, tipoObjeto, sprite, score 
 	
    .db x
    .db y
    .db w
    .db h
    .dw sprite
    .db tipoObjeto
    .db x
    .db y
    .db x
    .db y
    .db score
.endm


.macro newEnemy x, y, w, h, front1, front2, side1, side2, back1, back2, left1, left2, ataque, vida
    .db x
    .db y
    .db w
    .db h
    .dw front1
    .db #3
    .db x
    .db y
    .db x
    .db y
    .db #3
    .dw front1
    .dw front2
    .dw side1
    .dw side2
    .dw back1 
    .dw back2
    .db #0 ;; Ya no es caca, ahora es direccion
    .dw left1
    .dw left2
    .db #0
    .db #5
    .db ataque
    .db vida
    .db #0
    .db #5
    .db #1
    .db #2
    .db #2
.endm

.macro createStage name, tilemapPtr, enemiesPtr, objectsPtr,roomUpPtr, roomRightPtr, roomDownPtr, roomLeftPtr, tilesetPtr, minTile, numLevel
    name'_data::
    	name'_tilemap: 		.dw tilemapPtr
    	name'_enemyes:: 		.dw enemiesPtr
    	name'_objects:: 		.dw objectsPtr
    	name'_roomUp:  		.dw roomUpPtr
    	name'_roomRight:	.dw roomRightPtr
    	name'_roomDown: 	.dw roomDownPtr
    	name'_roomLeft: 	.dw roomLeftPtr
    	name'_tilesetPtr:	.dw tilesetPtr
    	name'_min_tile:		.db minTile
    	name'_level_num:	.db numLevel
.endm	

phantis1: .asciz " Happy  30 "
phantis2: .asciz "anniversary"
phantis3: .asciz "* Phantis *"


win1: .asciz	" You win! "


;;--------- NOMBRE -- TILEMAP PTR- ENEMIES PTR -- OBJECTS PTR -- PTR ARRIBA -- PTR DERECHA -- PTR ABAJO -- PTR IZQUIERDA -- PTR TILESET -- MINIMO TILESET COLISIONABLE


createStage level01, #_g_level01, #level01_enemies, #level01_items, #level05_data, #level02_data, #level01_data, #level01_data, #_g_garden_tileset, #2, #1
createStage level02, #_g_level02, #level02_enemies, #level02_items, #level02_data, #level03_data, #level02_data, #level01_data, #_g_garden_tileset, #2, #2
createStage level03, #_g_level03, #level03_enemies, #level03_items, #level03_data, #level03_data, #level03_data, #level02_data, #_g_garden_tileset, #2, #3
createStage level04, #_g_level04, #level04_enemies, #level04_items, #level08_data, #level04_data, #level04_data, #level04_data, #_g_garden_tileset, #2, #4
createStage level05, #_g_level05, #level05_enemies, #level05_items, #level05_data, #level06_data, #level01_data, #level05_data, #_g_garden_tileset, #2, #5
createStage level06, #_g_level06, #level06_enemies, #level06_items, #level06_data, #level07_data, #level06_data, #level05_data, #_g_garden_tileset, #2, #6
createStage level07, #_g_level07, #level07_enemies, #level07_items, #level11_data, #level08_data, #level07_data, #level06_data, #_g_garden_tileset, #2, #7
createStage level08, #_g_level08, #level08_enemies, #level08_items, #level12_data, #level08_data, #level04_data, #level07_data, #_g_garden_tileset, #2, #8
createStage level09, #_g_level09, #level09_enemies, #level09_items, #level13_data, #level10_data, #level09_data, #level09_data, #_g_tileset, #1, #9
createStage level10, #_g_level10, #level10_enemies, #level10_items, #level14_data, #level14_data, #level14_data, #level09_data, #_g_tileset, #1, #10
createStage level11, #_g_level11, #level11_enemies, #level11_items, #level11_data, #level12_data, #level07_data, #level11_data, #_g_tileset, #1, #11
createStage level12, #_g_level12, #level12_enemies, #level12_items, #level16_data, #level12_data, #level08_data, #level11_data, #_g_tileset, #1, #12
createStage level13, #_g_level13, #level13_enemies, #level13_items, #level17_data, #level14_data, #level09_data, #level13_data, #_g_tileset, #1, #13
createStage level14, #_g_level14, #level14_enemies, #level14_items, #level18_data, #level15_data, #level10_data, #level13_data, #_g_tileset, #1, #14
createStage level15, #_g_level15, #level15_enemies, #level15_items, #level15_data, #level16_data, #level15_data, #level14_data, #_g_tileset, #1, #15
createStage level16, #_g_level16, #level16_enemies, #level16_items, #level20_data, #level16_data, #level12_data, #level15_data, #_g_tileset, #1, #16
createStage level17, #_g_level17, #level17_enemies, #level17_items, #level17_data, #level18_data, #level13_data, #level17_data, #_g_tileset, #1, #17
createStage level18, #_g_level18, #level18_enemies, #level18_items, #level18_data, #level19_data, #level14_data, #level17_data, #_g_tileset, #1, #18
createStage level19, #_g_level19, #level19_enemies, #level19_items, #level19_data, #level19_data, #level19_data, #level18_data, #_g_tileset, #1, #19
createStage level20, #_g_level20, #level20_enemies, #level20_items, #level20_data, #level20_data, #level16_data, #level20_data, #_g_tileset, #1, #20






objectosArray:: 	




;;	- 1 = Objetos que dan puntos
;;	- 2 = Objetos que dan vida
;;	- 3 = Objetos que aumentan la vida maxima
;;	- 4 = Objetos que abren puertas (llaves)
;;	- 5 = Objetos que se abren con llaves (puertas)
;,x, y, w, h, sprite, type, last_x, last_y, previousLast_x, previousLast_Y, score_or_hp
;level01_enemies:
COMIENZO_ARRAYS::
level20_items:

	newObject #0x0C, #0xA4, #6, #16, #5, #_g_door_down, #123
	newObject #0xFE, #0x50, #4, #16, #4, #_g_key, #10

	.db #0xFF

level20_enemies:
	newEnemy #0x27, #0x56, #4, #16, #_g_evilwizard_front_1, #_g_evilwizard_front_2, #_g_evilwizard_side_1, #_g_evilwizard_side_2, #_g_evilwizard_back_1, #_g_evilwizard_back_2, #_g_evilwizard_left_1, #_g_evilwizard_left_2, #20, #190
	newEnemy #0x07, #0x96, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	newEnemy #0x43, #0x96, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	

	.db #0xFF

level19_items:

	.db #0xFF

level19_enemies:
	newEnemy #0x20, #0x56, #4, #16, #_g_warrior2_front_1, #_g_warrior2_front_2, #_g_warrior2_side_1, #_g_warrior2_side_2, #_g_warrior2_back_1, #_g_warrior2_back_2, #_g_warrior2_left_1, #_g_warrior2_left_2, #25, #240
	newEnemy #0x19, #0x0C, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	newEnemy #0x19, #0x9A, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	newEnemy #0x47, #0x54, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	

	.db #0xFF

level18_items:
	newObject #0x4A, #0x58, #6, #16, #5, #_g_door_right, #123
	newObject #0x13, #0x5E, #4, #16, #2, #_g_pollo, #10
	newObject #0x06, #0x5E, #4, #16, #2, #_g_pollo, #10
	newObject #0x15, #0x3A, #4, #16, #2, #_g_pollo, #10
	newObject #0x06, #0x3A, #4, #16, #2, #_g_pollo, #10
	newObject #0x0D, #0x4C, #4, #16, #2, #_g_pollo, #10

	.db #0xFF

level18_enemies:

	.db #0xFF

level17_items:
	newObject #0x24, #0x14, #4, #16, #1, #_g_coin, #10
	newObject #0x1D, #0x3A, #4, #16, #2, #_g_pollo, #10
	newObject #0x2D, #0x3C, #4, #16, #1, #_g_coin, #10
	newObject #0x24, #0x3A, #4, #16, #4, #_g_key, #10

	.db #0xFF

level17_enemies:
	newEnemy #0x0F, #0x5E, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	newEnemy #0x40, #0x3E, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	newEnemy #0x25, #0x54, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	
	.db #0xFF

level16_items:
	newObject #0x26, #0x6E, #4, #16, #2, #_g_pollo, #10
	newObject #0x26, #0x22, #4, #16, #2, #_g_pollo, #10
	newObject #0x0E, #0x8A, #4, #16, #2, #_g_pollo, #10
	newObject #0x3E, #0x1A, #4, #16, #3, #_g_mas_hp, #10
	
	.db #0xFF

level16_enemies:
	newEnemy #0x44, #0x45, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	newEnemy #0x15, #0x48, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	
	.db #0xFF


level15_items:
	newObject #0x3F, #0x14, #4, #16, #1, #_g_coin, #10
	newObject #0x24, #0x1A, #4, #16, #2, #_g_pollo, #10
	newObject #0x0B, #0x1A, #4, #16, #1, #_g_coin, #10
	
	.db #0xFF

level15_enemies:
	newEnemy #0x44, #0x36, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	newEnemy #0x1E, #0x5E, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	newEnemy #0x0B, #0x54, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	
	.db #0xFF



level14_items:
	newObject #0x13, #0x7A, #4, #16, #1, #_g_coin, #10
	newObject #0x13, #0x26, #4, #16, #2, #_g_pollo, #10

	.db #0xFF

level14_enemies:
	newEnemy #0x3A, #0x28, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40

	.db #0xFF

level13_items:
	newObject #0x1D, #0x98, #4, #16, #3, #_g_mas_hp, #10

	.db #0xFF

level13_enemies:
	newEnemy #0x25, #0x16, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	newEnemy #0x28, #0x70, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	newEnemy #0x40, #0x5E, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	
	.db #0xFF




level12_items:
	newObject #0x37, #0x12, #4, #16, #1, #_g_coin, #10
	newObject #0x47, #0x14, #4, #16, #1, #_g_coin, #10
	
	.db #0xFF

level12_enemies:
	newEnemy #0x11, #0x88, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	newEnemy #0x20, #0x38, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	newEnemy #0x3F, #0x3E, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	
	.db #0xFF


level11_items:
	newObject #0x25, #0x76, #4, #16, #4, #_g_key, #10
	newObject #0x06, #0x98, #4, #16, #2, #_g_pollo, #10
	newObject #0x35, #0x96, #4, #16, #1, #_g_coin, #10
	newObject #0x09, #0x12, #4, #16, #1, #_g_coin, #10
	
	.db #0xFF

level11_enemies:
	newEnemy #0x0E, #0x84, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	newEnemy #0x37, #0x12, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	newEnemy #0x3D, #0x90, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	
	.db #0xFF


level10_items:
	newObject #0x05, #0x14, #4, #16, #1, #_g_coin, #10
	
	.db #0xFF

level10_enemies:
	newEnemy #0x2F, #0x3E, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	newEnemy #0x34, #0x98, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	newEnemy #0x2A, #0x68, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	
	.db #0xFF

level09_items:
	newObject #0x22, #0x3C, #4, #16, #1, #_g_coin, #10
	newObject #0x0B, #0x1E, #4, #16, #2, #_g_pollo, #10

	.db #0xFF

level09_enemies:
	newEnemy #0x0A, #0x80, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	newEnemy #0x0B, #0x48, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	newEnemy #0x3B, #0x13, #4, #16, #_g_warrior1_front_1, #_g_warrior1_front_2, #_g_warrior1_side_1, #_g_warrior1_side_2, #_g_warrior1_back_1, #_g_warrior1_back_2, #_g_warrior1_left_1, #_g_warrior1_left_2, #15, #40
	
	.db #0xFF



level08_items:
	newObject #0x26, #0x00, #6, #16, #5, #_g_door, #123
	newObject #0x08, #0x6A, #4, #16, #3, #_g_mas_hp, #10
	
	.db #0xFF

level08_enemies:
	newEnemy #0x1D, #0x7E, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30
	newEnemy #0x1E, #0x24, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30
	newEnemy #0x3D, #0x76, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30
	newEnemy #0x47, #0x2A, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30
	
	.db #0xFF

level07_items:
	newObject #0x0A, #0x72, #4, #16, #1, #_g_coin, #10
	newObject #0x3F, #0x92, #4, #16, #1, #_g_coin, #10
	newObject #0x09, #0x1E, #4, #16, #1, #_g_coin, #10
	newObject #0x1E, #0x72, #4, #16, #2, #_g_pollo, #10
	
	.db #0xFF

level07_enemies:
	newEnemy #0x19, #0x98, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30
	newEnemy #0x33, #0x68, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30
	newEnemy #0x21, #0x25, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30
	newEnemy #0x3A, #0x10, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30
	
	.db #0xFF

level06_items:
	newObject #0x4A, #0x80, #6, #16, #5, #_g_door_right, #123
	newObject #70, #16, #4, #16, #1, #_g_coin, #10
	newObject #71, #152, #4, #16, #4, #_g_key, #10
	newObject #71, #105, #4, #16, #3, #_g_mas_hp, #10


	.db #0xFF

level06_enemies:
	newEnemy #0x3B, #0x7C, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30
	newEnemy #0x1E, #0x98, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30
	newEnemy #0x25, #0x72, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30
	newEnemy #0x33, #0x34, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30
	
	.db #0xFF

level05_items:
	newObject #70, #14, #4, #16, #1, #_g_coin, #10
	newObject #7, #14, #4, #16, #2, #_g_pollo, #10
	newObject #70, #154, #4, #16, #1, #_g_coin, #10

	.db #0xFF

level05_enemies:
	newEnemy #0x24, #0x58, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30
	newEnemy #0x23, #0x0C, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30
	newEnemy #0x3D, #0x58, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30
	
	.db #0xFF

level04_items:
	newObject #25, #150, #4, #16, #2, #_g_pollo, #10
	newObject #7, #14, #4, #16, #1, #_g_coin, #10
	newObject #64, #14, #4, #16, #1, #_g_coin, #10
	newObject #64, #150, #4, #16, #1, #_g_coin, #10
	newObject #7, #150, #4, #16, #1, #_g_coin, #10
	newObject #50, #150, #4, #16, #3, #_g_mas_hp, #10

	.db #0xFF

level04_enemies:
	.db #0xFF

level03_items:
	newObject #68, #29, #4, #16, #4, #_g_key, #10
	newObject #8, #153, #4, #16, #2, #_g_pollo, #10

	.db #0xFF

level03_enemies:
	newEnemy #0x05, #0x44, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30
	newEnemy #0x0D, #0x42, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30
	newEnemy #0x38, #0x7E, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30
	newEnemy #0x1B, #0x32, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30
	
	.db #0xFF

level02_items:
	newObject #67, #150, #4, #16, #1, #_g_coin, #10
	newObject #72, #27, #4, #16, #1, #_g_coin, #10

	.db #0xFF

level02_enemies:
	newEnemy #40, #99, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30
	newEnemy #45, #19, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30
	newEnemy #62, #150, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30
	
	.db #0xFF

level01_items:
	newObject #16, #0, #6, #16, #5, #_g_door, #123
	newObject #5, #115, #4, #16, #1, #_g_coin, #10
	newObject #70, #25, #4, #16, #1, #_g_coin, #10


	.db #0xff

level01_enemies:
	newEnemy #10, #10, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30
	newEnemy #45, #14, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30
	newEnemy #70, #55, #4, #16, #_g_rana_front_1, #_g_rana_front_2, #_g_rana_side_1, #_g_rana_side_2, #_g_rana_back_1, #_g_rana_back_2, #_g_rana_left_1, #_g_rana_left_2, #10, #30

	.db #0xFF

FIN_ARRAYS::
restablecer_musica:

	ld de, #_g_song_boss
	call cpct_akp_musicInit_asm

	ld hl, #isr
	call cpct_setInterruptHandler_asm

	ld a, #0
	ld (es18), a
	ld a, #1
	ld (only_once_18), a
	ret
only_once_4:: .db #1
only_once_20:: .db #1
only_once_18:: .db #1
only_once_19:: .db #1
es18:: .db #0
cambio_musica:: .db #0
	

special_stage_function::
	ld ix, (currentStage)
	ld a, num_level(ix)

	cp #9
	jp z, musicaCastillo
	jp nc, musicaCastillo
	jp c, musicaJardin
		musicaCastillo:
			ld a, (cambio_musica)
			cp #0
			jp nz, noCambiarMusica
				ld de, #_g_song_boss
				call cpct_akp_musicInit_asm
				ld a, #1
				ld (cambio_musica), a
				jp noCambiarMusica

		musicaJardin:
			ld a, (cambio_musica)
			cp #1
			jp nz, noCambiarMusica
				ld de, #_g_song_game
				call cpct_akp_musicInit_asm
				ld a, #0
				ld (cambio_musica), a
				jp noCambiarMusica

	noCambiarMusica:
	ld ix, (currentStage)
	ld a, num_level(ix)
	cp #18
	jp z, esNivel18

	ld a, (es18)
	cp #1
	call z, restablecer_musica

	ld ix, (currentStage)
	ld a, num_level(ix)
	cp #20
	jp z, esNivel20
	cp #4
	jp z, esNivel4

	ld a, #1
	ld (only_once_4), a 

	ld a, num_level(ix)
	cp #19
	jp z, esNivel19
	
	ret 

	esNivel18:
		ld a, #1
		ld (es18), a
		ld a, (only_once_18)
		cp #0
		ret z
		call cpct_akp_stop_asm
		ld hl, #isr_void
		call cpct_setInterruptHandler_asm
		call cpct_akp_stop_asm
		ld a, (only_once_18)
		dec a
		ld (only_once_18), a 
		ret


	esNivel20::
		ld h, enemies_h(ix)
		ld l, enemies_l(ix)

		push hl
		pop ix 

		ld a, vivo_muerto(ix)
		cp #1
		jp nz, magoMaloMuerto
			;;BOSS AUN VIVO
			ld a, (enemy_size_in_bytes)
			ld c, a
			ld b, #0
			add hl, bc

			push hl
			pop ix
			ld a, vivo_muerto(ix)
			cp #1
			jp z, enemigo1_no_muerto
				en1::
				ld a, #0x07
				ld (hl), a
				push hl 
				pop ix 
				ld a, #1
				ld vivo_muerto(ix), a
				ld a, #0x96
				ld y(ix), a
				ld a, #40
				ld life(ix),a 

			enemigo1_no_muerto:
			add hl, bc

			push hl
			pop ix
			ld a, vivo_muerto(ix)
			cp #1
			jp z, enemigo2_no_muerto
				en2::
				ld a, #0x43
				ld (hl), a
				push hl
				pop ix
				ld a, #1
				ld vivo_muerto(ix), a
				ld a, #0x96
				ld y(ix), a 
				ld a, #40
				ld life(ix),a 

			enemigo2_no_muerto:
				ret


		magoMaloMuerto::
			ld a, (only_once_20)
			cp #0
			ret z
			dec a
			ld (only_once_20), a
			ld ix, (currentStage)
			ld h, objects_h(ix)
			ld l, objects_l(ix)

			ld a, (object_size_in_bytes)
			ld c, a
			ld b, #0

			add hl, bc
			push hl 
			pop ix

			ld a, #0x27
			ld x(ix), a
			ld last_x(ix), a
			ld previousLast_x(ix), a

			ld hl, (score_number)
			ld bc, #0090
			add hl, bc
			ld (score_number), hl
			ret


	esNivel4:
		call pinta_phantis
		ret

	esNivel19:

		ld a, (only_once_19)
		cp #0
		jp z, noTocarMusica
			ld de, #_g_song_boss
			call cpct_akp_musicInit_asm
			ld hl, #isr50
			call cpct_setInterruptHandler_asm

			ld a, #0
			ld (only_once_19), a
		noTocarMusica:
		ld h, enemies_h(ix)
		ld l, enemies_l(ix)

		push hl
		pop ix 

		ld a, vivo_muerto(ix)
		cp #1
		jp nz, magoMaloMuerto2
			;;BOSS AUN VIVO
			ld a, (enemy_size_in_bytes)
			ld c, a
			ld b, #0
			add hl, bc

			push hl
			pop ix
			ld a, vivo_muerto(ix)
			cp #1
			jp z, enemigo1_no_muerto2
				en12::
				ld a, #0x23
				ld (hl), a
				push hl 
				pop ix 
				ld a, #1
				ld vivo_muerto(ix), a
				ld a, #0x0C
				ld y(ix), a
				ld a, #40
				ld life(ix),a 

			enemigo1_no_muerto2:
			add hl, bc

			push hl
			pop ix
			ld a, vivo_muerto(ix)
			cp #1
			jp z, enemigo2_no_muerto2
				en22::
				ld a, #0x23
				ld (hl), a
				push hl
				pop ix
				ld a, #1
				ld vivo_muerto(ix), a
				ld a, #0x9A
				ld y(ix), a 
				ld a, #40
				ld life(ix),a 

			enemigo2_no_muerto2:
			add hl, bc

			push hl
			pop ix
			ld a, vivo_muerto(ix)
			cp #1
			jp z, enemigo3_no_muerto2
				en32::
				ld a, #0x47
				ld (hl), a
				push hl
				pop ix
				ld a, #1
				ld vivo_muerto(ix), a
				ld a, #0x54
				ld y(ix), a 
				ld a, #40
				ld life(ix),a 

			enemigo3_no_muerto2:
				ret

		magoMaloMuerto2::
			ld hl, #isr_void
  			call cpct_setInterruptHandler_asm
 			call cpct_akp_stop_asm
 			call pinta_final_juego
 			call switchBuffers
 			call pinta_final_juego
 			call print_reset
			bucleInfinitoFinal:
				call check_reset_key
    			cp #1
    			jp z, reiniciaJuego
				jp bucleInfinitoFinal
			ret


pinta_final_juego:
	ld hl, (pointerScreen)
  ex de, hl
  ld c, #18
  ld b, #80
  ;ld c, #31
  ;ld b, #130
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #win1             ;; HL = Pointer to the start of the string
  ld   bc, #0x090B              ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm 

	ret 



pinta_phantis:
	ld a, (only_once_4)
	cp #0
	ret z
	dec a
	ld (only_once_4), a
pinta_phantis_pausa::
	ld a, #2

	bucle_phantis:
	push af 
	ld hl, (pointerScreen)
  ex de, hl
  ld c, #18
  ld b, #80
  ;ld c, #31
  ;ld b, #130
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #phantis1             ;; HL = Pointer to the start of the string
  ld   bc, #0x0B06              ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm 

  ld hl, (pointerScreen)
  ex de, hl
  ld c, #18
  ld b, #90
  ;ld c, #31
  ;ld b, #130
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #phantis2             ;; HL = Pointer to the start of the string
  ld   bc, #0x0B04              ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm 

  ld hl, (pointerScreen)
  ex de, hl
  ld c, #18
  ld b, #100
  ;ld c, #31
  ;ld b, #130
  call cpct_getScreenPtr_asm 
  ex de, hl
  ld   hl, #phantis3              ;; HL = Pointer to the start of the string
  ld   bc, #0x0B02              ;; B = Background colour, C = Foreground colour
  call cpct_drawStringM0_asm 

  call switchBuffers

  pop af
  dec a
  ret z
  jp bucle_phantis


