;;-----------------------------LICENSE NOTICE------------------------------------
;;  This file is part of Nightmare Fortress: An Amstrad CPC Game 
;;  Copyright (C) 2017 Natalia Bernal Pérez / Álvaro Esteve Bernabeu / Plácido Antonio López Ávila
;;
;;  Nightmare Fortress is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU Lesser General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  Nightmare Fortress is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU Lesser General Public License for more details.
;;
;;  You should have received a copy of the GNU Lesser General Public License
;;  along with Nightmare Fortress.  If not, see <http://www.gnu.org/licenses/>.
;;-------------------------------------------------------------------------------

.include "macros.h.s"
.include "cpctelera.h.s"

screenMem: .db #0 ;; Representa la direccion C000
backBuffer: .db #1 ;; Representa la direccion 8000
pointerScreen:: .dw #0x8000 ;; Etiqueta que indica la direccion del backbuffer, en la cual vamos a dibujar/borrar

switchBuffers::
	ld a, (screenMem) ;; Guardamos en A el valor que representa la direccion a la que apunta en este momento la memoria de video
	cp #0 ;; Comparamos lo que hay en A con 0
	jr z, cambiar_a_8000 ;; Si el valor de screenMem es 0, significa que esta apuntando a C000, y tiene que cambiar a 8000

	;; Si el valor de screenMem no es 0, significa que esta apuntando a 8000, y hay que cambiar a C000
	ld a, #0 ;; Cambiamos el valor de screenMem a 0 para indicar que ahora la memoria esta apuntando a C000
	ld (screenMem), a ;; |
	ld a, #1 ;; Cambiamos el valor de backBuffer a 1 para indicar que el back buffer ahora es 8000
	ld (backBuffer), a ;; |
	ld hl, #0x8000 ;; En pointerScreen estara la direccion en la que vamos a borrar/dibujar
	ld (pointerScreen), hl ;; Esta direccion debe ser a la que apunte el backbuffer, ya que se debe dibujar/borrar en el backbuffer
	ld l, #0x30 ;; Guardamos en L el valor para que la memoria de video apunte a C000
	call cpct_setVideoMemoryPage_asm
	ret

	;; Cambiamos el puntero de la memoria de video a 8000
	cambiar_a_8000:
		ld a, #1 ;; Cambiamos el valor de screenMem a 1 para indicar que ahora la memoria esta apuntando a 8000
		ld (screenMem), a ;; |
		ld a, #0 ;; Cambiamos el valor de backBuffer a 0 para indicar que el back buffer ahora es C000
		ld (backBuffer), a ;; |
		ld hl, #0xC000 ;; El backbuffer es C000, asi que la etiqueta que indica donde dibujar/borrar debe tener C000
		ld (pointerScreen), hl ;; |
		ld l, #0x20 ;; Guardamos en L el valor para que la memoria de video apunte a 8000
		call cpct_setVideoMemoryPage_asm

ret
