##-----------------------------LICENSE NOTICE------------------------------------
##  This file is part of CPCtelera: An Amstrad CPC Game Engine 
##  Copyright (C) 2016 ronaldo / Fremos / Cheesetea / ByteRealms (@FranGallegoBR)
##
##  This program is free software: you can redistribute it and/or modify
##  it under the terms of the GNU Lesser General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU Lesser General Public License for more details.
##
##  You should have received a copy of the GNU Lesser General Public License
##  along with this program.  If not, see <http://www.gnu.org/licenses/>.
##------------------------------------------------------------------------------

############################################################################
##                        CPCTELERA ENGINE                                ##
##                 Automatic image conversion file                        ##
##------------------------------------------------------------------------##
## This file is intended for users to automate tilemap conversion from    ##
## original files (like Tiled .tmx) into C-arrays.                        ##
##                                                                        ##
## Macro used for conversion is TMX2C, which has up to 4 parameters:      ##
##  (1): TMX file to be converted to C array                              ##
##  (2): C identifier for the generated C array                           ##
##  (3): Output folder for C and H files generated (Default same folder)  ##
##  (4): Bits per item (1,2,4 or 6 to codify tilemap into a bitarray).    ##
##       Blanck for normal integer tilemap array (8 bits per item)        ##
##  (5): Aditional options (aditional modifiers for cpct_tmx2csv)         ##
##                                                                        ##
## Macro is used in this way (one line for each image to be converted):   ##
##  $(eval $(call TMX2C,(1),(2),(3),(4),(5)))                             ##
##                                                                        ##
## Important:                                                             ##
##  * Do NOT separate macro parameters with spaces, blanks or other chars.##
##    ANY character you put into a macro parameter will be passed to the  ##
##    macro. Therefore ...,src/sprites,... will represent "src/sprites"   ##
##    folder, whereas ...,  src/sprites,... means "  src/sprites" folder. ##
##  * You can omit parameters by leaving them empty.                      ##
##  * Parameters (4) and (5) are optional and generally not required.     ##
############################################################################

## Conversion Examples
##

## Convert img/tilemap.tmx to src/tilemap.c and src/tilemap.h
##		This file contains a tilemap created with Tiled that uses tiles
## in img/tiles.png. This macro will convert the tilemap into a C-array
## named g_tilemap, containing all the IDs of the tiles that are located 
## at each given location of the C-array. 
##

#$(eval $(call TMX2C,img/tilemap.tmx,g_tilemap,src/,4))

## Convert img/level0b.tmx to src/levels/level0b.c and src/levels/level0b.h
##		This file contains another tilemap created with Tiled. This macro 
## will convert the tilemap into a C bitarray of 4-bits per item. The array
## will be named g_level0_4bit. For each tile ID included into the final 
## bitarray, only 4 bits will be used. Therefore, each byte of the array 
## will contain 2 tile IDs.
##

$(eval $(call TMX2C,img/menu.tmx,g_menu,src/levels/, 2))

$(eval $(call TMX2C,img/level01.tmx,g_level01,src/levels/, 2))
$(eval $(call TMX2C,img/level02.tmx,g_level02,src/levels/, 2))
$(eval $(call TMX2C,img/level03.tmx,g_level03,src/levels/, 2))
$(eval $(call TMX2C,img/level04.tmx,g_level04,src/levels/, 2))
$(eval $(call TMX2C,img/level05.tmx,g_level05,src/levels/, 2))
$(eval $(call TMX2C,img/level06.tmx,g_level06,src/levels/, 2))
$(eval $(call TMX2C,img/level07.tmx,g_level07,src/levels/, 2))
$(eval $(call TMX2C,img/level08.tmx,g_level08,src/levels/, 2))
$(eval $(call TMX2C,img/level09.tmx,g_level09,src/levels/, 2))
$(eval $(call TMX2C,img/level10.tmx,g_level10,src/levels/, 2))
$(eval $(call TMX2C,img/level11.tmx,g_level11,src/levels/, 2))
$(eval $(call TMX2C,img/level12.tmx,g_level12,src/levels/, 2))
$(eval $(call TMX2C,img/level13.tmx,g_level13,src/levels/, 2))
$(eval $(call TMX2C,img/level14.tmx,g_level14,src/levels/, 2))
$(eval $(call TMX2C,img/level15.tmx,g_level15,src/levels/, 2))
$(eval $(call TMX2C,img/level16.tmx,g_level16,src/levels/, 2))
$(eval $(call TMX2C,img/level17.tmx,g_level17,src/levels/, 2))
$(eval $(call TMX2C,img/level18.tmx,g_level18,src/levels/, 2))
$(eval $(call TMX2C,img/level19.tmx,g_level19,src/levels/, 2))
$(eval $(call TMX2C,img/level20.tmx,g_level20,src/levels/, 2))



