;###########################################################################
;#### FICHERO: main.s
;###########################################################################
;;-----------------------------LICENSE NOTICE------------------------------------
;;  This file is part of CPCtelera: An Amstrad CPC Game Engine
;;  Copyright (C) 2018 ronaldo / Fremos / Cheesetea / ByteRealms (@FranGallegoBR)
;;
;;  This program is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU Lesser General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  This program is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU Lesser General Public License for more details.
;;
;;  You should have received a copy of the GNU Lesser General Public License
;;  along with this program.  If not, see <http://www.gnu.org/licenses/>.
;;-------------------------------------------------------------------------------
 
;; Include all CPCtelera constant definitions, macros and variables
.include "cpctelera.h.s"
.include "entity.h.s"
.include "main.h.s"
.include "menu.h.s"
;;
;; Start of _DATA area
;;  SDCC requires at least _DATA and _CODE areas to be declared, but you may use
;;  any one of them for any purpose. Usually, compiler puts _DATA area contents
;;  right after _CODE area contents.
;;
.area _DATA
.area _CODE

;;
;; MAIN function. This is the entry point of the application.
;;    _main:: global symbol is required for correctly compiling and linking
;;
_main::
  ;; Disable firmware to prevent it from interfering with string drawing
  call cpct_disableFirmware_asm
 
  ld    c, #0
  call cpct_setVideoMode_asm
  ld hl, #_Palette
  ld de, #16
  call cpct_setPalette_asm
  ld de, #0x4000
  call cpct_akp_musicInit_asm
 
iniciar:

  call init_menu

  call salir_menu

loop:
call cpct_akp_musicPlay_asm
 
  ld    ix, #hero_data
  call ent_clear
  call ent_update
  call ent_draw
  

  ld a, (k_bullet)
  cp #0x00
  jr z, salty
  ld ix, #bullet_data
  call ent_clear
  call ent_update
  call ent_draw

  salty:
   
  ld a, (k_bullet1)
  cp #0x00
  jr z, salto
  ld ix, #bullet_data1
  call ent_clear
  call ent_update
  call ent_draw

  salto:

  ld a, (k_bullet2)
  cp #0x00
  jr z, saltoA
  ld ix, #bullet_data2
  call ent_clear
  call ent_update
  call ent_draw

  saltoA:

  ld a, (k_bullet3)
  cp #0x00
  jr z, saltoB
  ld ix, #bullet_data3
  call ent_clear
  call ent_update
  call ent_draw

  saltoB:
  ld a, (k_bullet4)
  cp #0x00
  jr z, saltoC
  ld ix, #bullet_data4
  call ent_clear
  call ent_update
  call ent_draw

  saltoC:
 
  ld a, (k_enemy)
  cp #0x00
  jr nz, salt
  ld ix, #enemy_data
  call ent_clear
  call ent_update
  call ent_draw
   ld iy, #enemy_data ;;ESTO TAMBIEN
  call col_bullet_hero


  salt:

  ld a, (k_enemy1)
  cp #0x00
  jr nz, salt1
  ld ix, #enemy_data1
  call ent_clear
  call ent_update
  call ent_draw
  call col_bullet_hero1


salt1:
   ld a, (k_enemy2)
  cp #0x00
  jr nz, salt2
  ld ix, #enemy_data2
  call ent_clear
  call ent_update
  call ent_draw
  call col_bullet_hero2


salt2:
 
ld a, (k_enemy3)
  cp #0x00
  jr nz, salt3
  ld ix, #enemy_data3
  call ent_clear
  call ent_update
  call ent_draw
  call col_bullet_hero3


salt3:
ld a, (k_enemy4)
  cp #0x00
  jr nz, salt4
  ld ix, #enemy_data4
  call ent_clear
  call ent_update
  call ent_draw
  call col_bullet_hero4


salt4:
ld a, (k_enemy5)
  cp #0x00
  jr nz, salt5
  ld ix, #enemy_data5
  call ent_clear
  call ent_update
  call ent_draw
  call col_bullet_hero5


salt5:
ld a, (k_enemy6)
  cp #0x00
  jr nz, salt6
  ld ix, #enemy_data6
  call ent_clear
  call ent_update
  call ent_draw
  call col_bullet_hero6


salt6:
ld a, (k_enemy7)
  cp #0x00
  jr nz, salt7
  ld ix, #enemy_data7
  call ent_clear
  call ent_update
  call ent_draw
  call col_bullet_hero7


salt7:  
ld a, (k_enemy8)
  cp #0x00
  jr nz, salt8
  ld ix, #enemy_data8
  call ent_clear
  call ent_update
  call ent_draw
  call col_bullet_hero8


salt8:
ld a, (k_enemy9)
  cp #0x00
  jr nz, salt9
  ld ix, #enemy_data9
  call ent_clear
  call ent_update
  call ent_draw
  call col_bullet_hero9


salt9:  

 call col_bullet_wall

 call limit_disparo_enemy9
 call col_bullet_enemy
 call col_bullet_wall2

  call limit_disparo_enemy8
 call col_bullet_enemy1
 call col_bullet_wall3

  call limit_disparo_enemy7
 call col_bullet_enemy2
 call col_bullet_wall4

  call limit_disparo_enemy5
 call col_bullet_enemy3
 call col_bullet_wall5

  call limit_disparo
  call reset
  call draw_hud

  call cpct_waitVSYNC_asm
   ld hl, #0x1600

  ;; Loop forever
  call	cpct_scanKeyboard_asm
  call cpct_akp_stop_asm
    ld hl, #Key_P
        call cpct_isKeyPressed_asm
        
    jp nz ,iniciar
  jp    loop
