;;---------------------------------------------------------------------------------------------------------------
;#MIT License                                                                                                   #
;#Copyright (c) 2021 Cyb3rApes                                                                                  #
;#                                                                                                              #
;#Permission is hereby granted, free of charge, to any person obtaining a copy 					                   #
;#of this software and associated documentation files (the "Software"), 					                         #
;#to deal in the Software without restriction, including without limitation the rights to use, copy, 		       #
;#modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, 				                #
;#and to permit persons to whom the Software is furnished to do so, subject to the following conditions:	       #
;#														                                                                      #
;#The above copyright notice and this permission notice shall be included in all copies or substantial 		    #
;#portions of the Software.											                                                    #
;#														                                                                      #
;#THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT 		       #
;#NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.	    #
;#IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,	    #
;#WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 		    #
;#SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.							                                     #
;################################################################################################################

;#GPL License
;#This file is part of "The Capeture".
;#
;#"The Capeture" is free software: you can redistribute it and/or modify
;#it under the terms of the GNU General Public License as published by
;#the Free Software Foundation, either version 3 of the License, or
;#(at your option) any later version.
;#
;#"The Capeture"  is distributed in the hope that it will be useful,
;#but WITHOUT ANY WARRANTY; without even the implied warranty of
;#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;#GNU General Public License for more details.
;#
;#You should have received a copy of the GNU General Public License
;#along with "The Capeture".  If not, see https://www.gnu.org/licenses/.
;;----------------------------------------------------------------------------------------------------------------
.include "cpctelera.h.s"

.area _DATA


string5: .asciz "Game Over"
string6: .asciz "Press Enter"
string7: .asciz "Level Completed!"
string8: .asciz "Mary is safe!"
string9: .asciz "Is she though?"
string10: .asciz ";)"


.area _CODE

.globl cpct_disableFirmware_asm
.globl cpct_getScreenPtr_asm
.globl cpct_setDrawCharM0_asm
.globl cpct_drawStringM0_asm
.globl cpct_setVideoMode_asm
.globl cpct_setPALColour_asm
.globl cpct_waitVSYNC_asm
.globl cpct_scanKeyboard_f_asm
.globl cpct_isKeyPressed_asm
.globl Key_1
.globl Key_2
.globl Key_3
.globl _spr_heart
.globl cpct_drawSprite_asm
.globl cpct_setPalette_asm
.globl _g_palette
.globl cpct_drawSolidBox_asm
.globl cpct_memset_asm
.globl Key_Enter
.globl cpct_drawCharM0_asm
.globl Key_Return
.globl intentos
.globl _spr_numeros_0
.globl _spr_numeros_1
.globl _spr_numeros_2
.globl _spr_numeros_3
.globl _spr_numeros_4
.globl _spr_numeros_5
.globl _menu_final_end 
.globl _game_mode_end 
   
;.globl _menu_0_end
;.globl _menu_1_end
;.globl _menu_2_end
;.globl _menu_3_end
;.globl _menu_4_end
;.globl _menu_5_end 
.globl cpct_zx7b_decrunch_s_asm
   
display_menu::
   ;call cpct_disableFirmware_asm

   ld c,#0

   call cpct_setVideoMode_asm
   cpctm_setBorder_asm HW_BLACK

   ld hl, #_g_palette ;;puntero a paleta de colores
   ld de, #16 ;;colores que se modifican
   call cpct_setPalette_asm ;;asigna nuestra paleta como principal

   ;ld hl, #_menu_0_end 
   ;ld de, #0xFFFF
   ;call cpct_zx7b_decrunch_s_asm
;
   ;ld hl, #_menu_1_end 
   ;ld de, #0xFFFF
   ;call cpct_zx7b_decrunch_s_asm
;
   ;ld hl, #_menu_2_end 
   ;ld de, #0xFFFF
   ;call cpct_zx7b_decrunch_s_asm
;
   ;ld hl, #_menu_3_end 
   ;ld de, #0xFFFF
   ;call cpct_zx7b_decrunch_s_asm
;
   ;ld hl, #_menu_4_end 
   ;ld de, #0xFFFF
   ;call cpct_zx7b_decrunch_s_asm
;
   ;ld hl, #_menu_5_end 
   ;ld de, #0xFFFF
   ;call cpct_zx7b_decrunch_s_asm

   ld hl, #_menu_final_end 
   ld de, #0xFFFF
   call cpct_zx7b_decrunch_s_asm

   ret

draw_score::
   ld de, #0xC000
   ld b, #0 ;; Y
   ld c, #0 ;; X
   call cpct_getScreenPtr_asm

   ex de, hl ; DE = Ptr videomem(X, Y)

   ;; Dibujamos el sprite
   ld hl, #_spr_heart
   ld b, #8 ;; H
   ld c, #4 ;; W

   call cpct_drawSprite_asm

   ld de, #0xC000
   ld b, #0 ;; Y
   ld c, #4 ;; X
   call cpct_getScreenPtr_asm

   ex de, hl ; DE = Ptr videomem(X, Y)

   ;; Seleccionamos el sprite a dibujar
   ;; Sprite a dibujar = Pos inicial + 32bytes*intentos

   ;; To do: en vez de hacer un if para cada, hacerlo con un bucle con la formual de arriba. si da tiempo hacer
   ld a, (intentos)

   cp #1
   jp z, intento1

   cp #2
   jp z, intento2

   cp #3
   jp z, intento3

   cp #4
   jp z, intento4

   cp #5
   jp z, intento5

   ld hl, #_spr_numeros_5
   ld b, #8 ;; H
   ld c, #4 ;; W
   jp dibuja_numero

   intento1:
   ld hl, #_spr_numeros_0
   ld b, #8 ;; H
   ld c, #4 ;; W
   jp dibuja_numero

   intento2:
   ld hl, #_spr_numeros_1
   ld b, #8 ;; H
   ld c, #4 ;; W
   jp dibuja_numero

   intento3:
   ld hl, #_spr_numeros_2
   ld b, #8 ;; H
   ld c, #4 ;; W
   jp dibuja_numero

   intento4:
   ld hl, #_spr_numeros_3
   ld b, #8 ;; H
   ld c, #4 ;; W
   jp dibuja_numero

   intento5:
   ld hl, #_spr_numeros_4
   ld b, #8 ;; H
   ld c, #4 ;; W

   dibuja_numero:

   call cpct_drawSprite_asm
ret

display_game_mode::

   ld c,#0

   call cpct_setVideoMode_asm
   cpctm_setBorder_asm HW_BLACK

   ld hl, #_g_palette ;;puntero a paleta de colores
   ld de, #16 ;;colores que se modifican
   call cpct_setPalette_asm ;;asigna nuestra paleta como principal


   ld hl, #_game_mode_end 
   ld de, #0xFFFF
   call cpct_zx7b_decrunch_s_asm
   
   ret

choose_game_mode::
   bucle_game_mode:

   call cpct_scanKeyboard_f_asm

   ld hl,#Key_1
   call cpct_isKeyPressed_asm ;;p
   ld a, #1
   jr nz, salirBucle_gm

   ld hl,#Key_2
   call cpct_isKeyPressed_asm ;;p
   ld a, #2
   jr nz, salirBucle_gm

   ld hl,#Key_3
   call cpct_isKeyPressed_asm ;;p
   ld a, #3
   jr nz, salirBucle_gm

   jp bucle_game_mode

   salirBucle_gm:


   ;; Guardamos el cambio elegido:
   cp #1 ;; Easy
   jp z, easy

   cp #2 ;; Normal
   jp z, normal

   ;; Hardcore
   ld a, #1
   ld (intentos), a
   ret

   easy:
   ld a, #6
   ld (intentos), a
   ret

   normal:
   ld a, #3
   ld (intentos), a
ret


choose_option::

   bucle_menu:

   call cpct_scanKeyboard_f_asm

   ld hl,#Key_1
   call cpct_isKeyPressed_asm ;;p
   ld a, #1
   jr nz, salirBucle

   ld hl,#Key_2
   call cpct_isKeyPressed_asm ;;p
   ld a, #2
   jr nz, salirBucle

   jp bucle_menu

   salirBucle:
   ret


display_end_game::

   cpctm_setBorder_asm HW_BLACK

   ld l,#0
   ld h,#HW_BLACK
   call cpct_setPALColour_asm

   ld de, #0xC000
   ld a, #0
   ld bc, #0x3FFF
   call cpct_memset_asm
  
   ld    h, #7        ;; D = Background PEN (0)
   ld    l, #13       ;; E = Foreground PEN (3)

   ;;12(Verde),6(azul),4(Blanco),3(Rojo),2(Cian),1(Amarillo)

   call cpct_setDrawCharM0_asm   ;; Set draw char colours


   ld   de, #CPCT_VMEM_START_ASM ;; DE = Pointer to start of the screen
   ld    b, #90                  ;; B = y coordinate (24 = 0x18)
   ld    c, #20                  ;; C = x coordinate (16 = 0x10)

   call cpct_getScreenPtr_asm    ;; Calculate video memory location and return it in HL

   ld   iy, #string5    ;; IY = Pointer to the string 

   call cpct_drawStringM0_asm  ;; Draw the string


   ld    h, #0       ;; D = Background PEN (0)
   ld    l, #14      ;; E = Foreground PEN (3)

   call cpct_setDrawCharM0_asm   ;; Set draw char colours

   ld   de, #CPCT_VMEM_START_ASM ;; DE = Pointer to start of the screen
   ld    b, #110                  ;; B = y coordinate (24 = 0x18)
   ld    c, #16                  ;; C = x coordinate (16 = 0x10)

   call cpct_getScreenPtr_asm    ;; Calculate video memory location and return it in HL

   ld   iy, #string6    ;; IY = Pointer to the string 

   call cpct_drawStringM0_asm  ;; Draw the string


   bucle_gameover:

   call cpct_scanKeyboard_f_asm

   ld hl,#Key_Enter
   call cpct_isKeyPressed_asm ;;p
   jr nz, salirBucle_gameover

   ld hl,#Key_Return
   call cpct_isKeyPressed_asm ;;p
   jr nz, salirBucle_gameover

   jp bucle_gameover

   salirBucle_gameover:

   ret



display_ending::

   cpctm_setBorder_asm HW_BLACK

   ld l,#0
   ld h,#HW_BLACK
   call cpct_setPALColour_asm

   ld de, #0xC000
   ld a, #0
   ld bc, #0x3FFF
   call cpct_memset_asm
  
   ld    h, #6          ;; D = Background PEN (0)
   ld    l, #14       ;; E = Foreground PEN (3)

   ;;12(Verde),6(azul),4(Blanco),3(Rojo),2(Cian),1(Amarillo)

   call cpct_setDrawCharM0_asm   ;; Set draw char colours


   ld   de, #CPCT_VMEM_START_ASM ;; DE = Pointer to start of the screen
   ld    b, #70                  ;; B = y coordinate (24 = 0x18)
   ld    c, #18                  ;; C = x coordinate (16 = 0x10)

   call cpct_getScreenPtr_asm    ;; Calculate video memory location and return it in HL

   ld   iy, #string8    ;; IY = Pointer to the string 

   call cpct_drawStringM0_asm  ;; Draw the string


   ld    h, #0       ;; D = Background PEN (0)
   ld    l, #13       ;; E = Foreground PEN (3)

   call cpct_setDrawCharM0_asm   ;; Set draw char colours

   ld   de, #CPCT_VMEM_START_ASM ;; DE = Pointer to start of the screen
   ld    b, #140                 ;; B = y coordinate (24 = 0x18)
   ld    c, #16                  ;; C = x coordinate (16 = 0x10)

   call cpct_getScreenPtr_asm    ;; Calculate video memory location and return it in HL

   ld   iy, #string9    ;; IY = Pointer to the string 

   call cpct_drawStringM0_asm  ;; Draw the string

   ld    h, #0        ;; D = Background PEN (0)
   ld    l, #13     ;; E = Foreground PEN (3)

   call cpct_setDrawCharM0_asm   ;; Set draw char colours

   ld   de, #CPCT_VMEM_START_ASM ;; DE = Pointer to start of the screen
   ld    b, #160                  ;; B = y coordinate (24 = 0x18)
   ld    c, #40                  ;; C = x coordinate (16 = 0x10)

   call cpct_getScreenPtr_asm    ;; Calculate video memory location and return it in HL

   ld   iy, #string10    ;; IY = Pointer to the string 

   call cpct_drawStringM0_asm  ;; Draw the string


   bucle_ending:

   call cpct_scanKeyboard_f_asm

   ld hl,#Key_Enter
   call cpct_isKeyPressed_asm ;;p
   jr nz, salirBucle_ending

   ld hl,#Key_Return
   call cpct_isKeyPressed_asm ;;p
   jr nz, salirBucle_ending

   jp bucle_ending

   salirBucle_ending:

   ret


display_when_success::

   cpctm_setBorder_asm HW_BLACK

   ld l,#0
   ld h,#HW_BLACK
   call cpct_setPALColour_asm

   ld de, #0xC000
   ld a, #0
   ld bc, #0x3FFF
   call cpct_memset_asm
   ;;-------------------------------------------------------------------------------------------------------

   call delay
   call delay
   call delay

   
   ;; Set up draw char colours before calling draw string
   ld    h, #0        ;; D = Background PEN (0)
   ld    l, #15      ;; E = Foreground PEN (3)

   ;;12(Verde),6(azul),4(Blanco),3(Rojo),2(Cian),1(Amarillo)

   call cpct_setDrawCharM0_asm   ;; Set draw char colours

   ld b,#90 ;;Coordenada Y
   ld c,#4 ;;Coordenada X
   
   ld hl,#string7   ;;Carga en hl el puntero al principio de la cadena.
   
   pokemon:
      ld a,#65    
      cp c
      jp z ,cambia_linea
      ld a,#0

      start:
      
      ld e,(hl)  ;;Carga en DE el contenido de memoria apuntado por HL.Ahora tendremos en E el valor ASCII del caracter a imprimir.
      ;;-------------------------------------------------------------------------Comprueba si es el final de cadena,comparando con cero.---------------------------------------------------
      cp e
      jp z, loop
      ;;-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
      push bc
      push hl
      push de

      call video_pos            ;; Calcula la posicion del caracter.
      pop de
      call cpct_drawCharM0_asm  ;; Dibuja el siguiente caracter.
      
      pop hl
      pop bc
      inc hl
      inc c
      inc c
      inc c
      inc c
      push bc
      call delay
      pop bc
   
      jr pokemon

      cambia_linea:
         inc b
         inc b
         inc b
         inc b
         inc b
         inc b
         inc b
         inc b
         inc b
         inc b
         ld c,#0
         jp start

   jr loop

   video_pos:
      ;; Calcula el puntero a la posicion de memoria en la que se quiera pintar,utilizando un sistema de coordenadas cartesianas.
      ld   de, #CPCT_VMEM_START_ASM 
      call cpct_getScreenPtr_asm    ;;Devuelve el puntero en el registro HL.
      ret

   delay:   ;;5x10 halts
      ld a,#0
      ld b,#5

      rep:
         dec b
         halt
         halt
         halt
         halt
         halt

         cp b
         jr nz,rep
      
   loop:

      ret