
;;---------------------------------------------------------------------------------------------------------------
;#MIT License                                                                                                   #
;#Copyright (c) 2021 Cyb3rApes                                                                                  #
;#                                                                                                              #
;#Permission is hereby granted, free of charge, to any person obtaining a copy 					                #
;#of this software and associated documentation files (the "Software"), 					                    #
;#to deal in the Software without restriction, including without limitation the rights to use, copy, 		    #
;#modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, 				            #
;#and to permit persons to whom the Software is furnished to do so, subject to the following conditions:	    #
;#														                                                        #
;#The above copyright notice and this permission notice shall be included in all copies or substantial 		    #
;#portions of the Software.											                                            #
;#														                                                        #
;#THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT 		    #
;#NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.	    #
;#IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,	    #
;#WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 		    #
;#SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.							                            #
;################################################################################################################

;#GPL License
;#This file is part of "The Capeture".
;#
;#"The Capeture" is free software: you can redistribute it and/or modify
;#it under the terms of the GNU General Public License as published by
;#the Free Software Foundation, either version 3 of the License, or
;#(at your option) any later version.
;#
;#"The Capeture"  is distributed in the hope that it will be useful,
;#but WITHOUT ANY WARRANTY; without even the implied warranty of
;#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;#GNU General Public License for more details.
;#
;#You should have received a copy of the GNU General Public License
;#along with "The Capeture".  If not, see https://www.gnu.org/licenses/.
;;----------------------------------------------------------------------------------------------------------------


.include "cpctelera.h.s"
.include "man/entity.h.s"

.globl cpct_getScreenPtr_asm
.globl ret_artificial
.globl cpct_disableFirmware_asm
.globl cpct_setVideoMode_asm
.globl cpct_setPalette_asm
;;.globl cpct_setPALColour_asm
.globl man_entity_forall_matching
.globl man_entity_create_cyborg
.globl cpct_drawSprite_asm
.globl cpct_drawSolidBox_asm
.globl cpct_etm_setDrawTilemap4x8_ag_asm
.globl cpct_etm_drawTilemap4x8_ag_asm
.globl man_entity_set4destruction
;;.globl cpct_etm_setTileset2x4_asm
;;.globl cpct_etm_drawTileBox2x4_asm
.globl entities
.globl player
.globl _tiles_00
.globl man_level_map
.globl man_entity_create_proyectil
.globl man_entity_create_bullet_arachnoid

entity_to_render: .dw 0
recarga_arachnoid: .db tiempo_arachnoid
is_switch_on:: .db 0 ;; 0 si el switch esta apagado, 1 en caso contrario

sys_render_tilemap::

;;;;Version 1
    ld bc, #0x1914 ;;alto y ancho en tiles del tilemap (25 en alto y 20 en largo)
    ld de, #0x14;;ancho del tilemap entero, en este caso coincide con nuestro propio mapa
    ld hl, #_tiles_00 ;;direccion del primer tile del tileset
    
    call cpct_etm_setDrawTilemap4x8_ag_asm

    ld hl, #0xC000 ;;puntero a memoria de video alineada donde iniciar el copiado
    ld de, #man_level_map
    
    call cpct_etm_drawTilemap4x8_ag_asm

    ret


sys_render_init::
   ;;call cpct_disableFirmware_asm

   ld c, #0
   call cpct_setVideoMode_asm

   cpctm_setBorder_asm HW_BLACK

   ;;ld l, #0
   ;;ld h, #HW_BLACK
   ;;call cpct_setPALColour_asm

;;dibuja con nuestra paleta
   ld hl, #_g_palette ;;puntero a paleta de colores
   ld de, #16 ;;colores que se modifican
   call cpct_setPalette_asm ;;asigna nuestra paleta como principal

    call sys_render_tilemap


   ret


sys_render_player_orientate::
    ld ix, #player ;; Cargamos direccion del jugador!

    ld a, e_o(ix) 

    cp #orientation_left
    jr z, leftDirection

    cp #orientation_right
    jr z, rightDirection

    cp #orientation_down
    jr z, downDirection

    ;; Si llega aqui es porque tiene que ir para arriba!
    ld hl, #_spr_pers_U
    ld e_spriteupperbyte(ix), h
    ld e_spritelowerbyte(ix), l

    jr finished

    leftDirection:
        ; Asignamos su sprite
        ld hl, #_spr_pers_L
        ld e_spriteupperbyte(ix), h
        ld e_spritelowerbyte(ix), l

        jr finished

    rightDirection:
        ; Asignamos su sprite
        ld hl, #_spr_pers_R
        ld e_spriteupperbyte(ix), h
        ld e_spritelowerbyte(ix), l

        jr finished

    downDirection:

    ld hl, #_spr_pers_D
    ld e_spriteupperbyte(ix), h
    ld e_spritelowerbyte(ix), l
    finished:
    ret

;; Input entity to render in IX
sys_render_one_entity:: ;; Input: La entidad la tenemos en el registro de

    ;; Borrar anterior posicion de video
    ld e, e_dirlowerbyte(ix)
    ld d, e_dirupperbyte(ix)
    ld a, #0
    xor a
    ld b, e_h(ix)
    ld c, e_w(ix)
    call cpct_drawSolidBox_asm

    ;; Ahora comprobamos si la entidad introducida iba a morir, si no, la dibujamos!

    ld a, e_type(ix)
    and #e_type_set4destruction;;Ahora tendremos en a 0x80 o 0x00. si es 0x80, llamamos a destruir!
    ld b, #e_type_set4destruction
    cp b
    jr z, no_render ;; Si es 0x80, no se renderiza porque eso significa que va a morir!

    ;; Calcular nueva posicon de memoria
    ld de, #0xC000
    ld b, e_y(ix)
    ld c, e_x(ix)
    call cpct_getScreenPtr_asm
    ex de, hl ; DE = Ptr videomem(X, Y)

    ;; Guardamos la nueva posicion como la anterior para la siguiente iteracion
    ld e_dirlowerbyte(ix), e
    ld e_dirupperbyte(ix), d

    ;; Dibujamos el sprite
    ld l, e_spritelowerbyte(ix)
    ld h, e_spriteupperbyte(ix)
    ld b, e_h(ix)
    ld c, e_w(ix)

    call cpct_drawSprite_asm
    no_render:

    jp ret_artificial ;; Simulamos una funcion


sys_render_update::
    ld hl, #sys_render_one_entity
    ld a, #(e_type_render)
    call man_entity_forall_matching
    ret

;; Input entity to update in IX
;; Dependiendo del tipo de entidad, cambiaremos su sprite por el que le corresponda
sys_render_animations_update_one::

    ;; Decrementmos su contador de animacion. Si llega a 0 ejecutamos la animacion, si no, la ignoramos al entidad
    ld a, e_ca(ix)

    cp #0
    jr z, ejecutaAnimacion

    dec a

    jr z, ejecutaAnimacion

    ;; Si no es 0, actualizamos su valor y seguimos:
    ld e_ca(ix), a

    ;; Antes de salir, vemos si vale 5 porque es un caso especial para las torretas ya que reusamos este byte para multiples tareas:
    cp #tiempo_proyectil
    jp z, disparar_proyectil

    jp ret_artificial

    ejecutaAnimacion:

        ld a, e_e(ix) ;; Pasamos el atributo entity para ver que tipo de entidad vamos a procesar

        cp #entity_mina
        jp z, mina_animation

        cp #entity_puerta
        jp z, puerta_animation

        cp #entity_explosion
        jp z, explosion_animation

        cp #entity_rotatorio
        jp z, rotatorio_animation

        cp #entity_arachnoid
        jp z, arachnoid_animation

        cp #entity_torreta
        jp z, torreta_animation

        cp #entity_fuego
        jp z, fuego_animation

        cp #entity_cchamber
        jp z, cchamber_animation

        cp #entity_mono
        jp z, mono_animation

        cp #entity_chica
        jp z, chica_animation


        explosion_animation:
            ld a, e_ts(ix)

            cp #0
            jr z, explosion_0

            cp #1
            jr z, explosion_1

            cp #2
            jr z, explosion_2

            cp #3
            jr z, explosion_3

            cp #4
            jr z, explosion_4

            cp #5
            jr z, explosion_5


            explosion_0:

                ld e_ts(ix), #1
                ld hl, #_spr_explosion_1
                jp explosion_continue
                
            explosion_1:
                ld e_ts(ix), #2
                ld hl, #_spr_explosion_2
                jp explosion_continue


            explosion_2:
                ld e_ts(ix), #3
                ld hl, #_spr_explosion_3
                jp explosion_continue

            explosion_3:
                ld e_ts(ix), #4
                ld hl, #_spr_explosion_4
                jp explosion_continue

            explosion_4:
                ld e_ts(ix), #5
                ld hl, #_spr_explosion_4
        
            explosion_continue:

                ld e_spriteupperbyte(ix), h
                ld e_spritelowerbyte(ix), l 

                ld e_ca(ix), #3 ;;Reiniciamos su contador 
                jp ret_artificial

            explosion_5:
                ;; Si tiene el sprite ultimo de explosion, simplemente la destruimos!
                call man_entity_set4destruction
                jp ret_artificial
        

        puerta_animation:
            ld a, (is_switch_on)
            cp #0

            jp z, switch_off

            ;; Si llega aqui, es que esta activo!
            ld a, e_ts(ix)

            cp #0
            jr z, puerta_0

            cp #1
            jr z, puerta_1

            cp #2
            jr z, puerta_2

            cp #3
            jr z, puerta_3

            cp #4
            jr z, puerta_4

            cp #5
            jr z, puerta_5

            cp #6
            jr z, puerta_6

            cp #7
            jr z, puerta_7

            ;; Sprite 8
            ;; Si tiene el sprite ultimo de explosion, simplemente la destruimos!
            call man_entity_set4destruction
            jp ret_artificial

            puerta_0:

                ld e_ts(ix), #1
                ld hl, #_spr_puerta_1
                jp puerta_continue
                
            puerta_1:
                ld e_ts(ix), #2
                ld hl, #_spr_puerta_2
                jp puerta_continue


            puerta_2:
                ld e_ts(ix), #3
                ld hl, #_spr_puerta_3
                jp puerta_continue

            puerta_3:
                ld e_ts(ix), #4
                ld hl, #_spr_puerta_4
                jp puerta_continue

            puerta_4:
                ld e_ts(ix), #5
                ld hl, #_spr_puerta_5
                jp puerta_continue

            puerta_5:
                ld e_ts(ix), #6
                ld hl, #_spr_puerta_6
                jp puerta_continue

            puerta_6:
                ld e_ts(ix), #7
                ld hl, #_spr_puerta_7
                jp puerta_continue

            puerta_7:
                ld e_ts(ix), #8
                ld hl, #_spr_puerta_8
                jp puerta_continue
        
            puerta_continue:

                ld e_spriteupperbyte(ix), h
                ld e_spritelowerbyte(ix), l 

                ld e_ca(ix), #3 ;;Reiniciamos su contador 
                jp ret_artificial

            switch_off:
                jp ret_artificial



        mina_animation:
            ;; La logica de esta animacion es basicamente alternar entre sus dos sprites. Por lo tanto, si tiene uno, ponemos el otro, y viceversa
            ;; Como la mina solo tiene 2 posiblidades de sprites, vemos cual esta pintado ahora y ponemos el siguiente:

            ld a, e_ts(ix)

            cp #0
            jr z, mina_0

            ;; Si llegamos aqui significa que tiene pintado el 1, por lo tanto pintamos el 0:
            ld e_ts(ix), #0
            ld hl, #_spr_mina_0
            ld e_spriteupperbyte(ix), h
            ld e_spritelowerbyte(ix), l 

            ld e_ca(ix), #50 ;;Reiniciamos su contador 
            jp ret_artificial

            mina_0:
                ld e_ts(ix), #1
                ld hl, #_spr_mina_1
                ld e_spriteupperbyte(ix), h
                ld e_spritelowerbyte(ix), l 

                ld e_ca(ix), #50 ;;Reiniciamos su contador
                jp ret_artificial
        
        rotatorio_animation:
            ;; El sprite a colocar dependera de la orientacion y del sprite anterior que habia colocado, jugamos con esto:
            ld a, e_o(ix)
            cp #orientation_left
            jp z, orientation_left_animation

            ;; Si llegamos aqui estamos en orientacion derecha

            ;; Pasamos a ver que tipo de sprite habia colocado
            ld a, e_ts(ix)

            cp #0
            jr z, rotatorio_R_0

            ;; Si llegamos aqui significa que tiene pintado el 1, por lo tanto pintamos el 0:
            ld e_ts(ix), #0
            ld hl, #_spr_rotatorioR_0
            ld e_spriteupperbyte(ix), h
            ld e_spritelowerbyte(ix), l 

            ld e_ca(ix), #2 ;;Reiniciamos su contador 
            jp ret_artificial

            rotatorio_R_0:
            ld e_ts(ix), #1
            ld hl, #_spr_rotatorioR_1
            ld e_spriteupperbyte(ix), h
            ld e_spritelowerbyte(ix), l 

            ld e_ca(ix), #2 ;;Reiniciamos su contador 
            jp ret_artificial

            orientation_left_animation:

            ;; Pasamos a ver que tipo de sprite habia colocado
            ld a, e_ts(ix)

            cp #0
            jr z, rotatorio_L_0

            ;; Si llegamos aqui significa que tiene pintado el 1, por lo tanto pintamos el 0:
            ld e_ts(ix), #0
            ld hl, #_spr_rotatorioL_0
            ld e_spriteupperbyte(ix), h
            ld e_spritelowerbyte(ix), l 

            ld e_ca(ix), #2 ;;Reiniciamos su contador 
            jp ret_artificial

            rotatorio_L_0:
            ld e_ts(ix), #1
            ld hl, #_spr_rotatorioL_1
            ld e_spriteupperbyte(ix), h
            ld e_spritelowerbyte(ix), l 

            ld e_ca(ix), #2 ;;Reiniciamos su contador 

            jp ret_artificial

        torreta_animation:
            ;; Vemos la oritentacion que tiene, y de ahi pasamos al siguiente.
            ;; El orden sera el siguiente: R-D-F-U
            ld a, e_o(ix)

            cp #orientation_right
            jp z, torretaR

            cp #orientation_down
            jp z, torretaD

            cp #orientation_left
            jp z, torretaL

            ;; Si llegamos aqui significa que tenia orientacion hacia arriba
            ;; Por lo tanto, siguiendo el orden, tocaria poner la derecha otra vez:
            ld hl, #_spr_torreta_3
            ld e_spriteupperbyte(ix), h
            ld e_spritelowerbyte(ix), l 
            ld e_ca(ix), #10 ;;Reiniciamos su contador
            ld e_o(ix), #orientation_right 
            jp ret_artificial

            torretaR:
                ld hl, #_spr_torreta_2
                ld e_spriteupperbyte(ix), h
                ld e_spritelowerbyte(ix), l 
                ld e_ca(ix), #10 ;;Reiniciamos su contador 
                ld e_o(ix), #orientation_down
                jp ret_artificial

            torretaD:
                ld hl, #_spr_torreta_1
                ld e_spriteupperbyte(ix), h
                ld e_spritelowerbyte(ix), l 
                ld e_ca(ix), #10 ;;Reiniciamos su contador 
                ld e_o(ix), #orientation_left
                jp ret_artificial

            torretaL:
                ld hl, #_spr_torreta_0
                ld e_spriteupperbyte(ix), h
                ld e_spritelowerbyte(ix), l 
                ld e_o(ix), #orientation_up
                ld e_ca(ix), #10 ;;Reiniciamos su contador 
                jp ret_artificial
            
        arachnoid_animation:
            ;; En primer lugar, comprobamos si se se ha pasado su tiempo de recarga para poder disparar
            ld a, (recarga_arachnoid)
            dec a
            jr nz, noDisparar_arachnoid

            ;; Si llega aqui es que se ha terminado su recarga, por lo tanto, disparamos y reiniciamos su contador
            ld a, #tiempo_arachnoid
            ld (recarga_arachnoid), a

            push ix
            pop iy
            call man_entity_create_bullet_arachnoid
            push iy
            pop ix
            jr empezar_animacion_arachnoid

            noDisparar_arachnoid:
            ;; Aqui simplemente actualizamos su contador:
            ld (recarga_arachnoid), a

            empezar_animacion_arachnoid:
            ;; Reiniciamos su contador de animacion:
            ld e_ca(ix), #10
            ld a, e_ts(ix)

            cp #0
            jr z, arachnoid_animation_0

            ;; Si estamos aqui es que teniamos el sprite 1, pintamos el 0 en su correcta orientacion:
            ld a, e_o(ix)
            cp #orientation_up

            jr z, arachnoid_o_u_0

            ;; Si no, tenemos que pintar el sprite 0 de orientacion abajo
            ld e_ts(ix), #0
            ld hl, #_spr_arachnoid_down_0
            ld e_spriteupperbyte(ix), h
            ld e_spritelowerbyte(ix), l 
            jp ret_artificial

            arachnoid_o_u_0:
            ld e_ts(ix), #0
            ld hl, #_spr_arachnoid_up_0
            ld e_spriteupperbyte(ix), h
            ld e_spritelowerbyte(ix), l 
            jp ret_artificial

            ;; Si estamos aqui, es que teniamos el sprite 0, pintamos el 1 en su correcta orientacion:
            arachnoid_animation_0:
            ld a, e_o(ix)
            cp #orientation_up

            jr z, arachnoid_o_u_1

            ;; Si no, tenemos que pintar el sprite 1 de orientacion abajo
            ld e_ts(ix), #1
            ld hl, #_spr_arachnoid_down_1
            ld e_spriteupperbyte(ix), h
            ld e_spritelowerbyte(ix), l 
            jp ret_artificial

            arachnoid_o_u_1:
            ld e_ts(ix), #1
            ld hl, #_spr_arachnoid_up_1
            ld e_spriteupperbyte(ix), h
            ld e_spritelowerbyte(ix), l 
            jp ret_artificial
        
        disparar_proyectil:
            ld a, e_e(ix)
            cp #entity_torreta
            jr z, realizar_disparo_proyectil

            ;; Sino es una torreta, nos da igual
            jp ret_artificial

            realizar_disparo_proyectil:
                push ix
                pop iy
                call man_entity_create_proyectil
                jp ret_artificial
        
        fuego_animation:
            ld a, e_ts(ix)

            cp #0
            jr z, fire_0

            cp #1
            jr z, fire_1

            cp #2
            jr z, fire_2

            cp #3
            jr z, fire_3

            cp #4
            jr z, fire_4

            cp #5
            jr z, fire_5

            ;; Si llegamos aqui, tenemos el sprite 6
            ld e_ts(ix), #0
            ld hl, #_spr_fire_0
            jp fire_continue

            fire_0:

                ld e_ts(ix), #1
                ld hl, #_spr_fire_1
                jp fire_continue
                
            fire_1:
                ld e_ts(ix), #2
                ld hl, #_spr_fire_2
                jp fire_continue


            fire_2:
                ld e_ts(ix), #3
                ld hl, #_spr_fire_3
                jp fire_continue

            fire_3:
                ld e_ts(ix), #4
                ld hl, #_spr_fire_4
                jp fire_continue

            fire_4:
                ld e_ts(ix), #5
                ld hl, #_spr_fire_5

            fire_5:
                ld e_ts(ix), #6
                ld hl, #_spr_fire_6
        
            fire_continue:

                ld e_spriteupperbyte(ix), h
                ld e_spritelowerbyte(ix), l 

                ld e_ca(ix), #10 ;;Reiniciamos su contador 
                jp ret_artificial
            
        cchamber_animation:
            ld a, e_ts(ix)

            cp #0
            jp z, cchamber_0

            cp #1
            jp z, cchamber_1

            cp #2
            jp z, cchamber_2

            cp #3
            jp z, cchamber_3

            cp #4
            jp z, cchamber_4

            ;; Si llegamos aqui, tenemos el sprite 5
            ld e_ts(ix), #0
            ;; Comprobamos estado 
            ld a, e_vy(ix)

            cp #3
            jp z, cchamber_5_h

            cp #2
            jp z, cchamber_5_m

            ;; Si llegamos aqui, es low:
            ld hl, #_spr_cchamber_l_0
            jp cchamber_continue

            cchamber_5_h:
            ld hl, #_spr_cchamber_h_0
            jp cchamber_continue

            cchamber_5_m:
            ld hl, #_spr_cchamber_m_0
            jp cchamber_continue

            cchamber_0:

                ld e_ts(ix), #1

                ;; Comprobamos estado 
                ld a, e_vy(ix)

                cp #3
                jp z, cchamber_0_h

                cp #2
                jp z, cchamber_0_m

                ;; Si llegamos aqui, es low:
                ld hl, #_spr_cchamber_l_1
                jp cchamber_continue

                cchamber_0_h:
                ld hl, #_spr_cchamber_h_1
                jp cchamber_continue

                cchamber_0_m:
                ld hl, #_spr_cchamber_m_1
                jp cchamber_continue
                
            cchamber_1:
                ld e_ts(ix), #2
                ;; Comprobamos estado 
                ld a, e_vy(ix)

                cp #3
                jp z, cchamber_1_h

                cp #2
                jp z, cchamber_1_m

                ;; Si llegamos aqui, es low:
                ld hl, #_spr_cchamber_l_2
                jp cchamber_continue

                cchamber_1_h:
                ld hl, #_spr_cchamber_h_2
                jp cchamber_continue

                cchamber_1_m:
                ld hl, #_spr_cchamber_m_2
                jp cchamber_continue


            cchamber_2:
                ld e_ts(ix), #3
                ;; Comprobamos estado 
                ld a, e_vy(ix)

                cp #3
                jp z, cchamber_2_h

                cp #2
                jp z, cchamber_2_m

                ;; Si llegamos aqui, es low:
                ld hl, #_spr_cchamber_l_3
                jp cchamber_continue

                cchamber_2_h:
                ld hl, #_spr_cchamber_h_3
                jp cchamber_continue

                cchamber_2_m:
                ld hl, #_spr_cchamber_m_3
                jp cchamber_continue

            cchamber_3:
                ld e_ts(ix), #4
                ;; Comprobamos estado 
                ld a, e_vy(ix)

                cp #3
                jp z, cchamber_3_h

                cp #2
                jp z, cchamber_3_m

                ;; Si llegamos aqui, es low:
                ld hl, #_spr_cchamber_l_4
                jp cchamber_continue

                cchamber_3_h:
                ld hl, #_spr_cchamber_h_4
                jp cchamber_continue

                cchamber_3_m:
                ld hl, #_spr_cchamber_m_4
                jp cchamber_continue

            cchamber_4:
                ld e_ts(ix), #5
                ;; Comprobamos estado 
                ld a, e_vy(ix)

                cp #3
                jp z, cchamber_4_h

                cp #2
                jp z, cchamber_4_m

                ;; Si llegamos aqui, es low:
                ld hl, #_spr_cchamber_l_5
                jp cchamber_continue

                cchamber_4_h:
                ld hl, #_spr_cchamber_h_5
                jp cchamber_continue

                cchamber_4_m:
                ld hl, #_spr_cchamber_m_5
    
            cchamber_continue:

                ld e_spriteupperbyte(ix), h
                ld e_spritelowerbyte(ix), l 

                ld e_ca(ix), #10 ;;Reiniciamos su contador 

                ;; Por ultimo, decrementamos el contador de generacion de cyborg. Si llega a 0, generamos cyborg justo debajo de ella y reiniciamos contador. Sino, sobreescribimos el anterior y seguimos:
                ld a, e_o(ix)
                dec a

                jr nz, no_generar_cyborg

                ;; Si llegamos aqui es que nos toca genera un cyborg, lo generamos:
                push ix ;; Guardamos la direccion del cchamber en la pila para no perderlo al generar el cyborg ya que man_entity_create_cyborg modifica dicho registro
                call man_entity_create_cyborg
                push ix
                pop  iy
                pop  ix
                ;; Cyborg en IY y CChamber en IX: modificamos su X y su Y para que aparezcan justo debajo:
                ld a, e_y(ix)
                ld b, #16
                add a, b
                ld e_y(iy), a ;; Pintamos al cyborg 16 bytes mas abajo
                ld a, e_x(ix)
                ld e_x(iy), a ;; Pintamos al cyborg en la misma X
                ld a, #tiempo_generacion_cyborg

                no_generar_cyborg:
                ld e_o(ix), a
                jp ret_artificial
            

            chica_animation:
                ld a, e_ts(ix)

                cp #0
                jr z, chica_0

                cp #1
                jr z, chica_1

                cp #2
                jr z, chica_2

                ;; Si llegamos aqui, tenemos el sprite 3
                ld e_ts(ix), #0
                ld hl, #_spr_chica_0
                jp chica_continue

                chica_0:
                    ld e_ts(ix), #1
                    ld hl, #_spr_chica_1
                    jp chica_continue
                    
                chica_1:
                    ld e_ts(ix), #2
                    ld hl, #_spr_chica_2
                    jp chica_continue


                chica_2:
                    ld e_ts(ix), #3
                    ld hl, #_spr_chica_3
                    jp chica_continue
            
                chica_continue:
                    ld e_spriteupperbyte(ix), h
                    ld e_spritelowerbyte(ix), l 

                    ld e_ca(ix), #10 ;;Reiniciamos su contador 
                    jp ret_artificial

                
            mono_animation:
                ld a, e_ts(ix)

                cp #0
                jr z, mono_0

                cp #1
                jr z, mono_1

                cp #2
                jr z, mono_2

                ;; Si llegamos aqui, tenemos el sprite 3
                ld e_ts(ix), #0
                ld hl, #_spr_mono_0
                jp mono_continue

                mono_0:
                    ld e_ts(ix), #1
                    ld hl, #_spr_mono_1
                    jp mono_continue
                    
                mono_1:
                    ld e_ts(ix), #2
                    ld hl, #_spr_mono_2
                    jp mono_continue


                mono_2:
                    ld e_ts(ix), #3
                    ld hl, #_spr_mono_3
                    jp mono_continue
            
                mono_continue:
                    ld e_spriteupperbyte(ix), h
                    ld e_spritelowerbyte(ix), l 

                    ld e_ca(ix), #10 ;;Reiniciamos su contador 
                    jp ret_artificial  
        
    jp ret_artificial

sys_render_animations_update::
ld hl, #sys_render_animations_update_one
ld a, #(e_type_render | e_type_animated)
call man_entity_forall_matching
ret

