;;---------------------------------------------------------------------------------------------------------------
;#MIT License                                                                                                   #
;#Copyright (c) 2021 Cyb3rApes                                                                                  #
;#                                                                                                              #
;#Permission is hereby granted, free of charge, to any person obtaining a copy 					                   #
;#of this software and associated documentation files (the "Software"), 					                         #
;#to deal in the Software without restriction, including without limitation the rights to use, copy, 		       #
;#modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, 				                #
;#and to permit persons to whom the Software is furnished to do so, subject to the following conditions:	       #
;#														                                                                      #
;#The above copyright notice and this permission notice shall be included in all copies or substantial 		    #
;#portions of the Software.											                                                    #
;#														                                                                      #
;#THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT 		       #
;#NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.	    #
;#IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,	    #
;#WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 		    #
;#SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.							                                     #
;################################################################################################################

;#GPL License
;#This file is part of "The Capeture".
;#
;#"The Capeture" is free software: you can redistribute it and/or modify
;#it under the terms of the GNU General Public License as published by
;#the Free Software Foundation, either version 3 of the License, or
;#(at your option) any later version.
;#
;#"The Capeture"  is distributed in the hope that it will be useful,
;#but WITHOUT ANY WARRANTY; without even the implied warranty of
;#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;#GNU General Public License for more details.
;#
;#You should have received a copy of the GNU General Public License
;#along with "The Capeture".  If not, see https://www.gnu.org/licenses/.
;;----------------------------------------------------------------------------------------------------------------
.globl cpct_akp_musicInit_asm
.globl cpct_akp_musicPlay_asm
.globl cpct_akp_stop_asm
.globl cpct_setInterruptHandler_asm
.globl _intro_song
.globl _fail_song
.globl _rescue_song
.globl _river_song
.globl _forest_song
.globl _battle_song
.globl _run_song
.globl _ape_song
.globl _rainbow_song
.globl _mama_song
.globl _kill_song

.globl cpct_disableFirmware_asm

contador_vsync: .db 0

    isr_play:
       exx
       push af
       push bc
       push de
       push hl
       push iy
    
       ld a,(contador_vsync)
       dec a
       ld (contador_vsync),a
       jr nz,retorno
    
          call cpct_akp_musicPlay_asm
          ld a,#6
          ld (contador_vsync),a
     
    retorno:
       pop iy
       pop hl
       pop de
       pop bc
       pop af
       exx
       ret
    
stop_music::
   call cpct_akp_stop_asm
   call cpct_disableFirmware_asm
   ret

play_music::
    call cpct_akp_musicInit_asm
    ld hl,#isr_play
    call cpct_setInterruptHandler_asm
    ret

play_menu_music::
   call stop_music
   ld de, #_intro_song
   call play_music
   ret
;;bloque 1
play_lvl1_music::
   call stop_music
   ld de, #_rescue_song
   call play_music
   ret
play_lvl2_music::
   call stop_music
   ld de, #_ape_song
   call play_music
   ret
play_lvl3_music::
   call stop_music
   ld de, #_river_song
   call play_music
   ret

;;bloque 2
play_lvl4_music::
   call stop_music
   ld de, #_run_song
   call play_music
   ret
play_lvl5_music::
   call stop_music
   ld de, #_forest_song
   call play_music
   ret
play_lvl6_music::
   call stop_music
   ld de, #_kill_song
   call play_music
   ret
   ;;bloque 3
play_lvl7_music::
   call stop_music
   ld de, #_mama_song
   call play_music
   ret
play_lvl8_music::
   call stop_music
   ld de, #_kill_song
   call play_music
   ret
play_lvl9_music::
   call stop_music
   ld de, #_run_song
   call play_music
   ret
   ;;final boss
play_lvl_Boss_music::
   call stop_music
   ld de, #_battle_song
   call play_music
   ret

play_lvl_arco_music::
   call stop_music
   ld de, #_rainbow_song
   call play_music
   ret 

play_gameover_music::
   call stop_music
   ld de, #_fail_song
   call play_music
   ret