;;---------------------------------------------------------------------------------------------------------------
;#MIT License                                                                                                   #
;#Copyright (c) 2021 Cyb3rApes                                                                                  #
;#                                                                                                              #
;#Permission is hereby granted, free of charge, to any person obtaining a copy 					                #
;#of this software and associated documentation files (the "Software"), 					                    #
;#to deal in the Software without restriction, including without limitation the rights to use, copy, 		    #
;#modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, 				            #
;#and to permit persons to whom the Software is furnished to do so, subject to the following conditions:	    #
;#														                                                        #
;#The above copyright notice and this permission notice shall be included in all copies or substantial 		    #
;#portions of the Software.											                                            #
;#														                                                        #
;#THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT 		    #
;#NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.	    #
;#IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,	    #
;#WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 		    #
;#SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.							                            #
;################################################################################################################

;#GPL License
;#This file is part of "The Capeture".
;#
;#"The Capeture" is free software: you can redistribute it and/or modify
;#it under the terms of the GNU General Public License as published by
;#the Free Software Foundation, either version 3 of the License, or
;#(at your option) any later version.
;#
;#"The Capeture"  is distributed in the hope that it will be useful,
;#but WITHOUT ANY WARRANTY; without even the implied warranty of
;#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;#GNU General Public License for more details.
;#
;#You should have received a copy of the GNU General Public License
;#along with "The Capeture".  If not, see https://www.gnu.org/licenses/.
;;----------------------------------------------------------------------------------------------------------------

.include "man/entity.h.s"
.include "cpctelera.h.s"

.globl cpct_scanKeyboard_f_asm
.globl Key_Q
.globl Key_A
.globl Key_O
.globl Key_P
.globl Key_Space
.globl cpct_isKeyPressed_asm 
.globl man_entity_forall_matching
.globl ret_artificial
.globl man_entity_create_bullet

max_recarga=5;; Constante con el tiempo de recarga. Conforme se vaya reduciendo los fps, esto tendremos que bajarlo porque hara menos iteracones por lo tanto, menos iteraciones a saltar! ir probando. si pulso espacio y no dispara es por eso

tiempo_recarga: .db 0;; Inicializamos a 0

;; Change Velocity depending on input of user
;; Input: Entity in IX
sys_input_one_entity::

    ld a, (tiempo_recarga)

    ;; Si es 0, no hace falta reiniciar, significa que ya esta listo para disparar
    cp #0
    jr z, continuar_input

    dec a
    ld (tiempo_recarga),a 

    continuar_input:

    ;; Reset velocity
    ld e_vx(ix), #0
    ld e_vy(ix), #0 
      
    call cpct_scanKeyboard_f_asm
    
    ld hl,#Key_Space
    call cpct_isKeyPressed_asm ;;p
    jr nz, disparar

    ld hl,#Key_Q
    call cpct_isKeyPressed_asm ;;q
    jr nz, up

    ld hl,#Key_A
    call cpct_isKeyPressed_asm ;;a
    jr nz, down

    ld hl,#Key_O
    call cpct_isKeyPressed_asm ;;o
    jr nz, left

    ld hl,#Key_P
    call cpct_isKeyPressed_asm ;;p
    jr nz, right

    jr nothingpressed

    up:
        ld e_vy(ix),#-2
        ld e_o(ix), #0x03
        jr nothingpressed
    
    down:
        ld e_vy(ix),#2
        ld e_o(ix), #0x00
        jr nothingpressed
    
    left:
        ld e_vx(ix),#-1
        ld e_o(ix), #0x02
        jr nothingpressed
  
    right:
        ld e_vx(ix),#1
        ld e_o(ix), #0x01
        jr nothingpressed
    
    disparar:
        ;; Si el tiempo de recarga es 0, disparamos, si no, no! Si es 0, lo volvemos a inicializar a su valor maximo!
        ld a, (tiempo_recarga)
        cp #0

        jr nz, nothingpressed

        call man_entity_create_bullet
        ld a, #max_recarga
        ld (tiempo_recarga), a
        
    nothingpressed:
    jp ret_artificial ;; Simulamos una funcion


sys_input_update::
    ld hl, #sys_input_one_entity
    ld a, #(e_type_input) 
    call man_entity_forall_matching
    ret