;;---------------------------------------------------------------------------------------------------------------
;#MIT License                                                                                                   #
;#Copyright (c) 2021 Cyb3rApes                                                                                  #
;#                                                                                                              #
;#Permission is hereby granted, free of charge, to any person obtaining a copy 					                #
;#of this software and associated documentation files (the "Software"), 					                    #
;#to deal in the Software without restriction, including without limitation the rights to use, copy, 		    #
;#modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, 				            #
;#and to permit persons to whom the Software is furnished to do so, subject to the following conditions:	    #
;#														                                                        #
;#The above copyright notice and this permission notice shall be included in all copies or substantial 		    #
;#portions of the Software.											                                            #
;#														                                                        #
;#THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT 		    #
;#NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.	    #
;#IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,	    #
;#WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 		    #
;#SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.							                            #
;################################################################################################################

;#GPL License
;#This file is part of "The Capeture".
;#
;#"The Capeture" is free software: you can redistribute it and/or modify
;#it under the terms of the GNU General Public License as published by
;#the Free Software Foundation, either version 3 of the License, or
;#(at your option) any later version.
;#
;#"The Capeture"  is distributed in the hope that it will be useful,
;#but WITHOUT ANY WARRANTY; without even the implied warranty of
;#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;#GNU General Public License for more details.
;#
;#You should have received a copy of the GNU General Public License
;#along with "The Capeture".  If not, see https://www.gnu.org/licenses/.
;;----------------------------------------------------------------------------------------------------------------


;;
;;  ENTITY MANAGER DECLARATION
;;

;; Formato entidades:
;; Type
;; Entity
;; X
;; Y
;; VX ;; Disparos left para cambiar de estado en cchamber 
;; VY ;; Estado de la cchamber
;; w
;; h
;; DirPrevia (upper byte)
;; DirPrevia (lower byte)
;; SPRITE upper byte ya que son punteros!
;; Sprite lower byte
;; orientacion ;; 0->abajo, 1->derecha, 2->izq, 3->arriba ;; Tiempo restante para generar los cyborgs!
;; prevx
;; prevy
;; contador_animacion ;; Iteraciones restantes para cambiar su sprite
;; Tipo Sprite que tiene puesto (esto solo servira para animaciones)

;; Constantes para poder utilizarlas luego, se usan como si fuera el numero tal cual, por lo tanto, para cargar es solamente con #nombreConstante

num_entities=100;; Un jugador, 3 zombies y un objeto que no se mueva
entity_size=17

;; Estas constantes son para calcular la posicion de la bala para que quede centrada al disparar. Si se cambia el sprite, cambiar estos valores! Siempre sera bytes/2 - 1 !!
mitad_jugador_x=1
mitad_jugador_y=3

mitad_torreta_x=3
mitad_torreta_y=7

tiempo_proyectil=5
tiempo_arachnoid=5
tiempo_generacion_cyborg=4

cchamber_life=3 ;; Disparos para pasar de un estado a otro.

;; Bit for types of entites
e_type_ia_bit               = 7 ;; 1 si esta vivo, 0 si muerto
e_type_physics_bit          = 6 ;; 1 significa que se le debe de pasar al sistema de fisicas para que actualice su posicion, 0 si no
e_type_input_bit            = 5 ;; 1 significa que el sistema de fisicas actualizara su posicion mediante input del usuario
e_type_render_bit           = 4 ;; 1 significa que deberemos de pasarselo al render para que lo pinte!
e_type_set4destruction_bit  = 3 ;; 1 significa que debemos de invalidar la entidad en la siguiente iteracion
e_type_collision_bit        = 2
e_type_collided_bit         = 1 ;; 1 significa que la entidad ha sufrido una entidad, 0 significa que no!
e_type_animated_bit         = 0 ;; 1 significa que la entidad ha sufrido una entidad, 0 significa que no!

;; Mascaras
e_type_ia    = (1 << e_type_ia_bit)
e_type_physics  = (1 << e_type_physics_bit)
e_type_input    = (1 << e_type_input_bit)
e_type_render   = (1 << e_type_render_bit)
e_type_set4destruction   = (1 << e_type_set4destruction_bit)
e_type_collision = (1 << e_type_collision_bit)
e_type_collided = (1 << e_type_collided_bit)
e_type_animated = (1 << e_type_animated_bit)

e_type_invalid    = 0x00
orientation_left  = 0x02
orientation_right = 0x01
orientation_up    = 0x03
orientation_down  = 0x00

entity_player     = 0x00
entity_bala       = 0x01
entity_mina       = 0x02
entity_valla      = 0x03
entity_explosion  = 0x04
entity_rotatorio  = 0x05
entity_torreta    = 0x06
entity_arachnoid  = 0x07
entity_fuego      = 0x08
entity_puerta     = 0x09
entity_switch     = 0x0A
entity_cchamber   = 0x0B
entity_cyborg     = 0x0C
entity_chica      = 0x0D
entity_mono       = 0x0E

;; Constantes para procesar las entidades con el registro IX
e_type==0
e_e==1
e_x==2
e_y==3
e_vx==4
e_vy==5
e_w==6
e_h==7
e_dirupperbyte==8
e_dirlowerbyte==9
e_spriteupperbyte==10
e_spritelowerbyte==11
e_o==12
e_prevx==13
e_prevy==14
e_ca==15
e_ts==16
;; Globales

.globl cpct_memset_asm
.globl cpct_getRandom_mxor_u8_asm
.globl is_switch_on
.globl _spr_pers_R
.globl _spr_pers_D
.globl _spr_pers_U
.globl _spr_pers_L
.globl _spr_bala
.globl _spr_valla
.globl _spr_mina_0
.globl _spr_mina_1
.globl _g_palette
.globl _spr_explosion_0
.globl _spr_explosion_1
.globl _spr_explosion_2
.globl _spr_explosion_3
.globl _spr_explosion_4
.globl _spr_explosion_5
.globl _spr_rotatorioR_0
.globl _spr_rotatorioR_1
.globl _spr_rotatorioL_0
.globl _spr_rotatorioL_1
.globl _spr_torreta_0
.globl _spr_torreta_1
.globl _spr_torreta_2
.globl _spr_torreta_3
.globl _spr_arachnoid_down_0
.globl _spr_arachnoid_down_1
.globl _spr_arachnoid_up_0
.globl _spr_arachnoid_up_1
.globl _spr_fire_0
.globl _spr_fire_1
.globl _spr_fire_2
.globl _spr_fire_3
.globl _spr_fire_4
.globl _spr_fire_5
.globl _spr_fire_6
.globl _spr_puerta_0
.globl _spr_puerta_1
.globl _spr_puerta_2
.globl _spr_puerta_3
.globl _spr_puerta_4
.globl _spr_puerta_5
.globl _spr_puerta_6
.globl _spr_puerta_7
.globl _spr_puerta_8
.globl _spr_switch_0
.globl _spr_switch_1
.globl _spr_cchamber_h_0
.globl _spr_cchamber_h_1
.globl _spr_cchamber_h_2
.globl _spr_cchamber_h_3
.globl _spr_cchamber_h_4
.globl _spr_cchamber_h_5
.globl _spr_cchamber_l_0
.globl _spr_cchamber_l_1
.globl _spr_cchamber_l_2
.globl _spr_cchamber_l_3
.globl _spr_cchamber_l_4
.globl _spr_cchamber_l_5
.globl _spr_cchamber_l_0
.globl _spr_cchamber_m_0
.globl _spr_cchamber_m_1
.globl _spr_cchamber_m_2
.globl _spr_cchamber_m_3
.globl _spr_cchamber_m_4
.globl _spr_cchamber_m_5
.globl _spr_cyborgR
.globl _spr_mono_0
.globl _spr_mono_1
.globl _spr_mono_2
.globl _spr_mono_3
.globl _spr_chica_0
.globl _spr_chica_1
.globl _spr_chica_2
.globl _spr_chica_3

