;;-------------------------------------------------------------------------------------------------------------
;#MIT License                                                                                                   #
;#Copyright (c) 2021 Cyb3rApes                                                                                  #
;#                                                                                                              #
;#Permission is hereby granted, free of charge, to any person obtaining a copy 					                   #
;#of this software and associated documentation files (the "Software"), 					                         #
;#to deal in the Software without restriction, including without limitation the rights to use, copy, 		       #
;#modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, 				                #
;#and to permit persons to whom the Software is furnished to do so, subject to the following conditions:	       #
;#														                                                                      #
;#The above copyright notice and this permission notice shall be included in all copies or substantial 		    #
;#portions of the Software.											                                                    #
;#														                                                                      #
;#THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT 		       #
;#NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.	    #
;#IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,	    #
;#WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 		    #
;#SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.							                                     #
;################################################################################################################

;#GPL License
;#This file is part of "The Capeture".
;#
;#"The Capeture" is free software: you can redistribute it and/or modify
;#it under the terms of the GNU General Public License as published by
;#the Free Software Foundation, either version 3 of the License, or
;#(at your option) any later version.
;#
;#"The Capeture"  is distributed in the hope that it will be useful,
;#but WITHOUT ANY WARRANTY; without even the implied warranty of
;#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;#GNU General Public License for more details.
;#
;#You should have received a copy of the GNU General Public License
;#along with "The Capeture".  If not, see https://www.gnu.org/licenses/.
;;----------------------------------------------------------------------------------------------------------------
.area _DATA

contador: .db 0 ;; Contador para el bucle de entidades a crear

.area _CODE


.globl display_menu
.globl choose_option
.globl display_end_game
.globl display_when_success
.globl display_game_mode
.globl choose_game_mode
.globl play_lvl_boss
.globl play_lvl_arco
.globl play_lvl_1
.globl play_lvl_2
.globl play_lvl_3
.globl play_lvl_4
.globl play_lvl_5
.globl play_lvl_6
.globl play_lvl_7
.globl play_lvl_8
.globl play_lvl_9
.globl stop_music
.globl play_menu_music
.globl play_gameover_music
.globl display_ending


intentos: .db 0

_main::
   inicializar:
      ld a, #6
      ld (intentos), a ;; Por defecto modo easy
      call play_menu_music

   inicio_juego:
      call display_menu
      call choose_option ;; Bucle que esperara el input del usuario, devolvera el resultado en a

      cp #1
      jp z, empezar_partida

      ;; Si llega aqui, es la opcion 2 del juego!
      jp seleccionar_game_mode

      empezar_partida:

         ;; 
         ;; BLOQUE BOSQUE
         ;;
         nivel1:
            call play_lvl_1 ;; Un juego tendra dos outputs, 0 -> Game Over, 1 -> Next level. Output en A!
            cp #0
            jp z, game_over
            call display_when_success

         nivel2:
            call play_lvl_2 ;; Un juego tendra dos outputs, 0 -> Game Over, 1 -> Next level. Output en A!
            cp #0
            jp z, game_over
            call display_when_success
         
         nivel3:
            call play_lvl_3 ;; Un juego tendra dos outputs, 0 -> Game Over, 1 -> Next level. Output en A!
            cp #0
            jp z, game_over
            call display_when_success

         ;; 
         ;; BLOQUE FABRICA
         ;;
         nivel4:
            call play_lvl_4 ;; Un juego tendra dos outputs, 0 -> Game Over, 1 -> Next level. Output en A!
            cp #0
            jp z, game_over
            call display_when_success
         
         nivel5:
            call play_lvl_5 ;; Un juego tendra dos outputs, 0 -> Game Over, 1 -> Next level. Output en A!
            cp #0
            jp z, game_over

            cp #3 ;; Si el jugador ha entrado por el portal arcoiris, nos vamos al nivel especial!
            jp z, nivel_arco

            call display_when_success
         
         nivel6:
            call play_lvl_6 ;; Un juego tendra dos outputs, 0 -> Game Over, 1 -> Next level. Output en A!
            cp #0
            jp z, game_over
            call display_when_success
;
         ;; 
         ;; BLOQUE HUB CENTRAL
         ;;
         nivel7:
            call play_lvl_7 ;; Un juego tendra dos outputs, 0 -> Game Over, 1 -> Next level. Output en A!
            cp #0
            jp z, game_over
            call display_when_success
      
         nivel8:
            call play_lvl_8 ;; Un juego tendra dos outputs, 0 -> Game Over, 1 -> Next level. Output en A!
            cp #0
            jp z, game_over
            call display_when_success
   
         nivel9:
            call play_lvl_9 ;; Un juego tendra dos outputs, 0 -> Game Over, 1 -> Next level. Output en A!
            cp #0
            jp z, game_over
            call display_when_success
         nivel_boss:
            call play_lvl_boss ;; Un juego tendra dos outputs, 0 -> Game Over, 1 -> Next level. Output en A!
            cp #0
            jp z, game_over
            call stop_music
            call display_ending
            jp inicializar

         nivel_arco:
            call play_lvl_arco ;; Un juego tendra dos outputs, 0 -> Game Over, 1 -> Next level. Output en A!
            cp #0
            jp z, game_over

            ;; Si no es game_over, volvemos al nivel 5!
            jp nivel5
            
         jr .

      seleccionar_game_mode:
         call display_game_mode
         call choose_game_mode
         jp inicio_juego

      game_over:
         call play_gameover_music
         call display_end_game
         jp inicializar




