##-----------------------------LICENSE NOTICE------------------------------------
##  This file is part of CPCtelera: An Amstrad CPC Game Engine 
##  Copyright (C) 2018 ronaldo / Fremos / Cheesetea / ByteRealms (@FranGallegoBR)
##
##  This program is free software: you can redistribute it and/or modify
##  it under the terms of the GNU Lesser General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU Lesser General Public License for more details.
##
##  You should have received a copy of the GNU Lesser General Public License
##  along with this program.  If not, see <http://www.gnu.org/licenses/>.
##------------------------------------------------------------------------------
############################################################################
##                        CPCTELERA ENGINE                                ##
##                 Automatic image conversion file                        ##
##------------------------------------------------------------------------##
## This file is intended for users to automate image conversion from JPG, ##
## PNG, GIF, etc. into C-arrays.                                          ##
############################################################################

##
## NEW MACROS
##

## 16 colours palette
#PALETTE=0 1 2 3 6 9 11 12 13 15 16 18 20 24 25 26

## Default values
#$(eval $(call IMG2SP, SET_MODE        , 0                  ))  { 0, 1, 2 }
#$(eval $(call IMG2SP, SET_MASK        , none               ))  { interlaced, none }
#$(eval $(call IMG2SP, SET_FOLDER      , src/               ))
#$(eval $(call IMG2SP, SET_EXTRAPAR    ,                    ))
#$(eval $(call IMG2SP, SET_IMG_FORMAT  , sprites            ))	{ sprites, zgtiles, screen }
#$(eval $(call IMG2SP, SET_OUTPUT      , c                  ))  { bin, c }
#$(eval $(call IMG2SP, SET_PALETTE_FW  , $(PALETTE)         ))
#$(eval $(call IMG2SP, CONVERT_PALETTE , $(PALETTE), g_palette ))
#$(eval $(call IMG2SP, CONVERT         , img.png , w, h, array, palette, tileset))

#PALETTE=0 1 2 3 6 9 11 12 13 15 16 18 20 24 25 26
PALETTE=12 9 0 1 2 3 4 6 10 13 15 16 20 26 24 18
#dorado(808000) verde(008000) negro(000000) azul_osc(000080)
#azul_clr(0000ff) granate(800000) morado(800080) rojo(ff0000)
#cian(008080) gris(808080) naranja(ff8000) carne(ff8080)
#cian_clr(00ffff) blanco(ffffff) pendiente_amarillo(ffff00) pendiente_verde_clr(00ff00)

$(eval $(call IMG2SP, SET_PALETTE_FW  , $(PALETTE)))
$(eval $(call IMG2SP, SET_FOLDER      , src/sprites))
$(eval $(call IMG2SP, CONVERT_PALETTE , $(PALETTE), g_palette ))
$(eval $(call IMG2SP, CONVERT         , assets/bala.png , 2, 2, spr_bala,,))
$(eval $(call IMG2SP, CONVERT         , assets/pers_D.png , 8, 8, spr_pers_D,,))
$(eval $(call IMG2SP, CONVERT         , assets/pers_U.png , 8, 8, spr_pers_U,,))
$(eval $(call IMG2SP, CONVERT         , assets/pers_L.png , 8, 8, spr_pers_L,,))
$(eval $(call IMG2SP, CONVERT         , assets/pers_R.png , 8, 8, spr_pers_R,,))
$(eval $(call IMG2SP, CONVERT         , assets/Mina.png , 8, 8, spr_mina,,))
$(eval $(call IMG2SP, CONVERT         , assets/Valla.png , 8, 8, spr_valla,,))
$(eval $(call IMG2SP, CONVERT         , assets/Explosion.png , 8, 8, spr_explosion,,))
$(eval $(call IMG2SP, CONVERT         , assets/Heart.png , 8, 8, spr_heart,,))
$(eval $(call IMG2SP, CONVERT         , assets/Numeros.png , 8, 8, spr_numeros,,))
$(eval $(call IMG2SP, CONVERT         , assets/Base_rotatorio_L.png , 8, 8, spr_rotatorioL,,))
$(eval $(call IMG2SP, CONVERT         , assets/Base_rotatorio_R.png , 8, 8, spr_rotatorioR,,))
$(eval $(call IMG2SP, CONVERT         , assets/Torreta.png , 16, 16, spr_torreta,,))
$(eval $(call IMG2SP, CONVERT         , assets/Base_Cyborg_Chamber.png , 16, 16, spr_cchamber_h,,))
$(eval $(call IMG2SP, CONVERT         , assets/Base_Cyborg_Chamber_med.png , 16, 16, spr_cchamber_m,,))
$(eval $(call IMG2SP, CONVERT         , assets/Base_Cyborg_Chamber_low.png , 16, 16, spr_cchamber_l,,))
$(eval $(call IMG2SP, CONVERT         , assets/Arachnoid_down.png , 8, 8, spr_arachnoid_down,,))
$(eval $(call IMG2SP, CONVERT         , assets/Arachnoid_up.png , 8, 8, spr_arachnoid_up,,))
$(eval $(call IMG2SP, CONVERT         , assets/Base_Fire.png , 4, 3, spr_fire,,))
$(eval $(call IMG2SP, CONVERT         , assets/Puerta.png , 8, 8, spr_puerta,,))
$(eval $(call IMG2SP, CONVERT         , assets/Base_switch.png , 8, 4, spr_switch,,))
$(eval $(call IMG2SP, CONVERT         , assets/chica.png , 8, 16, spr_chica,,))
$(eval $(call IMG2SP, CONVERT         , assets/mono.png , 16, 16, spr_mono,,))
$(eval $(call IMG2SP, CONVERT         , assets/cyb_2.png , 8, 8, spr_cyborgR,,))



$(eval $(call IMG2SP, SET_IMG_FORMAT  , zgtiles            ))
$(eval $(call IMG2SP, CONVERT         , assets/tilemaps/Paleta_64.png , 8, 8, tiles,,))
$(eval $(call IMG2SP, SET_OUTPUT      , bin                  )) 
$(eval $(call IMG2SP, SET_IMG_FORMAT  , screen           ))
#$(eval $(call IMG2SP, CONVERT         , assets/menu_0.png , 160, 200, menu_0,,))
#$(eval $(call IMG2SP, CONVERT         , assets/menu_1.png , 160, 200, menu_1,,))
#$(eval $(call IMG2SP, CONVERT         , assets/menu_2.png , 160, 200, menu_2,,))
#$(eval $(call IMG2SP, CONVERT         , assets/menu_3.png , 160, 200, menu_3,,))
#$(eval $(call IMG2SP, CONVERT         , assets/menu_4.png , 160, 200, menu_4,,))
#$(eval $(call IMG2SP, CONVERT         , assets/menu_5.png , 160, 200, menu_5,,))
$(eval $(call IMG2SP, CONVERT         , assets/Menu.png , 160, 200, Menu,,))
#$(eval $(call IMG2SP, CONVERT         , assets/escenas_0.png , 160, 200, escenas_0,,))
#$(eval $(call IMG2SP, CONVERT         , assets/escenas_1.png , 160, 200, escenas_1,,))
#$(eval $(call IMG2SP, CONVERT         , assets/escenas_2.png , 160, 200, escenas_2,,))
#$(eval $(call IMG2SP, CONVERT         , assets/escenas_3.png , 160, 200, escenas_3,,))
$(eval $(call IMG2SP, CONVERT         , assets/Game_mode.png , 160, 200, Game_mode,,))


##
## OLD MACROS (For compatibility)
##

## Example firmware palette definition as variable in cpct_img2tileset format

#PALETTE={0 1 3 4 7 9 10 12 13 16 19 20 21 24 25 26}

## AUTOMATED IMAGE CONVERSION EXAMPLE (Uncomment EVAL line to use)
##
##    This example would convert img/example.png into src/example.{c|h} files.
##    A C-array called pre_example[24*12*2] would be generated with the definition
##    of the image example.png in mode 0 screen pixel format, with interlaced mask.
##    The palette used for conversion is given through the PALETTE variable and
##    a pre_palette[16] array will be generated with the 16 palette colours as 
##	  hardware colour values.

#$(eval $(call IMG2SPRITES,assets/zombie.png,0,sprite,8,8,$(PALETTE),mask,src/sprites,hwpalette))
#$(eval $(call IMG2SPRITES,assets/bala.png,0,sprite2,8,8,$(PALETTE),mask,src/sprites,hwpalette))
#$(eval $(call IMG2SPRITES,assets/personaje.png,0,sprite3,8,8,$(PALETTE),mask,src/sprites,hwpalette))




############################################################################
##              DETAILED INSTRUCTIONS AND PARAMETERS                      ##
##------------------------------------------------------------------------##
##                                                                        ##
## Macro used for conversion is IMG2SPRITES, which has up to 9 parameters:##
##  (1): Image file to be converted into C sprite (PNG, JPG, GIF, etc)    ##
##  (2): Graphics mode (0,1,2) for the generated C sprite                 ##
##  (3): Prefix to add to all C-identifiers generated                     ##
##  (4): Width in pixels of each sprite/tile/etc that will be generated   ##
##  (5): Height in pixels of each sprite/tile/etc that will be generated  ##
##  (6): Firmware palette used to convert the image file into C values    ##
##  (7): (mask / tileset / zgtiles)                                       ##
##     - "mask":    generate interlaced mask for all sprites converted    ##
##     - "tileset": generate a tileset array with pointers to all sprites ##
##     - "zgtiles": generate tiles/sprites in Zig-Zag pixel order and     ##
##                  Gray Code row order                                   ##
##  (8): Output subfolder for generated .C/.H files (in project folder)   ##
##  (9): (hwpalette)                                                      ##
##     - "hwpalette": output palette array with hardware colour values    ##
## (10): Aditional options (you can use this to pass aditional modifiers  ##
##       to cpct_img2tileset)                                             ##
##                                                                        ##
## Macro is used in this way (one line for each image to be converted):   ##
##  $(eval $(call IMG2SPRITES,(1),(2),(3),(4),(5),(6),(7),(8),(9), (10))) ##
##                                                                        ##
## Important:                                                             ##
##  * Do NOT separate macro parameters with spaces, blanks or other chars.##
##    ANY character you put into a macro parameter will be passed to the  ##
##    macro. Therefore ...,src/sprites,... will represent "src/sprites"   ##
##    folder, whereas ...,  src/sprites,... means "  src/sprites" folder. ##
##                                                                        ##
##  * You can omit parameters but leaving them empty. Therefore, if you   ##
##  wanted to specify an output folder but do not want your sprites to    ##
##  have mask and/or tileset, you may omit parameter (7) leaving it empty ##
##     $(eval $(call IMG2SPRITES,imgs/1.png,0,g,4,8,$(PAL),,src/))        ##
############################################################################
