;;----------------------------------------LICENSE NOTICE----------------------------------------
;;	_________ __________ __   _______ ______ ______ ___     ___ ______ ______ _________			
;;	\______   \______   /  \ /__   __/__   __\ ____\   \   /   /  __  /__   __\   _____\		
;;	      /  /      /  / /\ \   | |     | |  | \___/    \_/    \  \_\ \  | |   \  \_____		
;;	     /  /      /  /  __  \  | |     | |  |  ___\  \ ___ /  /  ____/  | |    \_____  \		
;;	    /  /      /  /  /  \  \ | |     | |  | /___/  /     \  \  \      | |      ____\  \		
;;	   /_ /      /_ /__/    \__\|_|     |_|  /_____\__\     /__/__/      |_|     \________\		
;;
;;  Code & Gfx Copyright (C) 2018 Alvaro Jover (@vorixo), Jordi Amoros (@byFlowee) 
;;	and Cristian Garcia (@cgr71ii)
;;  Music & Fx Copyright (C) 2018 Alvaro Jover (@vorixo)
;;  This file is part of 77 ATTEMPTS: an Amstrad CPC Game made with CPCTelera
;;
;;  This program is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  This program is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU General Public License for more details.
;;
;;  You should have received a copy of the GNU General Public License
;;  along with this program.  If not, see <http://www.gnu.org/licenses/>.
;;----------------------------------------------------------------------------------------------

.globl ru_getCurrentVM
.globl ru_getBackVM
.globl ru_initBackBuffer
.globl ru_drawMaskedEntity
.globl ru_gretScreenPointerOnDEBasedOnPosition ;; TBD: erase?
.globl ru_drawContextMenuFrame
.globl ru_drawText
.globl ru_switchBuffer
.globl ru_fadeIn
.globl ru_fadeOut
.globl ru_getVmOffset
 
NVSYNCS_FADE_IN_OUT = 2

;;========================================================================================
;; See: http://lronaldo.github.io/cpctelera/files/sprites/transparency_table_macros-h.html
;; This macro redefines in assembly the transparency table for MODE 0 in PEN 0.
;;========================================================================================
.macro MASKTABLE0M0
      .db 0xFF, 0xAA, 0x55, 0x00, 0xAA, 0xAA, 0x00, 0x00
      .db 0x55, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0xAA, 0xAA, 0x00, 0x00, 0xAA, 0xAA, 0x00, 0x00
      .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0x55, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0x55, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0xAA, 0xAA, 0x00, 0x00, 0xAA, 0xAA, 0x00, 0x00
      .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0xAA, 0xAA, 0x00, 0x00, 0xAA, 0xAA, 0x00, 0x00
      .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0x55, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0x55, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0x55, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0x55, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
      .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
.endm

;;
;; The trans table needs to be on a memory aligned area where to write this information
;;
.equ trans_table_loc, 0x100 ; or 0x1000... ect 

;;========================================================================================
;; This macro is the assembly version of:
;; cpctm_createTransparentMaskTable(TABLENAME,ADDRESS,MODE,PEN)
;; It won't generate this code unless the user decides to.
;;========================================================================================
.macro ru_createMaskTable
    .area MT_TABLE (ABS)		;; Table name
    .org trans_table_loc					;; Memory aligned area where to write this information
    MASKTABLE0M0				;; Literal table we are going to work with
    .area _CSEG (REL, CON)		;; 
.endm