;;----------------------------------------LICENSE NOTICE----------------------------------------
;;	_________ __________ __   _______ ______ ______ ___     ___ ______ ______ _________			
;;	\______   \______   /  \ /__   __/__   __\ ____\   \   /   /  __  /__   __\   _____\		
;;	      /  /      /  / /\ \   | |     | |  | \___/    \_/    \  \_\ \  | |   \  \_____		
;;	     /  /      /  /  __  \  | |     | |  |  ___\  \ ___ /  /  ____/  | |    \_____  \		
;;	    /  /      /  /  /  \  \ | |     | |  | /___/  /     \  \  \      | |      ____\  \		
;;	   /_ /      /_ /__/    \__\|_|     |_|  /_____\__\     /__/__/      |_|     \________\		
;;
;;  Code & Gfx Copyright (C) 2018 Alvaro Jover (@vorixo), Jordi Amoros (@byFlowee) 
;;	and Cristian Garcia (@cgr71ii)
;;  Music & Fx Copyright (C) 2018 Alvaro Jover (@vorixo)
;;  This file is part of 77 ATTEMPTS: an Amstrad CPC Game made with CPCTelera
;;
;;  This program is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  This program is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU General Public License for more details.
;;
;;  You should have received a copy of the GNU General Public License
;;  along with this program.  If not, see <http://www.gnu.org/licenses/>.
;;----------------------------------------------------------------------------------------------

.area _DATA
.area _CODE

.include "cpctglobals.h.s"
.include "gamemanager/menu.h.s"
.include "gamemanager/game.h.s"
.include "renderutils.h.s"

;;=====================================================================================================================
;; MAIN INDICATIONS:
;; Z80CODELOC is set at 0x1000 in build_config.mk, this means that our program will start @ 0x1000 mem address.
;; This give us room to be able to store things from 0x0040 to 0x1000. Be careful with cpct_drawCharM1 and subvariants
;; http://lronaldo.github.io/cpctelera/files/strings/cpct_drawCharM1-s.html 
;; "Do not put this function’s code below 0x4000 in memory."
;;=====================================================================================================================

;; Main palette definition
.globl _g_palette

;;=============================================
;; Initializes the cpc
;;=============================================
initialize_cpc:
    ;; Initialize systems
    ;; Disable firmware
    call cpct_disableFirmware_asm  

    ;; Set video mode
    ld      c, #0
    call cpct_setVideoMode_asm

    ;; Setting the palette                                                                          ;; \
    ld hl, #_g_palette                                                                              ;; |
    ld de, #16                                                                                      ;; | TBD: Consider moving out of init cpc since this will exec once when we start the cpc and no more    
    call cpct_setPalette_asm                                                                        ;; | If we want to change palette in the middle of the game this should go on initialize_menu.

    call ru_initBackBuffer
                                                                                                    ;; |  
    ru_createMaskTable      ;; Creating the mask table for transparencies at 0x0100                 ;; /

    ret


;;=============================================
;; Main program entry
;;=============================================
_main::

    ld sp, #0x8000              ;; Move stack to 0x8000 since we'll be using double buffer
    call initialize_cpc

    ;; Main Loop
    main_loop:
        ;; Menu intialisation
        call mn_initialize_menu
        call mn_loop_menu
        ;; Game loop
        call gm_startgame
    jr main_loop