;;----------------------------------------LICENSE NOTICE----------------------------------------
;;	_________ __________ __   _______ ______ ______ ___     ___ ______ ______ _________			
;;	\______   \______   /  \ /__   __/__   __\ ____\   \   /   /  __  /__   __\   _____\		
;;	      /  /      /  / /\ \   | |     | |  | \___/    \_/    \  \_\ \  | |   \  \_____		
;;	     /  /      /  /  __  \  | |     | |  |  ___\  \ ___ /  /  ____/  | |    \_____  \		
;;	    /  /      /  /  /  \  \ | |     | |  | /___/  /     \  \  \      | |      ____\  \		
;;	   /_ /      /_ /__/    \__\|_|     |_|  /_____\__\     /__/__/      |_|     \________\		
;;
;;  Code & Gfx Copyright (C) 2018 Alvaro Jover (@vorixo), Jordi Amoros (@byFlowee) 
;;	and Cristian Garcia (@cgr71ii)
;;  Music & Fx Copyright (C) 2018 Alvaro Jover (@vorixo)
;;  This file is part of 77 ATTEMPTS: an Amstrad CPC Game made with CPCTelera
;;
;;  This program is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  This program is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU General Public License for more details.
;;
;;  You should have received a copy of the GNU General Public License
;;  along with this program.  If not, see <http://www.gnu.org/licenses/>.
;;----------------------------------------------------------------------------------------------

SCREEN_WIDTH  = 80      ;; Amstrad CPC screen width
SCREEN_HEIGHT = 200     ;; Amstrad CPC screen height

;; Num of tiles width and height
LEVEL_TILES_W =  20
LEVEL_TILES_H =  23
LVL_TOTAL =	LEVEL_TILES_W * LEVEL_TILES_H

;; Tiles size. All tiles in this game have this size
TILE_W = 	4
TILE_H = 	8
TILE_TOTAL = TILE_W * TILE_H
MAP_ORIGIN_X = 0
MAP_ORIGIN_Y = 2 * TILE_H
MAP_OFFSET_Y = 2 * 0x50
MAP_END_X    = SCREEN_WIDTH     ;; Screen width
MAP_END_Y    = SCREEN_HEIGHT    ;; Screen height

;; Constants for collisions
RANGE_ID_LAST = 0x80
RANGE_DEFAULT_VALUE_IF_NOT_FOUND = 0xFF

;; Constants for hero handling
WJ_TICKS = 8


;; GAME LOGIC MANAGEMENT
CURRENTLVLINPROGRESS 	= 0
MAINMENU				= 1
RESTART 				= 2
NEXTLEVEL 				= 3

;; Memory constants
MEM_BEGIN_DECOMPRESSED_MAP = 0x900 			
MEM_BEGIN_DECOMPRESSED_TITLE = 0x900 	;; The title gets vanished by the map 
MEM_NEXT_DECOMPRESSED_TITLE = MEM_BEGIN_DECOMPRESSED_TITLE+2360

;; Max number of levels
MAX_LEVEL_NUM = 56 ;; we have currently 50, 0 to 48 + 1 (end of the game) 

BLACK_COLOR_M1 = 0b00000000
GREY_COLOR_M1  = 0b00000011
WHITE_COLOR_M1 = 0b11111111
