;;----------------------------------------LICENSE NOTICE----------------------------------------
;;	_________ __________ __   _______ ______ ______ ___     ___ ______ ______ _________			
;;	\______   \______   /  \ /__   __/__   __\ ____\   \   /   /  __  /__   __\   _____\		
;;	      /  /      /  / /\ \   | |     | |  | \___/    \_/    \  \_\ \  | |   \  \_____		
;;	     /  /      /  /  __  \  | |     | |  |  ___\  \ ___ /  /  ____/  | |    \_____  \		
;;	    /  /      /  /  /  \  \ | |     | |  | /___/  /     \  \  \      | |      ____\  \		
;;	   /_ /      /_ /__/    \__\|_|     |_|  /_____\__\     /__/__/      |_|     \________\		
;;
;;  Code & Gfx Copyright (C) 2018 Alvaro Jover (@vorixo), Jordi Amoros (@byFlowee) 
;;	and Cristian Garcia (@cgr71ii)
;;  Music & Fx Copyright (C) 2018 Alvaro Jover (@vorixo)
;;  This file is part of 77 ATTEMPTS: an Amstrad CPC Game made with CPCTelera
;;
;;  This program is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  This program is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU General Public License for more details.
;;
;;  You should have received a copy of the GNU General Public License
;;  along with this program.  If not, see <http://www.gnu.org/licenses/>.
;;----------------------------------------------------------------------------------------------

.include "cpctglobals.h.s"
.include "globals.h.s"
.include "mapmanager.h.s"
.include "renderutils.h.s"
.include "gamemanager/serialization/serializeddata.h.s"
.include "entities/hero.h.s"
.include "sprites/compressed/game_title.h.s"
.include "gamemanager/game.h.s"
.include "gameplaystatics.h.s"
.include "keyboard/keyboard.h.s"
.include "music/MainMenuMusic.h.s"

.area _DATA
  present_text:     .asciz "UDesign presents"
  mn_menu_play: .asciz "1. START GAME"
  mn_menu_selc: .asciz "2. ENTER CODE"
  mn_menu_ctr: .asciz  "3. REMAP KEYS"
  mn_choose_hero: .asciz  "CHOOSE YOUR HERO"
  mn_alvaro: .asciz "A.Jover"
  mn_jordi:  .asciz "J.Amoros"
  mn_cris:   .asciz "C.Garcia"
  mn_lvlunderscore:   .asciz "000"
  mn_lvl0:   .asciz "0"
  mn_lvl1:   .asciz "1"
  mn_lvl2:   .asciz "2"
  mn_lvl3:   .asciz "3"
  mn_lvl4:   .asciz "4"
  mn_lvl5:   .asciz "5"
  mn_lvl6:   .asciz "6"
  mn_lvl7:   .asciz "7"
  mn_lvl8:   .asciz "8"
  mn_lvl9:   .asciz "9"
  mn_pointer:   .asciz "   ^"
  mn_notvalid: .asciz "BAD CODE"
  mn_moveright:.asciz "RIGHT"
  mn_moveleft: .asciz "LEFT "
  mn_jump:     .asciz "JUMP "
.area _CODE


;;===================================================================
;;  It decompresses the main title
;;  DESTROYS: AF, BC, DE, HL
;;===================================================================
mn_decompress_gametitle:
  ld hl, #_game_title_end              ;; HL += BC = map compressed addr + map compressed size (last position of array + 1)  
  push hl               ;; Save HL
  ld hl, #MEM_BEGIN_DECOMPRESSED_TITLE  ;; HL = begin of memory where decompressed map will be stored
  ld de, #_game_title_size
  add hl, de              ;; HL += DE = MEM_BEGIN_DECOMPRESSED_MAP + map decompressed size (last position of array + 1)
  dec hl                ;; HL-- = last position of array in map decompressed
  ld d, h               ;; |
  ld e, l               ;; \ DE = HL = last position of array in map decompressed
  pop hl                ;; Restore HL = last position of array in map compressed
  jp cpct_zx7b_decrunch_s_asm   ;; Decompress map in MEM_BEGIN_DECOMPRESSED_MAP


;;===================================================================
;; It initializes the menu resetting all the values to 0 as necesary
;; DESTROYS: AF, BC, DE, HL
;;===================================================================
mn_initialize_menu::
  ;; stoping previous music and reseting the interrupt handler
  call StopMusicRmvIsr

  ld hl, #0x0410
  call cpct_setPALColour_asm

	;; Cleaning the screen 
	call cpct_waitVSYNC_asm
	call ru_getCurrentVM	  ;; Start of the video memory
	ld bc, #0x4000 				  ;; |
	ld a, #0x0C 				    ;; | Color to drawn on all the vid memory
	call cpct_memset_asm 		;; Clearing the screen with a color
	call cpct_waitVSYNC_asm

	;; Init main menu music
  ld de, #_menu_music
  call cpct_akp_musicInit_asm


  ;;========================================
  ;; Game manager resets (start game from 0)
  ;;========================================
	;; Initialize map manager to first level
	ld a, #00                         ;; Id of the map we want to go to
  call mm_gotoSpecificMap           ;; This routine sets the map_num to the content stored on a
  ld a, #HERO_MAX_LIVES         
  ;call hero_set_num_lives           ;; Sets the default value of lives the character has
  ;call hero_reset_values            ;; we need to reset the hero in case we want to change the hero selection
	;ret
  ld hl, #hero_reset_values
  push hl
  jp hero_set_num_lives

;;===================================================================
;; Draws the background menu art
;; DESTROYS: AF, BC, DE, HL
;;===================================================================
.globl _hero_eye_sprite
mn_drawBackgroundMenu:
	   
  call ru_getCurrentVM
  ld bc, #0x4000          ;; |
  ld a, #0xFF             ;; | Color to drawn on all the vid memory
  call cpct_memset_asm      ;; Clearing the screen with a color
  call cpct_waitVSYNC_asm
  call mn_decompress_gametitle  ;; we decompress the game title

  ;; Painting title
  ;; Calculate Screen position
  ld   bc, #0x0000                             ;; C=Entity_X | B=Entity_Y
  call ru_gretScreenPointerOnDEBasedOnPosition
  ;;Draw Sprite
  ld      hl,  #MEM_BEGIN_DECOMPRESSED_TITLE
  ld      bc,  #0x3B28
  call cpct_drawSprite_asm
  ;; Calculate Screen position
  ld   bc, #0x0028                             ;; B=Entity_Y
  call ru_gretScreenPointerOnDEBasedOnPosition
  ;;Draw Sprite
  ld      hl, #MEM_NEXT_DECOMPRESSED_TITLE
  ld bc, #0x3B28
  call cpct_drawSprite_asm
  
  ;; Painting hero eyes
  ;; Calculate Screen position
  ld   bc, #0x4316                             ;; B=Entity_Y
  call ru_gretScreenPointerOnDEBasedOnPosition
  ;;Draw Sprite
  ld      hl,  #_hero_eye_sprite
  ld bc, #0x140A
  call cpct_drawSprite_asm
   ;; Calculate Screen position
  ld   bc, #0x4330                             ;; B=Entity_Y
  call ru_gretScreenPointerOnDEBasedOnPosition
  ;;Draw Sprite
  ld      hl,  #_hero_eye_sprite
  ld bc, #0x140A
  call cpct_drawSprite_asm

  ;; Painting black box for the menu
  ld   bc, #0x5A0A                             ;; B=Entity_Y
  call ru_gretScreenPointerOnDEBasedOnPosition
  ld a, #0x00
  ld bc, #0x3C3C
  call cpct_drawSolidBox_asm

  ;; Draw menu options
  ld    hl, #0x000f                   ;; H = Background PEN (0)
  ld    bc, #0x640C                    ;; text position y
  ld   iy, #mn_menu_play   ;; IY = Pointer to the start of the string
  call ru_drawText
  ld    hl, #0x000f                   ;; H = Background PEN (0)
  ld    bc, #0x730C                    ;; text position y
  ld   iy, #mn_menu_selc   ;; IY = Pointer to the start of the string
  call ru_drawText
  ld    hl, #0x000f                   ;; H = Background PEN (0)
  ld    bc, #0x820C                    ;; text position y
  ld   iy, #mn_menu_ctr   ;; IY = Pointer to the start of the string
  call ru_drawText

  ;; Draw fake border for the credits
  ld   bc, #0xAF00                             ;; B=Entity_Y
  call ru_gretScreenPointerOnDEBasedOnPosition
  ld a, #0xC0                            ;; Fake border end
  ld bc, #0x1928
  call cpct_drawSolidBox_asm
  ld   bc, #0xAF28                             ;; B=Entity_Y
  call ru_gretScreenPointerOnDEBasedOnPosition
  ld a, #0xC0                           ;; Fake border end
  ld bc, #0x1928
  call cpct_drawSolidBox_asm
  
  ;; Credits
  ld    hl, #0x010d                   ;; H = Background PEN (0)
  ld    bc, #0xBE05                    ;; text position y
  ld   iy, #mn_alvaro   ;; IY = Pointer to the start of the string
  call ru_drawText
  ld    hl, #0x010d                   ;; H = Background PEN (0)
  ld    bc, #0xBE2D                    ;; text position y
  ld   iy, #mn_jordi   ;; IY = Pointer to the start of the string
  call ru_drawText
  ld    hl, #0x010d                   ;; H = Background PEN (0)
  ld    bc, #0xB419                    ;; text position y
  ld   iy, #mn_cris   ;; IY = Pointer to the start of the string
  jp ru_drawText


;;===================================================================
;; Function that will take care of playing the music and anims
;; of the menu thanks to the continuous interruptions
;; DESTROYS: AF, BC, DE, HL
;;===================================================================
mn_interruptHandler:
  ;; Plays the music
  jp FiftyHzMusicPlayer

;;===================================================================
;; Lets you pick a character if the game was completed at least once
;;===================================================================
mn_char_selector::
  call gm_getGameWasCompleted
  or a
  ret z
  ;; Game was completed once
  call ru_getCurrentVM
  ld bc, #0x4000          ;; |
  ld a, #0x00             ;; | Color to drawn on all the vid memory
  call cpct_memset_asm      ;; Clearing the screen with a color
  call cpct_waitVSYNC_asm

  ld   bc, #0x551E                              ;; C=Entity_X
  call ru_gretScreenPointerOnDEBasedOnPosition
  ;;Draw Sprite
  ld      hl,  #_hero_sprites_0
  ld      bc, #0x0804
  call cpct_drawSprite_asm 
  ld   bc, #0x552D                              ;; C=Entity_X
  call ru_gretScreenPointerOnDEBasedOnPosition
  ;;Draw Sprite
  ld      hl,  #_princess_sprite_0
  ld      bc, #0x0804
  call cpct_drawSprite_asm 

  ld    hl, #0x000f                   ;; H = Background PEN (0)
  ld    bc, #0x4008                    ;; text position y
  ld   iy, #mn_choose_hero   ;; IY = Pointer to the start of the string
  call ru_drawText
  ld    hl, #0x000f                   ;; H = Background PEN (0)
  ld    bc, #0x651E                    ;; text position y
  ld   iy, #mn_lvl1   ;; IY = Pointer to the start of the string
  call ru_drawText
  ld    hl, #0x000f                   ;; H = Background PEN (0)
  ld    bc, #0x652D                    ;; text position y
  ld   iy, #mn_lvl2   ;; IY = Pointer to the start of the string
  call ru_drawText

  ld d, #100
  call waitNVSYNCs 

  mn_selector_key_handling:
    ;; Check for Key '1' being pressed
    call cpct_scanKeyboard_asm

    ld      hl, #Key_1              ;; HL=Key_1 Keycode
    call    cpct_isKeyPressed_asm   ;; Check if Key_1 is pressed
    or      a                      ;; Check A == 0
    jr      z, mn_skh_one_not_pressed        ;; Resume game if 1 was pressed

      ;; 1 Set hero sprite
      ld a, #00
      ;call hero_set_sprite_mem
      ;call cpct_waitVSYNC_asm
      ;ret
      ld hl, #cpct_waitVSYNC_asm
      push hl
      jp hero_set_sprite_mem

     mn_skh_one_not_pressed:
    ;; Check for Key '2' being pressed
    ld      hl, #Key_2              ;; HL=Key_2 Keycode
    call    cpct_isKeyPressed_asm   ;; Check if Key_2 is pressed
    or      a                      ;; Check A == 0
    jr      z, mn_selector_key_handling        ;; Restart the level if 2 was pressed

        ;; 2 Set princess sprite
        ld a, #01
        ;call hero_set_sprite_mem
        ;call cpct_waitVSYNC_asm
        ;ret
        ld hl, #cpct_waitVSYNC_asm
        push hl
        jp hero_set_sprite_mem

  jr nz, mn_selector_key_handling
ret

;;===================================================================
;; Main menu execution loop
;; DESTROYS: AF, BC, DE, HL
;;===================================================================
mn_loop_menu::
  
  call mn_drawBackgroundMenu

  ;; Raster sync
  call cpct_waitVSYNC_asm
  halt
  halt
  call cpct_waitVSYNC_asm

  ;; Setting the interrupHandler
  ld hl, #mn_interruptHandler
  call cpct_setInterruptHandler_asm

  ;fade(IN);
  ;cpct_setPALColour (16, 0x44);

  ;; Menu key handling
  mn_menu_key_handling:
    ;; Check for Key '1' being pressed
    call cpct_scanKeyboard_asm

      ld      hl, #Key_1              ;; HL=Key_1 Keycode
      call    cpct_isKeyPressed_asm   ;; Check if Key_1 is pressed
      or      a                      ;; Check A == 0
      jr      z, mn_one_not_pressed        ;; Resume game if 1 was pressed

        ;; 1 is pressed
        ;call cpct_waitVSYNC_asm
        ;call mn_char_selector
        ;ret
        ld hl, #mn_char_selector
        push hl
        jp cpct_waitVSYNC_asm

      mn_one_not_pressed:
      ;; Check for Key '2' being pressed
      ld      hl, #Key_2              ;; HL=Key_2 Keycode
      call    cpct_isKeyPressed_asm   ;; Check if Key_2 is pressed
      or      a                      ;; Check A == 0
      jr      z, mn_two_not_pressed        ;; Restart the level if 2 was pressed

          ;; 2 is pressed
          ld d, #30
          ;call waitNVSYNCs 
          ;call mn_entercode
          ;ret
          ld hl, #mn_entercode
          push hl
          jp waitNVSYNCs
        
      mn_two_not_pressed:
      ;; Check for Key '3' being pressed
      ld      hl, #Key_3               ;; HL=Key_3 Keycode
      call    cpct_isKeyPressed_asm   ;; Check if Key_3 is pressed
      or      a                      ;; Check a == 0
      jr      z, mn_menu_key_handling ;; Go to main menu if 3 was pressed

          ;; 3 is pressed
          ld d, #30
          ;call waitNVSYNCs 
          ;call mn_rebindkeys
          ;ret
          ld hl, #mn_rebindkeys
          push hl
          jp waitNVSYNCs

  jr nz, mn_menu_key_handling

  ret

;;================================================
;; Sets the number pressed in the following array
;; DESTROYS: IX, HL, DE, CB, AF
;;================================================
num_pressed:    ;; This array holds the numbers the user pressed
  .db #00
  .db #00
  .db #00
mn_insert_code_number:
  ld ix, #num_pressed
  ld a, (press_times)           ;; Based on the press times we do one operation or another
  ld c, a                       ;; C stores the press times
  ld a, #2                      ;; Numbers get introduced from left to right, thats why we reverse it
  sub c                         ;; reversing numbers introduced by the user
  or a
  jr z, mn_res_code_write_num
  mn_loop_resolve_num_press:
    inc ix
    dec a
  jr nz, mn_loop_resolve_num_press
  mn_res_code_write_num:
  ld 0(ix), b                   ;; we refresh the position of the number introduced
  ret

;;================================================
;; Converts the three digits introduced on a number
;; DESTROYS: IX, HL, DE, CB, AF
;;================================================
mn_resolvenumpressed:
  ld ix, #num_pressed         
  ld h, #0
  ld l,  0(ix)         ;; first digit
  
  push hl
  ld a, 1(ix)         ;; second digit
  ld de, #10
  call mul16
  ex de, hl
  pop hl 
  add hl, de

  push hl
  ld a, 2(ix)         ;; third digit
  ld de, #100         ;; we multiply it *100 to get the num
  call mul16          ;; 1 + 2*10 + 3*100 = 321
  ex de, hl
  pop hl 
  add hl, de
  ret


;;================================================
;; Contextual menu for key rebinding
;; DESTROYS: IY, HL, DE, AF , BC
;;================================================
mn_rebindkeys:
  call ru_drawContextMenuFrame  ;; Drawing a frame to place the code
  ;; we track only 3 actions, right, left and jump, they need ot be in order
  ld e, #3
  call get_keyboard_ix
  mn_rk_loop:
    push ix
    push de
    ld a, e
    cp #3
    jr z, mn_rk_three
    cp #2
    jr z, mn_rk_two
    cp #1
    jr z, mn_rk_one
    mn_rk_three:
    ld iy, #mn_moveright
    jr rb_mn_continue
    mn_rk_two:
    ld iy, #mn_moveleft
    jr rb_mn_continue
    mn_rk_one:
    ld iy, #mn_jump
    rb_mn_continue:
    ld    hl, #0x000E                    ;; L = Foreground PEN (3)
    ld    bc, #0x5F1E                      ;; text position xy
    call ru_drawText
    call waitForKey
    or a          ;; If there are no keys pressed we don't need to wait for it to be released
    pop de
    pop ix
    jr z, mn_rk_loop
      ;; A key was pressed
      ld 0(ix), l           ;; assigning the pressed key to the user_keyboard_definitions
      ld 1(ix), h           ;; |
      ld bc, #04            ;; The next key is 4 bytes ahead
      add ix, bc            ;; |
      push de               ;; |
      call waitKeyReleased  ;; we wait for the key to be released
      pop de
      dec e
  jr nz, mn_rk_loop
  jp mn_loop_menu                 ;; GOTO main menu


;;================================================
;; Contextual menu for code enter
;; DESTROYS: IY, HL, DE, AF
;;================================================
realnumber_pressed: .dw #0000
mn_entercode:
  call ru_drawContextMenuFrame  ;; Drawing a frame to place the code
  ;; Drawing default text: 000
  ld de, #mn_lvlunderscore          ;; de holds the string reference to modify
  ld hl, #0000
  call Num2Dec8b 
  call mn_drawmn_lvlunderscore

  ;; Menu key handling
  ld a, #0                    ;; Reseting variables for a new branc code to be entered
  ld (press_times), a         ;; |
  ld ix, #num_pressed         ;; | 
  ld 0(ix), #00               ;; |
  ld 1(ix), #00               ;; |
  ld 2(ix), #00               ;; |
  mn_entercode_key_handling:
    call mn_drawpointer
    call mn_keyboardhandler_words
    call mn_resolvenumpressed
    ld (realnumber_pressed), hl
    ld de, #mn_lvlunderscore          ;; de holds the string reference to modify
    call Num2Dec8b                    ;; we convert the number in string
    call mn_drawmn_lvlunderscore
    ld a, (press_times)
    cp #3
  jr nz, mn_entercode_key_handling
  
  ld d, #30         ;; | we wait some time to retrieve code result
  call waitNVSYNCs  ;; |

  ;; we check wether or not the code is valid
  ld hl, (realnumber_pressed)
  ld a, #0
  cp h                                  ;; if h is not 0, then its for sure a nun valid level, since we don't support more than 255 levels
  jr c, not_valid                       ;; |
  cp l                                  ;; check wether or not l is 0
  jr z, not_valid                       ;; if l is 0 then non valid aswell since we start at 1
  ld a, #MAX_LEVEL_NUM                  ;; We compare if the number introduced is in our range of levels
  cp l                                  ;; if the level is outside the range (stored in l)
  jr c, not_valid                       ;; then we travel to not_valid and show the non_valid message
  ld a, l                               ;; |
  dec a                                 ;; | levels go from 0 to n
  ;call mm_gotoSpecificMap               ;; | we travel to the valid map
  ;call mn_char_selector                 ;; we let the user select character (in case he can)
  ;ret 
  ld hl, #mn_char_selector
  push hl
  jp mm_gotoSpecificMap

  not_valid:
    call ru_drawContextMenuFrame  ;; Drawing a frame to place the code
    ld    hl, #0x000E                    ;; H = Background PEN (0) | L = Foreground PEN (3)
    ld    bc, #0x5F16                      ;; text position x y
    ld   iy, #mn_notvalid             ;; IY = Pointer to the start of the string
    call ru_drawText
    ld d, #100                    
    ;call waitNVSYNCs                  ;; we let the user read he entered a bad code
    ;call mn_loop_menu                 ;; GOTO main menu
    ;ret
    ld hl, #mn_loop_menu
    push hl
    jp waitNVSYNCs

mn_drawmn_lvlunderscore:
    ld    hl, #0x000F                    ;; H = Background PEN (0)
    ld    bc, #0x5A20                      ;; text position y
    ld   iy, #mn_lvlunderscore        ;; IY = Pointer to the start of the string
    jp ru_drawText

;;================================================
;; Main advanced keyboard handler for code control
;; DESTROYS: IY, HL, DE, AF
;;================================================
mn_keyboardhandler_words:
    call waitForKey
    or a          ;; If there are no keys pressed we don't need to wait for it to be released
    ret z
    call waitKeyReleased  ;; hasta aqui okay --------------------
    call mn_ispressedkeyvalid
    or a
    ret z
    call mn_insert_code_number
    ld a, (press_times)
    inc a
    ld (press_times), a
    ret 

;;================================================
;; It draws a pointer where we are writing
;; DESTROYS: AF, CB, DE, HL, IY
;;================================================
mn_drawpointer:
    ld a, (press_times)
    or a
    ld c, #20
    jr z, mn_draw_the_pointer_now
    
    ld d, a
    loop_mul_mn_dp:
      add #3
      dec d
    jr nz, loop_mul_mn_dp

    add c                          ;; text position x
    ld c, a
    
    mn_draw_the_pointer_now:
    ld    hl, #0x000F                    ;; H = Background PEN (0)s
    ld    b, #100                     ;; text position y
    ld   iy, #mn_pointer        ;; IY = Pointer to the start of the string
    jp ru_drawText

;;================================================
;; Main advanced keyboard handler for code control
;; DESTROYS: IY, HL, DE, AF
;;================================================
press_times: .db #00
valid_keys: 
.dw #Key_0
.dw #Key_1
.dw #Key_2
.dw #Key_3
.dw #Key_4
.dw #Key_5
.dw #Key_6
.dw #Key_7
.dw #Key_8
.dw #Key_9
;;============================================================
;; Returns in A if the pressed key for this context is valid
;; DESTROYS: BC, IX, DE
;; RETURNS: A 00 (not a valid key) | A 01 (valid key)
;;============================================================
mn_ispressedkeyvalid:
  ld b, #10           ;; B is going to be our index
  ld ix, #valid_keys  ;; |
  ld de, #18          ;; |
  add ix, de          ;; We add 18 because we have 10 keys each one is 2 bytes, so we get the last one doing this
  
  mn_ipkv_iterate_keys:
    ld d, 1(ix)       ;; | Because of little endian we retrieve the keys in reverse
    ld e, 0(ix)       ;; |
    cmp_hl_de         ;; This macro compares hl with de
    jr nz, mn_ipkv_check_next_key

      ;; if hl and de are equal then:
      dec b     ;; b-1 is the number we want to introduce
      ld a, #01
      ret
    
    mn_ipkv_check_next_key:
    dec ix
    dec ix
    dec b
  jr nz, mn_ipkv_iterate_keys
  ld a, #00
  ret

