;;----------------------------------------LICENSE NOTICE----------------------------------------
;;	_________ __________ __   _______ ______ ______ ___     ___ ______ ______ _________			
;;	\______   \______   /  \ /__   __/__   __\ ____\   \   /   /  __  /__   __\   _____\		
;;	      /  /      /  / /\ \   | |     | |  | \___/    \_/    \  \_\ \  | |   \  \_____		
;;	     /  /      /  /  __  \  | |     | |  |  ___\  \ ___ /  /  ____/  | |    \_____  \		
;;	    /  /      /  /  /  \  \ | |     | |  | /___/  /     \  \  \      | |      ____\  \		
;;	   /_ /      /_ /__/    \__\|_|     |_|  /_____\__\     /__/__/      |_|     \________\		
;;
;;  Code & Gfx Copyright (C) 2018 Alvaro Jover (@vorixo), Jordi Amoros (@byFlowee) 
;;	and Cristian Garcia (@cgr71ii)
;;  Music & Fx Copyright (C) 2018 Alvaro Jover (@vorixo)
;;  This file is part of 77 ATTEMPTS: an Amstrad CPC Game made with CPCTelera
;;
;;  This program is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  This program is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU General Public License for more details.
;;
;;  You should have received a copy of the GNU General Public License
;;  along with this program.  If not, see <http://www.gnu.org/licenses/>.
;;----------------------------------------------------------------------------------------------

.area _DATA
.area _CODE

.include "cpctglobals.h.s"
.include "renderutils.h.s"
.include "entities/entity.h.s"
.include "gameplaystatics.h.s"
.include "globals.h.s"
.include "macros/cpct_maths.h.s"
.include "mapmanager.h.s"

;;
;; Tileset globl
;;

;; TBD: Erase offsets calculus if we are not going to use them. 
;; Map includes:
.include "maps/compressed/cmp_map_0.h.s"
.include "maps/compressed/cmp_map_1.h.s"
.include "maps/compressed/cmp_map_2.h.s"
.include "maps/compressed/cmp_map_3.h.s"
.include "maps/compressed/cmp_map_4.h.s"
.include "maps/compressed/cmp_map_5.h.s"
.include "maps/compressed/cmp_map_6.h.s"
.include "maps/compressed/cmp_map_7.h.s"
.include "maps/compressed/cmp_map_8.h.s"
.include "maps/compressed/cmp_map_9.h.s"
.include "maps/compressed/cmp_map_10.h.s"
.include "maps/compressed/cmp_map_11.h.s"
.include "maps/compressed/cmp_map_12.h.s"
.include "maps/compressed/cmp_map_13.h.s"
.include "maps/compressed/cmp_map_14.h.s"
.include "maps/compressed/cmp_map_15.h.s"
.include "maps/compressed/cmp_map_16.h.s"
.include "maps/compressed/cmp_map_17.h.s"
.include "maps/compressed/cmp_map_18.h.s"
.include "maps/compressed/cmp_map_19.h.s"
.include "maps/compressed/cmp_map_20.h.s"
.include "maps/compressed/cmp_map_21.h.s"
.include "maps/compressed/cmp_map_22.h.s"
.include "maps/compressed/cmp_map_23.h.s"
.include "maps/compressed/cmp_map_24.h.s"
.include "maps/compressed/cmp_map_25.h.s"
.include "maps/compressed/cmp_map_26.h.s"
.include "maps/compressed/cmp_map_27.h.s"
.include "maps/compressed/cmp_map_28.h.s"
.include "maps/compressed/cmp_map_29.h.s"
.include "maps/compressed/cmp_map_30.h.s"
.include "maps/compressed/cmp_map_31.h.s"
.include "maps/compressed/cmp_map_32.h.s"
.include "maps/compressed/cmp_map_33.h.s"
.include "maps/compressed/cmp_map_34.h.s"
.include "maps/compressed/cmp_map_35.h.s"
.include "maps/compressed/cmp_map_36.h.s"
.include "maps/compressed/cmp_map_37.h.s"
.include "maps/compressed/cmp_map_38.h.s"
.include "maps/compressed/cmp_map_39.h.s"
.include "maps/compressed/cmp_map_40.h.s"
.include "maps/compressed/cmp_map_41_0.h.s"
.include "maps/compressed/cmp_map_41_1.h.s"
.include "maps/compressed/cmp_map_41_2.h.s"
.include "maps/compressed/cmp_map_41_3.h.s"
.include "maps/compressed/cmp_map_41.h.s"
.include "maps/compressed/cmp_map_42.h.s"
.include "maps/compressed/cmp_map_43.h.s"
.include "maps/compressed/cmp_map_44.h.s"
.include "maps/compressed/cmp_map_45.h.s"
.include "maps/compressed/cmp_map_46.h.s"
.include "maps/compressed/cmp_map_47.h.s"
.include "maps/compressed/cmp_map_48.h.s"

.include "maps/compressed/cmp_map_98.h.s"
.include "maps/compressed/cmp_map_99.h.s"
.include "maps/compressed/cmp_map_100.h.s"

;;
;; Map drawings globl
;;
.globl _game_tiles_00

;; Class that stores all the relevant information about the current map we are on
;; aswell as the init properties we will use to draw our maps (tileset)
;; WARNING!: This class doesn't manage menu data, it only manages MAP data.

;;=============================================
;;=============================================
;; PRIVATE DATA
;;=============================================
;;=============================================
num_map	   : .db #00		;; Current id for the map we are on
;; TBD: We assume the width and the height is the same for all of our maps

first_map: .dw #_cmp_map_0	;; Initial map. Take care, maps are stored in memory in reverse order of name

;; It is possible to recover memory maps compressed with offset operations
;;					CMP_SIZE 	DECMP_SIZE	;; (CMP = COMPRESSED | DECMP = DECOMPRESSED)
our_maps:
			.dw		_cmp_map_0_size_z			;; 0 map
			.dw		_cmp_map_1_size_z			;; 1 map
			.dw		_cmp_map_2_size_z			;; 2 map
			.dw     _cmp_map_3_size_z 			;; 3 map
			.dw 	_cmp_map_4_size_z			;; 4 map
			.dw 	_cmp_map_5_size_z			;; 5 map
			.dw 	_cmp_map_6_size_z			;; 6 map
			.dw 	_cmp_map_7_size_z			;; 7 map
			.dw 	_cmp_map_8_size_z			;; 8 map
			.dw 	_cmp_map_9_size_z			;; 9 map
			.dw 	_cmp_map_10_size_z			;; 10 map
			.dw 	_cmp_map_11_size_z			;; 11 map
			.dw 	_cmp_map_12_size_z			;; 12 map
			.dw 	_cmp_map_13_size_z			;; 13 map
			.dw 	_cmp_map_14_size_z			;; 14 map
			.dw 	_cmp_map_15_size_z			;; 15 map
			.dw 	_cmp_map_16_size_z			;; 16 map
			.dw 	_cmp_map_17_size_z			;; 17 map
			.dw 	_cmp_map_18_size_z			;; 18 map
			.dw 	_cmp_map_19_size_z			;; 19 map
			.dw 	_cmp_map_20_size_z			;; 20 map
			.dw 	_cmp_map_21_size_z			;; 21 map
			.dw 	_cmp_map_22_size_z			;; 22 map
			.dw 	_cmp_map_23_size_z			;; 23 map
			.dw 	_cmp_map_24_size_z			;; 24 map
			.dw 	_cmp_map_25_size_z			;; 25 map
			.dw 	_cmp_map_26_size_z			;; 26 map
			.dw 	_cmp_map_27_size_z			;; 27 map
			.dw 	_cmp_map_28_size_z			;; 28 map
			.dw 	_cmp_map_29_size_z			;; 29 map
			.dw 	_cmp_map_30_size_z			;; 30 map
			.dw 	_cmp_map_31_size_z			;; 31 map
			.dw 	_cmp_map_32_size_z			;; 32 map
			.dw 	_cmp_map_33_size_z			;; 33 map
			.dw 	_cmp_map_34_size_z			;; 34 map
			.dw 	_cmp_map_35_size_z			;; 35 map
			.dw 	_cmp_map_36_size_z			;; 36 map
			.dw 	_cmp_map_37_size_z			;; 37 map
			.dw 	_cmp_map_38_size_z			;; 38 map
			.dw 	_cmp_map_39_size_z			;; 39 map
			.dw 	_cmp_map_40_size_z			;; 40 map
			.dw 	_cmp_map_41_0_size_z		;; 41_0 map
			.dw 	_cmp_map_41_1_size_z		;; 41_1 map
			.dw 	_cmp_map_41_2_size_z		;; 41_2 map
			.dw 	_cmp_map_41_3_size_z		;; 41_3 map
			.dw 	_cmp_map_41_size_z			;; 41 map
			.dw 	_cmp_map_42_size_z			;; 42 map
			.dw 	_cmp_map_43_size_z			;; 43 map
			.dw 	_cmp_map_44_size_z			;; 44 map
			.dw 	_cmp_map_45_size_z			;; 45 map
			.dw 	_cmp_map_46_size_z			;; 46 map
			.dw 	_cmp_map_47_size_z			;; 47 map
			.dw 	_cmp_map_48_size_z			;; 48 map
			
			.dw 	_cmp_map_98_size_z			;; 98 map
			.dw 	_cmp_map_99_size_z			;; 99 map
			.dw 	_cmp_map_100_size_z			;; 100 map

			.db		0xFF						;; End of game! :D

mm_front_buffer:	.db 0xC0
mm_back_buffer:		.db 0x80

;;===================================================================
;;	ATTENTION:
;;	Every time that a new map is added it has to be updated
;;	our maps tables (i.e. our_maps variable) with its compressed
;;	size and descompressed size (both values are available in
;;	comments sections in .s files)
;;
;;	Map names have to be in order of playing for a future
;;	optimization and that order have to be reflected in
;;	our map table too (respectively).
;;===================================================================

;;===================================================================
;;
;;	Examples of how to work with compressed maps:
;;
;; If we want to draw the current map:
;; call mm_drawFullCurrentMapCmp
;;
;; If we want to configure that the player has passed the current level and we want to load next (permanent configuration!):
;; call mm_configNextMap			;; This sets up next level config
;; call mm_drawFullCurrentMapCmp
;;
;; If we want to configure that the player has passed the current level but we want to have the possibility of go to prvious level (no permanent configuration):
;; call mm_drawFullNextMapCmp		;; This draws next level but if you draw the current map, the current map it will be the previous to the drawn in the screen
;;
;; If we want to configure a specific map but do not lose the current map (e.g. see a demo of the map);
;; ld b, #5
;; call mm_drawFullSpecificMapCmp	;; This draws a specific level, map 5 in this example
;;
;; If we want to configure a specific map and override the configuration to be in that current map (e.g. load a specific map):
;; ld b, #5
;; call mm_configSpecificMap
;; call mm_drawFullCurrentMapCmp
;;===================================================================


;;===================================================================
;;	READ ME:
;;	Now that we are working with compression and decompression
;;	it is very easy to modify a ID tile of the tilemap in runtime.
;;
;;	Just modify the tile ID that you want from 
;;	MEM_BEGIN_DECOMPRESSED_MAP addr doing the maths and redraw 
;;	that specific tile.
;;
;;	If you want to check this just use debugger, go to
;;	MEM_BEGIN_DECOMPRESSED_MAP addr and modify some id tile
;;	and go to that position with our pretty character and that tile 
;;	will be redrawn. Thigs allows us to make thins like Alvaro said
;;	about make destroyable tiles when the character touchs, but
;;	without animation... if we want animation we have to make
;;	it with entities or with ticks (i think it would not be too 
;;	much hard)
;;===================================================================

;;===================================================================
;;	It decompresses a map
;;	INPUTS:
;;		HL: map compressed addr
;;		BC: map compressed size
;;		DE: map decompressed size
;;	DESTROYS: AF, BC, DE, HL
;;===================================================================
mm_decompress_map:
	add hl, bc							;; HL += BC = map compressed addr + map compressed size (last position of array + 1)
	dec hl								;; HL-- = last position of array in map compressed
	
	push hl								;; Save HL
	ld hl, #MEM_BEGIN_DECOMPRESSED_MAP	;; HL = begin of memory where decompressed map will be stored
	add hl, de							;; HL += DE = MEM_BEGIN_DECOMPRESSED_MAP + map decompressed size (last position of array + 1)
	dec hl								;; HL-- = last position of array in map decompressed
	ld d, h								;; |
	ld e, l								;; \ DE = HL = last position of array in map decompressed
	pop hl								;; Restore HL = last position of array in map compressed

	jp cpct_zx7b_decrunch_s_asm		;; Decompress map in MEM_BEGIN_DECOMPRESSED_MAP


;;===================================================================
;;	It resolves num_map and decompresses it
;;	DESTROYS: AF, BC, DE, HL, IY
;;===================================================================
mm_resolveAndDecompressCurrentMap:
	ld a, (num_map)			;; A = current map ID
	ld hl, (first_map)		;; HL stores map it will be loaded
	ld iy, #our_maps		;; IY = *(our_maps)

	cnm_loop:
	or a					;; |
	jr z, loadMap			;; \ If A == 0 then load map

		inc iy				;; |
		inc iy				;; \ IY += 0x02 (i.e. next level)

		ld b, 1(iy)			;; |
		ld c, 0(iy)			;; \ BC = compressed map size (offset to go back)

		ld d, a				;; Save A in D

		ld a, c				;; A = C = first byte of decompressed map size
		cp #0xFF			;; |
		ret z				;; \ If 0xFF, end of game :D

		push hl				;; |
		ld h, b				;; |
		ld l, c				;; | HL = BC
		call mulNeg1Reg16	;; | TAKE CARE: Maps are stores in reverse order so we need to subtract (we subtract adding the negative number)
		ld b, h				;; |
		ld c, l				;; | BC = (-1) * BC
		pop hl				;; \ Obtained offset to go back in array

		ld a, d				;; Restore A from D
		ld d, #0			;; D = 0
		
		add hl, bc			;; \ HL += BC (i.e. HL = *(first_map) - CMP_SIZE of map i for each i until reach map we want)

		dec a				;; A--
		jr cnm_loop
	loadMap:
		ld b, 1(iy)						;; |
		ld c, 0(iy)						;; \ BC = map compressed size
		ld d, #DECOMPRESSED_MAP_SIZE_B0	;; |
		ld e, #DECOMPRESSED_MAP_SIZE_B1	;; \ DE = map decompressed size (it is constant)

		jr mm_decompress_map


;;===================================================================
;;	It configures all necessary things to go to the next level.
;;	It updates variables to set next level configuration.
;;	DESTROYS: AF
;;===================================================================
mm_NextMap::
	ld a, (num_map)
	inc a
	ld (num_map), a
ret


;;===================================================================
;;	Returns in A the num_map
;;	DESTROYS: AF
;;	RETURNS: A
;;===================================================================
mm_GetA_num_map::
	ld a, (num_map)
ret

;;===================================================================
;;	It configures all necessary things to go to a specific level.
;;	INPUTS:
;;		 A: map ID (starting in 0)
;;	DESTROYS: AF
;;===================================================================
mm_gotoSpecificMap::
	ld (num_map), a				;; *(num_map) = A = map ID
ret


;;===================================================================
;; Decompresses and draws the current map
;; DESTROYS: AF, BC, DE, HL AF’, BC’, DE’, HL’
;;===================================================================
mm_DecompressAndDrawFullCurrentMap::
	call mm_resolveAndDecompressCurrentMap	;; It resolves and decompresses current map
											;; TBD: we are able not to call mm_configCurrentMap here 
											;;	    and let that decision to other module so it will
											;;		be possible to decide when it is better to
											;;		do the decompression. By now the decompression
											;;		will be done here
 	jr mm_drawFullCurrentMap


;;===================================================================
;; Draws current map in the screen
;; DESTROYS: AF, BC, DE, HL AF’, BC’, DE’, HL’
;;===================================================================
mm_drawFullCurrentMap::
	ld de, #LEVEL_TILES_W
	ld c, #LEVEL_TILES_W
	ld b, #LEVEL_TILES_H
	ld hl, #_game_tiles_00					;; |
	call cpct_etm_setDrawTilemap4x8_ag_asm  ;; | Main tileset for our maps

 	call ru_getCurrentVM
	ex de, hl
	ld de, #MAP_OFFSET_Y
	add hl, de
	ld de, #MEM_BEGIN_DECOMPRESSED_MAP
	call cpct_etm_drawTilemap4x8_ag_asm

	call ru_getBackVM
	ex de, hl
	ld de, #MAP_OFFSET_Y
	add hl, de
	ld de, #MEM_BEGIN_DECOMPRESSED_MAP
	call cpct_etm_drawTilemap4x8_ag_asm

	ld a, #LEVEL_TILES_H
	ld (last_h), a

	ret


;;===================================================================
;; Returns a tile xy position given an absolute xy position
;; INPUTS:
;;      HL =>
;;			H: x position
;;			L: y position
;; RETURNS:  HL => Tile coordinates, same format
;; DESTROYS: HL, AF, DE, BC
;;===================================================================
mm_ConvertToTileCoordinates::
    srl h
	srl h				 ;; (xpos)/TILE_W
    ;; ------------------------------------------
    ld a, l 			 ;; a = y position
    ld d, #MAP_ORIGIN_Y  ;; d = top map offset
    sub d                ;; a = ypos - top_offset
    ld l, a              ;; |
    srl l
	srl l
	srl l				 ;; (ypos - top_offset)/TILE_H   
	
    ret


;;===================================================================
;; Returns the tile id given a tilemap xy matrix position
;; INPUTS:
;;      HL =>
;;			H: x position
;;			L: y position
;; RETURNS:   A => tile id
;; DESTROYS: BC, HL
;;===================================================================
mm_getTileIdByPosition::
	ld c, h 								;;4
	ld b, #0								;;7
	ld a, l 								;;4
	ld h, #0								;;7

	sla l									;;8
	sla l									;;8
	sla l									;;8
	add hl, hl								;;11

	add a, a								;;4
	add a, a								;;4
	add_hl_a								;;20
	ld de, ##MEM_BEGIN_DECOMPRESSED_MAP		;;10
	add hl, de								;;11
	add hl, bc								;;11
	ld a, (hl)								;;7
	ret										;;total 124 T-states
											;;old => 125 best case, 557 worst case
												
	;ld  c, h                					;;4 B will be the cached x pos 
	;ld  b, l 									;;4 C will be the cached y pos
	;ld 	hl, #MEM_BEGIN_DECOMPRESSED_MAP 			;;10

	;ld  de, #LEVEL_TILES_W 					;;10 de contains the level tiles_w
	;tid_resolve_y:								;; We resolve the y cordinate on hl
	;	add hl,	de          					;;11*y 	HL = HL + LEVEL_TILES_W
	;	djnz tid_resolve_y 						;;13*y-1 + 11 

	;tip_skip_resolve_y:
	;xor a										;;4
	;cp c										;;4
	;jr z, tip_skip_resolve_x					;;12 if x == 0, then we don't need to resolve

	;ld a, c									;;4
	;add_hl_a									;;20
	;
	;tip_skip_resolve_x:

	;ld a, (hl)									;7
	;ret


;;===================================================================
;; Draws the tiles in the (x,y) position of the screen with a window
;; size equal or greater than the entity
;; INPUTS:
;;      IY => Pointer to entity
;; DESTROYS: 
;;		AF, BC, DE, HL, AF’, BC’, DE’, HL’, IY
;;===================================================================
last_w:	 .db #00
last_h:	 .db #00
tile_x:	 .db #00
tile_y:	 .db #00
mm_drawTiles::

	ld a, (last_h)				;;|
	ld d, Ent_h(iy)				;;|
	cp a, d						;;|
	jr nz, compute_window		;;|

	ld a, (last_w)				;;|
	ld d, Ent_w(iy)				;;|
	cp a, d						;;| If last entity computed had the same width and heigth
	jr z, skip_compute			;;| Skip window size computing and the setDrawTilemap call

	compute_window:
	;;=======================
	;; Window width in tiles
	ld d, Ent_w(iy)
	ld a, d
	ld (last_w), a
	ld e, #TILE_W
	call div8				   ;; D = EntityW / TileW
	
	ld b, #0
	cp a, #0
	jr nz, alignedX			   ;; If reminder != 0
		inc b				   ;; B++ 
 	alignedX:
	ld a, d					   ;;|
	add b					   ;;| 
	ld (tile_x), a			   ;;| tileX = A + B
	;;=======================

	;;=======================
	;; Window height in tiles
	ld d, Ent_h(iy)
	ld a, d
	ld (last_h), a
	ld e, #TILE_H
	call div8					;; D = EntityH / TileH
	
	ld b, #0
	cp a, #0
	jr nz, alignedY			   ;; If reminder != 0
 		inc b				   ;; B++ 
 	alignedY:
	ld a, d					   ;;|
	add b					   ;;| tileY = A + B
	;;=======================
	
	ld b, a										;;|
	ld a, (tile_x)							    ;;|
	ld c, a										;;| BC => Width and height in tiles of the window
	ld de, #LEVEL_TILES_W						;;| DE => Width in tiles of the tilemap
	ld hl, #_game_tiles_00						;;| HL => Pointer to definition of tileset
	 
	call cpct_etm_setDrawTilemap4x8_ag_asm

	skip_compute:

	ld h, Ent_ppx(iy)
	ld l, Ent_ppy(iy)
	call mm_ConvertToTileCoordinates			;;|
	
	ld a, h										;;|
	ld (tile_x), a								;;|
	
	add a, a
	add a, a									;;|	Tile_W * X coord in tiles (4*X)

	ld c, a

	ld a, l										;;| Converting hero coordinates to tile coords
	ld (tile_y), a								;;| and storing them

	add a, a
	add a, a
	add a, a									;;| Tile_H * Y coord in tiles (8*X)
	
	ld b, a										;; BC => Absolute coords of start of tile window

	call ru_getVmOffset							;; DE => Start of video memory + Y offset
	call cpct_getScreenPtr_asm				    ;; HL => Memory video pointer
	push hl										;; Storing the pointer for later

	ld a, (tile_y)
	ld l, a				;;4
	ld h, #0			;;7

	sla	l				;;8						;;|		
	sla l				;;8						;;|
	sla l				;;8						;;|	L >> 3 <==> L * 2³  
	add hl, hl			;;11					;;| Now we need 16bits since (tile_y) maximum value is 20 and 20⁴ would overflow 
	
	add a, a			;;4						;;|
	add a, a			;;4						;;| A = A * 2² 
	add_hl_a			;;20					;; HL + A => Level_W * Y coord in tiles
	
	ld de, #MEM_BEGIN_DECOMPRESSED_MAP;;10		;;|	DE => Pointer to star of tilemap
	add hl, de						  ;;11		;;| Map pointer + Y offset
	ld a, (tile_x)					  ;;13 		;;|	
	add_hl_a						  ;;20		;;| Map pointer + X offset
	ex de, hl						  			;;| DE => Pointer + offset
	pop hl										;;|	HL => Video memory pointer

	jp cpct_etm_drawTilemap4x8_ag_asm