;;----------------------------------------LICENSE NOTICE----------------------------------------
;;	_________ __________ __   _______ ______ ______ ___     ___ ______ ______ _________			
;;	\______   \______   /  \ /__   __/__   __\ ____\   \   /   /  __  /__   __\   _____\		
;;	      /  /      /  / /\ \   | |     | |  | \___/    \_/    \  \_\ \  | |   \  \_____		
;;	     /  /      /  /  __  \  | |     | |  |  ___\  \ ___ /  /  ____/  | |    \_____  \		
;;	    /  /      /  /  /  \  \ | |     | |  | /___/  /     \  \  \      | |      ____\  \		
;;	   /_ /      /_ /__/    \__\|_|     |_|  /_____\__\     /__/__/      |_|     \________\		
;;
;;  Code & Gfx Copyright (C) 2018 Alvaro Jover (@vorixo), Jordi Amoros (@byFlowee) 
;;	and Cristian Garcia (@cgr71ii)
;;  Music & Fx Copyright (C) 2018 Alvaro Jover (@vorixo)
;;  This file is part of 77 ATTEMPTS: an Amstrad CPC Game made with CPCTelera
;;
;;  This program is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  This program is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU General Public License for more details.
;;
;;  You should have received a copy of the GNU General Public License
;;  along with this program.  If not, see <http://www.gnu.org/licenses/>.
;;----------------------------------------------------------------------------------------------

;;=====================
;; Utilities consts
;;=====================
.equ ENT_ACTIVE,     0			;; The entity is active
.equ ENT_NOTACTIVE, -1			;; The entity is inactive
;; Sprite status
.equ ANIM_Normal_right,     0 ;; The anim is flipped to the right (Usually the default one)  
.equ ANIM_Normal_left,      1 ;; The anim is flipped to the left

.equ CHAR_IDLE,             0 ;; Character is quiet, not moving
.equ CHAR_WALKING,          1 ;; Character is walking
.equ CHAR_FALLING,          2 ;; Character is falling in the air
.equ CHAR_JUMPING,          3 ;; Character is jumping

;; Jump status
.equ CHAR_GRAV_NORMAL,     0      ;; Gravity normal
.equ CHAR_GRAV_FLIPPED,    1      ;; Gravity flipped


;;===========================;;
;; "Fake inheritation chain" ;;
;;===========================;;
;;		     ENTITY 	     ;;
;;		       vv 			 ;;
;;		      PAWN 			 ;;
;;		       vv 			 ;;
;;        CHARACTER 		 ;;
;;===========================;;


;;===========================================================================================
;; Entity:
;; An entity represents something that exists in the world:
;; Characters, bullets, keys, doors...
;; It is the most basic representation of something that can be placed and spawned in the map
;;
;; The basic properties an entity has are the following:
;; > FVector2D(x, y): Entity location in the screen by coordinates
;; > FVector2D(w, h): Entity boundaries determines by the width and the height
;; > bIsActive: Defines if the entity is active or not. Activity purposes can be defined by the "definers".
;; > Sprite: Visual representation of the entity. It has a width and a height aswell but it doesn't
;;   have to necessarily match with the entity boundaries.
;;===========================================================================================
.macro defineEntity name, x, y, w, h, act, spr 
    name'_data:
        name'_x:         .db x      ;; #0
        name'_y:         .db y      ;; #1
        name'_w:         .db w      ;; #2
        name'_h:         .db h      ;; #3
        name'_px:        .db x      ;; #4
        name'_py:        .db y      ;; #5
        name'_ppx:       .db x      ;; #6
        name'_ppy:       .db y      ;; #7
        name'_draw:      .db 2      ;; #8
        name'_isactive:	 .db act    ;; #9
        name'_sprite:    .dw spr    ;; #10-11
.endm


;;===========================================================================================
;; Pawn:
;; A pawn represents a type of entity that extends its purpose.
;; Pawns can move in a simple way, if complex movement is desired. Use the character definition.
;; The basic properties a pawn has are the following:
;; > frame: Current frame of the current animation playing
;; > upd: Points to the update function of the pawn
;;===========================================================================================
.macro definePawn name, x, y, w, h, act, spr
	defineEntity name, x, y, w, h, act, spr
        name'_frame:    .db #00     ;; #12
.endm

;;===========================================================================================
;; Character:
;; A character represents a type of pawn that extends its purpose.
;; Characters define a much more complex movement than a pawn
;; The basic properties a character has are the following:
;; > JumpTableIndex: Status of the jump table defined in the character.
;; > GravityDirection: Defines the gravity direction for this entity
;; > Char_look_side: Side where the character is looking at
;; > Char_state: Character current state
;;===========================================================================================
.macro defineCharacter name, x, y, w, h, act, spr, grav_dir
	definePawn name, x, y, w, h, act, spr 
        name'_jump_index:      .db #-1                    ;; #13
        name'_gravdirection:   .db grav_dir               ;; #14
        name'_look_side:        .db ANIM_Normal_right     ;; #15
        name'_state:            .db CHAR_FALLING          ;; #16
        name'_pstate:           .db CHAR_FALLING          ;; #17
.endm

;;=================================================================================
;; Entities const:
;; Every single entity will use these constant to access their properties
;;=================================================================================
.equ Ent_x,     0
.equ Ent_y,     1
.equ Ent_w,     2
.equ Ent_h,     3
.equ Ent_px,    4
.equ Ent_py,    5
.equ Ent_ppx,   6
.equ Ent_ppy,   7
.equ Ent_draw,  9
.equ Ent_act,	9
.equ Ent_spr_l, 10
.equ Ent_spr_h, 11

;;=================================================================================
;; Pawn consts: TBD
;; Pawn specific constants, it will use Ent_ for entity properties
;;=================================================================================
.equ Pawn_frame,     12

;;=================================================================================
;; Character consts:
;; Character specific constants, it will use Ent_ or Pawn_ for entity or pawn properties
;;=================================================================================
.equ Char_jmp,                    13
.equ Char_grav_dir,               14
.equ Char_look_side,              15
.equ Char_state,                  16
.equ Char_pstate,                 17
        