;;----------------------------------------LICENSE NOTICE----------------------------------------
;;	_________ __________ __   _______ ______ ______ ___     ___ ______ ______ _________			
;;	\______   \______   /  \ /__   __/__   __\ ____\   \   /   /  __  /__   __\   _____\		
;;	      /  /      /  / /\ \   | |     | |  | \___/    \_/    \  \_\ \  | |   \  \_____		
;;	     /  /      /  /  __  \  | |     | |  |  ___\  \ ___ /  /  ____/  | |    \_____  \		
;;	    /  /      /  /  /  \  \ | |     | |  | /___/  /     \  \  \      | |      ____\  \		
;;	   /_ /      /_ /__/    \__\|_|     |_|  /_____\__\     /__/__/      |_|     \________\		
;;
;;  Code & Gfx Copyright (C) 2018 Alvaro Jover (@vorixo), Jordi Amoros (@byFlowee) 
;;	and Cristian Garcia (@cgr71ii)
;;  Music & Fx Copyright (C) 2018 Alvaro Jover (@vorixo)
;;  This file is part of 77 ATTEMPTS: an Amstrad CPC Game made with CPCTelera
;;
;;  This program is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  This program is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU General Public License for more details.
;;
;;  You should have received a copy of the GNU General Public License
;;  along with this program.  If not, see <http://www.gnu.org/licenses/>.
;;----------------------------------------------------------------------------------------------

.include "entities/entity.h.s"

;;==============================
;; CHAR JUMPER GLOBAL FUNCTIONS
;;==============================
.globl _charjumper_sprite
.globl _charjumper_angry_sprite

.globl charjp_doForAll
.globl charjp_spawnJumper
.globl charjp_getJumperById
.globl charjp_destroyJumper
.globl charjp_destroyAllJumpers

.globl charjp_moveToXY
.globl charjp_moveRight
.globl charjp_moveLeft
.globl charjp_gravity
.globl charjp_updateForAll


;;==============================
;; SAW GLOBAL FUNCTIONS
;;==============================
.globl _minisaw_sprites_0
.globl _minisaw_sprites_1
.globl saw_doForAll
.globl saw_spawnSaw
.globl saw_getSawById
.globl saw_destroySaw
.globl saw_destroyAllSaws
.globl saw_updateSaw
.globl saw_drawAll
.globl saw_drawTilesAll


;;======================================================
;; CHAR JUMPER MACRO AND CONST DEFINITION
;;======================================================
CHAR_JUMPER_ADDRESS 	= 0x040
CHAR_JUMPER_SIZE 		= 18
CHAR_JUMPER_MAX_ENT 	= 1
CHAR_JUMPER_HEIGHT	 	= 8
CHAR_JUMPER_TICKS		= 2

.macro defineCharJumper name, x, y, w, h, act, spr, grav_dir
    defineCharacter name, x, y, w, h, act, spr, grav_dir
.endm

;; Set here default values for the jumper to grab, 
;; if their sprite are the same set it here, otherwise leave the task to the spawn routine
;; The spawn routine will set px, py, x and y. And other if needed.
.macro defineCharJumperDefault _name, _suf
    defineCharJumper name'_suf, 0, 0, 4, 8, ENT_ACTIVE, _charjumper_sprite, CHAR_GRAV_NORMAL
.endm

;; Vector of charjumpers
.macro defineNCharJumperDefault _name
  	.area CHARJP_SPWN (ABS)		
  	.org CHAR_JUMPER_ADDRESS
	_c = 0
	.rept CHAR_JUMPER_MAX_ENT
	defineCharJumperDefault _name, \_c
    	_c = _c + 1
  	.endm
  	.area _CSEG (REL, CON)		;; Setting back mem area
.endm


;;======================================================
;; SAW MACRO AND CONST DEFINITION
;;======================================================
SAW_ADDRESS 	= 0x052    ;; We don't lose a single byte placing the saws at this address 		
SAW_SIZE 		= 19
SAW_MAX_ENT 	= 4

.macro defineMiniSaw name, x, y, w, h, act, spr, ax, rng, spwn, spd, tck
    definePawn name, x, y, w, h, act, spr
    name'_axis:     .db ax
    name'_range:    .db rng
	name'_spawn:	.db spwn
	name'_speed:	.db spd
	name'_tick:		.db tck
	name'_anim:		.db #0
.endm

;; Set here default values for the Saw to grab, 
;; if their sprite are the same set it here, otherwise leave the task to the spawn routine
;; The spawn routine will set px, py, x and y. And other if needed.
.macro defineMiniSawDefault _name, _suf
    defineMiniSaw name'_suf, 0, 0, 4, 8, ENT_ACTIVE, _minisaw_sprites_0, 0, 4, 0, 1, 0
.endm

;; Vector of minisaws
.macro defineNMiniSawDefault _name
  	.area saw_SPWN (ABS)		
  	.org SAW_ADDRESS
	_c = 0
	.rept SAW_MAX_ENT
	defineMiniSawDefault _name, \_c
    	_c = _c + 1
  	.endm
  	.area _CSEG (REL, CON)		;; Setting back mem area
.endm

.equ Saw_axis,      13          ;; Entity pawn => 12
.equ Saw_range,     14          ;; Travel length of the saw
.equ Saw_spawn,		15			;; Spawn point
.equ Saw_speed,		16			;; Saw speed
.equ Saw_tick,  	17			;; Current tick
.equ Saw_anim,		18