##-----------------------------LICENSE NOTICE------------------------------------
##  This file is part of CPCtelera: An Amstrad CPC Game Engine 
##  Copyright (C) 2018 ronaldo / Fremos / Cheesetea / ByteRealms (@FranGallegoBR)
##
##  This program is free software: you can redistribute it and/or modify
##  it under the terms of the GNU Lesser General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU Lesser General Public License for more details.
##
##  You should have received a copy of the GNU Lesser General Public License
##  along with this program.  If not, see <http://www.gnu.org/licenses/>.
##------------------------------------------------------------------------------
############################################################################
##                        CPCTELERA ENGINE                                ##
##                 Automatic image conversion file                        ##
##------------------------------------------------------------------------##
## This file is intended for users to automate tilemap conversion from    ##
## original files (like Tiled .tmx) into C-arrays.                        ##
############################################################################

##
## NEW MACROS
##

# Default values
#$(eval $(call TMX2DATA, SET_ASMVARPREFIX, yes       ))   { yes, no      }
#$(eval $(call TMX2DATA, SET_USEMACROS   , yes       ))   { yes, no      }
#$(eval $(call TMX2DATA, SET_OUTPUTS     , h c       ))   { bin hs h s c }
#$(eval $(call TMX2DATA, SET_BASE        , dec       ))   { dec hex bin }
#$(eval $(call TMX2DATA, SET_BITSPERITEM , 8         ))   { 1, 2, 4, 6, 8 }
#$(eval $(call TMX2DATA, SET_FOLDER      , src/maps      )) 
#$(eval $(call TMX2DATA, SET_EXTRAPAR    ,           ))	
# Conversion 
#$(eval $(call TMX2DATA, CONVERT, tmxfile, array )) 

$(eval $(call TMX2DATA, SET_FOLDER      , src/maps      )) 
$(eval $(call TMX2DATA, SET_OUTPUTS     , hs bin  	    ))
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_0.tmx, g_map1)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_1.tmx, g_map2)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_2.tmx, g_map3)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_3.tmx, g_map4)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_4.tmx, g_map5)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_5.tmx, g_map6)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_6.tmx, g_map7)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_7.tmx, g_map8)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_8.tmx, g_map9))
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_9.tmx, g_map10)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_10.tmx, g_map11)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_11.tmx, g_map12)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_12.tmx, g_map13)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_13.tmx, g_map14)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_14.tmx, g_map15))
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_15.tmx, g_map16)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_16.tmx, g_map17))
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_17.tmx, g_map18)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_18.tmx, g_map19))
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_19.tmx, g_map20)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_20.tmx, g_map21)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_21.tmx, g_map22))
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_22.tmx, g_map23)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_23.tmx, g_map24)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_24.tmx, g_map25))
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_25.tmx, g_map26)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_26.tmx, g_map27)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_27.tmx, g_map28)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_28.tmx, g_map29)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_29.tmx, g_map30))
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_30.tmx, g_map31)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_31.tmx, g_map32)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_32.tmx, g_map33)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_33.tmx, g_map34))
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_34.tmx, g_map35))
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_35.tmx, g_map36)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_36.tmx, g_map37)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_37.tmx, g_map38))
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_38.tmx, g_map39))
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_39.tmx, g_map40))
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_40.tmx, g_map41)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_41_0.tmx, g_map42_0))
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_41_1.tmx, g_map42_1))
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_41_2.tmx, g_map42_2)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_41_3.tmx, g_map42_3)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_41.tmx, g_map42)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_42.tmx, g_map43)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_43.tmx, g_map44))
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_44.tmx, g_map45))
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_45.tmx, g_map46)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_46.tmx, g_map47)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_47.tmx, g_map48))
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_48.tmx, g_map49))

$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_98.tmx, g_map98)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_99.tmx, g_map99)) 
$(eval $(call TMX2DATA, CONVERT, assets/20x23_8x8_100.tmx, g_map100)) 


##
## OLD MACROS (For compatibility)
##

## TILEMAP CONVERSION EXAMPLES (Uncomment EVAL lines to use)
##

## Convert img/tilemap.tmx to src/tilemap.c and src/tilemap.h
##		This file contains a tilemap created with Tiled that uses tiles
## in img/tiles.png. This macro will convert the tilemap into a C-array
## named g_tilemap, containing all the IDs of the tiles that are located 
## at each given location of the C-array. 
##

#$(eval $(call TMX2C,img/tilemap.tmx,g_tilemap,src/,4))

## Convert img/level0b.tmx to src/levels/level0b.c and src/levels/level0b.h
##		This file contains another tilemap created with Tiled. This macro 
## will convert the tilemap into a C bitarray of 4-bits per item. The array
## will be named g_level0_4bit. For each tile ID included into the final 
## bitarray, only 4 bits will be used. Therefore, each byte of the array 
## will contain 2 tile IDs.
##

#$(eval $(call TMX2C,assets/mapa_8x11.tmx,g_level0,src/maps/,))
#$(eval $(call TMX2C,assets/mapa_8x112.tmx,g_level1,src/maps/,))
#$(eval $(call TMX2C,assets/level0_11x18.tmx,g_level0,src/maps/,))






############################################################################
##              DETAILED INSTRUCTIONS AND PARAMETERS                      ##
##------------------------------------------------------------------------##
##                                                                        ##
## Macro used for conversion is TMX2C, which has up to 4 parameters:      ##
##  (1): TMX file to be converted to C array                              ##
##  (2): C identifier for the generated C array                           ##
##  (3): Output folder for C and H files generated (Default same folder)  ##
##  (4): Bits per item (1,2,4 or 6 to codify tilemap into a bitarray).    ##
##       Blanck for normal integer tilemap array (8 bits per item)        ##
##  (5): Aditional options (aditional modifiers for cpct_tmx2csv)         ##
##                                                                        ##
## Macro is used in this way (one line for each image to be converted):   ##
##  $(eval $(call TMX2C,(1),(2),(3),(4),(5)))                             ##
##                                                                        ##
## Important:                                                             ##
##  * Do NOT separate macro parameters with spaces, blanks or other chars.##
##    ANY character you put into a macro parameter will be passed to the  ##
##    macro. Therefore ...,src/sprites,... will represent "src/sprites"   ##
##    folder, whereas ...,  src/sprites,... means "  src/sprites" folder. ##
##  * You can omit parameters by leaving them empty.                      ##
##  * Parameters (4) and (5) are optional and generally not required.     ##
############################################################################
