##-----------------------------LICENSE NOTICE------------------------------------
##  This file is part of CPCtelera: An Amstrad CPC Game Engine 
##  Copyright (C) 2018 ronaldo / Fremos / Cheesetea / ByteRealms (@FranGallegoBR)
##
##  This program is free software: you can redistribute it and/or modify
##  it under the terms of the GNU Lesser General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU Lesser General Public License for more details.
##
##  You should have received a copy of the GNU Lesser General Public License
##  along with this program.  If not, see <http://www.gnu.org/licenses/>.
##------------------------------------------------------------------------------
############################################################################
##                        CPCTELERA ENGINE                                ##
##                 Automatic compression utilities                        ##
##------------------------------------------------------------------------##
## This file is intended for users to automate the generation of          ##
## compressed files and their inclusion in users' projects.               ##
############################################################################

## COMPRESSION EXAMPLE (Uncomment lines to use)
##

## First 3 calls to ADD2PACK add enemy, hero and background
## graphics (previously converted to binary data) into the 
## compressed group 'mygraphics'. After that, call to PACKZX7B
## compresses all the data and generates an array with the result
## that is placed in src/mygraphics.c & src/mygraphics.h, ready
## to be included and used by other modules.
##
#$(eval $(call ADD2PACK,mygraphics,gfx/enemy.bin))
#$(eval $(call ADD2PACK,mygraphics,gfx/hero.bin))
#$(eval $(call ADD2PACK,mygraphics,gfx/background.bin))
#$(eval $(call PACKZX7B,mygraphics,src/))

# Packing
$(eval $(call ADD2PACK,cmp_map_0,src/maps/20x23_8x8_0.bin))
$(eval $(call ADD2PACK,cmp_map_1,src/maps/20x23_8x8_1.bin))
$(eval $(call ADD2PACK,cmp_map_2,src/maps/20x23_8x8_2.bin))
$(eval $(call ADD2PACK,cmp_map_3,src/maps/20x23_8x8_3.bin))
$(eval $(call ADD2PACK,cmp_map_4,src/maps/20x23_8x8_4.bin)) 
$(eval $(call ADD2PACK,cmp_map_5,src/maps/20x23_8x8_5.bin)) 
$(eval $(call ADD2PACK,cmp_map_6,src/maps/20x23_8x8_6.bin))
$(eval $(call ADD2PACK,cmp_map_7,src/maps/20x23_8x8_7.bin))
$(eval $(call ADD2PACK,cmp_map_8,src/maps/20x23_8x8_8.bin)) 
$(eval $(call ADD2PACK,cmp_map_9,src/maps/20x23_8x8_9.bin)) 
$(eval $(call ADD2PACK,cmp_map_10,src/maps/20x23_8x8_10.bin)) 
$(eval $(call ADD2PACK,cmp_map_11,src/maps/20x23_8x8_11.bin)) 
$(eval $(call ADD2PACK,cmp_map_12,src/maps/20x23_8x8_12.bin))
$(eval $(call ADD2PACK,cmp_map_13,src/maps/20x23_8x8_13.bin))
$(eval $(call ADD2PACK,cmp_map_14,src/maps/20x23_8x8_14.bin)) 
$(eval $(call ADD2PACK,cmp_map_15,src/maps/20x23_8x8_15.bin)) 
$(eval $(call ADD2PACK,cmp_map_16,src/maps/20x23_8x8_16.bin)) 
$(eval $(call ADD2PACK,cmp_map_17,src/maps/20x23_8x8_17.bin)) 
$(eval $(call ADD2PACK,cmp_map_18,src/maps/20x23_8x8_18.bin)) 
$(eval $(call ADD2PACK,cmp_map_19,src/maps/20x23_8x8_19.bin)) 
$(eval $(call ADD2PACK,cmp_map_20,src/maps/20x23_8x8_20.bin)) 
$(eval $(call ADD2PACK,cmp_map_21,src/maps/20x23_8x8_21.bin)) 
$(eval $(call ADD2PACK,cmp_map_22,src/maps/20x23_8x8_22.bin)) 
$(eval $(call ADD2PACK,cmp_map_23,src/maps/20x23_8x8_23.bin)) 
$(eval $(call ADD2PACK,cmp_map_24,src/maps/20x23_8x8_24.bin)) 
$(eval $(call ADD2PACK,cmp_map_25,src/maps/20x23_8x8_25.bin)) 
$(eval $(call ADD2PACK,cmp_map_26,src/maps/20x23_8x8_26.bin)) 
$(eval $(call ADD2PACK,cmp_map_27,src/maps/20x23_8x8_27.bin)) 
$(eval $(call ADD2PACK,cmp_map_28,src/maps/20x23_8x8_28.bin)) 
$(eval $(call ADD2PACK,cmp_map_29,src/maps/20x23_8x8_29.bin)) 
$(eval $(call ADD2PACK,cmp_map_30,src/maps/20x23_8x8_30.bin)) 
$(eval $(call ADD2PACK,cmp_map_31,src/maps/20x23_8x8_31.bin)) 
$(eval $(call ADD2PACK,cmp_map_32,src/maps/20x23_8x8_32.bin)) 
$(eval $(call ADD2PACK,cmp_map_33,src/maps/20x23_8x8_33.bin)) 
$(eval $(call ADD2PACK,cmp_map_34,src/maps/20x23_8x8_34.bin)) 
$(eval $(call ADD2PACK,cmp_map_35,src/maps/20x23_8x8_35.bin)) 
$(eval $(call ADD2PACK,cmp_map_36,src/maps/20x23_8x8_36.bin)) 
$(eval $(call ADD2PACK,cmp_map_37,src/maps/20x23_8x8_37.bin)) 
$(eval $(call ADD2PACK,cmp_map_38,src/maps/20x23_8x8_38.bin)) 
$(eval $(call ADD2PACK,cmp_map_39,src/maps/20x23_8x8_39.bin)) 
$(eval $(call ADD2PACK,cmp_map_40,src/maps/20x23_8x8_40.bin)) 
$(eval $(call ADD2PACK,cmp_map_41_0,src/maps/20x23_8x8_41_0.bin))
$(eval $(call ADD2PACK,cmp_map_41_1,src/maps/20x23_8x8_41_1.bin))
$(eval $(call ADD2PACK,cmp_map_41_2,src/maps/20x23_8x8_41_2.bin))  
$(eval $(call ADD2PACK,cmp_map_41_3,src/maps/20x23_8x8_41_3.bin))  
$(eval $(call ADD2PACK,cmp_map_41,src/maps/20x23_8x8_41.bin)) 
$(eval $(call ADD2PACK,cmp_map_42,src/maps/20x23_8x8_42.bin)) 
$(eval $(call ADD2PACK,cmp_map_43,src/maps/20x23_8x8_43.bin)) 
$(eval $(call ADD2PACK,cmp_map_44,src/maps/20x23_8x8_44.bin)) 
$(eval $(call ADD2PACK,cmp_map_45,src/maps/20x23_8x8_45.bin)) 
$(eval $(call ADD2PACK,cmp_map_46,src/maps/20x23_8x8_46.bin)) 
$(eval $(call ADD2PACK,cmp_map_47,src/maps/20x23_8x8_47.bin)) 
$(eval $(call ADD2PACK,cmp_map_48,src/maps/20x23_8x8_48.bin)) 

$(eval $(call ADD2PACK,cmp_map_98,src/maps/20x23_8x8_98.bin)) 
$(eval $(call ADD2PACK,cmp_map_99,src/maps/20x23_8x8_99.bin)) 
$(eval $(call ADD2PACK,cmp_map_100,src/maps/20x23_8x8_100.bin)) 


# Compressing
$(eval $(call PACKZX7B,cmp_map_0,src/maps/compressed))
$(eval $(call PACKZX7B,cmp_map_1,src/maps/compressed))
$(eval $(call PACKZX7B,cmp_map_2,src/maps/compressed))
$(eval $(call PACKZX7B,cmp_map_3,src/maps/compressed))
$(eval $(call PACKZX7B,cmp_map_4,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_5,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_6,src/maps/compressed))
$(eval $(call PACKZX7B,cmp_map_7,src/maps/compressed))
$(eval $(call PACKZX7B,cmp_map_8,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_9,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_10,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_11,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_12,src/maps/compressed))
$(eval $(call PACKZX7B,cmp_map_13,src/maps/compressed))
$(eval $(call PACKZX7B,cmp_map_14,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_15,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_16,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_17,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_18,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_19,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_20,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_21,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_22,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_23,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_24,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_25,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_26,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_27,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_28,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_29,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_30,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_31,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_32,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_33,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_34,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_35,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_36,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_37,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_38,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_39,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_40,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_41_0,src/maps/compressed))
$(eval $(call PACKZX7B,cmp_map_41_1,src/maps/compressed))
$(eval $(call PACKZX7B,cmp_map_41_2,src/maps/compressed))
$(eval $(call PACKZX7B,cmp_map_41_3,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_41,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_42,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_43,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_44,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_45,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_46,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_47,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_48,src/maps/compressed)) 

$(eval $(call PACKZX7B,cmp_map_98,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_99,src/maps/compressed)) 
$(eval $(call PACKZX7B,cmp_map_100,src/maps/compressed)) 

# Compressing the title
$(eval $(call ADD2PACK,game_title,src/sprites/maintitle.bin))
$(eval $(call PACKZX7B,game_title,src/sprites/compressed))

############################################################################
##              DETAILED INSTRUCTIONS AND PARAMETERS                      ##
##------------------------------------------------------------------------##
##                                                                        ##
## Macros used for compression are ADD2PACK and PACKZX7B:                 ##
##                                                                        ##
##	ADD2PACK: Adds files to packed (compressed) groups. Each call to this ##
##  		  macro will add a file to a named compressed group.          ##
##  PACKZX7B: Compresses all files in a group into a single binary and    ##
##            generates a C-array and a header to comfortably use it from ##
##            inside your code.                                           ##
##                                                                        ##
##------------------------------------------------------------------------##
##                                                                        ##
##  $(eval $(call ADD2PACK,<packname>,<file>))                            ##
##                                                                        ##
##		Sequentially adds <file> to compressed group <packname>. Each     ##
## call to this macro adds a new <file> after the latest one added.       ##
## packname could be any valid C identifier.                              ##
##                                                                        ##
##  Parameters:                                                           ##
##  (packname): Name of the compressed group where the file will be added ##
##  (file)    : File to be added at the end of the compressed group       ##
##                                                                        ##
##------------------------------------------------------------------------##
##                                                                        ##
##  $(eval $(call PACKZX7B,<packname>,<dest_path>))                       ##
##                                                                        ##
##		Compresses all files in the <packname> group using ZX7B algorithm ##
## and generates 2 files: <packname>.c and <packname>.h that contain a    ##
## C-array with the compressed data and a header file for declarations.   ##
## Generated files are moved to the folder <dest_path>.                   ##
##                                                                        ##
##  Parameters:                                                           ##
##  (packname) : Name of the compressed group to use for packing          ##
##  (dest_path): Destination path for generated output files              ##
##                                                                        ##
############################################################################
##                                                                        ##
## Important:                                                             ##
##  * Do NOT separate macro parameters with spaces, blanks or other chars.##
##    ANY character you put into a macro parameter will be passed to the  ##
##    macro. Therefore ...,src/sprites,... will represent "src/sprites"   ##
##    folder, whereas ...,  src/sprites,... means "  src/sprites" folder. ##
##  * You can omit parameters by leaving them empty.                      ##
##  * Parameters (4) and (5) are optional and generally not required.     ##
############################################################################
