
;; Continental Circus - original release - Virgin
;;
;; large cassette case with single cassette. 
;;
;; - there is a 2 block standard CPC loader at standard 1000 baud
;;   first block is 2K long, second is approx 1.5K long
;; 
;;   this is followed by the speedlock blocks
;;
;; - a copyright message is displayed after loader is decrypted

;; - multi-colour border stripes for speedlock leader

;; - blue and black border stripes for for speedlock data

;; - there is a small encrypted speedlock block followed by main speedlock blocks
;;
;; In the case of Continental Circus, the main block is small and is a
;; second loader for the remaining main file.

;;-------------------------------------------------------------------
;; jumps here if load has failed

a43a 06f6      ld      b,$f6
a43c af        xor     a
a43d ed79      out     (c),a			;; stop cassette motor

a43f dd7700    ld      (ix+$00),a
a442 dd2b      dec     ix				;; clear all memory
a444 18f9      jr      $a43f            

;;-------------------------------------------------------------------

a446 d1        pop     de
a447 08        ex      af,af'
a448 fe01      cp      $01				;; test checksum

a44a 067f      ld      b,$7f			;; set border to black
a44c 3e10      ld      a,$10
a44e ed79      out     (c),a
a450 3e54      ld      a,$54
a452 ed79      out     (c),a

a454 d9        exx     
a455 e1        pop     hl
a456 d9        exx     
a457 d8        ret     c				

;; load failed
a458 18e0      jr      $a43a            


;;-------------------------------------------------------------------
;; get leader pulse
;; A = delay in 16T/4us units
;; H = pulse count
;; L' = border colour
;; C = previous cassette input bit state

;; B corrupted

a45a 3d        dec     a				;; delay. each loop takes 4us (16T states)
a45b 20fd      jr      nz,$a45a         

a45d a7        and     a				;; case where jr takes 2us (condition not met)
										;; final loop will take 4us as well.
										
;; wait for cassette data input to change state
;; h = duration of pulse (0 = 256)

a45e 24        inc     h				;; counts time that pulse remains in current state
a45f c8        ret     z

a460 06f5      ld      b,$f5			;; PPI port B

a462 ed78      in      a,(c)			;; read PPI port B input
a464 a9        xor     c				;; previous cassette data input state
a465 e680      and     $80				;; cassette data input
a467 28f5      jr      z,$a45e          ;; jump if state not changed

a469 067f      ld      b,$7f			
a46b 3e10      ld      a,$10
a46d ed79      out     (c),a			;; select border

a46f 79        ld      a,c				;; toggle cassette data input state
a470 2f        cpl     
a471 4f        ld      c,a

;; border colour for leader
a472 d9        exx     
a473 7d        ld      a,l				;; colour
a474 3c        inc     a				;; increment
a475 e60f      and     $0f
a477 6f        ld      l,a

a478 f620      or      $20
a47a d9        exx     

a47b 17        rla     
a47c ed79      out     (c),a			;; set border colour
a47e 37        scf     
a47f c9        ret     


;;-------------------------------------------------------------------
;; get data pulse

a480 3d        dec     a				;; [1]
a481 20fd      jr      nz,$a480         ;; [3]		4us = 16T

a483 a7        and     a				;; [1]

;; count length of pulse
a484 24        inc     h
a485 c8        ret     z

a486 06f5      ld      b,$f5
a488 ed78      in      a,(c)
a48a a9        xor     c
a48b e680      and     $80
a48d 28f5      jr      z,$a484          ; (-$0b)

a48f 067f      ld      b,$7f
a491 3e10      ld      a,$10
a493 ed79      out     (c),a			;; select border

a495 79        ld      a,c
a496 2f        cpl     
a497 4f        ld      c,a

a498 1f        rra     
a499 3e2a      ld      a,$2a			
a49b 17        rla     
a49c 3d        dec     a

a49d ed79      out     (c),a			;; border colour for data
a49f 37        scf     
a4a0 c9        ret     

;;---------------------------------------------------------

a4a1 06f6      ld      b,$f6
a4a3 3e10      ld      a,$10
a4a5 ed79      out     (c),a			;; start cassette

a4a7 d9        exx     
a4a8 e5        push    hl
a4a9 2e00      ld      l,$00
a4ab d9        exx     
a4ac 214aa4    ld      hl,$a44a
a4af e5        push    hl
a4b0 06f5      ld      b,$f5
a4b2 ed78      in      a,(c)
a4b4 e680      and     $80
a4b6 4f        ld      c,a
a4b7 cd5aa4    call    $a45a			;; leader
a4ba 30fb      jr      nc,$a4b7         ; (-$05)

a4bc 211504    ld      hl,$0415
a4bf 10fe      djnz    $a4bf            ; (-$02)
a4c1 2b        dec     hl
a4c2 7c        ld      a,h
a4c3 b5        or      l
a4c4 20f9      jr      nz,$a4bf         ; (-$07)

a4c6 3e0a      ld      a,$0a
a4c8 cd5aa4    call    $a45a			;; leader
a4cb 30ea      jr      nc,$a4b7         ; (-$16)

a4cd 26c4      ld      h,$c4
a4cf 3e1c      ld      a,$1c
a4d1 cd5aa4    call    $a45a			;; leader
a4d4 30e1      jr      nc,$a4b7         ; (-$1f)

a4d6 3eda      ld      a,$da
a4d8 bc        cp      h
a4d9 38f2      jr      c,$a4cd          ; (-$0e)

a4db 26c4      ld      h,$c4
a4dd 3e1c      ld      a,$1c
a4df cd5aa4    call    $a45a			;; leader
a4e2 30d3      jr      nc,$a4b7         ; (-$2d)

a4e4 3eda      ld      a,$da
a4e6 bc        cp      h
a4e7 38e4      jr      c,$a4cd          ; (-$1c)

a4e9 fd21c0a9  ld      iy,$a9c0
a4ed fd6e00    ld      l,(iy+$00)
a4f0 26c4      ld      h,$c4
a4f2 3e1c      ld      a,$1c
a4f4 cd5aa4    call    $a45a			;; leader
a4f7 30be      jr      nc,$a4b7         ; (-$42)
a4f9 3ed7      ld      a,$d7
a4fb bc        cp      h
a4fc 30dd      jr      nc,$a4db         ; (-$23)
a4fe 2c        inc     l
a4ff 20ef      jr      nz,$a4f0         ; (-$11)
a501 2670      ld      h,$70
a503 3e1c      ld      a,$1c
a505 cd5aa4    call    $a45a			;; leader
a508 30ad      jr      nc,$a4b7         ; (-$53)
a50a 3e1c      ld      a,$1c
a50c cd5aa4    call    $a45a			;; leader
a50f 30a6      jr      nc,$a4b7         ; (-$5a)

a511 7c        ld      a,h
a512 fecd      cp      $cd
a514 300e      jr      nc,$a524         ; (+$0e)

a516 fe9c      cp      $9c
a518 30cf      jr      nc,$a4e9         ; (-$31)

a51a fd23      inc     iy
a51c fd7d      ld      a,iyl
a51e fec4      cp      $c4				; compare for end of pulse table
a520 20cb      jr      nz,$a4ed         ; (-$35)
a522 18c5      jr      $a4e9            ; (-$3b)

a524 3e0b      ld      a,$0b

;; fetch 5 bits
a526 2680      ld      h,$80			; pulse timing dependant
a528 2e08      ld      l,$08			; 5 bits
a52a 3e0b      ld      a,$0b			; initial delay
a52c 1802      jr      $a530            ; 

;;---------------------------------------------------

;; L is initially a bitmask which is used to define number of bits to fetch
;; and after will contain a byte of data 
;; e.g. if L is 8 -> 00001000 then 5 bits will be read
;; and the upper 3 bits will be 000
;; H = timing constant

;; initial sync

a52e 3e09      ld      a,$09			;; pulse timing dependant
a530 cd80a4    call    $a480			;; data pulse
a533 d0        ret     nc				 

a534 3e0b      ld      a,$0b			;; pulse timing dependant
a536 cd80a4    call    $a480			;; data pulse
a539 d0        ret     nc

a53a 3e9f      ld      a,$9f			;; pulse timing dependant
a53c bc        cp      h				;; nc : greater or equal, c : less

a53d cb15      rl      l				;; shift into byte

a53f 2680      ld      h,$80			;; pulse timing dependant
a541 d22ea5    jp      nc,$a52e			;; will keep going until bit shifted into carry is 1.


a544 3e1d      ld      a,$1d			;; check: 11101
a546 bd        cp      l
a547 c23aa4    jp      nz,$a43a			;; load fail

;; succeeded

a54a 00        nop     
a54b af        xor     a
a54c 08        ex      af,af'

a54d 26a1      ld      h,$a1			;; timing constant
a54f 2e01      ld      l,$01			;; 8 bits
a551 fd2100ac  ld      iy,$ac00
a555 3e04      ld      a,$04			;; delay
a557 1817      jr      $a570            ;; fetch first byte

;;---------------------------------
;; L = data byte
a559 3e46      ld      a,$46			;; decrypt byte (these bytes are different for each program!!)
a55b ad        xor     l
a55c c68d      add     a,$8d			
a55e dd7700    ld      (ix+$00),a		;; write to ram
a561 dd23      inc     ix				;; increment ram pointer
a563 1b        dec     de				;; decrement byte count


a564 26a1      ld      h,$a1			; timing constant
a566 2e01      ld      l,$01
a568 2e01      ld      l,$01			; 8 bits
a56a 3e01      ld      a,$01			; delay
a56c 1802      jr      $a570            ; fetch byte

;;----------------------------------
;; L = bit-mask defining number of bits to fetch
;; H = timing constant
;; data bits

a56e 3e09      ld      a,$09
a570 cd80a4    call    $a480			;; data pulse
a573 d0        ret     nc

a574 3e0b      ld      a,$0b
a576 cd80a4    call    $a480			;; data pulse
a579 d0        ret     nc

a57a 3ec0      ld      a,$c0			;; timing constant (0/1)
a57c bc        cp      h
a57d cb15      rl      l

a57f 26a1      ld      h,$a1			;; timing constant (0/1)
a581 d26ea5    jp      nc,$a56e

;; update checksum
a584 08        ex      af,af'
a585 ad        xor     l
a586 08        ex      af,af'

a587 7a        ld      a,d
a588 b3        or      e
a589 20ce      jr      nz,$a559         ;; any more bytes?

a58b c346a4    jp      $a446			;; check checksum and quit


;; ---------------------
;; L = data byte
a58e 3e46      ld      a,$46			;; decrypt byte (these are different for each program)
a590 ad        xor     l
a591 c68d      add     a,$8d			;; 
a593 dd7700    ld      (ix+$00),a		;; write to ram
a596 dd23      inc     ix				;; increment ram pointer
a598 1b        dec     de				;; decrement count

;; sub-block sync
a599 2e02      ld      l,$02			;; 7 bits
a59b 3e04      ld      a,$04			;; delay
a59d 26b3      ld      h,$b3			;; timing constant
a59f cd0ba6    call    $a60b
a5a2 d0        ret     nc


;; table entry:
;; 0,1 = load address
;; 2,3 = length
;; 4 = unused on CPC


a5a3 fd7e04    ld      a,(iy+$04)		;; end of table?
a5a6 b7        or      a
a5a7 285a      jr      z,$a603          ; (+$5a)

a5a9 69        ld      l,c
a5aa 01007f    ld      bc,$7f00
a5ad 00        nop     
a5ae 00        nop     
a5af 00        nop     
a5b0 fd4e00    ld      c,(iy+$00)		;; get load address from table
a5b3 fd4601    ld      b,(iy+$01)
a5b6 dd210000  ld      ix,$0000
a5ba dd09      add     ix,bc
a5bc 4d        ld      c,l

;; sub block sync
a5bd 3e01      ld      a,$01			;; delay
a5bf 2e02      ld      l,$02			;; 7 bits
a5c1 26b3      ld      h,$b3			;; timing constant
a5c3 cd0ba6    call    $a60b			
a5c6 d0        ret     nc

;; check if copied
a5c7 3e7f      ld      a,$7f			
a5c9 bd        cp      l
a5ca 2803      jr      z,$a5cf          ;
;; copied.
a5cc 32bfa9    ld      ($a9bf),a

;; sub block sync
a5cf 2e02      ld      l,$02			;; 7 bits
a5d1 3e08      ld      a,$08			;; delay
a5d3 26b3      ld      h,$b3			;; timing constant
a5d5 cd0ba6    call    $a60b
a5d8 d0        ret     nc

a5d9 fd5e02    ld      e,(iy+$02)			;; get length from table
a5dc fd5603    ld      d,(iy+$03)
a5df 69        ld      l,c
a5e0 010500    ld      bc,$0005				;; size of each entry in table
a5e3 fd09      add     iy,bc

a5e5 4d        ld      c,l
a5e6 7b        ld      a,e
a5e7 b2        or      d

a5e8 26a1      ld      h,$a1				;; timing constant
a5ea 2e01      ld      l,$01				;; 8 bits
a5ec 3e01      ld      a,$01				;; delay
a5ee c270a5    jp      nz,$a570

;; check checksum and quit
a5f1 1146a4    ld      de,$a446
a5f4 ed538ca5  ld      ($a58c),de

a5f8 1173a5    ld      de,$a573
a5fb d5        push    de
a5fc ed5be2a9  ld      de,($a9e2)
a600 c384a4    jp      $a484

;; finished loading from table
a603 3e06      ld      a,$06
a605 00        nop     
a606 00        nop     
a607 18b6      jr      $a5bf            ; (-$4a)

;;----------------------------------------------------
;; sub-block sync pulses

;; L is bitmask 
a609 3e0d      ld      a,$0d
a60b cd80a4    call    $a480			;; data pulse
a60e 3e10      ld      a,$10
a610 cd80a4    call    $a480			;; data pulse
a613 d0        ret     nc

a614 3edb      ld      a,$db
a616 bc        cp      h
a617 cb15      rl      l
a619 26b3      ld      h,$b3
a61b d209a6    jp      nc,$a609
a61e c9        ret     

;;-----------------------------------------------

a61f cda1a4    call    $a4a1
a622 210080    ld      hl,$8000
a625 06ff      ld      b,$ff
a627 c5        push    bc
a628 1e00      ld      e,$00
a62a 4b        ld      c,e
a62b 16ff      ld      d,$ff
a62d 06f5      ld      b,$f5
a62f ed78      in      a,(c)
a631 e680      and     $80
a633 a9        xor     c
a634 2850      jr      z,$a686          ; (+$50)
a636 1c        inc     e
a637 79        ld      a,c
a638 2f        cpl     
a639 e680      and     $80
a63b 4f        ld      c,a
a63c 15        dec     d
a63d c22da6    jp      nz,$a62d
a640 73        ld      (hl),e
a641 23        inc     hl
a642 c1        pop     bc
a643 10e2      djnz    $a627            ; (-$1e)
a645 210000    ld      hl,$0000
a648 113280    ld      de,$8032
a64b 0632      ld      b,$32
a64d c5        push    bc
a64e 1a        ld      a,(de)
a64f 0600      ld      b,$00
a651 4f        ld      c,a
a652 09        add     hl,bc
a653 13        inc     de
a654 c1        pop     bc
a655 10f6      djnz    $a64d            ; (-$0a)
a657 e5        push    hl
a658 210000    ld      hl,$0000
a65b 11cd80    ld      de,$80cd
a65e 0632      ld      b,$32
a660 c5        push    bc
a661 1a        ld      a,(de)
a662 0600      ld      b,$00
a664 4f        ld      c,a
a665 09        add     hl,bc
a666 13        inc     de
a667 c1        pop     bc
a668 10f6      djnz    $a660            ; (-$0a)
a66a c1        pop     bc
a66b 7c        ld      a,h
a66c b7        or      a
a66d 2013      jr      nz,$a682         ; (+$13)
a66f a7        and     a
a670 ed42      sbc     hl,bc
a672 013200    ld      bc,$0032
a675 a7        and     a
a676 ed42      sbc     hl,bc
a678 d8        ret     c

a679 09        add     hl,bc
a67a 01cdff    ld      bc,$ffcd
a67d a7        and     a
a67e ed42      sbc     hl,bc
a680 d0        ret     nc

a681 3c        inc     a
a682 32bfa9    ld      ($a9bf),a
a685 c9        ret     

a686 00        nop     
a687 00        nop     
a688 c33ca6    jp      $a63c

;;----------------------------------------------------
;; output copyright message

a68b 3e01      ld      a,$01
a68d cd0ebc    call    $bc0e			;; mode 1

a690 2163a7    ld      hl,$a763
a693 cdfba6    call    $a6fb			;; set palette

a696 3e01      ld      a,$01
a698 cd72bb    call    $bb72

a69b 3e0d      ld      a,$0d
a69d cd6fbb    call    $bb6f

a6a0 2173a7    ld      hl,$a773
a6a3 cd4aa7    call    $a74a			;; output text

a6a6 0602      ld      b,$02
a6a8 0e0d      ld      c,$0d
a6aa 3e10      ld      a,$10
a6ac cd24a7    call    $a724			;; draw thick bar

a6af 3e04      ld      a,$04
a6b1 cd72bb    call    $bb72
a6b4 3e03      ld      a,$03
a6b6 cd6fbb    call    $bb6f
a6b9 218ca7    ld      hl,$a78c
a6bc cd4aa7    call    $a74a			;; output text
a6bf 3e0b      ld      a,$0b
a6c1 cd72bb    call    $bb72
a6c4 3e11      ld      a,$11
a6c6 cd6fbb    call    $bb6f
a6c9 2184a7    ld      hl,$a784
a6cc cd4aa7    call    $a74a			;; output text
a6cf 060c      ld      b,$0c
a6d1 0e11      ld      c,$11
a6d3 3e07      ld      a,$07
a6d5 cd24a7    call    $a724			;; draw thick bar
a6d8 3e0e      ld      a,$0e
a6da cd72bb    call    $bb72
a6dd 3e04      ld      a,$04
a6df cd6fbb    call    $bb6f
a6e2 2155a8    ld      hl,$a855
a6e5 cd4aa7    call    $a74a
a6e8 3e16      ld      a,$16
a6ea cd72bb    call    $bb72
a6ed 3e03      ld      a,$03
a6ef cd6fbb    call    $bb6f
a6f2 2146a9    ld      hl,$a946
a6f5 cd4aa7    call    $a74a			;; output text

a6f8 2153a7    ld      hl,$a753
a6fb af        xor     a
a6fc f5        push    af
a6fd 46        ld      b,(hl)
a6fe 48        ld      c,b
a6ff 23        inc     hl
a700 e5        push    hl
a701 cd32bc    call    $bc32			;; set pen colour
a704 e1        pop     hl
a705 f1        pop     af
a706 3c        inc     a
a707 fe10      cp      $10
a709 20f1      jr      nz,$a6fc         ; 

a70b 0600      ld      b,$00
a70d 48        ld      c,b
a70e cd38bc    call    $bc38			;; set border color

;; wait for 6 full screen refreshes
a711 1e06      ld      e,$06
a713 06f5      ld      b,$f5

;; wait for end of vsync
a715 ed78      in      a,(c)
a717 1f        rra     
a718 38fb      jr      c,$a715          ; (-$05)
;; wait for start of vsync
a71a ed78      in      a,(c)
a71c 1f        rra     
a71d 30fb      jr      nc,$a71a         ; (-$05)
a71f 1d        dec     e
a720 20f1      jr      nz,$a713         ; (-$0f)

a722 f3        di      
a723 c9        ret     

;;------------------------------------------------------------
;; draw thick horizontal bar (in color 1 (mode 2), 3 (mode 1), 15 (mode 0))
;; B = row number (1-25)
;; C = x pixel coordinate

a724 2100c0    ld      hl,$c000			;; start address of screen
a727 0d        dec     c
a728 cb21      sla     c

a72a 05        dec     b
a72b 2806      jr      z,$a733          

;; B = row number (each row is 8 lines tall)

a72d 115000    ld      de,$0050			;; width of screen line in bytes
a730 19        add     hl,de
a731 10fd      djnz    $a730            

a733 09        add     hl,bc

a734 0602      ld      b,$02			;; height of bar

a736 4f        ld      c,a
a737 cb21      sla     c

a739 c5        push    bc
a73a e5        push    hl

;; write number of bytes defined by C register
a73b 36ff      ld      (hl),$ff			;; pixel data (4 pixels mode 1, 2 pixels mode 0, 8 pixels mode 2)
a73d 0d        dec     c
a73e 23        inc     hl
a73f 20fa      jr      nz,$a73b         

a741 e1        pop     hl
a742 7c        ld      a,h				;; advance to next line down screen 
a743 c608      add     a,$08
a745 67        ld      h,a
a746 c1        pop     bc
a747 10f0      djnz    $a739            
a749 c9        ret     

;;-----------------------------------------------------------
;; output zero terminated string to screen
a74a 7e        ld      a,(hl)
a74b b7        or      a
a74c c8        ret     z

a74d cd5abb    call    $bb5a			;; firmware function "txt output"
a750 23        inc     hl
a751 18f7      jr      $a74a            
;;-----------------------------------------------------------
;; colours defined using firmware numbers

a753 00        nop     
a754 1a        ld      a,(de)
a755 14        inc     d
a756 0600      ld      b,$00
a758 00        nop     
a759 00        nop     
a75a 00        nop     
a75b 00        nop     
a75c 00        nop     
a75d 00        nop     
a75e 00        nop     
a75f 00        nop     
a760 00        nop     
a761 00        nop     
a762 00        nop     
a763 00        nop     
a764 00        nop     
a765 00        nop     
a766 00        nop     
a767 00        nop     
a768 00        nop     
a769 00        nop     
a76a 00        nop     
a76b 00        nop     
a76c 00        nop     
a76d 00        nop     
a76e 00        nop     
a76f 00        nop     
a770 00        nop     
a771 00        nop     
a772 00        nop     

;; text (in standard ASCII)
a773 43        ld      b,e
a774 4f        ld      c,a
a775 50        ld      d,b
a776 59        ld      e,c
a777 52        ld      d,d
a778 49        ld      c,c
a779 47        ld      b,a
a77a 48        ld      c,b
a77b 54        ld      d,h
a77c 204e      jr      nz,$a7cc         ; (+$4e)
a77e 4f        ld      c,a
a77f 54        ld      d,h
a780 49        ld      c,c
a781 43        ld      b,e
a782 45        ld      b,l
a783 00        nop     
a784 57        ld      d,a
a785 41        ld      b,c
a786 52        ld      d,d
a787 4e        ld      c,(hl)
a788 49        ld      c,c
a789 4e        ld      c,(hl)
a78a 47        ld      b,a
a78b 00        nop     
a78c 54        ld      d,h
a78d 68        ld      l,b
a78e 69        ld      l,c
a78f 73        ld      (hl),e
a790 2070      jr      nz,$a802         ; (+$70)
a792 72        ld      (hl),d
a793 6f        ld      l,a
a794 67        ld      h,a
a795 72        ld      (hl),d
a796 61        ld      h,c
a797 6d        ld      l,l
a798 2069      jr      nz,$a803         ; (+$69)
a79a 73        ld      (hl),e
a79b 2070      jr      nz,$a80d         ; (+$70)
a79d 72        ld      (hl),d
a79e 6f        ld      l,a
a79f 74        ld      (hl),h
a7a0 65        ld      h,l
a7a1 63        ld      h,e
a7a2 74        ld      (hl),h
a7a3 65        ld      h,l
a7a4 64        ld      h,h
a7a5 2075      jr      nz,$a81c         ; (+$75)
a7a7 6e        ld      l,(hl)
a7a8 64        ld      h,h
a7a9 65        ld      h,l
a7aa 72        ld      (hl),d
a7ab 2055      jr      nz,$a802         ; (+$55)
a7ad 2e4b      ld      l,$4b
a7af 2e20      ld      l,$20
a7b1 2020      jr      nz,$a7d3         ; (+$20)
a7b3 2043      jr      nz,$a7f8         ; (+$43)
a7b5 6f        ld      l,a
a7b6 70        ld      (hl),b
a7b7 79        ld      a,c
a7b8 72        ld      (hl),d
a7b9 69        ld      l,c
a7ba 67        ld      h,a
a7bb 68        ld      l,b
a7bc 74        ld      (hl),h
a7bd 204c      jr      nz,$a80b         ; (+$4c)
a7bf 61        ld      h,c
a7c0 77        ld      (hl),a
a7c1 2061      jr      nz,$a824         ; (+$61)
a7c3 6e        ld      l,(hl)
a7c4 64        ld      h,h
a7c5 206d      jr      nz,$a834         ; (+$6d)
a7c7 61        ld      h,c
a7c8 79        ld      a,c
a7c9 206e      jr      nz,$a839         ; (+$6e)
a7cb 6f        ld      l,a
a7cc 74        ld      (hl),h
a7cd 2062      jr      nz,$a831         ; (+$62)
a7cf 65        ld      h,l
a7d0 2063      jr      nz,$a835         ; (+$63)
a7d2 6f        ld      l,a
a7d3 70        ld      (hl),b
a7d4 69        ld      l,c
a7d5 65        ld      h,l
a7d6 64        ld      h,h
a7d7 2c        inc     l
a7d8 2020      jr      nz,$a7fa         ; (+$20)
a7da 2020      jr      nz,$a7fc         ; (+$20)
a7dc 68        ld      l,b
a7dd 69        ld      l,c
a7de 72        ld      (hl),d
a7df 65        ld      h,l
a7e0 64        ld      h,h
a7e1 206f      jr      nz,$a852         ; (+$6f)
a7e3 72        ld      (hl),d
a7e4 2072      jr      nz,$a858         ; (+$72)
a7e6 65        ld      h,l
a7e7 70        ld      (hl),b
a7e8 72        ld      (hl),d
a7e9 6f        ld      l,a
a7ea 64        ld      h,h
a7eb 75        ld      (hl),l
a7ec 63        ld      h,e
a7ed 65        ld      h,l
a7ee 64        ld      h,h
a7ef 2c        inc     l
a7f0 206f      jr      nz,$a861         ; (+$6f)
a7f2 72        ld      (hl),d
a7f3 206f      jr      nz,$a864         ; (+$6f)
a7f5 74        ld      (hl),h
a7f6 68        ld      l,b
a7f7 65        ld      h,l
a7f8 72        ld      (hl),d
a7f9 77        ld      (hl),a
a7fa 69        ld      l,c
a7fb 73        ld      (hl),e
a7fc 65        ld      h,l
a7fd 2020      jr      nz,$a81f         ; (+$20)
a7ff 2020      jr      nz,$a821         ; (+$20)
a801 2020      jr      nz,$a823         ; (+$20)
a803 206d      jr      nz,$a872         ; (+$6d)
a805 6f        ld      l,a
a806 64        ld      h,h
a807 69        ld      l,c
a808 66        ld      h,(hl)
a809 69        ld      l,c
a80a 65        ld      h,l
a80b 64        ld      h,h
a80c 2077      jr      nz,$a885         ; (+$77)
a80e 69        ld      l,c
a80f 74        ld      (hl),h
a810 68        ld      l,b
a811 6f        ld      l,a
a812 75        ld      (hl),l
a813 74        ld      (hl),h
a814 2074      jr      nz,$a88a         ; (+$74)
a816 68        ld      l,b
a817 65        ld      h,l
a818 2063      jr      nz,$a87d         ; (+$63)
a81a 6f        ld      l,a
a81b 6e        ld      l,(hl)
a81c 73        ld      (hl),e
a81d 65        ld      h,l
a81e 6e        ld      l,(hl)
a81f 74        ld      (hl),h
a820 206f      jr      nz,$a891         ; (+$6f)
a822 66        ld      h,(hl)
a823 2074      jr      nz,$a899         ; (+$74)
a825 68        ld      l,b
a826 65        ld      h,l
a827 2020      jr      nz,$a849         ; (+$20)
a829 2020      jr      nz,$a84b         ; (+$20)
a82b 2043      jr      nz,$a870         ; (+$43)
a82d 6f        ld      l,a
a82e 70        ld      (hl),b
a82f 79        ld      a,c
a830 72        ld      (hl),d
a831 69        ld      l,c
a832 67        ld      h,a
a833 68        ld      l,b
a834 74        ld      (hl),h
a835 204f      jr      nz,$a886         ; (+$4f)
a837 77        ld      (hl),a
a838 6e        ld      l,(hl)
a839 65        ld      h,l
a83a 72        ld      (hl),d
a83b 2e20      ld      l,$20
a83d 2020      jr      nz,$a85f         ; (+$20)
a83f 2020      jr      nz,$a861         ; (+$20)
a841 2020      jr      nz,$a863         ; (+$20)
a843 2020      jr      nz,$a865         ; (+$20)
a845 2020      jr      nz,$a867         ; (+$20)
a847 2020      jr      nz,$a869         ; (+$20)
a849 2020      jr      nz,$a86b         ; (+$20)
a84b 2020      jr      nz,$a86d         ; (+$20)
a84d 2020      jr      nz,$a86f         ; (+$20)
a84f 2020      jr      nz,$a871         ; (+$20)
a851 2020      jr      nz,$a873         ; (+$20)
a853 2000      jr      nz,$a855         ; (+$00)
a855 49        ld      c,c
a856 74        ld      (hl),h
a857 2069      jr      nz,$a8c2         ; (+$69)
a859 73        ld      (hl),e
a85a 2061      jr      nz,$a8bd         ; (+$61)
a85c 2043      jr      nz,$a8a1         ; (+$43)
a85e 52        ld      d,d
a85f 49        ld      c,c
a860 4d        ld      c,l
a861 49        ld      c,c
a862 4e        ld      c,(hl)
a863 41        ld      b,c
a864 4c        ld      c,h
a865 204f      jr      nz,$a8b6         ; (+$4f)
a867 46        ld      b,(hl)
a868 46        ld      b,(hl)
a869 45        ld      b,l
a86a 4e        ld      c,(hl)
a86b 43        ld      b,e
a86c 45        ld      b,l
a86d 2074      jr      nz,$a8e3         ; (+$74)
a86f 6f        ld      l,a
a870 2073      jr      nz,$a8e5         ; (+$73)
a872 65        ld      h,l
a873 6c        ld      l,h
a874 6c        ld      l,h
a875 2c        inc     l
a876 2020      jr      nz,$a898         ; (+$20)
a878 2020      jr      nz,$a89a         ; (+$20)
a87a 2020      jr      nz,$a89c         ; (+$20)
a87c 2068      jr      nz,$a8e6         ; (+$68)
a87e 69        ld      l,c
a87f 72        ld      (hl),d
a880 65        ld      h,l
a881 2c        inc     l
a882 206f      jr      nz,$a8f3         ; (+$6f)
a884 66        ld      h,(hl)
a885 66        ld      h,(hl)
a886 65        ld      h,l
a887 72        ld      (hl),d
a888 206f      jr      nz,$a8f9         ; (+$6f)
a88a 72        ld      (hl),d
a88b 2065      jr      nz,$a8f2         ; (+$65)
a88d 78        ld      a,b
a88e 70        ld      (hl),b
a88f 6f        ld      l,a
a890 73        ld      (hl),e
a891 65        ld      h,l
a892 2066      jr      nz,$a8fa         ; (+$66)
a894 6f        ld      l,a
a895 72        ld      (hl),d
a896 2073      jr      nz,$a90b         ; (+$73)
a898 61        ld      h,c
a899 6c        ld      l,h
a89a 65        ld      h,l
a89b 206f      jr      nz,$a90c         ; (+$6f)
a89d 72        ld      (hl),d
a89e 2020      jr      nz,$a8c0         ; (+$20)
a8a0 2020      jr      nz,$a8c2         ; (+$20)
a8a2 2020      jr      nz,$a8c4         ; (+$20)
a8a4 2068      jr      nz,$a90e         ; (+$68)
a8a6 69        ld      l,c
a8a7 72        ld      (hl),d
a8a8 65        ld      h,l
a8a9 2c        inc     l
a8aa 206f      jr      nz,$a91b         ; (+$6f)
a8ac 72        ld      (hl),d
a8ad 206f      jr      nz,$a91e         ; (+$6f)
a8af 74        ld      (hl),h
a8b0 68        ld      l,b
a8b1 65        ld      h,l
a8b2 72        ld      (hl),d
a8b3 77        ld      (hl),a
a8b4 69        ld      l,c
a8b5 73        ld      (hl),e
a8b6 65        ld      h,l
a8b7 2064      jr      nz,$a91d         ; (+$64)
a8b9 69        ld      l,c
a8ba 73        ld      (hl),e
a8bb 74        ld      (hl),h
a8bc 72        ld      (hl),d
a8bd 69        ld      l,c
a8be 62        ld      h,d
a8bf 75        ld      (hl),l
a8c0 74        ld      (hl),h
a8c1 65        ld      h,l
a8c2 2020      jr      nz,$a8e4         ; (+$20)
a8c4 2020      jr      nz,$a8e6         ; (+$20)
a8c6 2020      jr      nz,$a8e8         ; (+$20)
a8c8 2020      jr      nz,$a8ea         ; (+$20)
a8ca 2020      jr      nz,$a8ec         ; (+$20)
a8cc 2069      jr      nz,$a937         ; (+$69)
a8ce 6e        ld      l,(hl)
a8cf 66        ld      h,(hl)
a8d0 72        ld      (hl),d
a8d1 69        ld      l,c
a8d2 6e        ld      l,(hl)
a8d3 67        ld      h,a
a8d4 69        ld      l,c
a8d5 6e        ld      l,(hl)
a8d6 67        ld      h,a
a8d7 2028      jr      nz,$a901         ; (+$28)
a8d9 49        ld      c,c
a8da 6c        ld      l,h
a8db 6c        ld      l,h
a8dc 65        ld      h,l
a8dd 67        ld      h,a
a8de 61        ld      h,c
a8df 6c        ld      l,h
a8e0 29        add     hl,hl
a8e1 2063      jr      nz,$a946         ; (+$63)
a8e3 6f        ld      l,a
a8e4 70        ld      (hl),b
a8e5 69        ld      l,c
a8e6 65        ld      h,l
a8e7 73        ld      (hl),e
a8e8 206f      jr      nz,$a959         ; (+$6f)
a8ea 66        ld      h,(hl)
a8eb 2020      jr      nz,$a90d         ; (+$20)
a8ed 2020      jr      nz,$a90f         ; (+$20)
a8ef 2020      jr      nz,$a911         ; (+$20)
a8f1 2020      jr      nz,$a913         ; (+$20)
a8f3 2020      jr      nz,$a915         ; (+$20)
a8f5 74        ld      (hl),h
a8f6 68        ld      l,b
a8f7 69        ld      l,c
a8f8 73        ld      (hl),e
a8f9 2063      jr      nz,$a95e         ; (+$63)
a8fb 6f        ld      l,a
a8fc 6d        ld      l,l
a8fd 70        ld      (hl),b
a8fe 75        ld      (hl),l
a8ff 74        ld      (hl),h
a900 65        ld      h,l
a901 72        ld      (hl),d
a902 2070      jr      nz,$a974         ; (+$70)
a904 72        ld      (hl),d
a905 6f        ld      l,a
a906 67        ld      h,a
a907 72        ld      (hl),d
a908 61        ld      h,c
a909 6d        ld      l,l
a90a 2061      jr      nz,$a96d         ; (+$61)
a90c 6e        ld      l,(hl)
a90d 64        ld      h,h
a90e 2070      jr      nz,$a980         ; (+$70)
a910 65        ld      h,l
a911 72        ld      (hl),d
a912 73        ld      (hl),e
a913 6f        ld      l,a
a914 6e        ld      l,(hl)
a915 73        ld      (hl),e
a916 2020      jr      nz,$a938         ; (+$20)
a918 2020      jr      nz,$a93a         ; (+$20)
a91a 2020      jr      nz,$a93c         ; (+$20)
a91c 2066      jr      nz,$a984         ; (+$66)
a91e 6f        ld      l,a
a91f 75        ld      (hl),l
a920 6e        ld      l,(hl)
a921 64        ld      h,h
a922 2064      jr      nz,$a988         ; (+$64)
a924 6f        ld      l,a
a925 69        ld      l,c
a926 6e        ld      l,(hl)
a927 67        ld      h,a
a928 2073      jr      nz,$a99d         ; (+$73)
a92a 6f        ld      l,a
a92b 2077      jr      nz,$a9a4         ; (+$77)
a92d 69        ld      l,c
a92e 6c        ld      l,h
a92f 6c        ld      l,h
a930 2062      jr      nz,$a994         ; (+$62)
a932 65        ld      h,l
a933 2070      jr      nz,$a9a5         ; (+$70)
a935 72        ld      (hl),d
a936 6f        ld      l,a
a937 73        ld      (hl),e
a938 65        ld      h,l
a939 63        ld      h,e
a93a 75        ld      (hl),l
a93b 74        ld      (hl),h
a93c 65        ld      h,l
a93d 64        ld      h,h
a93e 2e20      ld      l,$20
a940 2020      jr      nz,$a962         ; (+$20)
a942 2020      jr      nz,$a964         ; (+$20)
a944 2000      jr      nz,$a946         ; (+$00)
a946 41        ld      b,c
a947 6e        ld      l,(hl)
a948 79        ld      a,c
a949 2069      jr      nz,$a9b4         ; (+$69)
a94b 6e        ld      l,(hl)
a94c 66        ld      h,(hl)
a94d 6f        ld      l,a
a94e 72        ld      (hl),d
a94f 6d        ld      l,l
a950 61        ld      h,c
a951 74        ld      (hl),h
a952 69        ld      l,c
a953 6f        ld      l,a
a954 6e        ld      l,(hl)
a955 206f      jr      nz,$a9c6         ; (+$6f)
a957 6e        ld      l,(hl)
a958 2050      jr      nz,$a9aa         ; (+$50)
a95a 69        ld      l,c
a95b 72        ld      (hl),d
a95c 61        ld      h,c
a95d 63        ld      h,e
a95e 79        ld      a,c
a95f 2073      jr      nz,$a9d4         ; (+$73)
a961 68        ld      l,b
a962 6f        ld      l,a
a963 75        ld      (hl),l
a964 6c        ld      l,h
a965 64        ld      h,h
a966 2062      jr      nz,$a9ca         ; (+$62)
a968 65        ld      h,l
a969 2020      jr      nz,$a98b         ; (+$20)
a96b 2020      jr      nz,$a98d         ; (+$20)
a96d 2070      jr      nz,$a9df         ; (+$70)
a96f 61        ld      h,c
a970 73        ld      (hl),e
a971 73        ld      (hl),e
a972 65        ld      h,l
a973 64        ld      h,h
a974 2074      jr      nz,$a9ea         ; (+$74)
a976 6f        ld      l,a
a977 2074      jr      nz,$a9ed         ; (+$74)
a979 68        ld      l,b
a97a 65        ld      h,l
a97b 2046      jr      nz,$a9c3         ; (+$46)
a97d 65        ld      h,l
a97e 64        ld      h,h
a97f 65        ld      h,l
a980 72        ld      (hl),d
a981 61        ld      h,c
a982 74        ld      (hl),h
a983 69        ld      l,c
a984 6f        ld      l,a
a985 6e        ld      l,(hl)
a986 2041      jr      nz,$a9c9         ; (+$41)
a988 67        ld      h,a
a989 61        ld      h,c
a98a 69        ld      l,c
a98b 6e        ld      l,(hl)
a98c 73        ld      (hl),e
a98d 74        ld      (hl),h
a98e 2020      jr      nz,$a9b0         ; (+$20)
a990 2020      jr      nz,$a9b2         ; (+$20)
a992 2020      jr      nz,$a9b4         ; (+$20)
a994 2020      jr      nz,$a9b6         ; (+$20)
a996 53        ld      d,e
a997 6f        ld      l,a
a998 66        ld      h,(hl)
a999 74        ld      (hl),h
a99a 77        ld      (hl),a
a99b 61        ld      h,c
a99c 72        ld      (hl),d
a99d 65        ld      h,l
a99e 2054      jr      nz,$a9f4         ; (+$54)
a9a0 68        ld      l,b
a9a1 65        ld      h,l
a9a2 66        ld      h,(hl)
a9a3 74        ld      (hl),h
a9a4 202d      jr      nz,$a9d3         ; (+$2d)
a9a6 2054      jr      nz,$a9fc         ; (+$54)
a9a8 65        ld      h,l
a9a9 6c        ld      l,h
a9aa 2e20      ld      l,$20
a9ac 3031      jr      nc,$a9df         ; (+$31)
a9ae 2032      jr      nz,$a9e2         ; (+$32)
a9b0 34        inc     (hl)
a9b1 3020      jr      nc,$a9d3         ; (+$20)
a9b3 3637      ld      (hl),$37
a9b5 35        dec     (hl)
a9b6 3620      ld      (hl),$20
a9b8 2020      jr      nz,$a9da         ; (+$20)
a9ba 2020      jr      nz,$a9dc         ; (+$20)
a9bc 2020      jr      nz,$a9de         ; (+$20)
a9be 00        nop     
a9bf 00        nop     
a9c0 1e2a      ld      e,$2a
a9c2 2822      jr      z,$a9e6          ; (+$22)


;; code loaded to here
a9c4 00        nop     
a9c5 00        nop     
a9c6 00        nop     
a9c7 00        nop     
a9c8 00        nop     
a9c9 00        nop     
a9ca 00        nop     
a9cb 00        nop     
a9cc 00        nop     
a9cd 00        nop     
a9ce 00        nop     
a9cf 00        nop     
a9d0 00        nop     
a9d1 00        nop     
a9d2 00        nop     
a9d3 00        nop     
a9d4 00        nop     
a9d5 00        nop     
a9d6 00        nop     
a9d7 00        nop     
a9d8 00        nop     
a9d9 00        nop     
a9da 00        nop     
a9db 00        nop     
a9dc 00        nop     
a9dd 00        nop     
a9de 00        nop     
a9df 00        nop     
a9e0 00        nop     
a9e1 00        nop     
a9e2 00        nop     
a9e3 00        nop     
;; load first block, which will load the rest 
a9e4 dd21c4a9  ld      ix,$a9c4
a9e8 118f00    ld      de,$008f
a9eb cd1fa6    call    $a61f


;;------------------------------------------------------

;; this is the loaded data

;; load table
defw &0100
defw &00ff
defb &80
defw &a559
defw &0001
defb &80
defw &a58e
defw &0003
defb &80
defw &0200
defw &00ff
defb &80
defb &00

a9d8 00        nop     
a9d9 00        nop     
a9da 00        nop     
a9db 00        nop     
a9dc 00        nop     
a9dd 00        nop     
a9de 00        nop     
a9df 00        nop     
a9e0 00        nop     
a9e1 00        nop     
a9e2 2000      jr      nz,$a9e4         ; (+$00)

a9e4 dd21c4a9  ld      ix,$a9c4
a9e8 118f00    ld      de,$008f
a9eb cd1fa6    call    $a61f
 
;; enable multiface rom
a9ee 01e8fe    ld      bc,$fee8
a9f1 ed49      out     (c),c
;; check byte in multiface rom
a9f3 3a0000    ld      a,($0000)
a9f6 fef3      cp      $f3
a9f8 ca3aa4    jp      z,$a43a

;; initialse load table
a9fb dd2100ac  ld      ix,$ac00
a9ff dde5      push    ix
aa01 d1        pop     de
aa02 21c4a9    ld      hl,$a9c4
aa05 011e00    ld      bc,$001e
aa08 edb0      ldir    

;; copy remaining load code
aa0a 2118aa    ld      hl,$aa18
aa0d 1100bf    ld      de,$bf00
aa10 013b00    ld      bc,$003b
aa13 edb0      ldir    
aa15 c300bf    jp      $bf00

;; mode 1 - clear screen
aa18 3e01      ld      a,$01
aa1a cd0ebc    call    $bc0e
;; set palette and wait for 6 screen refreshes
aa1d 2128a4    ld      hl,$a428
aa20 cdfba6    call    $a6fb

aa23 31f8bf    ld      sp,$bff8
;; load address and length of initial block
aa26 dd2100c0  ld      ix,$c000
aa2a 114f00    ld      de,$004f

;; enable speedlock V2 style loading for remaining data
aa2d 218ea5    ld      hl,$a58e
aa30 228ca5    ld      ($a58c),hl
aa33 cda1a4    call    $a4a1

;; load ok?
aa36 3abfa9    ld      a,($a9bf)
aa39 b7        or      a
aa3a c23aa4    jp      nz,$a43a

;; the following confuses the floppy disc controller
;; and does not allow programs to save to disc
;;
;; the floppy disc controller has to be reset
;; to allow saving again - which can take quite a lot of code
aa3d 017ffb    ld      bc,$fb7f
aa40 3e03      ld      a,$03
aa42 ed79      out     (c),a

;; stop cassette motor
aa44 06f6      ld      b,$f6
aa46 af        xor     a
aa47 ed79      out     (c),a

;; and execute code (this is actually a Gremlin style loader!!)
aa49 ed4f      ld      r,a
aa4b 08        ex      af,af'
aa4c 31f8bf    ld      sp,$bff8
aa4f f3        di      
aa50 c30001    jp      $0100




;;------------------------------------------------------
;; from here is all garbage, used to fill the file so
;; it is much longer.
;;
;; this will defeat some tape-to-disc transfer programs

a9ee 25        dec     h
a9ef 9b        sbc     a,e
a9f0 dd7700    ld      (ix+$00),a
a9f3 cd969a    call    $9a96
a9f6 dd7701    ld      (ix+$01),a
a9f9 32309b    ld      ($9b30),a
a9fc cd969a    call    $9a96
a9ff dd7702    ld      (ix+$02),a
aa02 32319b    ld      ($9b31),a
aa05 cd969a    call    $9a96
aa08 dd7703    ld      (ix+$03),a
aa0b cd969a    call    $9a96
aa0e dd7704    ld      (ix+$04),a
aa11 0604      ld      b,$04
aa13 cd969a    call    $9a96
aa16 10fb      djnz    $aa13            ; (-$05)
aa18 21379b    ld      hl,$9b37
aa1b e5        push    hl
aa1c 111c00    ld      de,$001c
aa1f 19        add     hl,de
aa20 3601      ld      (hl),$01
aa22 e1        pop     hl
aa23 ed4b309b  ld      bc,($9b30)
aa27 3e01      ld      a,$01
aa29 3c        inc     a
aa2a 37        scf     
aa2b c9        ret     

aa2c ed5b309b  ld      de,($9b30)
aa30 ed732e9b  ld      ($9b2e),sp
aa34 cdf399    call    $99f3
aa37 3e01      ld      a,$01
aa39 3c        inc     a
aa3a 37        scf     
aa3b c9        ret     

aa3c 57        ld      d,a
aa3d 72        ld      (hl),d
aa3e 6f        ld      l,a
aa3f 6e        ld      l,(hl)
aa40 67        ld      h,a
aa41 2066      jr      nz,$aaa9         ; (+$66)
aa43 69        ld      l,c
aa44 6c        ld      l,h
aa45 65        ld      h,l
aa46 2074      jr      nz,$aabc         ; (+$74)
aa48 79        ld      a,c
aa49 70        ld      (hl),b
aa4a 65        ld      h,l
aa4b 0d        dec     c
aa4c ed7b2e9b  ld      sp,($9b2e)
aa50 21649a    ld      hl,$9a64
aa53 c36299    jp      $9962
aa56 c5        push    bc
aa57 01ddfa    ld      bc,$fadd
aa5a ed78      in      a,(c)
aa5c c1        pop     bc
aa5d c9        ret     

aa5e c5        push    bc
aa5f 01dcfa    ld      bc,$fadc
aa62 ed78      in      a,(c)
aa64 c1        pop     bc
aa65 c9        ret     

aa66 c5        push    bc
aa67 01ddfa    ld      bc,$fadd
aa6a ed79      out     (c),a
aa6c c1        pop     bc
aa6d c9        ret     

aa6e c5        push    bc
aa6f d5        push    de
aa70 dde5      push    ix
aa72 cda59a    call    $9aa5
aa75 dde1      pop     ix
aa77 d1        pop     de
aa78 c1        pop     bc
aa79 da7499    jp      c,$9974
aa7c c9        ret     

aa7d cd7e9a    call    $9a7e
aa80 17        rla     
aa81 d8        ret     c

aa82 1f        rra     
aa83 1f        rra     
aa84 3818      jr      c,$aa9e          ; (+$18)
aa86 0680      ld      b,$80
aa88 cdcc9a    call    $9acc
aa8b cd7e9a    call    $9a7e
aa8e 17        rla     
aa8f d8        ret     c

aa90 1f        rra     
aa91 1f        rra     
aa92 380a      jr      c,$aa9e          ; (+$0a)
aa94 3e42      ld      a,$42
aa96 cd1ebb    call    $bb1e
aa99 c27499    jp      nz,$9974
aa9c 18ed      jr      $aa8b            ; (-$13)
aa9e cd869a    call    $9a86
aaa1 6f        ld      l,a
aaa2 0600      ld      b,$00
aaa4 3a329b    ld      a,($9b32)
aaa7 e67f      and     $7f
aaa9 b0        or      b
aaaa 32329b    ld      ($9b32),a
aaad 3e05      ld      a,$05
aaaf cd8e9a    call    $9a8e
aab2 3a329b    ld      a,($9b32)
aab5 cd8e9a    call    $9a8e
aab8 7d        ld      a,l
aab9 a7        and     a
aaba c9        ret     

aabb 3ec3      ld      a,$c3
aabd 21049a    ld      hl,$9a04
aac0 3277bc    ld      ($bc77),a
aac3 2278bc    ld      ($bc78),hl
aac6 21549a    ld      hl,$9a54
aac9 3283bc    ld      ($bc83),a
aacc 2284bc    ld      ($bc84),hl
aacf 3e37      ld      a,$37
aad1 327abc    ld      ($bc7a),a
aad4 3ec9      ld      a,$c9
aad6 327bbc    ld      ($bc7b),a
aad9 21d998    ld      hl,$98d9
aadc 3ec3      ld      a,$c3
aade 3298bc    ld      ($bc98),a
aae1 2299bc    ld      ($bc99),hl
aae4 328cbc    ld      ($bc8c),a
aae7 21209b    ld      hl,$9b20
aaea 228dbc    ld      ($bc8d),hl
aaed 3e00      ld      a,$00



