;; HACKER - Ricochet re-release
;;
;; RICOCHET loader
;;
;; attributes:
;; - 1 block binary loader
;; - 6 byte header block followed by n byte data block; length defined by header block
;; (6 byte header block contains load address, length and execution address.)
;; - NO CHECKSUM!
;; - border flashes red/yellow stripes
;;
;; loading sequence:
;; 1. load header
;; 2. load data
;; 3. if execution address is defined (e.g. execution address is not 0), then execute code
;; if code returns, go back to step 1


a200 f3        di     
;; relocation routine which does not need start address 
a201 21e1e9    ld      hl,$e9e1
a204 224000    ld      ($0040),hl
a207 cd4000    call    $0040
a20a 113800    ld      de,$0038
a20d 19        add     hl,de
;; HL = calculated start address
a20e 111fbf    ld      de,$bf1f				; destination address
a211 01db00    ld      bc,$00db				; length
a214 edb0      ldir    

a216 311ebf    ld      sp,$bf1e
a219 cd37bd    call    $bd37				; firmware function: jump restore
a21c cd00bb    call    $bb00				; firmware function: km initialise
a21f cd4ebb    call    $bb4e				; firmware function: txt initialise
a222 cdffbb    call    $bbff				; firmware function: scr initialise
a225 cd02bc    call    $bc02				; firmware function: scr reset
a228 cda7bc    call    $bca7				; firmware function: sound reset

;; initialise firmware functions: cas in open and cas in direct
;; to utilities this loader functions.
;;
;; e.g. cas in open will load the header block
;; cas in direct will load the code
;;
;; not used by this instance of the loader
a22b 211fbf    ld      hl,$bf1f
a22e 2278bc    ld      ($bc78),hl
a231 2149bf    ld      hl,$bf49
a234 2284bc    ld      ($bc84),hl
a237 3ec3      ld      a,$c3
a239 3277bc    ld      ($bc77),a
a23c 3283bc    ld      ($bc83),a


;; begin loading "loop"
a23f c338bf    jp      $bf38

;;------------------------------------------------------------------------------------

;; 6 byte header block
;;
;; offset 0,1: load address
;; offset 2,3: length
;; offset 4,5: execution address

bf1f f3        di      

;; load header block
bf20 dd215dbf  ld      ix,$bf5d
bf24 110600    ld      de,$0006
bf27 cd8abf    call    $bf8a

bf2a ed5b5dbf  ld      de,($bf5d)		; load address
bf2e ed4b5fbf  ld      bc,($bf5f)		; length
bf32 3e01      ld      a,$01
bf34 b7        or      a
bf35 37        scf     
bf36 fb        ei      
bf37 c9        ret     

;;---------------------------------------------------------------------------
;;
;; loading loop:
;;
;; - load header block
;; - load data block
;; - if execution address is defined (e.g. it is not 0), then execute code and continue with loading
;;
;; the final block will not return here but execute the program

bf38 cd1fbf    call    $bf1f			;; load header block
bf3b d5        push    de
bf3c e1        pop     hl
bf3d cd49bf    call    $bf49			;; load data block
bf40 7c        ld      a,h				; execution address?
bf41 b5        or      l
bf42 28f4      jr      z,$bf38          ; 

;; execute code. When it returns it will continue with loading

bf44 1138bf    ld      de,$bf38
bf47 d5        push    de
;; execute it
bf48 e9        jp      (hl)

;;---------------------------------------------------------------------------
;; HL = load address

bf49 f3        di      
bf4a e5        push    hl
bf4b dde1      pop     ix
bf4d ed5b5fbf  ld      de,($bf5f)		;; length
bf51 cd8abf    call    $bf8a			;; load data
bf54 2a61bf    ld      hl,($bf61)		;; execution address
bf57 3e01      ld      a,$01
bf59 b7        or      a
bf5a 37        scf     
bf5b fb        ei      
bf5c c9        ret     

;;---------------------------------------------------------------------------
;; storage for header block

bf5d defs 6

;;---------------------------------------------------------------------------
;; get wave

bf63 cd67bf    call    $bf67
bf66 d0        ret     nc

;; get pulse
bf67 3e16      ld      a,$16
bf69 3d        dec     a
bf6a 20fd      jr      nz,$bf69         ; (-$03)
bf6c a7        and     a
bf6d 24        inc     h
bf6e c8        ret     z

bf6f 06f5      ld      b,$f5
bf71 ed78      in      a,(c)
bf73 a9        xor     c
bf74 e680      and     $80
bf76 28f5      jr      z,$bf6d          ; (-$0b)

bf78 067f      ld      b,$7f
bf7a 3e10      ld      a,$10
bf7c ed79      out     (c),a			;; select border

bf7e 79        ld      a,c
bf7f 2f        cpl     
bf80 4f        ld      c,a

;; based on cassette data input, generate border colour
bf81 e603      and     $03
bf83 3c        inc     a
bf84 f648      or      $48
bf86 ed79      out     (c),a			;; set border colour
bf88 37        scf     
bf89 c9        ret     

;;--------------------------------------------------------------
;; IX = load address
;; DE = length

bf8a f3        di      

;; start tape motor
bf8b 06f6      ld      b,$f6
bf8d 3e10      ld      a,$10
bf8f ed79      out     (c),a

bf91 06f5      ld      b,$f5

;; wait for first pulse
bf93 ed78      in      a,(c)
bf95 e680      and     $80
bf97 4f        ld      c,a
bf98 cd67bf    call    $bf67			; get pulse
bf9b 30fb      jr      nc,$bf98         ; 

;; delay
bf9d 211501    ld      hl,$0115
bfa0 10fe      djnz    $bfa0            ; (-$02)
bfa2 2b        dec     hl
bfa3 7c        ld      a,h
bfa4 b5        or      l
bfa5 20f9      jr      nz,$bfa0         ; (-$07)

bfa7 cd63bf    call    $bf63			; get wave
bfaa 30ec      jr      nc,$bf98         ;
 
;; get pilot waves
bfac 269c      ld      h,$9c
bfae cd63bf    call    $bf63			; get wave
bfb1 30e5      jr      nc,$bf98         ;
bfb3 3ec6      ld      a,$c6
bfb5 bc        cp      h
bfb6 30e0      jr      nc,$bf98         ; (-$20)
bfb8 2c        inc     l
bfb9 20f1      jr      nz,$bfac         ; 

bfbb 26c9      ld      h,$c9
bfbd cd67bf    call    $bf67			; get pulse (sync pulse 1, or pilot pulses)
bfc0 30d6      jr      nc,$bf98         ; (-$2a)
bfc2 7c        ld      a,h
bfc3 fed4      cp      $d4
bfc5 30f4      jr      nc,$bfbb         ; 
bfc7 cd67bf    call    $bf67			; get pulse (sync pulse 2)

bfca 2600      ld      h,$00
bfcc 06b0      ld      b,$b0
bfce dd2b      dec     ix
bfd0 13        inc     de
bfd1 1803      jr      $bfd6            ; (+$03)

;; write byte to memory
bfd3 dd7500    ld      (ix+$00),l
bfd6 dd23      inc     ix
bfd8 1b        dec     de
;; fetch a byte
bfd9 26b2      ld      h,$b2
bfdb 2e01      ld      l,$01
bfdd cd63bf    call    $bf63
bfe0 d0        ret     nc
bfe1 3ecb      ld      a,$cb
bfe3 bc        cp      h
bfe4 cb15      rl      l
bfe6 26b0      ld      h,$b0
bfe8 30f3      jr      nc,$bfdd         ; (-$0d)
bfea 00        nop     
bfeb 00        nop     
bfec 00        nop     
bfed 00        nop     
bfee 7a        ld      a,d
bfef b3        or      e
bff0 20e1      jr      nz,$bfd3         ; loop fetching bytes

;; stop tape motor
bff2 06f6      ld      b,$f6
bff4 af        xor     a
bff5 ed79      out     (c),a

bff7 a7        and     a
bff8 c9        ret     

