/***** AY Sound Support *******************************************
 ** AY-3-8912 beta emulation (20000601)                          **
 ** Support of Channels A,B,C and Noise                          **
 ** No hardware envelope yet                                     **
 ** No stereo yet                                                **
 ** Some other problems : opposite wavelength (no sound, like in **
 **                       "Orphee")                              **
 **                       some noise problems...                 **
 ******************************************************************/ 

/*
 *  If you want to make changes, please do not(!) use TABs !!!!!
 */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <termios.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/soundcard.h>
#include "aysound.h"
#include "cpc.h"
#include "io.h"

int     SoundOn=1;

/* Sound device driver : "/dev/dsp" */
int     dspfd=0;

/********************************************************************/
/* Sample Resolution and Sample rate. It's hard-coded. It would be  */
/* better if these settings were passed to init_dsp() function...   */
/********************************************************************/
int     sample_res=16; 
int     sample_rate=44100;

int     nb_samples;
double  magic_number;
int     note[4]        = {0, 0, 0, 0 };
double  fq[4]          = {0.,0.,0.,0.};
double  nsample[4]     = {0.,0.,0.,0.};
char    phase[4]       = {1, 1, 1, 1 };
char    new_note[4]    = {0, 0, 0, 0 };
char    bits[8]        = {1,2,4,8,16,32,64,128};
char    log_ampl[16]   = {0,3,4,5,7,9,11,13,17,21,26,33,41,51,64,80};
int     max_volume;
int     AY_rec = -1;
FILE    *debug_snd;

/****************************************************************************/
/* I don't know how to do the same random generator as in the AY chip. This */
/* generator is a linux pseudo-random, not an AY pseudo-random ! I don't    */
/* know if there is adifference for human ears ...                          */
/****************************************************************************/
int random_noise() {
    int x1, j;

    x1 = (((random()*1.0)/RAND_MAX)*32767)+1;
    for (j=0; x1 > 0; j++) 
        {
         x1>>=1;
        }
    return (16-j);
   }

/***************************************************************************/
/* you have only to give the adress of the AY registers, and this function */
/* will do the rest... I have a doubt about the mixer.                     */
/***************************************************************************/

void mix_notes(char *AY_array_reg) {
    int      i, j;
    double   mix;
    float    amplitude, ampnoise;
    signed   char ampl8;
             int  ampl16;
    AYframe *cur_frame;

    if (!SoundOn) return;
    cur_frame = (AYframe*)AY_array_reg;
    if (AY_rec == 1)
        for (i=0; i <14; i++)
             fprintf(debug_snd, "%c", AY_array_reg[i]);

    for (j=0; j < 3; j++) {
        cur_frame->fqx[j] = cur_frame->fqx[j] & 0x0fff;
        if (cur_frame->fqx[j] != note[j]) {
            note[j]     = cur_frame->fqx[j];
            fq[j]       = note[j] * magic_number;
            new_note[j] = 1;
        }
    }

    cur_frame->fqn = cur_frame->fqn & 0x1f;
    if (cur_frame->fqn != note[3]) {
        note[3]    = cur_frame->fqn;
        fq[3]      = note[3] * magic_number;
        nsample[3] = fq[3] * random_noise();
    }

    for (i=0; i < nb_samples; i++) {
         mix = 0;

         ampnoise   = phase[3];
         nsample[3] = nsample[3] - 1;

         if (nsample[3] < 1) {
             phase[3]    = -phase[3];
             nsample[3] += fq[3]*random_noise();
         }

         for (j=0; j<3; j++) {

             /* This line disable the hardware envelope (try it with "commando"  */
             /* and you will understand                                          */
             cur_frame->lv[j] = cur_frame->lv[j] & 0x0f;;

             /* when the hardware envelope will be coded, this line should be deleted */
             if ((cur_frame->mix & bits[j+3]) == 0)
                mix+= ampnoise * log_ampl[cur_frame->lv[j]];
              amplitude  = phase[j];
              nsample[j] = nsample[j] - 1;

              if (nsample[j] < 1) {
                  phase[j]    = -phase[j];
                  if (new_note[j] == 1) {
                      new_note[j] = 0;
                      nsample[j]  = fq[j];
                     }
                  else
                      nsample[j] += fq[j];
                 }

              if (!(cur_frame->mix & bits[j]))
                  mix+= amplitude * log_ampl[cur_frame->lv[j]];
             }

         mix = (mix / 256) * max_volume;

         if (sample_res == 8) {
               ampl8 = mix-128;
               write(dspfd, &ampl8, 1);
              }
         else {
               ampl16 = mix;
               write(dspfd, &ampl16, 2);
              }
        }
   }


void switchAYRec() {
   AY_rec = -AY_rec;
   if (AY_rec == -1)
        fclose(debug_snd);
   else
       debug_snd = fopen("sound.tmp", "w");
}



void resetAYRegister() {
   int i;

   for (i=0; i <4; i++) {
        note[i]    = 0;
        fq[i]      = 0.;
        nsample[i] = 0.;
        phase[i]   = 1;
   }
}

int init_dsp() {
    if (dspfd != 0)
        close (dspfd);
    dspfd = open ("/dev/dsp", O_WRONLY);
    if (ioctl(dspfd, SOUND_PCM_WRITE_BITS, &sample_res)==-1) {
        printf ("\n*** ERROR while initializing sample resolution ***");
        return (-1);
    }
    else
        if (ioctl(dspfd, SOUND_PCM_WRITE_RATE, &sample_rate)==-1) {
           printf ("\\n*** ERROR while initializing sample rate ***");
           return (-1);
        }

    resetAYRegister();
    nb_samples   = sample_rate / 50;
    magic_number = sample_rate / 125000.0;
    max_volume   = (pow(2, sample_res)/2) - 1;
    return (0);
}
