/* XTI 1.2 - shell interface stuff */
/* file name : xti_shll.c */



#define kDSK  0
#define kEDK  1
#define kDIF  2
#define kCPD  3
#define kEMC  4
#define kODF  5
#define kAMI  6
#define kCPC  7
#define kNPC  8
#define kNEWD 200
#define kNEWS 201
#define kNEWI 202
#define kNUL  255

char *sDSK = "plain disk image";
char *sEDK = "extended disk image";
char *sDIF = "DIF revision 2";
char *sODF = "DIF older revision";
char *sCPD = "CPD format";
char *sEMC = "EmuCPC format";
char *sAMI = "AmiCPC format";
char *sCPC = "!CPCEmu format";
char *sNPC = "NO$CPC format";

char *fDSK = "-dsk";
char *fEDK = "-edsk";
char *fDIF = "-dif";
char *fODF = "-odif";
char *fCPD = "-cpd";
char *fEMC = "-emu";
char *fAMI = "-ami";
char *fCPC = "-cpc";
char *fNPC = "-ncpc";

char *fNEWD = "-newD";
char *fNEWS = "-newS";
char *fNEWI = "-newI";
char *fCUT = "-cut";
char *fDET = "-DE";
char *fMRG = "-merge";
char *fICL = "-incl";
char *fES1 = "-es1";
char *fES2 = "-es2";
char *fBCK = "-back";


#if MSDOS == 0
char *sfEDSK = ".edsk";
char *sfDDSK = ".ddsk";
char *sfXDSK = ".xdsk";
#else
char *sfEDSK = ".edk";
char *sfDDSK = ".ddk";
char *sfXDSK = ".xdk";
#endif

char *sfODSK = ".dsk";


void doFlag1(char *theFlags)
{ 
 if (!strcmp(theFlags,fDSK)) { theFormat = kDSK;
        printf("Source file is assumed to be %s\n",sDSK); }
 else if (!strcmp(theFlags,fEDK)) { theFormat = kEDK;
        printf("Source file is assumed to be %s\n",sEDK); }
 else if (!strcmp(theFlags,fDIF)) { theFormat = kDIF;
        printf("Source file is assumed to be %s\n",sDIF); }
 else if (!strcmp(theFlags,fODF)) { theFormat = kODF;
        printf("Source file is assumed to be %s\n",sODF); }
 else if (!strcmp(theFlags,fCPD)) { theFormat = kCPD;
        printf("Source file is assumed to be %s\n",sCPD); }
 else if (!strcmp(theFlags,fEMC)) { theFormat = kEMC;
        printf("Source file is assumed to be %s\n",sEMC); }
 else if (!strcmp(theFlags,fAMI)) { theFormat = kAMI;
        printf("Source file is assumed to be %s\n",sAMI); }
 else if (!strcmp(theFlags,fCPC)) { theFormat = kCPC;
        printf("Source file is assumed to be %s\n",sCPC); }
 else if (!strcmp(theFlags,fNPC)) { theFormat = kNPC;
        printf("Source file is assumed to be %s\n",sNPC); }
}


void doFlag2(char *theFlags)
{
 int i;

 if (strstr(theFlags, fCUT) == theFlags)
   { i = atoi(theFlags + strlen(fCUT));
     if (i>0) theCut = min(i,k8KB);        /* 8k sector buffer limit */
           else printf("Incorrect sector limit, using %d\n", theCut); }
 else if (!strcmp(theFlags, fDET)) DETrick = 1;
}


int newFlag(char *theFlags)
{
 if (!strcmp(theFlags,fNEWD)) { theFormat = kNEWD; return(1); }
 else if (!strcmp(theFlags,fNEWS)) { theFormat = kNEWS; return(1); }
 else if (!strcmp(theFlags,fNEWI)) { theFormat = kNEWI; return(1); }
 return(0);
}


void getFormat(char *fileName)
{
 FILE *Scanned;
 char buffer[9];
 int  i;

 if ( (Scanned = fopen(fileName, "rb")) != NULL)
  {
   for(i=0; i<8; i++) buffer[i] = fgetc(Scanned);
   buffer[8] = '\0';

   if (!strcmp(buffer, "EXTENDED")) { theFormat = kEDK;
        printf("Source file is %s\n", sEDK); }
   else if (!strcmp(buffer, "NORMDISK")) { theFormat = kCPD;
        printf("Source file is %s\n", sCPD); }
   else if (!strcmp(buffer, "MV - CPC")) { theFormat = kDSK;
        printf("Source file is %s\n", sDSK); }
   else if (!strcmp(buffer, "CPC-Emul")) { theFormat = kCPC;
        printf("Source file is %s\n", sCPC); }
   else if (!strncmp(buffer, "CPCD", 4)) { theFormat = kEMC;
        printf("Source file is %s\n", sEMC); }
   else if ( (strstr(fileName, ".dif") != NULL)
           ||(strstr(fileName, ".DIF") != NULL))
      { if (*buffer < 2) {theFormat = kODF;
                          printf("Source file is probably %s\n", sODF); }
        else if (*buffer == 2) {theFormat = kDIF;
                          printf("Source file is probably %s\n", sDIF); }
      }
   else if ( (strstr(fileName, ".dsk") != NULL)
           ||(strstr(fileName, ".DSK") != NULL)) { theFormat = kNPC;
        printf("Source file is probably %s\n", sNPC); }
   else if ((buffer[0] == 0) && (buffer[1] == 0) && (buffer[2] == 2)) { theFormat = kAMI;
        printf("Source file is probably %s\n", sAMI); }

   fclose(Scanned);
  }  
}


void doFile(char *SourceName)
{
 char TargetName[256];
 char *dotpt;


 if (theFormat == kNUL)
    { fprintf(stderr, "Improper file format !\n"); exit(1);}
 theCutHi = (theCut >> 8) & 255;
 theCutLo = theCut & 255;


 sprintf (TargetName, "%s", SourceName);
 if ((dotpt = strchr(TargetName, '.')) == NULL) dotpt = TargetName + strlen(TargetName);
 sprintf (dotpt, sfEDSK);
 if (!strcmp(SourceName, TargetName)) sprintf (dotpt, sfXDSK);

 if ((Source = fopen(SourceName,"rb")) == NULL)
     {
     fprintf(stderr, "Unable to open %s !\n", SourceName);
     exit(2);
     }

 Target = fopen(TargetName, "wb");                      

switch(theFormat)
{
 case kDSK:
       printf("Extending the image...\n");
       dsk2edsk(); break;
 case kEDK:
       printf("Cleaning the image...\n");
       edsk2edsk(); break;
 case kDIF:
       printf("Converting the image...\n");
       dif2edsk(); break;
 case kODF:
       printf("Converting the image...\n");
       Odif2edsk(); break;
 case kCPD:
       printf("Converting the image...\n");
       cpd2edsk(); break;
 case kEMC:
       printf("Converting the image...\n");
       emc2edsk(); break;
 case kAMI:
       printf("Converting the image...\n");
       ami2edsk(); break;
 case kCPC:
       printf("Converting the image...\n");
       cpc2edsk(); break;
 case kNPC:
       printf("Converting the image...\n");
       npc2edsk(); break;
}

 fclose(Source);
 fclose(Target);
}
