/* XTI 1.4 - AMSDOS file inclusion routines */
/* filename: xti_incl.c */




#define kBAD    0
#define kDATA   1
#define kSYSTEM 2
#define kTsize (512*9+256)

long DirOffset;
long resTracks;

FILE *ImageFile;

char *DataString = "Data";
char *SysString  = "System";

int FreeBlockTags[180];    /* arrays of booleans */
int FreeBlockNumber;
int FreeEntryTags[64];
int FreeEntryNumber;
char AllNames[64][11];
int  NextName;







long Block2Offset(int numero, int block)
{
 int track;
 int sector;

 track = (block*2)/9 + resTracks;
 sector = (block*2)%9;

 if (numero)
    { sector++;                      /* skip possible track header */
      if (sector == 9) {track++; sector = 0;} }

 return((256+kTsize*track)+(256+512*sector));
}


void getDirectory()
{
 int i,j;
 char x;
 unsigned char Directory[2048];

 FreeEntryNumber = 0;
 for (i=0; i<64; i++) FreeEntryTags[i] = 1;
 NextName = 0;
 for (i=0; i<(64*11); i++) *(*AllNames+i) = 0;

 if (theFormat == kSYSTEM) { resTracks = 2;  FreeBlockNumber = 169;}
                      else { resTracks = 0;  FreeBlockNumber = 178;}
 DirOffset = 512 + kTsize*resTracks;

 fseek(ImageFile, DirOffset, SEEK_SET);
 for (i=0; i<2048; i++) Directory[i] = fgetc(ImageFile);
 for (i=0; i<2; i++) FreeBlockTags[i] = 0;
 for (i=2; i<(2+FreeBlockNumber); i++) FreeBlockTags[i] = 1;

 for (i=0; i<2048; i+= 32)
    {
    if (Directory[i] == 0xe5)
         { FreeEntryNumber++; continue;} /* erased ? */
    FreeEntryTags[i>>5] = 0;

    for(j = i+16; j<i+32; j++)     /* create bit map */
        if (!Directory[j]) break; else
         { FreeBlockTags[Directory[j]] = 0;
           FreeBlockNumber--; }

    if (Directory[i+12] != 0) continue; /* not first */
    for(j = 0; j<11; j++)
          {
          x = Directory[i+j+1];
          if (!x) x = ' ';
          AllNames[NextName][j] = x;
          }
    NextName++;
    }
}


void CheckFormat(char *fileName)
{
 FILE *Scanned;
 unsigned char buffer[13];
 int  i;

 theFormat = kBAD;
 if ( (Scanned = fopen(fileName, "rb")) != NULL)
  {
   fseek(Scanned, 128, SEEK_SET);
   for(i=0; i<13; i++) buffer[i] = fgetc(Scanned);
     if (!strcmp((char *)buffer, "Data Disk\n"))   theFormat = kDATA;
else if (!strcmp((char *)buffer, "System Disk\n")) theFormat = kSYSTEM;
   fclose(Scanned);
  }  
}




int IncludeFile()
{
 char SourceName[256];
 char TargetName[12];
 char c,x;
 char *DotPt;
 unsigned char EntryBuff[32];
 unsigned char BlockBuff[1024];
 FILE *Source;
 int  h,i,j,s, delta, cmax, lmax, rem, adj;
 int  sector, offset, selectedcluster, ePos;
 int  entry, cluster, TotBytes;
 char k = 'A';
 unsigned long size;


 if (!(FreeBlockNumber && FreeEntryNumber))
     { printf("Image is full !\n"); return(0); }
 printf("Include ? ");
 scanf("%s", SourceName);
 if (*SourceName == '.') return(0);
 if ((Source = fopen(SourceName, "rb")) == NULL) 
     { printf("\nFile not found...\n"); return (1); }

 fseek(Source, 0, SEEK_END);
 size = ftell(Source);
 fseek(Source, 0, SEEK_SET);

 if ((size>(FreeBlockNumber*1024L)) || (size>(FreeEntryNumber*16384L)))
    { printf ("\nSorry, file is too big...\n"); return (1); }
 if (!size) { printf ("\nThis file is empty !\n"); return(1); }

 s = strlen(SourceName);
 j = 0;

 for(i=0; i<11; i++)
  {
  if (j<s)
   {
   c = toupper(SourceName[j++]);
   if (c == '.')
      {
      if (i>7)  i--;
         else { x = ' '; j--; }
      }
     else
      { if (!isalnum(c)) x = '#'; else x = c; }
   }
   else x = ' ';
  TargetName[i] = x;
  }

 TargetName[11] = 0;

 for(j=10; TargetName[j] == ' '; j--) ;

retest:
 for(i=0; i<NextName; i++) if (!strncmp(TargetName, AllNames[i], 11)) break;
 if (i<NextName) { TargetName[j] = k++; goto retest; }

 printf("Including file as %s\n", TargetName);
 sprintf(AllNames[NextName++], "%s", TargetName);

 h = size >> 14;              /* number of entries, careful rounding */
 if (delta = (size & 0x3FFF)) h++;
 FreeEntryNumber -= h;

 if (delta) {
	cmax = delta >> 10;          /* number of blocks in last entry */
	if (rem = (delta & 0x3FF)) cmax++;
	} else
	{ cmax = 16; rem = 0; }

 if (rem) {
	adj = rem >> 7;              /* number of chunks in last block */
	if (rem & 0x7F) adj++;
	} else
	{ adj = 8; rem = 1024; }   /* bug fix vs 1.3 by Antoine Pitrou here */

 for(entry=0; entry<h; entry++)   /* loop on entries */
   {
   TotBytes = 0;
   for(i=0; i<32; i++) EntryBuff[i] = 0;
   sprintf((char *)EntryBuff+1, "%s", TargetName);
   lmax = (entry == (h-1)) ? cmax : 16;   /* wait for last entry */

   for (cluster=0; cluster<lmax; cluster++) /* loop on clusters */
     {
     if ( (cluster == (lmax-1)) && (entry == (h-1)) )
       {   /* last of last ... */
       for(j=0; j<rem; j++) BlockBuff[j] = fgetc(Source);
       for(j=rem; j<1024; j++) BlockBuff[j] = 0;
       TotBytes += adj;
       }
      else
       {   /* normal case */
       for(j=0; j<1024; j++) BlockBuff[j] = fgetc(Source);
       TotBytes += 8;
       }

     for(selectedcluster = 0; selectedcluster<180; selectedcluster++)
            if (FreeBlockTags[selectedcluster]) break;

     for(sector=0; sector<2; sector++)     /* loop on sectors */
       {
       fseek(ImageFile, Block2Offset(sector, selectedcluster), SEEK_SET);
       for (offset=0; offset<512; offset++)  /* loop on bytes */
                fputc(BlockBuff[offset+512*sector], ImageFile);
       }

     EntryBuff[cluster+16] = selectedcluster;
     FreeBlockTags[selectedcluster] = 0;
     FreeBlockNumber--;
     }

   for(ePos = 0; ePos<64; ePos++) if (FreeEntryTags[ePos]) break;
   fseek(ImageFile, DirOffset+32*ePos, SEEK_SET);
   EntryBuff[12] = entry;
   EntryBuff[15] = TotBytes;

   for (i=0; i<32; i++) fputc(EntryBuff[i], ImageFile);
   FreeEntryTags[ePos] = 0;
   }

 return(1);
}



void doIncluder(char *ImageName)
{
 char *FormString;

 CheckFormat(ImageName);

 if (theFormat == kBAD)
    { fprintf(stderr,"Improper file format !\n");
      exit(1);}

 if ((ImageFile = fopen(ImageName,"r+b")) == NULL)  /* dubious file mode */
    { fprintf(stderr,"Cannot write to Image !\n");
      exit(3);}

 getDirectory();
 if (theFormat == kDATA) FormString = DataString;
                    else FormString = SysString;
 printf("Image is %s, with %d K free, %d files over %d entries.\n",
        FormString, FreeBlockNumber, NextName, 64-FreeEntryNumber); 

 while (IncludeFile()) ;

 fclose(ImageFile);
}
