/*  Disk Image Extender, conversion utility by Pierre Guerrier  */
/* Release 1.4, February 1998. Contact: Pierre.Guerrier@wanadoo.fr */
/*      See attached "read_me" file for more informations       */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>

#define MSDOS 1
#define AMIGA 0
#define MAC   0
/* change these values for your OS, all zero -> UNIX */

#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2
/* flags for fseek(), change if different on your OS */

#include "XTI_CONV.C"
#include "XTI_SHLL.C"
#include "XTI_MISC.C"
#include "XTI_INCL.C"

#if MAC == 1
#include <SIOUX.h>
extern long _fcreator;
extern long _ftype;
#endif

int main(int argc, char **argv)
{
 int i;
 int startArg = 1;

 printf("Disk Image Extender v1.4 (c) 1998 Pierre Guerrier, \n");
#if MSDOS == 1
 printf("DOS port by Ulrich Doewich\n");
#elif AMIGA == 1
 printf("Amiga port by Kevin Thacker\n");
#elif MAC == 1
	_fcreator = 'CPC+';
	_ftype = 'cDSK';
	SIOUXSettings.asktosaveonclose = FALSE;
	SIOUXSettings.autocloseonquit = FALSE;
	/* Get command line parameters from SIOUX */
	argc = ccommand(&argv);  
	if (argc>1)
		SIOUXSettings.autocloseonquit = TRUE;
	printf("Mac port by Brice Rive\n");
	SIOUXSetTitle("\pXTI (Disk Image XTender)");
#else
 printf("Unix version\n");
#endif

 Reset();
 switch(argc)
 {
  case 2:  getFormat(argv[1]); doFile(argv[1]); break;
  case 3:
	if (!strcmp(argv[1], fBCK)) { doRevert(argv[2]); break; }
	if (!strcmp(argv[1], fICL)) { doIncluder(argv[2]); break; }
	if (extFlag(argv[1])) { doExt(argv[2]); break; }
	if (newFlag(argv[1])) { doNew(argv[2]); break; }
	doFlag1(argv[1]);
	if (theFormat == kNUL)
	   {
	   doFlag2(argv[1]);
	   getFormat(argv[2]);
       }
    doFile(argv[2]);
	break;
  case 4:
    if (!strcmp(argv[1], fMRG)) { doMerger(argv[2], argv[3]); break; }
    doFlag1(argv[1]);
    doFlag2(argv[2]);
    doFile (argv[3]);
    break;
  default: fprintf(stderr,"Usage 1: %s [-format override] [-special] file\n", argv[0]);
           fprintf(stderr,"  Known format tags: dsk, edsk, dif, odif, cpd, emu, ami, cpc, ncpc\n");
           fprintf(stderr,"  Special tags: DE, cut[size], where \"size\" is in 0..8192\n");
           fprintf(stderr,"Usage 2: %s -merge file1 file2\n", argv[0]);
           fprintf(stderr,"Usage 3: %s -es[side no] file, where \"side no\" is 1/2\n", argv[0]);
           fprintf(stderr,"Usage 4: %s -incl file\n", argv[0]);
           fprintf(stderr,"Usage 5: %s -new[format] file\n", argv[0]);
           fprintf(stderr,"  Where \"format\" is one of: S, D, I\n");
           fprintf(stderr,"Usage 6: %s -back file\n", argv[0]);
           exit(3); break;
 }
 exit(0);
}
